import { Duration } from 'aws-cdk-lib';
import { IUserPool } from 'aws-cdk-lib/aws-cognito';
import { Construct } from 'constructs';
import { XAmazonApigatewayAuthorizer } from '../x-amazon-apigateway/authorizer';
import { XAmazonApigatewayAuthType } from '../x-amazon-apigateway/authtype';
import { Id } from './authorizer';
export interface CognitoUserPoolsAuthorizerProps {
    readonly cognitoUserPools: IUserPool[];
    readonly resultsCacheTtl?: Duration;
}
export declare class CognitoUserPoolsAuthorizer extends Construct {
    readonly id: Id;
    readonly xAmazonApigatewayAuthtype: XAmazonApigatewayAuthType;
    readonly xAmazonApigatewayAuthorizer: XAmazonApigatewayAuthorizer;
    constructor(scope: Construct, id: Id, props: CognitoUserPoolsAuthorizerProps);
}
