#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Lightlab documentation build configuration file, created by
# sphinx-quickstart on Sat Mar 25 20:35:35 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#

import better_apidoc

# -- Generate API documentation ------------------------------------------------


def run_apidoc(_):
    """Generage API documentation"""
    better_apidoc.main(
        ['better-apidoc', '-t', './_templates', '--force', '--no-toc',
         '--separate', '-o', './API', '../lightlab'])


def run_testdoc(_):
    better_apidoc.main(
        ['better-apidoc', '-t', './_templates', '--force', '--no-toc',
         '--separate', '-o', './TestAPI', '../tests'])


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc',
              'sphinx.ext.autosummary',
              'sphinx.ext.intersphinx',
              'sphinx.ext.inheritance_diagram',
              'sphinx.ext.coverage',
              'sphinx.ext.napoleon',
              'sphinx.ext.todo',
              'sphinx.ext.mathjax',
              'sphinx.ext.ifconfig',
              'sphinx.ext.viewcode',
              'sphinxcontrib.bibtex',
              'nbsphinx']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md']
# source_suffix = '.rst'

source_parsers = {
    '.md': 'recommonmark.parser.CommonMarkParser',
}

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'Lightwave Laboratory Instrumentation'
copyright = '(c) 2018 Lightwave Lab, Princeton University'
author = 'Alex Tait, Thomas Ferreira de Lima'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#

with open("../version.py") as f:
    code = compile(f.read(), "version.py", 'exec')
    version_dict = {}
    exec(code, {}, version_dict)
    # The short X.Y version.
    version = version_dict['version']
    # The full version, including alpha/beta/rc tags.
    release = version_dict['release']


# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', '**.ipynb_checkpoints']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for Autodocumentation ----------------------------------------------
autodoc_member_order = 'bysource'
autoclass_content = 'both'
add_module_names = False
napoleon_google_docstring = True
napoleon_use_param = True

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'alabaster' # The default

import sphinx_rtd_theme
html_theme = 'sphinx_rtd_theme'
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'Lightlab'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

doc_title = 'Lightlab Documentation'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'Lightlab.tex', doc_title,
     author, 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'lightlab', doc_title,
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'Lightlab', doc_title,
     author, 'Lightlab', project,
     'Miscellaneous'),
]


# -- Options for IPyNb output -------------------------------------------
nbsphinx_timeout = 60
nbsphinx_allow_errors = True
nbsphinx_execute = 'never'

# -- Mock C libraries to save autodoc -------------------------------------------
import sys
from unittest.mock import MagicMock


class Mock(MagicMock):

    @classmethod
    def __getattr__(cls, name):
        return MagicMock()


MOCK_MODULES = ['numpy',
                'matplotlib',
                'matplotlib.pyplot',
                'matplotlib.figure',
                'matplotlib.backends',
                'matplotlib.backends.backend_pdf',
                'scipy',
                'scipy.optimize',
                'scipy.io',
                'pandas',
                'IPython',
                'IPython.lib',
                'IPython.lib.lexers',
                'matplotlib.cm',
                'jsonpickle',
                'jsonpickle.ext',
                'jsonpickle.ext.numpy']
sys.modules.update((mod_name, Mock()) for mod_name in MOCK_MODULES)


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'python': ('https://docs.python.org/', None)}


def setup(app):
    app.connect('builder-inited', run_apidoc)
    app.connect('builder-inited', run_testdoc)
