# When to file an issue
Issues are used to report bugs and request fixes. They can also be used to suggest minor enhancements for functionality you think _should_ be there already. This includes reporting documentation that _should_ be there.

Before submitting, skim the existing issues. If you find the same issue, please go to it and comment that you have also reproduced it! Also, you should be relatively confident that you are using it correctly and that the code is acting incorrectly. 

Instead, for technical support on `x`, go to `y`, where
* `x=` core features, `y=` relevant documentation and then __this__ discussion board
* `x=` writing a driver, `y=` "how to write a driver", "abstract drivers", "contributing drivers" then discussion board
* `x=` using someone else's driver, `y=` blame history to find who wrote it, then __this__ discussion area

Instead, to request core features, go __this__ discussion board

--------

# Template [Title of issue]

### Description

[Description of the issue]

### Steps to Reproduce

1. [First Step]
2. [Second Step]
3. [and so on...]

**Expected behavior:** [What you expect to happen]

**Actual behavior:** [What actually happens]

### Version
Latest: [0.2.0] -- you can get this by running `python version.py` in the lightlab development directory

Branch: [@development]

Commit short hash: [1234abcd]

### Additional Information
Any additional information, configuration or data that might be necessary to reproduce the issue.
