# lightlab Code of Conduct

## Why have a code of conduct?
This Code of Conduct is designed to help all of us build a pleasant, productive, and fearless community. It is not just a feel-good document suggested by Github (see enactment). In the event that issues occur, it's better to have this Code in writing to point to.

This code of conduct is adapted from that of the [nengo](https://github.com/nengo/nengo) project, which, in turn, was adapted from the [DigitalOcean Engineering Code of Conduct](https://github.com/digitalocean/engineering-code-of-conduct). As they are, this document is licenced under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

## Social rules
#### No feigning surprise
Don’t act surprised when people say they don’t know something, or ask a question that has what you feel is an "obvious" answer ("I can’t believe you don’t know what a [reflog](https://www.youtube.com/watch?v=oHg5SJYRHA0) is!"). "I don't know" is a perfectly valid statement and presents an opportunity to help out.

#### No backseat driving
If a thread is working through a problem, you shouldn’t join the thread, drop an advice bomb, then leave. Thread conversations are like real-life conversations - it can be rude to interrupt, half-participate, and/or vanish. By all means, join conversations! First, please read the thread history; ask questions. Reply to questions/comments on your comments. If you want to show support for an idea presented in a thread, consider using a simple :+1: (`:+1:`) rather than stating the same point a different way. If you feel that there is a different approach that could be taken, but you do not have the time or motivation to implement that approach yourself, make a note to yourself to explore that approach when you have time instead of putting that burden on someone else.

#### Be welcoming
We are committed to providing a friendly, safe and welcoming environment for all, regardless of level of experience, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, or religion. You will be excluded from the community if you insult, demean, or harass anyone either in a public forum or private channel. We interpret "harassment" as defined in the [Citizen Code of Conduct](http://citizencodeofconduct.org/) whose wording is derived from the [Geek Feminism Anti-Harassment Policy](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy). 

## Time
Be respectful of other people: their time, their location, and other considerations of a distributed team.

#### Meetings
Be on time. Resist the temptation to have local-only meetings when remote teammates should be involved. Instead, take the discussion to the forum, a group hangout, Github issue, or dev meeting as appropriate.

#### Concision
Keep in mind that what you write once will be read by several people. Writing a short message means people can understand the conversation as efficiently as possible. When a long explanation is necessary, consider adding a summary. Try to bring new arguments to a conversation so that each message adds something unique to the thread, keeping in mind that the rest of the thread still contains the other messages that have already been made.

#### Topicality
Git allows simultaneous development of different features, which can get confusing. Try to stay on topic, both in the discussion (in the thread) and code changes (in the branch). If a discussion brings to mind some related but separate issue, please start a separate discussion/branch for it. This is not always easy in practice. 

Sometimes you sit down to work on feature `X1.0` and end up writing features `X2.0`, `Y1.0`, and `Z1.0`. In that case, try your hand at Git's very useful patching functionality `git add -p` ([Tutorial](https://johnkary.net/blog/git-add-p-the-most-powerful-git-feature-youre-not-using-yet/)) and interactive staging tool `git add --interactive` ([Tutorial](https://coderwall.com/p/u4vjkw/git-add-interactive-or-how-to-make-amazing-commits)). These are how you can combine working carefree all over the place with writing clear, organized, topic-oriented history.

## Feedback 
### Giving
Assume that the other person is smart and capable, even if they don’t have the same expertise as you. Go about your review under the assumption that the decisions were made for a reason, not in a vacuum.

Feedback is negatively critical when it focuses on something wrong with someone or something they produced, especially without any mention of ways to make their behavior or their product better. Critical feedback on work often looks like "you don’t write enough tests" or "your code quality isn’t good enough." Personal criticism often looks like "you should be less judgmental" or "you are a burden because you ask too many questions."

Constructive feedback is more about how a person can do better rather than what they are doing wrong. If you want someone to do something better, you should tell them what better looks like. Ask a question to get a discussion rolling, to gain context, and then if you see room for improvement give declarative feedback to that effect. This creates an environment where people understand what success looks like instead of just feeling like they are unsuccessful.

### Receiving
While the reviewer must do their best to be constructive in their feedback, so must the reader do their best to read a comment as attempting to be constructive and not personally critical - as hard as this may be when you are passionate about what you do. Assume that the reviewer is trying to help and is not trying to make you feel bad.

You are not your products. It is important to realize that it’s better to find errors in review than in production and recognize that your work fits into a larger whole. 

A review is not a test that you must pass to be accepted by the community. By creating something to be reviewed, you are already a member of our community.

## Enactment
If somebody requests that you stop a certain behavior (even if said behavior is not explicitly covered in this document), you are expected to comply immediately. Complying is not an admission of guilt or of a transgression; rather, it is an acknowledgment that further discussion of what caused the request is probably a good idea. Work with the other party to fix the situation. If a miscommunication happened in writing, move the discussion to a richer medium like a video chat. Use the opportunity to build stronger relationships and better the team.

Enforcement of the Code of Conduct is essential. If there is no enforcement, then the Code of Conduct becomes a feel-good document without value. Individuals should feel empowered to call out violations publicly or privately. Maintainers of lightlab projects are available (atait@ieee.org, tlima@princeton.edu) to help moderate, address concerns, and solve violations.

## Further reading
Want to know more about the motivation behind the presence of and points within this Code of Conduct? DigitalOcean’s Code of Conduct, the nengo authors' changes, and our changes are inspired by several other excellent resources

* [Introducing DigitalOcean’s Engineering Code of Conduct](https://github.com/digitalocean/engineering-code-of-conduct/blob/master/introduction.md)
* [The Recurse Center’s Social Rules](https://www.recurse.com/manual#sec-environment)
* [Criticism and Ineffective Feedback by Kate Heddleston](https://kateheddleston.com/blog/criticism-and-ineffective-feedback)
* [Geek Feminism Anti-Harassment Policy](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy)
