import * as route53 from '@aws-cdk/aws-route53';
import * as core from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface PrivateAssetBucketProps {
    /**
     * @stability stable
     */
    readonly assetBucketName?: string;
    /**
     * if you want to use an imported bucket instead.
     *
     * @stability stable
     */
    readonly assetBucketNameImport?: string;
    /**
     * @stability stable
     */
    readonly customDomain?: CustomDomain;
    /**
     * @stability stable
     */
    readonly userPoolId: string;
    /**
     * @stability stable
     */
    readonly userPoolClientId: string;
    /**
     * The token use that you expect to be present in the JWT's token_use claim.
     *
     * Usually you are verifying either Access token (common) or ID token (less common).
     * Pass null explicitly to not check the JWT's token use--if you know what you're doing
     *
     * @stability stable
     */
    readonly tokenUse?: 'access' | 'id';
}
/**
 * @stability stable
 */
export interface CustomDomain {
    /**
     * @stability stable
     */
    readonly zone: route53.IHostedZone;
    /**
     * domainName needs to be part of the hosted zone e.g.: image.example.com.
     *
     * @stability stable
     */
    readonly domainName: string;
}
/**
 * @stability stable
 */
export declare class PrivateAssetBucket extends core.Construct {
    /**
     * @stability stable
     */
    assetBucketName: string;
    /**
     * @stability stable
     */
    assetBucketCloudfrontUrl: string;
    /**
     * @stability stable
     */
    assetBucketRecordDomainName: string | undefined;
    /**
     * @stability stable
     */
    constructor(scope: core.Construct, id: string, props: PrivateAssetBucketProps);
}
