""" This module contains Winger-Seitz radii. """

winger_seitz_radii = {
  'Vc' : 1.5,
   'H' : 1.39,
  'He' : 2.55,
  'Li' : 3.04,
  'Be' : 2.27,
   'B' : 1.96,
   'C' : 1.66,
   'N' : 1.90,
   'O' : 1.90,
   'F' : 2.17,
  'Ne' : 2.89,
  'Na' : 3.76,
  'Mg' : 3.25,
  'Al' : 2.95,
  'Si' : 2.63,
   'P' : 2.56,
   'S' : 2.70,
  'Cl' : 2.85,
  'Ar' : 3.71,
   'K' : 4.66,
  'Ca' : 3.88,
  'Sc' : 3.31,
  'Ti' : 2.99,
   'V' : 2.76,
  'Cr' : 2.64,
  'Mn' : 2.57,
  'Fe' : 2.52,
  'Co' : 2.52,
  'Ni' : 2.55,
  'Cu' : 2.62,
  'Zn' : 2.78,
  'Ga' : 2.75,
  'Ge' : 2.79,
  'As' : 2.83,
  'Se' : 2.94,
  'Br' : 3.13,
  'Kr' : 4.32,
  'Rb' : 4.95,
  'Sr' : 4.22,
   'Y' : 3.61,
  'Zr' : 3.28,
  'Nb' : 3.03,
  'Mo' : 2.91,
  'Tc' : 2.82,
  'Ru' : 2.77,
  'Rh' : 2.78,
  'Pd' : 2.84,
  'Ag' : 2.95,
  'Cd' : 3.14,
  'In' : 3.30,
  'Sn' : 3.45,
  'Sb' : 3.30,
  'Te' : 3.31,
   'I' : 3.50,
  'Xe' : 4.31,
  'Cs' : 5.30,
  'Ba' : 4.20,
  'La' : 3.91,
  'Ce' : 3.80,
  'Pr' : 3.75,
  'Nd' : 3.70,
  'Pm' : 3.65,
  'Sm' : 3.60,
  'Eu' : 3.55,
  'Gd' : 3.52,
  'Tb' : 3.61,
  'Dy' : 3.67,
  'Ho' : 3.70,
  'Er' : 3.73,
  'Tm' : 3.75,
  'Yb' : 3.56,
  'Lu' : 3.44,
  'Hf' : 3.23,
  'Ta' : 3.04,
   'W' : 2.93,
  'Re' : 2.86,
  'Os' : 2.82,
  'Ir' : 2.83,
  'Pt' : 2.88,
  'Au' : 2.98,
  'Hg' : 3.27,
  'Tl' : 3.57,
  'Pb' : 3.14351193885013,
  'Bi' : 3.37,
  'Po' : 3.46,
  'At' : 3.63,
  'Rn' : 4.44,
  'Fr' : 5.81,
  'Ra' : 4.30,
  'Ac' : 3.84,
  'Th' : 3.52,
  'Pa' : 3.32,
   'U' : 3.13,
  'Np' : 3.02,
  'Pu' : 2.96,
  'Am' : 2.93,
  'Cm' : 2.93,
  'Bk' : 2.95,
  'Cf' : 2.99,
  'Es' : 3.05,
  'Fm' : 3.17,
}

"""
`Winger-Seitz radii<https://en.wikipedia.org/wiki/Wigner%E2%80%93Seitz_radius>` 
as dictionary with chemical symbols as keys.

Winger-Seitz radius is a radius of sphere with its volume equal to the volume
per a free electron in a bulk material. 
"""
