def getCloudXRecv(vmanage, deviceId):
    """
    Get CloudExpress routes received list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/cloudx?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getLinkList(vmanage, state):
    """
    Get OMP connection list
    
    Parameters:
    state	 (string):	Connection state
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/links?state={state}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getMcastAdvt(vmanage, deviceId):
    """
    Get OMP multicast autodiscover advertised list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/mcastautodiscoveradvt?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getMcastRecv(vmanage, deviceId):
    """
    Get OMP multicast autodiscover received list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/mcastautodiscoverrecv?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getMcastRoutesAdvt(vmanage, deviceId):
    """
    Get OMP multicast routes advertised list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/mcastroutesadvt?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getMcastRoutesRecv(vmanage, deviceId):
    """
    Get OMP multicast routes received list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/mcastroutesrecv?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getSessionList(vmanage, deviceId):
    """
    Get OMP session list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/peers?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getAdvRoutesList(vmanage, deviceId):
    """
    Get OMP advertised routes list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/routes/advertised?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getAdvRoutesListV6(vmanage, deviceId):
    """
    Get OMP advertised routes list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/routes/advertised/ompIpv6?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getRcvdRouteList(vmanage, deviceId):
    """
    Get OMP received routes list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/routes/received?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getRcvdRouteListVv6(vmanage, deviceId):
    """
    Get OMP received routes list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/routes/received/ompIpv6?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getServices(vmanage, deviceId):
    """
    Get OMP services list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/services?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getDeviceStatus(vmanage):
    """
    Get device OMP status
    
    Parameters:
            
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/status"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getSummary(vmanage, deviceId):
    """
    Get OMP summary
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/summary?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getSyncSessionList(vmanage, deviceId):
    """
    Get OP session list
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/synced/peers?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getAdvTlocsList(vmanage, deviceId):
    """
    Get advertised TLOCs list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/tlocs/advertised?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getRcvdTlocsList(vmanage, deviceId):
    """
    Get received TLOCs list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/omp/tlocs/received?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
