# Generated by Django 2.1.4 on 2019-06-14 11:10

import django.core.files.storage
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import seo.mixins.models
import seo.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ModelInstanceSeo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_type', models.CharField(blank=True, choices=[('article', 'Article'), ('website', 'Website')], default='article', max_length=40, verbose_name='Open graph type')),
                ('twitter_type', models.CharField(blank=True, choices=[('summary', 'Summary Card'), ('summary_large_image', 'Summary Card with Large Image'), ('player', 'Player'), ('app', 'App')], default='summary', max_length=40, verbose_name='Twitter type')),
                ('index', models.CharField(blank=True, choices=[('index', 'Index'), ('noindex', 'No index')], default='index', max_length=15, verbose_name='Index robots value')),
                ('follow', models.CharField(blank=True, choices=[('follow', 'Follow'), ('nofollow', 'No follow')], default='follow', max_length=15, verbose_name='Follow robots value')),
                ('canonical', models.CharField(blank=True, max_length=255, verbose_name='Canonical')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='Title')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='OpenGraph Title')),
                ('keywords', models.TextField(blank=True, verbose_name='Keywords')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('og_description', models.TextField(blank=True, verbose_name='OpenGraph Description')),
                ('image', models.ImageField(blank=True, null=True, storage=django.core.files.storage.FileSystemStorage(), upload_to=seo.utils.image_upload_to, validators=[django.core.validators.FileExtensionValidator(['jpg', 'jpeg', 'png'])], verbose_name='Image')),
                ('width', models.PositiveIntegerField(default=1200, verbose_name='Image width')),
                ('height', models.PositiveIntegerField(default=630, verbose_name='Image height')),
                ('alt', models.CharField(blank=True, max_length=255, verbose_name='Image alt text')),
                ('h1', models.CharField(blank=True, max_length=255, verbose_name='H1 title')),
                ('seo_text', models.TextField(blank=True, help_text='Can be useful for some static pages or some objects (like product category).', verbose_name='Seo text')),
                ('object_id', models.CharField(help_text='Please enter the ID of the related object.', max_length=255, verbose_name='Object Primary Key')),
                ('content_type', models.ForeignKey(help_text='Please select the type (model) for the relation, you want to build.', limit_choices_to={'model__in': ['article', 'user']}, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='Content Type')),
            ],
            options={
                'verbose_name': 'Model instance seo',
                'verbose_name_plural': 'Model instance seo',
            },
            bases=(seo.mixins.models.SeoTagsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='UrlSeo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_type', models.CharField(blank=True, choices=[('article', 'Article'), ('website', 'Website')], default='article', max_length=40, verbose_name='Open graph type')),
                ('twitter_type', models.CharField(blank=True, choices=[('summary', 'Summary Card'), ('summary_large_image', 'Summary Card with Large Image'), ('player', 'Player'), ('app', 'App')], default='summary', max_length=40, verbose_name='Twitter type')),
                ('index', models.CharField(blank=True, choices=[('index', 'Index'), ('noindex', 'No index')], default='index', max_length=15, verbose_name='Index robots value')),
                ('follow', models.CharField(blank=True, choices=[('follow', 'Follow'), ('nofollow', 'No follow')], default='follow', max_length=15, verbose_name='Follow robots value')),
                ('canonical', models.CharField(blank=True, max_length=255, verbose_name='Canonical')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='Title')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='OpenGraph Title')),
                ('keywords', models.TextField(blank=True, verbose_name='Keywords')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('og_description', models.TextField(blank=True, verbose_name='OpenGraph Description')),
                ('image', models.ImageField(blank=True, null=True, storage=django.core.files.storage.FileSystemStorage(), upload_to=seo.utils.image_upload_to, validators=[django.core.validators.FileExtensionValidator(['jpg', 'jpeg', 'png'])], verbose_name='Image')),
                ('width', models.PositiveIntegerField(default=1200, verbose_name='Image width')),
                ('height', models.PositiveIntegerField(default=630, verbose_name='Image height')),
                ('alt', models.CharField(blank=True, max_length=255, verbose_name='Image alt text')),
                ('h1', models.CharField(blank=True, max_length=255, verbose_name='H1 title')),
                ('seo_text', models.TextField(blank=True, help_text='Can be useful for some static pages or some objects (like product category).', verbose_name='Seo text')),
                ('url', models.CharField(db_index=True, max_length=255, unique=True, verbose_name='Url')),
                ('is_default', models.BooleanField(default=False, help_text='Default instance for all pages.', verbose_name='Is default')),
            ],
            options={
                'verbose_name': 'Url seo',
                'verbose_name_plural': 'Url seo',
            },
            bases=(seo.mixins.models.SeoTagsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ViewSeo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_type', models.CharField(blank=True, choices=[('article', 'Article'), ('website', 'Website')], default='article', max_length=40, verbose_name='Open graph type')),
                ('twitter_type', models.CharField(blank=True, choices=[('summary', 'Summary Card'), ('summary_large_image', 'Summary Card with Large Image'), ('player', 'Player'), ('app', 'App')], default='summary', max_length=40, verbose_name='Twitter type')),
                ('index', models.CharField(blank=True, choices=[('index', 'Index'), ('noindex', 'No index')], default='index', max_length=15, verbose_name='Index robots value')),
                ('follow', models.CharField(blank=True, choices=[('follow', 'Follow'), ('nofollow', 'No follow')], default='follow', max_length=15, verbose_name='Follow robots value')),
                ('canonical', models.CharField(blank=True, max_length=255, verbose_name='Canonical')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='Title')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='OpenGraph Title')),
                ('keywords', models.TextField(blank=True, verbose_name='Keywords')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('og_description', models.TextField(blank=True, verbose_name='OpenGraph Description')),
                ('image', models.ImageField(blank=True, null=True, storage=django.core.files.storage.FileSystemStorage(), upload_to=seo.utils.image_upload_to, validators=[django.core.validators.FileExtensionValidator(['jpg', 'jpeg', 'png'])], verbose_name='Image')),
                ('width', models.PositiveIntegerField(default=1200, verbose_name='Image width')),
                ('height', models.PositiveIntegerField(default=630, verbose_name='Image height')),
                ('alt', models.CharField(blank=True, max_length=255, verbose_name='Image alt text')),
                ('h1', models.CharField(blank=True, max_length=255, verbose_name='H1 title')),
                ('seo_text', models.TextField(blank=True, help_text='Can be useful for some static pages or some objects (like product category).', verbose_name='Seo text')),
                ('view', models.CharField(choices=[('index', 'Index')], max_length=100, unique=True, verbose_name='View')),
            ],
            options={
                'verbose_name': 'View seo',
                'verbose_name_plural': 'View seo',
            },
            bases=(seo.mixins.models.SeoTagsMixin, models.Model),
        ),
    ]
