# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-04-15T11:34:18+00:00

from __future__ import annotations

from datetime import datetime, timedelta
from typing import Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, constr


class ApplyResponse(BaseModel):
    status: Literal['applied', 'nothing to apply'] = Field(..., title='Status')


class BatchSource(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the batch source.', title='Name'
    )
    timestamp_field: Optional[str] = Field(
        None,
        description='Event timestamp field used for point-in-time joins of attribute values.',
        title='Timestamp Field',
    )
    created_timestamp_column: Optional[str] = Field(
        None,
        description='Timestamp column indicating when the row was created, used for deduplicating rows.',
        title='Created Timestamp Column',
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    owner: Optional[str] = Field(
        None,
        description='The owner of the data source, typically the email of the primary maintainer.',
        title='Owner',
    )
    date_partition_column: Optional[str] = Field(
        None,
        description='Timestamp column used for partitioning.',
        title='Date Partition Column',
    )
    database: str = Field(
        ..., description='Database where the attributes are stored.', title='Database'
    )
    schema_: str = Field(
        ...,
        alias='schema',
        description='Schema in which the table is located.',
        title='Schema',
    )
    table: str = Field(
        ..., description='Table where the attributes are stored.', title='Table'
    )


class Criterion(BaseModel):
    property_syntax: Optional[Literal['blobl', 'snowflake']] = Field(
        'snowflake',
        description='The syntax used to reference the property.',
        title='Property Syntax',
    )
    property: str = Field(
        ...,
        description='The path to the property on the event or entity you wish to filter.',
        title='Property',
    )
    operator: Literal['=', '!=', '<', '>', '<=', '>=', 'like', 'in'] = Field(
        ...,
        description='The operator used to compare the property to the value.',
        title='Operator',
    )
    value: Union[
        str, int, float, bool, List[str], List[int], List[float], List[bool]
    ] = Field(..., description='The value to compare the property to.', title='Value')


class Entity(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    key: Optional[constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128)] = (
        Field(
            None,
            description='The key used to join this entity to an attribute table. If not specified, the name is used.',
            title='Key',
        )
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    owner: Optional[str] = Field(
        None,
        description='The owner of the entity, typically the email of the primary maintainer.',
        title='Owner',
    )
    ttl: Optional[timedelta] = Field(
        None,
        description='The amount of time that attributes for the entity will live in the online store. If not specified both here and in the View, the ttl is not limited.',
        title='Ttl',
    )


class EntityIdentifiers(BaseModel):
    session: Optional[List] = Field(None, title='Session')
    user: Optional[List] = Field(None, title='User')


class Event(BaseModel):
    name: Optional[
        constr(pattern=r'^[a-zA-Z0-9-_]+$', min_length=1, max_length=128)
    ] = Field(
        None,
        description='Name of the event (`event_name` column in atomic.events table).',
        title='Name',
    )
    vendor: Optional[
        constr(pattern=r'^[a-zA-Z0-9-_.]+$', min_length=1, max_length=128)
    ] = Field(
        None,
        description='Vendor of the event (`event_vendor` column in atomic.events table).',
        title='Vendor',
    )
    version: Optional[constr(pattern=r'^[0-9]+-[0-9]+-[0-9]+$')] = Field(
        None,
        description='Version of the event (`event_version` column in atomic.events table).',
        title='Version',
    )


class FieldModel(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The name of the field.', title='Name'
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    type: Literal[
        'bytes',
        'string',
        'int32',
        'int64',
        'double',
        'float',
        'bool',
        'unix_timestamp',
        'bytes_list',
        'string_list',
        'int32_list',
        'int64_list',
        'double_list',
        'float_list',
        'bool_list',
        'unix_timestamp_list',
    ] = Field(
        ..., description='The type of the field, such as string or float.', title='Type'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )


class GetOnlineAttributesRequest(BaseModel):
    entities: EntityIdentifiers
    service: Optional[str] = Field(None, title='Service')
    attributes: Optional[List[str]] = Field(None, title='Attributes')
    full_attribute_names: Optional[bool] = Field(False, title='Full Attribute Names')


class LinkEntity(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )


class PushAttributesRequest(BaseModel):
    push_source_name: str = Field(..., title='Push Source Name')
    df: Dict[str, List] = Field(..., title='Df')
    allow_registry_cache: Optional[bool] = Field(True, title='Allow Registry Cache')
    to: Optional[Literal['online', 'online_and_offline']] = Field('online', title='To')


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class VersionedLinkView(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )
    version: Optional[int] = Field(
        1, description='The version of the object.', title='Version'
    )


class Criteria(BaseModel):
    all: Optional[List[Criterion]] = Field(
        None,
        description='An array of conditions used to filter the events. All conditions must be met.',
        title='All',
    )
    any: Optional[List[Criterion]] = Field(
        None,
        description='An array of conditions used to filter the events. At least one condition must be met.',
        title='Any',
    )


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class Service(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    views: Optional[List[VersionedLinkView]] = Field(
        None,
        description='A list containing views, representing the features in the service.',
        max_length=100,
        min_length=1,
        title='Views',
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    owner: Optional[str] = Field(
        None,
        description='The owner of the service, typically the email of the primary maintainer.',
        title='Owner',
    )


class AttributeInput(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The name of the field.', title='Name'
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    type: Literal[
        'bytes',
        'string',
        'int32',
        'int64',
        'double',
        'float',
        'bool',
        'unix_timestamp',
        'bytes_list',
        'string_list',
        'int32_list',
        'int64_list',
        'double_list',
        'float_list',
        'bool_list',
        'unix_timestamp_list',
    ] = Field(
        ..., description='The type of the field, such as string or float.', title='Type'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    events: List[Event] = Field(
        ...,
        description='An array of event schemas that the attribute should be calculated for.',
        min_length=1,
        title='Events',
    )
    aggregation: Literal[
        'counter', 'sum', 'min', 'max', 'mean', 'first', 'last', 'unique_list'
    ] = Field(
        ..., description='The aggregation type of the attribute.', title='Aggregation'
    )
    property_syntax: Optional[Literal['blobl', 'snowflake']] = Field(
        'snowflake',
        description='The syntax used to reference the property.',
        title='Property Syntax',
    )
    property: Optional[str] = Field(
        None,
        description='The path to the property on the event or entity you wish to use in the aggregation.',
        title='Property',
    )
    criteria: Optional[Criteria] = Field(
        None, description='An array of conditions used to filter the events.'
    )
    period: Optional[timedelta] = Field(
        None,
        description='The time period over which the aggregation should be calculated.',
        title='Period',
    )
    default_value: Optional[
        Union[str, int, float, bool, List[Union[str, int, float, bool]]]
    ] = Field(
        None,
        description='The default value to use if the aggregation returns no results. If not set, the default value is automatically assigned based on the `type`.',
        title='Default Value',
    )


class AttributeOutput(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The name of the field.', title='Name'
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    type: Literal[
        'bytes',
        'string',
        'int32',
        'int64',
        'double',
        'float',
        'bool',
        'unix_timestamp',
        'bytes_list',
        'string_list',
        'int32_list',
        'int64_list',
        'double_list',
        'float_list',
        'bool_list',
        'unix_timestamp_list',
    ] = Field(
        ..., description='The type of the field, such as string or float.', title='Type'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    events: List[Event] = Field(
        ...,
        description='An array of event schemas that the attribute should be calculated for.',
        min_length=1,
        title='Events',
    )
    aggregation: Literal[
        'counter', 'sum', 'min', 'max', 'mean', 'first', 'last', 'unique_list'
    ] = Field(
        ..., description='The aggregation type of the attribute.', title='Aggregation'
    )
    property_syntax: Optional[Literal['blobl', 'snowflake']] = Field(
        'snowflake',
        description='The syntax used to reference the property.',
        title='Property Syntax',
    )
    property: Optional[str] = Field(
        None,
        description='The path to the property on the event or entity you wish to use in the aggregation.',
        title='Property',
    )
    criteria: Optional[Criteria] = Field(
        None, description='An array of conditions used to filter the events.'
    )
    period: Optional[timedelta] = Field(
        None,
        description='The time period over which the aggregation should be calculated.',
        title='Period',
    )
    default_value: Optional[
        Union[str, int, float, bool, List[Union[str, int, float, bool]]]
    ] = Field(
        None,
        description='The default value to use if the aggregation returns no results. If not set, the default value is automatically assigned based on the `type`.',
        title='Default Value',
    )


class ViewInput(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )
    version: Optional[int] = Field(
        1, description='The version of the object.', title='Version'
    )
    entity: LinkEntity = Field(
        ..., description='The entity that this view is associated with.'
    )
    ttl: Optional[timedelta] = Field(
        None,
        description="The amount of time this group of attributes lives. If not specified, the entity's ttl is used or the ttl is not limited.",
        title='Ttl',
    )
    batch_source: Optional[BatchSource] = Field(
        None,
        description='The batch source for materializing this feature view from the warehouse.',
    )
    online: Optional[bool] = Field(
        True,
        description='A boolean indicating whether online retrieval is enabled for this feature view.',
        title='Online',
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    owner: Optional[str] = Field(
        None,
        description='The owner of the feature view, typically the email of the primary maintainer.',
        title='Owner',
    )
    fields: Optional[List[FieldModel]] = Field(
        None,
        description='The list of table columns that are part of this view during materialization.',
        title='Fields',
    )
    attributes: Optional[List[AttributeInput]] = Field(
        None,
        description='The list of attributes that will be calculated from events as part of this view.',
        title='Attributes',
    )


class ViewOutput(BaseModel):
    name: constr(pattern=r'^[A-Za-z0-9_]+$', min_length=1, max_length=128) = Field(
        ..., description='The unique name of the object.', title='Name'
    )
    version: Optional[int] = Field(
        1, description='The version of the object.', title='Version'
    )
    entity: LinkEntity = Field(
        ..., description='The entity that this view is associated with.'
    )
    ttl: Optional[timedelta] = Field(
        None,
        description="The amount of time this group of attributes lives. If not specified, the entity's ttl is used or the ttl is not limited.",
        title='Ttl',
    )
    batch_source: Optional[BatchSource] = Field(
        None,
        description='The batch source for materializing this feature view from the warehouse.',
    )
    online: Optional[bool] = Field(
        True,
        description='A boolean indicating whether online retrieval is enabled for this feature view.',
        title='Online',
    )
    description: Optional[str] = Field(
        None, description='A human-readable description.', title='Description'
    )
    tags: Optional[Dict[str, str]] = Field(
        None,
        description='A dictionary of key-value pairs to store arbitrary metadata.',
        title='Tags',
    )
    owner: Optional[str] = Field(
        None,
        description='The owner of the feature view, typically the email of the primary maintainer.',
        title='Owner',
    )
    fields: Optional[List[FieldModel]] = Field(
        None,
        description='The list of table columns that are part of this view during materialization.',
        title='Fields',
    )
    attributes: Optional[List[AttributeOutput]] = Field(
        None,
        description='The list of attributes that will be calculated from events as part of this view.',
        title='Attributes',
    )
    feast_name: str = Field(..., title='Feast Name')
    offline: bool = Field(..., title='Offline')
    stream_source_name: Optional[str] = Field(..., title='Stream Source Name')
    entity_key: str = Field(..., title='Entity Key')
    view_or_entity_ttl: Optional[timedelta] = Field(..., title='View Or Entity Ttl')


class AppliedAttributesForStream(BaseModel):
    views: List[ViewOutput] = Field(..., title='Views')
    applied_at: Optional[datetime] = Field(None, title='Applied At')


class TestViewRequest(BaseModel):
    view: ViewInput = Field(..., description='View to test')
    app_ids: Optional[List[str]] = Field(
        None,
        description='List of app_ids to test. If empty, all app_ids will be tested',
        title='App Ids',
    )
    window: Optional[timedelta] = Field(
        'PT1H',
        description='The time window to consider when querying the atomic events table',
        title='Window',
    )
    entity_ids: List[str] = Field(
        ...,
        description='List of entity IDs to test (e.g., list of domain_userid). If empty, a sample of 10 random IDs will be used',
        title='Entity Ids',
    )
