"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IAwsApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
exports.ActualResult = ActualResult;
_a = JSII_RTTI_SYMBOL_1;
ActualResult[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ActualResult", version: "2.32.1-alpha.0" };
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     * });
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
exports.ExpectedResult = ExpectedResult;
_b = JSII_RTTI_SYMBOL_1;
ExpectedResult[_b] = { fqn: "@aws-cdk/integ-tests-alpha.ExpectedResult", version: "2.32.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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