# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev5
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class ApplicationRequest(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "business_name",
            "business_phone",
            "partner_id",
            "business_address",
            "bank_id",
            "business_tax_id",
            "business_type",
            "doing_business_as",
            "enabled",
            "max_transaction_amount",
        }
        
        class properties:
            bank_id = schemas.IntSchema
        
            @staticmethod
            def business_address() -> typing.Type['Address1']:
                return Address1
            business_name = schemas.StrSchema
            business_phone = schemas.StrSchema
            
            
            class business_tax_id(
                schemas.StrSchema
            ):
                pass
            
            
            class business_type(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def INDIVIDUAL_SOLE_PROPRIETORSHIP(cls):
                    return cls("INDIVIDUAL_SOLE_PROPRIETORSHIP")
                
                @schemas.classproperty
                def CORPORATION(cls):
                    return cls("CORPORATION")
                
                @schemas.classproperty
                def LIMITED_LIABILITY_COMPANY(cls):
                    return cls("LIMITED_LIABILITY_COMPANY")
                
                @schemas.classproperty
                def PARTNERSHIP(cls):
                    return cls("PARTNERSHIP")
                
                @schemas.classproperty
                def ASSOCIATION_ESTATE_TRUST(cls):
                    return cls("ASSOCIATION_ESTATE_TRUST")
                
                @schemas.classproperty
                def TAX_EXEMPT_ORGANIZATION(cls):
                    return cls("TAX_EXEMPT_ORGANIZATION")
                
                @schemas.classproperty
                def INTERNATIONAL_ORGANIZATION(cls):
                    return cls("INTERNATIONAL_ORGANIZATION")
                
                @schemas.classproperty
                def GOVERNMENT_AGENCY(cls):
                    return cls("GOVERNMENT_AGENCY")
            doing_business_as = schemas.StrSchema
            enabled = schemas.BoolSchema
            max_transaction_amount = schemas.IntSchema
            partner_id = schemas.IntSchema
        
            @staticmethod
            def dob() -> typing.Type['ExternalPaymentDate']:
                return ExternalPaymentDate
            email = schemas.StrSchema
            first_name = schemas.StrSchema
        
            @staticmethod
            def incorporation_date() -> typing.Type['ExternalPaymentDate']:
                return ExternalPaymentDate
            last_name = schemas.StrSchema
        
            @staticmethod
            def personal_address() -> typing.Type['Address1']:
                return Address1
            phone = schemas.StrSchema
            principal_percentage_ownership = schemas.StrSchema
            
            
            class tax_id(
                schemas.StrSchema
            ):
                pass
            title = schemas.StrSchema
            url = schemas.StrSchema
            __annotations__ = {
                "bank_id": bank_id,
                "business_address": business_address,
                "business_name": business_name,
                "business_phone": business_phone,
                "business_tax_id": business_tax_id,
                "business_type": business_type,
                "doing_business_as": doing_business_as,
                "enabled": enabled,
                "max_transaction_amount": max_transaction_amount,
                "partner_id": partner_id,
                "dob": dob,
                "email": email,
                "first_name": first_name,
                "incorporation_date": incorporation_date,
                "last_name": last_name,
                "personal_address": personal_address,
                "phone": phone,
                "principal_percentage_ownership": principal_percentage_ownership,
                "tax_id": tax_id,
                "title": title,
                "url": url,
            }
    
    business_name: MetaOapg.properties.business_name
    business_phone: MetaOapg.properties.business_phone
    partner_id: MetaOapg.properties.partner_id
    business_address: 'Address1'
    bank_id: MetaOapg.properties.bank_id
    business_tax_id: MetaOapg.properties.business_tax_id
    business_type: MetaOapg.properties.business_type
    doing_business_as: MetaOapg.properties.doing_business_as
    enabled: MetaOapg.properties.enabled
    max_transaction_amount: MetaOapg.properties.max_transaction_amount
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_address"]) -> 'Address1': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_name"]) -> MetaOapg.properties.business_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_phone"]) -> MetaOapg.properties.business_phone: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_tax_id"]) -> MetaOapg.properties.business_tax_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["business_type"]) -> MetaOapg.properties.business_type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["doing_business_as"]) -> MetaOapg.properties.doing_business_as: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enabled"]) -> MetaOapg.properties.enabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["max_transaction_amount"]) -> MetaOapg.properties.max_transaction_amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dob"]) -> 'ExternalPaymentDate': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["email"]) -> MetaOapg.properties.email: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["first_name"]) -> MetaOapg.properties.first_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["incorporation_date"]) -> 'ExternalPaymentDate': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["last_name"]) -> MetaOapg.properties.last_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["personal_address"]) -> 'Address1': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["phone"]) -> MetaOapg.properties.phone: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["principal_percentage_ownership"]) -> MetaOapg.properties.principal_percentage_ownership: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tax_id"]) -> MetaOapg.properties.tax_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["title"]) -> MetaOapg.properties.title: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["url"]) -> MetaOapg.properties.url: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["bank_id", "business_address", "business_name", "business_phone", "business_tax_id", "business_type", "doing_business_as", "enabled", "max_transaction_amount", "partner_id", "dob", "email", "first_name", "incorporation_date", "last_name", "personal_address", "phone", "principal_percentage_ownership", "tax_id", "title", "url", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_address"]) -> 'Address1': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_name"]) -> MetaOapg.properties.business_name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_phone"]) -> MetaOapg.properties.business_phone: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_tax_id"]) -> MetaOapg.properties.business_tax_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["business_type"]) -> MetaOapg.properties.business_type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["doing_business_as"]) -> MetaOapg.properties.doing_business_as: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enabled"]) -> MetaOapg.properties.enabled: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["max_transaction_amount"]) -> MetaOapg.properties.max_transaction_amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dob"]) -> typing.Union['ExternalPaymentDate', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["email"]) -> typing.Union[MetaOapg.properties.email, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["first_name"]) -> typing.Union[MetaOapg.properties.first_name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["incorporation_date"]) -> typing.Union['ExternalPaymentDate', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["last_name"]) -> typing.Union[MetaOapg.properties.last_name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["personal_address"]) -> typing.Union['Address1', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["phone"]) -> typing.Union[MetaOapg.properties.phone, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["principal_percentage_ownership"]) -> typing.Union[MetaOapg.properties.principal_percentage_ownership, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tax_id"]) -> typing.Union[MetaOapg.properties.tax_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["title"]) -> typing.Union[MetaOapg.properties.title, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["url"]) -> typing.Union[MetaOapg.properties.url, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["bank_id", "business_address", "business_name", "business_phone", "business_tax_id", "business_type", "doing_business_as", "enabled", "max_transaction_amount", "partner_id", "dob", "email", "first_name", "incorporation_date", "last_name", "personal_address", "phone", "principal_percentage_ownership", "tax_id", "title", "url", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        business_name: typing.Union[MetaOapg.properties.business_name, str, ],
        business_phone: typing.Union[MetaOapg.properties.business_phone, str, ],
        partner_id: typing.Union[MetaOapg.properties.partner_id, decimal.Decimal, int, ],
        business_address: 'Address1',
        bank_id: typing.Union[MetaOapg.properties.bank_id, decimal.Decimal, int, ],
        business_tax_id: typing.Union[MetaOapg.properties.business_tax_id, str, ],
        business_type: typing.Union[MetaOapg.properties.business_type, str, ],
        doing_business_as: typing.Union[MetaOapg.properties.doing_business_as, str, ],
        enabled: typing.Union[MetaOapg.properties.enabled, bool, ],
        max_transaction_amount: typing.Union[MetaOapg.properties.max_transaction_amount, decimal.Decimal, int, ],
        dob: typing.Union['ExternalPaymentDate', schemas.Unset] = schemas.unset,
        email: typing.Union[MetaOapg.properties.email, str, schemas.Unset] = schemas.unset,
        first_name: typing.Union[MetaOapg.properties.first_name, str, schemas.Unset] = schemas.unset,
        incorporation_date: typing.Union['ExternalPaymentDate', schemas.Unset] = schemas.unset,
        last_name: typing.Union[MetaOapg.properties.last_name, str, schemas.Unset] = schemas.unset,
        personal_address: typing.Union['Address1', schemas.Unset] = schemas.unset,
        phone: typing.Union[MetaOapg.properties.phone, str, schemas.Unset] = schemas.unset,
        principal_percentage_ownership: typing.Union[MetaOapg.properties.principal_percentage_ownership, str, schemas.Unset] = schemas.unset,
        tax_id: typing.Union[MetaOapg.properties.tax_id, str, schemas.Unset] = schemas.unset,
        title: typing.Union[MetaOapg.properties.title, str, schemas.Unset] = schemas.unset,
        url: typing.Union[MetaOapg.properties.url, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'ApplicationRequest':
        return super().__new__(
            cls,
            *_args,
            business_name=business_name,
            business_phone=business_phone,
            partner_id=partner_id,
            business_address=business_address,
            bank_id=bank_id,
            business_tax_id=business_tax_id,
            business_type=business_type,
            doing_business_as=doing_business_as,
            enabled=enabled,
            max_transaction_amount=max_transaction_amount,
            dob=dob,
            email=email,
            first_name=first_name,
            incorporation_date=incorporation_date,
            last_name=last_name,
            personal_address=personal_address,
            phone=phone,
            principal_percentage_ownership=principal_percentage_ownership,
            tax_id=tax_id,
            title=title,
            url=url,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.address1 import Address1
from synctera_client.model.external_payment_date import ExternalPaymentDate
