# synctera-client
<h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.32.0.dev5
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import synctera_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import synctera_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import synctera_client
from pprint import pprint
from synctera_client.apis.tags import ach_api
from synctera_client.model.error import Error
from synctera_client.model.outgoing_ach import OutgoingAch
from synctera_client.model.outgoing_ach_list import OutgoingAchList
from synctera_client.model.outgoing_ach_patch import OutgoingAchPatch
from synctera_client.model.outgoing_ach_request import OutgoingAchRequest
# Defining the host is optional and defaults to https://api.synctera.com/v0
# See configuration.py for a list of all supported configuration parameters.
configuration = synctera_client.Configuration(
    host = "https://api.synctera.com/v0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (api_key): bearerAuth
configuration = synctera_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with synctera_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ach_api.ACHApi(api_client)
    outgoing_ach_request = OutgoingAchRequest(
        amount=607,
        company_entry_description="PAYROLL",
        currency="USD",
        customer_id="e9061cf1-b472-4066-bf4b-2491b33fd182",
        dc_sign="debit",
        effective_date="Fri Mar 18 00:00:00 UTC 2022",
        external_data=dict(),
        final_customer_id="final_customer_id_example",
        hold=AchRequestHoldData(
            amount=1,
            duration=2,
        ),
        id="cf0b50d4-f2f9-429b-bb6d-995a2e06d83a",
        is_same_day=True,
        memo="memo_example",
        originating_account_id="b58b33b8-9629-4414-91ee-62c0b200c7b4",
        receiving_account_id="3110c3f4-7937-4010-bded-86917767f50b",
        reference_info="Tempore atque et cum.",
        risk=RiskData(
            client_ip="client_ip_example",
        ),
    ) # OutgoingAchRequest | Send ACH request
idempotency_key = "7d943c51-e4ff-4e57-9558-08cab6b963c7" # str | An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry. (optional)

    try:
        # Send an ACH
        api_response = api_instance.add_transaction_out(outgoing_ach_requestidempotency_key=idempotency_key)
        pprint(api_response)
    except synctera_client.ApiException as e:
        print("Exception when calling ACHApi->add_transaction_out: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.synctera.com/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ACHApi* | [**add_transaction_out**](docs/apis/tags/ACHApi.md#add_transaction_out) | **post** /ach | Send an ACH
*ACHApi* | [**get_transaction_out**](docs/apis/tags/ACHApi.md#get_transaction_out) | **get** /ach/{transaction_id} | Get a sent ACH transaction
*ACHApi* | [**list_transactions_out**](docs/apis/tags/ACHApi.md#list_transactions_out) | **get** /ach | List sent ACH transactions
*ACHApi* | [**patch_transaction_out**](docs/apis/tags/ACHApi.md#patch_transaction_out) | **patch** /ach/{transaction_id} | Update a sent ACH transaction
*ACHTransactionSimulationsApi* | [**ach_return_simulation**](docs/apis/tags/ACHTransactionSimulationsApi.md#ach_return_simulation) | **post** /ach/transaction_simulations/receiving_return | Simulate receiving ACH return
*ACHTransactionSimulationsApi* | [**ach_transaction_simulation**](docs/apis/tags/ACHTransactionSimulationsApi.md#ach_transaction_simulation) | **post** /ach/transaction_simulations/receiving_transaction | Simulate receiving ACH transaction
*AccountsApi* | [**create_account**](docs/apis/tags/AccountsApi.md#create_account) | **post** /accounts | Create an account
*AccountsApi* | [**create_account_relationship**](docs/apis/tags/AccountsApi.md#create_account_relationship) | **post** /accounts/{account_id}/relationships | Create account relationship
*AccountsApi* | [**create_account_resource_product**](docs/apis/tags/AccountsApi.md#create_account_resource_product) | **post** /accounts/products | Create an account product
*AccountsApi* | [**create_account_template**](docs/apis/tags/AccountsApi.md#create_account_template) | **post** /accounts/templates | Create an account template
*AccountsApi* | [**delete_account_relationship**](docs/apis/tags/AccountsApi.md#delete_account_relationship) | **delete** /accounts/{account_id}/relationships/{relationship_id} | Delete account relationship
*AccountsApi* | [**delete_account_template**](docs/apis/tags/AccountsApi.md#delete_account_template) | **delete** /accounts/templates/{template_id} | Delete account template
*AccountsApi* | [**get_account**](docs/apis/tags/AccountsApi.md#get_account) | **get** /accounts/{account_id} | Get account
*AccountsApi* | [**get_account_relationship**](docs/apis/tags/AccountsApi.md#get_account_relationship) | **get** /accounts/{account_id}/relationships/{relationship_id} | Get account relationship
*AccountsApi* | [**get_account_template**](docs/apis/tags/AccountsApi.md#get_account_template) | **get** /accounts/templates/{template_id} | Get account template
*AccountsApi* | [**list_account_relationship**](docs/apis/tags/AccountsApi.md#list_account_relationship) | **get** /accounts/{account_id}/relationships | List account relationships
*AccountsApi* | [**list_account_resource_products**](docs/apis/tags/AccountsApi.md#list_account_resource_products) | **get** /accounts/products | List account products
*AccountsApi* | [**list_account_templates**](docs/apis/tags/AccountsApi.md#list_account_templates) | **get** /accounts/templates | List account templates
*AccountsApi* | [**list_accounts**](docs/apis/tags/AccountsApi.md#list_accounts) | **get** /accounts | List accounts
*AccountsApi* | [**patch_account**](docs/apis/tags/AccountsApi.md#patch_account) | **patch** /accounts/{account_id} | Patch account
*AccountsApi* | [**patch_account_product**](docs/apis/tags/AccountsApi.md#patch_account_product) | **patch** /accounts/products/{product_id} | Patch account product
*AccountsApi* | [**update_account**](docs/apis/tags/AccountsApi.md#update_account) | **put** /accounts/{account_id} | Update account
*AccountsApi* | [**update_account_relationship**](docs/apis/tags/AccountsApi.md#update_account_relationship) | **put** /accounts/{account_id}/relationships/{relationship_id} | Update account relationship
*AccountsApi* | [**update_account_template**](docs/apis/tags/AccountsApi.md#update_account_template) | **put** /accounts/templates/{template_id} | Update account template
*BusinessesApi* | [**create_business**](docs/apis/tags/BusinessesApi.md#create_business) | **post** /businesses | Create a business
*BusinessesApi* | [**get_business**](docs/apis/tags/BusinessesApi.md#get_business) | **get** /businesses/{business_id} | Get business
*BusinessesApi* | [**list_businesses**](docs/apis/tags/BusinessesApi.md#list_businesses) | **get** /businesses | List business
*BusinessesApi* | [**update_business**](docs/apis/tags/BusinessesApi.md#update_business) | **patch** /businesses/{business_id} | Patch business
*CardTransactionSimulationsApi* | [**simulate_authorization**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_authorization) | **post** /cards/transaction_simulations/authorization | Simulate authorization
*CardTransactionSimulationsApi* | [**simulate_authorization_advice**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_authorization_advice) | **post** /cards/transaction_simulations/authorization/advice | Simulate authorization advice
*CardTransactionSimulationsApi* | [**simulate_balance_inquiry**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_balance_inquiry) | **post** /cards/transaction_simulations/financial/balance_inquiry | Simulate balance inquiry
*CardTransactionSimulationsApi* | [**simulate_clearing**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_clearing) | **post** /cards/transaction_simulations/clearing | Simulate clearing or refund
*CardTransactionSimulationsApi* | [**simulate_financial**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_financial) | **post** /cards/transaction_simulations/financial | Simulate financial
*CardTransactionSimulationsApi* | [**simulate_financial_advice**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_financial_advice) | **post** /cards/transaction_simulations/financial/advice | Simulate financial advice
*CardTransactionSimulationsApi* | [**simulate_original_credit**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_original_credit) | **post** /cards/transaction_simulations/financial/original_credit | Simulate OCT
*CardTransactionSimulationsApi* | [**simulate_reversal**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_reversal) | **post** /cards/transaction_simulations/reversal | Simulate reversal
*CardTransactionSimulationsApi* | [**simulate_withdrawal**](docs/apis/tags/CardTransactionSimulationsApi.md#simulate_withdrawal) | **post** /cards/transaction_simulations/financial/withdrawal | Simulate ATM withdrawal
*CardWebhookSimulationsApi* | [**simulate_card_fulfillment_event**](docs/apis/tags/CardWebhookSimulationsApi.md#simulate_card_fulfillment_event) | **post** /cards/{card_id}/webhook_simulations/fulfillment | Simulate Card Fulfillment Event
*CardsApi* | [**activate_card**](docs/apis/tags/CardsApi.md#activate_card) | **post** /cards/activate | Activate a card
*CardsApi* | [**create_card_image**](docs/apis/tags/CardsApi.md#create_card_image) | **post** /cards/images | Create Card Image
*CardsApi* | [**create_gateway**](docs/apis/tags/CardsApi.md#create_gateway) | **post** /cards/gateways | Create Gateway
*CardsApi* | [**get_card**](docs/apis/tags/CardsApi.md#get_card) | **get** /cards/{card_id} | Get Card
*CardsApi* | [**get_card_barcode**](docs/apis/tags/CardsApi.md#get_card_barcode) | **get** /cards/{card_id}/barcodes | Get Card Barcode
*CardsApi* | [**get_card_image_data**](docs/apis/tags/CardsApi.md#get_card_image_data) | **get** /cards/images/{card_image_id}/data | Get Card Image Data
*CardsApi* | [**get_card_image_details**](docs/apis/tags/CardsApi.md#get_card_image_details) | **get** /cards/images/{card_image_id} | Get Card Image Details
*CardsApi* | [**get_card_widget_url**](docs/apis/tags/CardsApi.md#get_card_widget_url) | **get** /cards/card_widget_url | Get card widget URL
*CardsApi* | [**get_client_access_token**](docs/apis/tags/CardsApi.md#get_client_access_token) | **post** /cards/{card_id}/client_token | Get a client token
*CardsApi* | [**get_client_single_use_token**](docs/apis/tags/CardsApi.md#get_client_single_use_token) | **post** /cards/single_use_token | Get single-use token
*CardsApi* | [**get_gateway**](docs/apis/tags/CardsApi.md#get_gateway) | **get** /cards/gateways/{gateway_id} | Get Gateway
*CardsApi* | [**issue_card**](docs/apis/tags/CardsApi.md#issue_card) | **post** /cards | Issue a Card
*CardsApi* | [**list_card_image_details**](docs/apis/tags/CardsApi.md#list_card_image_details) | **get** /cards/images | List Card Image Details
*CardsApi* | [**list_card_products**](docs/apis/tags/CardsApi.md#list_card_products) | **get** /cards/products | List Card Products
*CardsApi* | [**list_cards**](docs/apis/tags/CardsApi.md#list_cards) | **get** /cards | List Cards
*CardsApi* | [**list_changes**](docs/apis/tags/CardsApi.md#list_changes) | **get** /cards/{card_id}/changes | List Card Changes
*CardsApi* | [**list_gateways**](docs/apis/tags/CardsApi.md#list_gateways) | **get** /cards/gateways | List Gateways
*CardsApi* | [**update_card**](docs/apis/tags/CardsApi.md#update_card) | **patch** /cards/{card_id} | Update Card
*CardsApi* | [**update_card_image_details**](docs/apis/tags/CardsApi.md#update_card_image_details) | **patch** /cards/images/{card_image_id} | Update Card Image Details
*CardsApi* | [**update_gateway**](docs/apis/tags/CardsApi.md#update_gateway) | **patch** /cards/gateways/{gateway_id} | Update Gateway
*CardsApi* | [**upload_card_image_data**](docs/apis/tags/CardsApi.md#upload_card_image_data) | **post** /cards/images/{card_image_id}/data | Upload Card Image
*CashPickupsAlphaApi* | [**create_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#create_cash_pickup) | **post** /cash_pickups | Create a cash pickup
*CashPickupsAlphaApi* | [**get_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#get_cash_pickup) | **get** /cash_pickups/{cash_pickup_id} | Get a cash pickup
*CashPickupsAlphaApi* | [**list_cash_pickups**](docs/apis/tags/CashPickupsAlphaApi.md#list_cash_pickups) | **get** /cash_pickups | List cash pickups
*CashPickupsAlphaApi* | [**patch_cash_pickup**](docs/apis/tags/CashPickupsAlphaApi.md#patch_cash_pickup) | **patch** /cash_pickups/{cash_pickup_id} | Update a cash pickup
*CustomersApi* | [**create_customer**](docs/apis/tags/CustomersApi.md#create_customer) | **post** /customers | Create a Customer
*CustomersApi* | [**create_customer_employment**](docs/apis/tags/CustomersApi.md#create_customer_employment) | **post** /customers/{customer_id}/employment | Create employment record
*CustomersApi* | [**create_customer_risk_rating**](docs/apis/tags/CustomersApi.md#create_customer_risk_rating) | **post** /customers/{customer_id}/risk_ratings | Create customer risk rating
*CustomersApi* | [**get_all_customer_employment**](docs/apis/tags/CustomersApi.md#get_all_customer_employment) | **get** /customers/{customer_id}/employment | List customer employment records
*CustomersApi* | [**get_all_customer_risk_ratings**](docs/apis/tags/CustomersApi.md#get_all_customer_risk_ratings) | **get** /customers/{customer_id}/risk_ratings | List customer risk ratings
*CustomersApi* | [**get_customer**](docs/apis/tags/CustomersApi.md#get_customer) | **get** /customers/{customer_id} | Get Customer
*CustomersApi* | [**get_customer_risk_rating**](docs/apis/tags/CustomersApi.md#get_customer_risk_rating) | **get** /customers/{customer_id}/risk_ratings/{risk_rating_id} | Get customer risk rating
*CustomersApi* | [**get_party_employment**](docs/apis/tags/CustomersApi.md#get_party_employment) | **get** /customers/{customer_id}/employment/{employment_id} | Get customer employment record
*CustomersApi* | [**list_customers**](docs/apis/tags/CustomersApi.md#list_customers) | **get** /customers | List Customers
*CustomersApi* | [**patch_customer**](docs/apis/tags/CustomersApi.md#patch_customer) | **patch** /customers/{customer_id} | Patch Customer
*CustomersApi* | [**prefill_customer**](docs/apis/tags/CustomersApi.md#prefill_customer) | **post** /customers/{customer_id}/prefill | Prefill customer
*CustomersApi* | [**update_customer**](docs/apis/tags/CustomersApi.md#update_customer) | **put** /customers/{customer_id} | Update Customer
*CustomersApi* | [**update_party_employment**](docs/apis/tags/CustomersApi.md#update_party_employment) | **put** /customers/{customer_id}/employment/{employment_id} | Update customer employment record
*DigitalWalletTokensApi* | [**create_digital_wallet_apple**](docs/apis/tags/DigitalWalletTokensApi.md#create_digital_wallet_apple) | **post** /cards/{card_id}/digital_wallet_tokens/applepay | Create digital wallet token provision request for Apple Pay
*DigitalWalletTokensApi* | [**create_digital_wallet_google**](docs/apis/tags/DigitalWalletTokensApi.md#create_digital_wallet_google) | **post** /cards/{card_id}/digital_wallet_tokens/googlepay | Create digital wallet token provision request for Google Pay
*DigitalWalletTokensApi* | [**get_digital_wallet_token**](docs/apis/tags/DigitalWalletTokensApi.md#get_digital_wallet_token) | **get** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Get Digital Wallet Token
*DigitalWalletTokensApi* | [**list_digital_wallet_tokens**](docs/apis/tags/DigitalWalletTokensApi.md#list_digital_wallet_tokens) | **get** /cards/digital_wallet_tokens | List Digital Wallet Tokens
*DigitalWalletTokensApi* | [**update_digital_wallet_token_status**](docs/apis/tags/DigitalWalletTokensApi.md#update_digital_wallet_token_status) | **patch** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Update Digital Wallet Token&#x27;s life cycle status
*DisclosuresApi* | [**create_disclosure**](docs/apis/tags/DisclosuresApi.md#create_disclosure) | **post** /disclosures | Create disclosure record
*DisclosuresApi* | [**get_disclosure**](docs/apis/tags/DisclosuresApi.md#get_disclosure) | **get** /disclosures/{disclosure_id} | Get disclosure
*DisclosuresApi* | [**list_disclosures**](docs/apis/tags/DisclosuresApi.md#list_disclosures) | **get** /disclosures | List disclosures
*DisclosuresDeprecatedApi* | [**create_disclosure1**](docs/apis/tags/DisclosuresDeprecatedApi.md#create_disclosure1) | **post** /customers/{customer_id}/disclosures | Create a Disclosure
*DisclosuresDeprecatedApi* | [**list_disclosures1**](docs/apis/tags/DisclosuresDeprecatedApi.md#list_disclosures1) | **get** /customers/{customer_id}/disclosures | List Disclosures
*DocumentsApi* | [**create_document**](docs/apis/tags/DocumentsApi.md#create_document) | **post** /documents | Create a document
*DocumentsApi* | [**create_document_version**](docs/apis/tags/DocumentsApi.md#create_document_version) | **post** /documents/{document_id}/versions | Create a new document version
*DocumentsApi* | [**get_document**](docs/apis/tags/DocumentsApi.md#get_document) | **get** /documents/{document_id} | Get a document
*DocumentsApi* | [**get_document_contents**](docs/apis/tags/DocumentsApi.md#get_document_contents) | **get** /documents/{document_id}/contents | Get contents of latest document version
*DocumentsApi* | [**get_document_version**](docs/apis/tags/DocumentsApi.md#get_document_version) | **get** /documents/{document_id}/versions/{document_version} | Get a document by version
*DocumentsApi* | [**get_document_version_contents**](docs/apis/tags/DocumentsApi.md#get_document_version_contents) | **get** /documents/{document_id}/versions/{document_version}/contents | Get document contents by version
*DocumentsApi* | [**list_documents**](docs/apis/tags/DocumentsApi.md#list_documents) | **get** /documents | List documents
*DocumentsApi* | [**update_document**](docs/apis/tags/DocumentsApi.md#update_document) | **patch** /documents/{document_id} | Update a document
*ExternalAccountsApi* | [**add_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#add_external_accounts) | **post** /external_accounts | Add an external account
*ExternalAccountsApi* | [**add_vendor_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#add_vendor_external_accounts) | **post** /external_accounts/add_vendor_accounts | Add external accounts through a vendor, such as Plaid.
*ExternalAccountsApi* | [**create_access_token**](docs/apis/tags/ExternalAccountsApi.md#create_access_token) | **post** /external_accounts/access_tokens | Create a permanent access token for an external account
*ExternalAccountsApi* | [**create_verification_link_token**](docs/apis/tags/ExternalAccountsApi.md#create_verification_link_token) | **post** /external_accounts/link_tokens | Create a link token to verify an external account
*ExternalAccountsApi* | [**delete_external_account**](docs/apis/tags/ExternalAccountsApi.md#delete_external_account) | **delete** /external_accounts/{external_account_id} | Delete an external account
*ExternalAccountsApi* | [**get_external_account**](docs/apis/tags/ExternalAccountsApi.md#get_external_account) | **get** /external_accounts/{external_account_id} | Get an external account
*ExternalAccountsApi* | [**get_external_account_balance**](docs/apis/tags/ExternalAccountsApi.md#get_external_account_balance) | **get** /external_accounts/{external_account_id}/balance | Get an external account balance
*ExternalAccountsApi* | [**get_external_account_transactions**](docs/apis/tags/ExternalAccountsApi.md#get_external_account_transactions) | **get** /external_accounts/{external_account_id}/transactions | List transactions of a given external account
*ExternalAccountsApi* | [**list_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#list_external_accounts) | **get** /external_accounts | List external accounts
*ExternalAccountsApi* | [**sync_vendor_external_accounts**](docs/apis/tags/ExternalAccountsApi.md#sync_vendor_external_accounts) | **post** /external_accounts/sync_vendor_accounts | Sync external accounts through a vendor, such as Plaid.
*ExternalAccountsApi* | [**update_external_account**](docs/apis/tags/ExternalAccountsApi.md#update_external_account) | **patch** /external_accounts/{external_account_id} | Patch an external account
*ExternalCardsAlphaApi* | [**create_external_card_from_token**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_from_token) | **post** /external_cards/tokens | Create External Card from token
*ExternalCardsAlphaApi* | [**create_external_card_transfer**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_transfer) | **post** /external_cards/transfers | Create External Card Transfer
*ExternalCardsAlphaApi* | [**create_external_card_transfer_reversal**](docs/apis/tags/ExternalCardsAlphaApi.md#create_external_card_transfer_reversal) | **post** /external_cards/transfers/{transfer_id}/reversals | Create External Card Transfer Reversal
*ExternalCardsAlphaApi* | [**get_external_card**](docs/apis/tags/ExternalCardsAlphaApi.md#get_external_card) | **get** /external_cards/{external_card_id} | Get External Card
*ExternalCardsAlphaApi* | [**get_external_card_transfer**](docs/apis/tags/ExternalCardsAlphaApi.md#get_external_card_transfer) | **get** /external_cards/transfers/{transfer_id} | Get External Card Transfer
*ExternalCardsAlphaApi* | [**list_external_card_transfers**](docs/apis/tags/ExternalCardsAlphaApi.md#list_external_card_transfers) | **get** /external_cards/transfers | List External Card Transfers
*ExternalCardsAlphaApi* | [**list_external_cards**](docs/apis/tags/ExternalCardsAlphaApi.md#list_external_cards) | **get** /external_cards | List External Cards
*InternalAccountsApi* | [**add_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#add_internal_accounts) | **post** /internal_accounts | Add internal accounts
*InternalAccountsApi* | [**get_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#get_internal_accounts) | **get** /internal_accounts/{internal_account_id} | Get internal account by id
*InternalAccountsApi* | [**list_internal_accounts**](docs/apis/tags/InternalAccountsApi.md#list_internal_accounts) | **get** /internal_accounts | List internal accounts
*InternalAccountsApi* | [**patch_internal_account**](docs/apis/tags/InternalAccountsApi.md#patch_internal_account) | **patch** /internal_accounts/{internal_account_id} | Patch internal account
*InternalTransferApi* | [**create_internal_transfer**](docs/apis/tags/InternalTransferApi.md#create_internal_transfer) | **post** /transactions/internal_transfer | Create an internal transfer
*InternalTransferApi* | [**get_internal_transfer_by_id**](docs/apis/tags/InternalTransferApi.md#get_internal_transfer_by_id) | **get** /transactions/internal_transfer/{id} | Get an internal transfer
*InternalTransferApi* | [**update_internal_transfer_by_id**](docs/apis/tags/InternalTransferApi.md#update_internal_transfer_by_id) | **patch** /transactions/internal_transfer/{id} | Update an internal transfer
*KYCVerificationDeprecatedApi* | [**create_customer_verification_result**](docs/apis/tags/KYCVerificationDeprecatedApi.md#create_customer_verification_result) | **post** /customers/{customer_id}/verifications | Create a customer verification result
*KYCVerificationDeprecatedApi* | [**get_verification**](docs/apis/tags/KYCVerificationDeprecatedApi.md#get_verification) | **get** /customers/{customer_id}/verifications/{verification_id} | Get verification result
*KYCVerificationDeprecatedApi* | [**list_verifications**](docs/apis/tags/KYCVerificationDeprecatedApi.md#list_verifications) | **get** /customers/{customer_id}/verifications | List verification results
*KYCVerificationDeprecatedApi* | [**verify_customer**](docs/apis/tags/KYCVerificationDeprecatedApi.md#verify_customer) | **post** /customers/{customer_id}/verify | Verify a customer&#x27;s identity
*KYCKYBVerificationsApi* | [**create_verification**](docs/apis/tags/KYCKYBVerificationsApi.md#create_verification) | **post** /verifications | Create a verification
*KYCKYBVerificationsApi* | [**get_verification1**](docs/apis/tags/KYCKYBVerificationsApi.md#get_verification1) | **get** /verifications/{verification_id} | Get verification
*KYCKYBVerificationsApi* | [**list_verifications1**](docs/apis/tags/KYCKYBVerificationsApi.md#list_verifications1) | **get** /verifications | List verifications
*KYCKYBVerificationsApi* | [**verify**](docs/apis/tags/KYCKYBVerificationsApi.md#verify) | **post** /verifications/verify | Verify a customer&#x27;s identity
*KYCKYBVerificationsApi* | [**verify_ad_hoc**](docs/apis/tags/KYCKYBVerificationsApi.md#verify_ad_hoc) | **post** /verifications/adhoc | Check if an individual is on any watchlists
*MonitoringApi* | [**create_subscription**](docs/apis/tags/MonitoringApi.md#create_subscription) | **post** /monitoring/subscriptions | Subscribe a customer or business to monitoring
*MonitoringApi* | [**delete_subscription**](docs/apis/tags/MonitoringApi.md#delete_subscription) | **delete** /monitoring/subscriptions/{subscription_id} | Delete monitoring subscription
*MonitoringApi* | [**get_alert**](docs/apis/tags/MonitoringApi.md#get_alert) | **get** /monitoring/alerts/{alert_id} | Retrieve a monitoring alert
*MonitoringApi* | [**get_subscription**](docs/apis/tags/MonitoringApi.md#get_subscription) | **get** /monitoring/subscriptions/{subscription_id} | Retrieve monitoring subscription
*MonitoringApi* | [**list_alerts**](docs/apis/tags/MonitoringApi.md#list_alerts) | **get** /monitoring/alerts | List monitoring alerts
*MonitoringApi* | [**list_subscriptions**](docs/apis/tags/MonitoringApi.md#list_subscriptions) | **get** /monitoring/subscriptions | List monitoring subscriptions
*MonitoringApi* | [**update_alert**](docs/apis/tags/MonitoringApi.md#update_alert) | **patch** /monitoring/alerts/{alert_id} | Update a monitoring alert
*PaymentSchedulesApi* | [**create_payment_schedule**](docs/apis/tags/PaymentSchedulesApi.md#create_payment_schedule) | **post** /payment_schedules | Create a payment schedule
*PaymentSchedulesApi* | [**list_payment_schedules**](docs/apis/tags/PaymentSchedulesApi.md#list_payment_schedules) | **get** /payment_schedules | List payment schedules
*PaymentSchedulesApi* | [**list_payments**](docs/apis/tags/PaymentSchedulesApi.md#list_payments) | **get** /payment_schedules/payments | List payments
*PaymentSchedulesApi* | [**patch_payment_schedule**](docs/apis/tags/PaymentSchedulesApi.md#patch_payment_schedule) | **patch** /payment_schedules/{payment_schedule_id} | Update a payment schedule
*PersonsApi* | [**create_person**](docs/apis/tags/PersonsApi.md#create_person) | **post** /persons | Create a person
*PersonsApi* | [**get_person**](docs/apis/tags/PersonsApi.md#get_person) | **get** /persons/{person_id} | Get person
*PersonsApi* | [**list_persons**](docs/apis/tags/PersonsApi.md#list_persons) | **get** /persons | List persons
*PersonsApi* | [**prefill_person**](docs/apis/tags/PersonsApi.md#prefill_person) | **post** /persons/{person_id}/prefill | Prefill person
*PersonsApi* | [**update_person**](docs/apis/tags/PersonsApi.md#update_person) | **patch** /persons/{person_id} | Update person
*ReconciliationsApi* | [**create_reconciliation**](docs/apis/tags/ReconciliationsApi.md#create_reconciliation) | **post** /reconciliations | Create a reconciliation
*ReconciliationsApi* | [**get_reconciliation**](docs/apis/tags/ReconciliationsApi.md#get_reconciliation) | **get** /reconciliations/{reconciliation_id} | Get reconciliation
*ReconciliationsApi* | [**list_reconciliations**](docs/apis/tags/ReconciliationsApi.md#list_reconciliations) | **get** /reconciliations | List reconciliations
*RelationshipsApi* | [**create_relationship**](docs/apis/tags/RelationshipsApi.md#create_relationship) | **post** /relationships | Create a relationship
*RelationshipsApi* | [**delete_relationship**](docs/apis/tags/RelationshipsApi.md#delete_relationship) | **delete** /relationships/{relationship_id} | Delete relationship
*RelationshipsApi* | [**get_relationship**](docs/apis/tags/RelationshipsApi.md#get_relationship) | **get** /relationships/{relationship_id} | Get relationship
*RelationshipsApi* | [**list_relationships**](docs/apis/tags/RelationshipsApi.md#list_relationships) | **get** /relationships | List relationships
*RelationshipsApi* | [**update_relationship**](docs/apis/tags/RelationshipsApi.md#update_relationship) | **patch** /relationships/{relationship_id} | Update relationship
*RemoteCheckDepositBetaApi* | [**create_rdc_deposit**](docs/apis/tags/RemoteCheckDepositBetaApi.md#create_rdc_deposit) | **post** /rdc/deposits | Create a Remote Check Deposit
*RemoteCheckDepositBetaApi* | [**get_rdc_deposit**](docs/apis/tags/RemoteCheckDepositBetaApi.md#get_rdc_deposit) | **get** /rdc/deposits/{deposit_id} | Get Remote Check Deposit
*RemoteCheckDepositBetaApi* | [**list_rdc_deposits**](docs/apis/tags/RemoteCheckDepositBetaApi.md#list_rdc_deposits) | **get** /rdc/deposits | List Remote Check Deposits
*SandboxWipeAlphaApi* | [**wipe_workspace**](docs/apis/tags/SandboxWipeAlphaApi.md#wipe_workspace) | **post** /wipe | Delete data
*SpendControlsBetaApi* | [**create_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#create_spend_control) | **post** /spend_controls | Create Spend Control
*SpendControlsBetaApi* | [**get_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#get_spend_control) | **get** /spend_controls/{spend_control_id} | Get Spend Control
*SpendControlsBetaApi* | [**list_spend_controls**](docs/apis/tags/SpendControlsBetaApi.md#list_spend_controls) | **get** /spend_controls | List Spend Controls
*SpendControlsBetaApi* | [**update_spend_control**](docs/apis/tags/SpendControlsBetaApi.md#update_spend_control) | **patch** /spend_controls/{spend_control_id} | Update Spend Control
*StatementsApi* | [**get_statement**](docs/apis/tags/StatementsApi.md#get_statement) | **get** /statements/{statement_id} | Get a statement
*StatementsApi* | [**list_statements**](docs/apis/tags/StatementsApi.md#list_statements) | **get** /statements | List statements
*TransactionsApi* | [**get_pending_transaction_by_id**](docs/apis/tags/TransactionsApi.md#get_pending_transaction_by_id) | **get** /transactions/pending/{id} | Get a pending transaction
*TransactionsApi* | [**get_posted_transaction_by_id**](docs/apis/tags/TransactionsApi.md#get_posted_transaction_by_id) | **get** /transactions/posted/{id} | Get a posted transaction
*TransactionsApi* | [**list_pending_transactions**](docs/apis/tags/TransactionsApi.md#list_pending_transactions) | **get** /transactions/pending | List pending transactions
*TransactionsApi* | [**list_posted_transactions**](docs/apis/tags/TransactionsApi.md#list_posted_transactions) | **get** /transactions/posted | List posted transactions
*WatchlistDeprecatedApi* | [**get_watchlist_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#get_watchlist_alert) | **get** /customers/{customer_id}/watchlists/alerts/{alert_id} | Retrieve watchlist monitoring alert
*WatchlistDeprecatedApi* | [**get_watchlist_subscription**](docs/apis/tags/WatchlistDeprecatedApi.md#get_watchlist_subscription) | **get** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Retrieve watchlist monitoring subscription
*WatchlistDeprecatedApi* | [**list_watchlist_alerts**](docs/apis/tags/WatchlistDeprecatedApi.md#list_watchlist_alerts) | **get** /customers/{customer_id}/watchlists/alerts | List watchlist monitoring alerts for a customer
*WatchlistDeprecatedApi* | [**list_watchlist_subscriptions**](docs/apis/tags/WatchlistDeprecatedApi.md#list_watchlist_subscriptions) | **get** /customers/{customer_id}/watchlists/subscriptions | List watchlist monitoring subscriptions for a customer
*WatchlistDeprecatedApi* | [**suppress_watchlist_entity_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#suppress_watchlist_entity_alert) | **post** /customers/{customer_id}/watchlists/suppressions | Suppress entity alert
*WatchlistDeprecatedApi* | [**update_watchlist_alert**](docs/apis/tags/WatchlistDeprecatedApi.md#update_watchlist_alert) | **put** /customers/{customer_id}/watchlists/alerts/{alert_id} | Update watchlist alert
*WatchlistDeprecatedApi* | [**update_watchlist_subscription**](docs/apis/tags/WatchlistDeprecatedApi.md#update_watchlist_subscription) | **put** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Update watchlist monitoring subscription
*WatchlistDeprecatedApi* | [**watchlist_subscribe**](docs/apis/tags/WatchlistDeprecatedApi.md#watchlist_subscribe) | **post** /customers/{customer_id}/watchlists/subscriptions | Subscribe a customer to watchlist monitoring
*WebhooksApi* | [**create_webhook1**](docs/apis/tags/WebhooksApi.md#create_webhook1) | **post** /webhooks | Create a webhook
*WebhooksApi* | [**delete_webhook**](docs/apis/tags/WebhooksApi.md#delete_webhook) | **delete** /webhooks/{webhook_id} | Delete a webhook
*WebhooksApi* | [**get_event**](docs/apis/tags/WebhooksApi.md#get_event) | **get** /webhooks/{webhook_id}/events/{event_id} | Get webhook event
*WebhooksApi* | [**get_webhook1**](docs/apis/tags/WebhooksApi.md#get_webhook1) | **get** /webhooks/{webhook_id} | Get a webhook
*WebhooksApi* | [**list_events**](docs/apis/tags/WebhooksApi.md#list_events) | **get** /webhooks/{webhook_id}/events | List webhook events
*WebhooksApi* | [**list_webhooks1**](docs/apis/tags/WebhooksApi.md#list_webhooks1) | **get** /webhooks | List webhooks
*WebhooksApi* | [**resend_event**](docs/apis/tags/WebhooksApi.md#resend_event) | **post** /webhooks/{webhook_id}/events/{event_id}/resend | Resend an event
*WebhooksApi* | [**trigger_event**](docs/apis/tags/WebhooksApi.md#trigger_event) | **post** /webhooks/trigger | Trigger an event
*WebhooksApi* | [**update_webhook**](docs/apis/tags/WebhooksApi.md#update_webhook) | **put** /webhooks/{webhook_id} | Update a webhook
*WiresAlphaApi* | [**cancel_wire**](docs/apis/tags/WiresAlphaApi.md#cancel_wire) | **patch** /wires/{wire_id} | Cancel an outgoing wire
*WiresAlphaApi* | [**create_wire**](docs/apis/tags/WiresAlphaApi.md#create_wire) | **post** /wires | Send a wire
*WiresAlphaApi* | [**get_wire**](docs/apis/tags/WiresAlphaApi.md#get_wire) | **get** /wires/{wire_id} | Get a wire by id
*WiresAlphaApi* | [**list_wires**](docs/apis/tags/WiresAlphaApi.md#list_wires) | **get** /wires | List wires

## Documentation For Models

 - [Account](docs/models/Account.md)
 - [AccountAccessStatus](docs/models/AccountAccessStatus.md)
 - [AccountBase](docs/models/AccountBase.md)
 - [AccountChargeSecured](docs/models/AccountChargeSecured.md)
 - [AccountCreation](docs/models/AccountCreation.md)
 - [AccountDepository](docs/models/AccountDepository.md)
 - [AccountGenericResponse](docs/models/AccountGenericResponse.md)
 - [AccountId](docs/models/AccountId.md)
 - [AccountIdentifiers](docs/models/AccountIdentifiers.md)
 - [AccountLineOfCredit](docs/models/AccountLineOfCredit.md)
 - [AccountList](docs/models/AccountList.md)
 - [AccountProduct](docs/models/AccountProduct.md)
 - [AccountProductList](docs/models/AccountProductList.md)
 - [AccountRange](docs/models/AccountRange.md)
 - [AccountRangeId](docs/models/AccountRangeId.md)
 - [AccountRangeResponse](docs/models/AccountRangeResponse.md)
 - [AccountRangeResponseList](docs/models/AccountRangeResponseList.md)
 - [AccountRangeUpdateRequest](docs/models/AccountRangeUpdateRequest.md)
 - [AccountRelationshipType](docs/models/AccountRelationshipType.md)
 - [AccountRouting](docs/models/AccountRouting.md)
 - [AccountSummary](docs/models/AccountSummary.md)
 - [AccountTemplate](docs/models/AccountTemplate.md)
 - [AccountTemplateResponse](docs/models/AccountTemplateResponse.md)
 - [AccountToAccountTransferRequest](docs/models/AccountToAccountTransferRequest.md)
 - [AccountType](docs/models/AccountType.md)
 - [AccountVerification](docs/models/AccountVerification.md)
 - [AccrualPayoutSchedule](docs/models/AccrualPayoutSchedule.md)
 - [AchInstruction](docs/models/AchInstruction.md)
 - [AchRequestHoldData](docs/models/AchRequestHoldData.md)
 - [AchReturnSimulationRequest](docs/models/AchReturnSimulationRequest.md)
 - [AchTransaction](docs/models/AchTransaction.md)
 - [AchTransactionData](docs/models/AchTransactionData.md)
 - [AchTransactionSimulationRequest](docs/models/AchTransactionSimulationRequest.md)
 - [AchTransactionSubtypes](docs/models/AchTransactionSubtypes.md)
 - [AddAccountsRequest](docs/models/AddAccountsRequest.md)
 - [AddAccountsRequestAccountIdentifiers](docs/models/AddAccountsRequestAccountIdentifiers.md)
 - [AddAccountsRequestRoutingIdentifiers](docs/models/AddAccountsRequestRoutingIdentifiers.md)
 - [AddVendorAccountFailure](docs/models/AddVendorAccountFailure.md)
 - [AddVendorAccountsErrorReason](docs/models/AddVendorAccountsErrorReason.md)
 - [AddVendorAccountsRequest](docs/models/AddVendorAccountsRequest.md)
 - [AddVendorAccountsResponse](docs/models/AddVendorAccountsResponse.md)
 - [AdditionalData](docs/models/AdditionalData.md)
 - [AdditionalOwnerData](docs/models/AdditionalOwnerData.md)
 - [Address](docs/models/Address.md)
 - [Address1](docs/models/Address1.md)
 - [Address2](docs/models/Address2.md)
 - [AdhocVerificationRequest](docs/models/AdhocVerificationRequest.md)
 - [AdhocVerificationResponse](docs/models/AdhocVerificationResponse.md)
 - [Alias](docs/models/Alias.md)
 - [AliasList](docs/models/AliasList.md)
 - [AppleDigitalWalletProvisionRequest](docs/models/AppleDigitalWalletProvisionRequest.md)
 - [AppleDigitalWalletProvisionResponse](docs/models/AppleDigitalWalletProvisionResponse.md)
 - [ApplicationListResponse](docs/models/ApplicationListResponse.md)
 - [ApplicationRequest](docs/models/ApplicationRequest.md)
 - [ApplicationResponse](docs/models/ApplicationResponse.md)
 - [ApplicationType](docs/models/ApplicationType.md)
 - [ApplicationUpdateRequest](docs/models/ApplicationUpdateRequest.md)
 - [AuthRequestModel](docs/models/AuthRequestModel.md)
 - [AuthorizationAdviceModel](docs/models/AuthorizationAdviceModel.md)
 - [Balance](docs/models/Balance.md)
 - [BalanceCeiling](docs/models/BalanceCeiling.md)
 - [BalanceFloor](docs/models/BalanceFloor.md)
 - [BalanceInquiryRequestModel](docs/models/BalanceInquiryRequestModel.md)
 - [BalanceType](docs/models/BalanceType.md)
 - [BanRule](docs/models/BanRule.md)
 - [BanRuleList](docs/models/BanRuleList.md)
 - [BanRulePatch](docs/models/BanRulePatch.md)
 - [BanRuleStatus](docs/models/BanRuleStatus.md)
 - [BanStatus](docs/models/BanStatus.md)
 - [BankDebitNetworkResponse](docs/models/BankDebitNetworkResponse.md)
 - [Base](docs/models/Base.md)
 - [BaseAccountVerification](docs/models/BaseAccountVerification.md)
 - [BaseCard](docs/models/BaseCard.md)
 - [BaseCashPickup](docs/models/BaseCashPickup.md)
 - [BaseDisclosure](docs/models/BaseDisclosure.md)
 - [BaseMasterDisclosure](docs/models/BaseMasterDisclosure.md)
 - [BasePerson](docs/models/BasePerson.md)
 - [BasePerson1](docs/models/BasePerson1.md)
 - [BaseStatement](docs/models/BaseStatement.md)
 - [BaseTemplateFields](docs/models/BaseTemplateFields.md)
 - [BaseTransaction](docs/models/BaseTransaction.md)
 - [BillingAddress](docs/models/BillingAddress.md)
 - [BillingPeriod](docs/models/BillingPeriod.md)
 - [Bin](docs/models/Bin.md)
 - [BinAndDebitNetwork](docs/models/BinAndDebitNetwork.md)
 - [BinAndDebitNetworkList](docs/models/BinAndDebitNetworkList.md)
 - [BinId](docs/models/BinId.md)
 - [BinNetworkMapping](docs/models/BinNetworkMapping.md)
 - [BinNetworkMappingResponse](docs/models/BinNetworkMappingResponse.md)
 - [BinResponse](docs/models/BinResponse.md)
 - [BinResponseList](docs/models/BinResponseList.md)
 - [BinStatus](docs/models/BinStatus.md)
 - [BinUpdateRequest](docs/models/BinUpdateRequest.md)
 - [BrandProductCode](docs/models/BrandProductCode.md)
 - [Business](docs/models/Business.md)
 - [Business1](docs/models/Business1.md)
 - [BusinessBusinessOwnerRelationship](docs/models/BusinessBusinessOwnerRelationship.md)
 - [BusinessId](docs/models/BusinessId.md)
 - [BusinessId1](docs/models/BusinessId1.md)
 - [BusinessId2](docs/models/BusinessId2.md)
 - [BusinessId3](docs/models/BusinessId3.md)
 - [BusinessId4](docs/models/BusinessId4.md)
 - [BusinessId5](docs/models/BusinessId5.md)
 - [BusinessList](docs/models/BusinessList.md)
 - [CalculationMethod](docs/models/CalculationMethod.md)
 - [CardAcceptorModel](docs/models/CardAcceptorModel.md)
 - [CardActivationRequest](docs/models/CardActivationRequest.md)
 - [CardBrand](docs/models/CardBrand.md)
 - [CardCategory](docs/models/CardCategory.md)
 - [CardChange](docs/models/CardChange.md)
 - [CardChangeState](docs/models/CardChangeState.md)
 - [CardChangesList](docs/models/CardChangesList.md)
 - [CardEditRequest](docs/models/CardEditRequest.md)
 - [CardFormat](docs/models/CardFormat.md)
 - [CardFulfillmentStatus](docs/models/CardFulfillmentStatus.md)
 - [CardId](docs/models/CardId.md)
 - [CardImageDetails](docs/models/CardImageDetails.md)
 - [CardImageDetailsList](docs/models/CardImageDetailsList.md)
 - [CardImageId](docs/models/CardImageId.md)
 - [CardImageMode](docs/models/CardImageMode.md)
 - [CardImageRejectionReason](docs/models/CardImageRejectionReason.md)
 - [CardImageStatus](docs/models/CardImageStatus.md)
 - [CardIssuanceRequest](docs/models/CardIssuanceRequest.md)
 - [CardListResponse](docs/models/CardListResponse.md)
 - [CardMetadata](docs/models/CardMetadata.md)
 - [CardOptions](docs/models/CardOptions.md)
 - [CardPin](docs/models/CardPin.md)
 - [CardPinStatus](docs/models/CardPinStatus.md)
 - [CardProduct](docs/models/CardProduct.md)
 - [CardProductId](docs/models/CardProductId.md)
 - [CardProductInternal](docs/models/CardProductInternal.md)
 - [CardProductListResponse](docs/models/CardProductListResponse.md)
 - [CardProductResponse](docs/models/CardProductResponse.md)
 - [CardProductType](docs/models/CardProductType.md)
 - [CardProductUpdateRequest](docs/models/CardProductUpdateRequest.md)
 - [CardProgram](docs/models/CardProgram.md)
 - [CardProgramId](docs/models/CardProgramId.md)
 - [CardProgramResponse](docs/models/CardProgramResponse.md)
 - [CardProgramResponseList](docs/models/CardProgramResponseList.md)
 - [CardProgramUpdateRequest](docs/models/CardProgramUpdateRequest.md)
 - [CardResponse](docs/models/CardResponse.md)
 - [CardStatus](docs/models/CardStatus.md)
 - [CardStatusObject](docs/models/CardStatusObject.md)
 - [CardStatusReasonCode](docs/models/CardStatusReasonCode.md)
 - [CardStatusReasonMemo](docs/models/CardStatusReasonMemo.md)
 - [CardStatusRequest](docs/models/CardStatusRequest.md)
 - [CardTransaction](docs/models/CardTransaction.md)
 - [CardTransactionData](docs/models/CardTransactionData.md)
 - [CardTransactionSubtypes](docs/models/CardTransactionSubtypes.md)
 - [CardWidgetUrlResponse](docs/models/CardWidgetUrlResponse.md)
 - [CashPickup](docs/models/CashPickup.md)
 - [CashPickupList](docs/models/CashPickupList.md)
 - [CashPickupPatchRequest](docs/models/CashPickupPatchRequest.md)
 - [CashPickupPostRequest](docs/models/CashPickupPostRequest.md)
 - [CashPickupStatus](docs/models/CashPickupStatus.md)
 - [ChangeChannel](docs/models/ChangeChannel.md)
 - [ChangeType](docs/models/ChangeType.md)
 - [CheckTransaction](docs/models/CheckTransaction.md)
 - [CheckTransactionData](docs/models/CheckTransactionData.md)
 - [CheckTransactionSubtypes](docs/models/CheckTransactionSubtypes.md)
 - [ClearingModel](docs/models/ClearingModel.md)
 - [ClientToken](docs/models/ClientToken.md)
 - [Content](docs/models/Content.md)
 - [ContestAch](docs/models/ContestAch.md)
 - [CountryCode](docs/models/CountryCode.md)
 - [CreateCardImageRequest](docs/models/CreateCardImageRequest.md)
 - [CreateGatewayRequest](docs/models/CreateGatewayRequest.md)
 - [CreateWebhookRequest](docs/models/CreateWebhookRequest.md)
 - [CurrencyCode](docs/models/CurrencyCode.md)
 - [CustomHeaders](docs/models/CustomHeaders.md)
 - [Customer](docs/models/Customer.md)
 - [CustomerAlias](docs/models/CustomerAlias.md)
 - [CustomerAliasList](docs/models/CustomerAliasList.md)
 - [CustomerId](docs/models/CustomerId.md)
 - [CustomerId1](docs/models/CustomerId1.md)
 - [CustomerInBody](docs/models/CustomerInBody.md)
 - [CustomerKycStatus](docs/models/CustomerKycStatus.md)
 - [CustomerList](docs/models/CustomerList.md)
 - [CustomerType](docs/models/CustomerType.md)
 - [CustomerVerification](docs/models/CustomerVerification.md)
 - [CustomerVerificationResult](docs/models/CustomerVerificationResult.md)
 - [CustomerVerificationResultList](docs/models/CustomerVerificationResultList.md)
 - [CustomerVerifyResponse](docs/models/CustomerVerifyResponse.md)
 - [DcSign](docs/models/DcSign.md)
 - [DebitNetwork](docs/models/DebitNetwork.md)
 - [DebitNetworkCreateRequest](docs/models/DebitNetworkCreateRequest.md)
 - [DebitNetworkId](docs/models/DebitNetworkId.md)
 - [DebitNetworkResponse](docs/models/DebitNetworkResponse.md)
 - [DebitNetworkResponseList](docs/models/DebitNetworkResponseList.md)
 - [DeleteResponse](docs/models/DeleteResponse.md)
 - [Deposit](docs/models/Deposit.md)
 - [DepositList](docs/models/DepositList.md)
 - [DepositPatchRequest](docs/models/DepositPatchRequest.md)
 - [Detail](docs/models/Detail.md)
 - [Details](docs/models/Details.md)
 - [DeviceType](docs/models/DeviceType.md)
 - [DigitalWalletTokenAddressVerification](docs/models/DigitalWalletTokenAddressVerification.md)
 - [DigitalWalletTokenEditRequest](docs/models/DigitalWalletTokenEditRequest.md)
 - [DigitalWalletTokenId](docs/models/DigitalWalletTokenId.md)
 - [DigitalWalletTokenResponse](docs/models/DigitalWalletTokenResponse.md)
 - [DigitalWalletTokenState](docs/models/DigitalWalletTokenState.md)
 - [DigitalWalletTokenization](docs/models/DigitalWalletTokenization.md)
 - [Disclosure](docs/models/Disclosure.md)
 - [Disclosure1](docs/models/Disclosure1.md)
 - [DisclosureList](docs/models/DisclosureList.md)
 - [DisclosureResponse](docs/models/DisclosureResponse.md)
 - [DisclosureType](docs/models/DisclosureType.md)
 - [DishonorAch](docs/models/DishonorAch.md)
 - [Document](docs/models/Document.md)
 - [DocumentList](docs/models/DocumentList.md)
 - [DocumentType](docs/models/DocumentType.md)
 - [DocumentVersion](docs/models/DocumentVersion.md)
 - [DocumentVersions](docs/models/DocumentVersions.md)
 - [EmbossName](docs/models/EmbossName.md)
 - [Employment](docs/models/Employment.md)
 - [EmploymentList](docs/models/EmploymentList.md)
 - [Encryption](docs/models/Encryption.md)
 - [EnhancedTransactionData](docs/models/EnhancedTransactionData.md)
 - [Environment](docs/models/Environment.md)
 - [Error](docs/models/Error.md)
 - [EvaluationContext](docs/models/EvaluationContext.md)
 - [EvaluationContextCustomer](docs/models/EvaluationContextCustomer.md)
 - [EvaluationResponse](docs/models/EvaluationResponse.md)
 - [EvaluationResult](docs/models/EvaluationResult.md)
 - [Event](docs/models/Event.md)
 - [EventList](docs/models/EventList.md)
 - [EventResend](docs/models/EventResend.md)
 - [EventTrigger](docs/models/EventTrigger.md)
 - [EventType](docs/models/EventType.md)
 - [EventType1](docs/models/EventType1.md)
 - [EventTypeExplicit](docs/models/EventTypeExplicit.md)
 - [EventTypeWildcard](docs/models/EventTypeWildcard.md)
 - [ExtAccountCustomerType](docs/models/ExtAccountCustomerType.md)
 - [ExternalAccount](docs/models/ExternalAccount.md)
 - [ExternalAccountAccessToken](docs/models/ExternalAccountAccessToken.md)
 - [ExternalAccountBalance](docs/models/ExternalAccountBalance.md)
 - [ExternalAccountLinkToken](docs/models/ExternalAccountLinkToken.md)
 - [ExternalAccountTransaction](docs/models/ExternalAccountTransaction.md)
 - [ExternalAccountVendorData](docs/models/ExternalAccountVendorData.md)
 - [ExternalAccountVendorValues](docs/models/ExternalAccountVendorValues.md)
 - [ExternalAccountsList](docs/models/ExternalAccountsList.md)
 - [ExternalAccountsTransactionList](docs/models/ExternalAccountsTransactionList.md)
 - [ExternalCardId](docs/models/ExternalCardId.md)
 - [ExternalCardListResponse](docs/models/ExternalCardListResponse.md)
 - [ExternalCardRequest](docs/models/ExternalCardRequest.md)
 - [ExternalCardResponse](docs/models/ExternalCardResponse.md)
 - [ExternalCardTransaction](docs/models/ExternalCardTransaction.md)
 - [ExternalCardTransactionSubtypes](docs/models/ExternalCardTransactionSubtypes.md)
 - [ExternalCardVerifications](docs/models/ExternalCardVerifications.md)
 - [ExternalPaymentDate](docs/models/ExternalPaymentDate.md)
 - [Fee](docs/models/Fee.md)
 - [FinancialInstitution](docs/models/FinancialInstitution.md)
 - [FinancialRequestModel](docs/models/FinancialRequestModel.md)
 - [FinicityAccountVerification](docs/models/FinicityAccountVerification.md)
 - [Form](docs/models/Form.md)
 - [FulfillmentDetails](docs/models/FulfillmentDetails.md)
 - [FundingSource](docs/models/FundingSource.md)
 - [FundingSourceResponse](docs/models/FundingSourceResponse.md)
 - [FundingSourceResponseList](docs/models/FundingSourceResponseList.md)
 - [GatewayCustomHeaders](docs/models/GatewayCustomHeaders.md)
 - [GatewayId](docs/models/GatewayId.md)
 - [GatewayListResponse](docs/models/GatewayListResponse.md)
 - [GatewayResponse](docs/models/GatewayResponse.md)
 - [GetViralLoopWaitlists](docs/models/GetViralLoopWaitlists.md)
 - [GoogleDigitalWalletProvisionRequest](docs/models/GoogleDigitalWalletProvisionRequest.md)
 - [GoogleDigitalWalletProvisionResponse](docs/models/GoogleDigitalWalletProvisionResponse.md)
 - [HoldCancelRequest](docs/models/HoldCancelRequest.md)
 - [HoldCreateRequest](docs/models/HoldCreateRequest.md)
 - [HoldCreateRequestStatus](docs/models/HoldCreateRequestStatus.md)
 - [HoldData](docs/models/HoldData.md)
 - [HoldDeclineRequest](docs/models/HoldDeclineRequest.md)
 - [HoldModifyRequest](docs/models/HoldModifyRequest.md)
 - [HoldPatchRequest](docs/models/HoldPatchRequest.md)
 - [HoldPostingRequest](docs/models/HoldPostingRequest.md)
 - [Id](docs/models/Id.md)
 - [InAppProvisioning](docs/models/InAppProvisioning.md)
 - [IngestionStatus](docs/models/IngestionStatus.md)
 - [Interest](docs/models/Interest.md)
 - [InternalAccount](docs/models/InternalAccount.md)
 - [InternalAccountPatch](docs/models/InternalAccountPatch.md)
 - [InternalAccountPurpose](docs/models/InternalAccountPurpose.md)
 - [InternalAccountType](docs/models/InternalAccountType.md)
 - [InternalAccountsList](docs/models/InternalAccountsList.md)
 - [InternalTransfer](docs/models/InternalTransfer.md)
 - [InternalTransferInstruction](docs/models/InternalTransferInstruction.md)
 - [InternalTransferPatch](docs/models/InternalTransferPatch.md)
 - [InternalTransferResponse](docs/models/InternalTransferResponse.md)
 - [InternalTransferTransaction](docs/models/InternalTransferTransaction.md)
 - [InternalTransferTransactionData](docs/models/InternalTransferTransactionData.md)
 - [InternalTransferTransactionSubtypes](docs/models/InternalTransferTransactionSubtypes.md)
 - [IsCustomer](docs/models/IsCustomer.md)
 - [ManualAccountVerification](docs/models/ManualAccountVerification.md)
 - [ManualEntry](docs/models/ManualEntry.md)
 - [MasterDisclosure](docs/models/MasterDisclosure.md)
 - [MasterDisclosureList](docs/models/MasterDisclosureList.md)
 - [Merchant](docs/models/Merchant.md)
 - [MinimumPayment](docs/models/MinimumPayment.md)
 - [MinimumPaymentFull](docs/models/MinimumPaymentFull.md)
 - [MinimumPaymentPartial](docs/models/MinimumPaymentPartial.md)
 - [MinimumPaymentType](docs/models/MinimumPaymentType.md)
 - [MinimumPaymentTypeFull](docs/models/MinimumPaymentTypeFull.md)
 - [MinimumPaymentTypeRateOrAmount](docs/models/MinimumPaymentTypeRateOrAmount.md)
 - [MonitoringAlert](docs/models/MonitoringAlert.md)
 - [MonitoringAlertList](docs/models/MonitoringAlertList.md)
 - [MonitoringStatus](docs/models/MonitoringStatus.md)
 - [MonitoringSubscription](docs/models/MonitoringSubscription.md)
 - [MonitoringSubscriptionList](docs/models/MonitoringSubscriptionList.md)
 - [NetworkFeeModel](docs/models/NetworkFeeModel.md)
 - [NoteCreate](docs/models/NoteCreate.md)
 - [NoteList](docs/models/NoteList.md)
 - [NoteResponse](docs/models/NoteResponse.md)
 - [OriginalCreditRequestModel](docs/models/OriginalCreditRequestModel.md)
 - [OriginalCreditSenderData](docs/models/OriginalCreditSenderData.md)
 - [OriginatingAccountId](docs/models/OriginatingAccountId.md)
 - [OutgoingAch](docs/models/OutgoingAch.md)
 - [OutgoingAchList](docs/models/OutgoingAchList.md)
 - [OutgoingAchPatch](docs/models/OutgoingAchPatch.md)
 - [OutgoingAchRequest](docs/models/OutgoingAchRequest.md)
 - [PaginatedResponse](docs/models/PaginatedResponse.md)
 - [PaginatedResponse1](docs/models/PaginatedResponse1.md)
 - [PaginatedTransactions](docs/models/PaginatedTransactions.md)
 - [PatchAccountProduct](docs/models/PatchAccountProduct.md)
 - [PatchAccountsRequestAccountIdentifiers](docs/models/PatchAccountsRequestAccountIdentifiers.md)
 - [PatchAccountsRequestRoutingIdentifiers](docs/models/PatchAccountsRequestRoutingIdentifiers.md)
 - [PatchBanStatus](docs/models/PatchBanStatus.md)
 - [PatchBusiness](docs/models/PatchBusiness.md)
 - [PatchBusinessBusinessOwnerRelationship](docs/models/PatchBusinessBusinessOwnerRelationship.md)
 - [PatchCustomer](docs/models/PatchCustomer.md)
 - [PatchDocument](docs/models/PatchDocument.md)
 - [PatchExternalAccount](docs/models/PatchExternalAccount.md)
 - [PatchInterest](docs/models/PatchInterest.md)
 - [PatchPaymentSchedule](docs/models/PatchPaymentSchedule.md)
 - [PatchPerson](docs/models/PatchPerson.md)
 - [PatchPersonBusinessOwnerRelationship](docs/models/PatchPersonBusinessOwnerRelationship.md)
 - [PatchPersonBusinessRelationship](docs/models/PatchPersonBusinessRelationship.md)
 - [PatchRelationshipIn](docs/models/PatchRelationshipIn.md)
 - [Payment](docs/models/Payment.md)
 - [PaymentDate](docs/models/PaymentDate.md)
 - [PaymentErrorDetails](docs/models/PaymentErrorDetails.md)
 - [PaymentInstruction](docs/models/PaymentInstruction.md)
 - [PaymentList](docs/models/PaymentList.md)
 - [PaymentSchedule](docs/models/PaymentSchedule.md)
 - [PaymentScheduleList](docs/models/PaymentScheduleList.md)
 - [PaymentScheduleStatus](docs/models/PaymentScheduleStatus.md)
 - [PaymentStatus](docs/models/PaymentStatus.md)
 - [PaymentType](docs/models/PaymentType.md)
 - [PaymentTypeList](docs/models/PaymentTypeList.md)
 - [PendingTransaction](docs/models/PendingTransaction.md)
 - [PendingTransactionData](docs/models/PendingTransactionData.md)
 - [PendingTransactionHistory](docs/models/PendingTransactionHistory.md)
 - [PendingTransactionHistoryData](docs/models/PendingTransactionHistoryData.md)
 - [PendingTransactions](docs/models/PendingTransactions.md)
 - [Person](docs/models/Person.md)
 - [Person1](docs/models/Person1.md)
 - [PersonBusinessOwnerRelationship](docs/models/PersonBusinessOwnerRelationship.md)
 - [PersonBusinessRelationship](docs/models/PersonBusinessRelationship.md)
 - [PersonId](docs/models/PersonId.md)
 - [PersonId1](docs/models/PersonId1.md)
 - [PersonList](docs/models/PersonList.md)
 - [PhysicalCard](docs/models/PhysicalCard.md)
 - [PhysicalCardFormat](docs/models/PhysicalCardFormat.md)
 - [PhysicalCardIssuanceRequest](docs/models/PhysicalCardIssuanceRequest.md)
 - [PhysicalCardPlusStatus](docs/models/PhysicalCardPlusStatus.md)
 - [PhysicalCardResponse](docs/models/PhysicalCardResponse.md)
 - [PhysicalCardResponseStatus](docs/models/PhysicalCardResponseStatus.md)
 - [PingResponse](docs/models/PingResponse.md)
 - [PlaidAccountVerification](docs/models/PlaidAccountVerification.md)
 - [PostedTransaction](docs/models/PostedTransaction.md)
 - [PostedTransactionData](docs/models/PostedTransactionData.md)
 - [PostedTransactionReverseRequest](docs/models/PostedTransactionReverseRequest.md)
 - [PostedTransactions](docs/models/PostedTransactions.md)
 - [PrefillRequest](docs/models/PrefillRequest.md)
 - [Prospect](docs/models/Prospect.md)
 - [Prospect1](docs/models/Prospect1.md)
 - [ProspectEditable](docs/models/ProspectEditable.md)
 - [ProspectStatus](docs/models/ProspectStatus.md)
 - [ProspectsList](docs/models/ProspectsList.md)
 - [ProviderType](docs/models/ProviderType.md)
 - [ProvisioningAppVersion](docs/models/ProvisioningAppVersion.md)
 - [ProvisioningControls](docs/models/ProvisioningControls.md)
 - [PushTokenizeRequestData](docs/models/PushTokenizeRequestData.md)
 - [QuickstartT10](docs/models/QuickstartT10.md)
 - [QuickstartT10Response](docs/models/QuickstartT10Response.md)
 - [RateDetails](docs/models/RateDetails.md)
 - [Rates](docs/models/Rates.md)
 - [RawResponse](docs/models/RawResponse.md)
 - [RecipientName](docs/models/RecipientName.md)
 - [Reconciliation](docs/models/Reconciliation.md)
 - [ReconciliationInput](docs/models/ReconciliationInput.md)
 - [ReconciliationList](docs/models/ReconciliationList.md)
 - [RelatedResourceId](docs/models/RelatedResourceId.md)
 - [RelatedResourceType](docs/models/RelatedResourceType.md)
 - [RelatedResourceType1](docs/models/RelatedResourceType1.md)
 - [Relationship](docs/models/Relationship.md)
 - [Relationship1](docs/models/Relationship1.md)
 - [RelationshipIn](docs/models/RelationshipIn.md)
 - [RelationshipList](docs/models/RelationshipList.md)
 - [RelationshipRole](docs/models/RelationshipRole.md)
 - [RelationshipsList](docs/models/RelationshipsList.md)
 - [ResendResponse](docs/models/ResendResponse.md)
 - [ResourceType](docs/models/ResourceType.md)
 - [ResponseHistoryItem](docs/models/ResponseHistoryItem.md)
 - [ReturnAch](docs/models/ReturnAch.md)
 - [ReversalModel](docs/models/ReversalModel.md)
 - [RiskData](docs/models/RiskData.md)
 - [RiskRating](docs/models/RiskRating.md)
 - [RiskRatingList](docs/models/RiskRatingList.md)
 - [SavingsSummary](docs/models/SavingsSummary.md)
 - [ScheduleConfig](docs/models/ScheduleConfig.md)
 - [Security](docs/models/Security.md)
 - [Shipping](docs/models/Shipping.md)
 - [SimulateCardFulfillment](docs/models/SimulateCardFulfillment.md)
 - [SingleUseTokenRequest](docs/models/SingleUseTokenRequest.md)
 - [SingleUseTokenResponse](docs/models/SingleUseTokenResponse.md)
 - [SocureEventBody](docs/models/SocureEventBody.md)
 - [SocureGlobalWatchlist](docs/models/SocureGlobalWatchlist.md)
 - [SocureMatch](docs/models/SocureMatch.md)
 - [SocureMatchList](docs/models/SocureMatchList.md)
 - [SocureMatches](docs/models/SocureMatches.md)
 - [SocureReasonCode](docs/models/SocureReasonCode.md)
 - [SocureWatchlistResult](docs/models/SocureWatchlistResult.md)
 - [SpendControl](docs/models/SpendControl.md)
 - [SpendControlDirection](docs/models/SpendControlDirection.md)
 - [SpendControlId](docs/models/SpendControlId.md)
 - [SpendControlIds](docs/models/SpendControlIds.md)
 - [SpendControlResponse](docs/models/SpendControlResponse.md)
 - [SpendControlResponseList](docs/models/SpendControlResponseList.md)
 - [SpendControlRollingWindowDays](docs/models/SpendControlRollingWindowDays.md)
 - [SpendControlTimeRange](docs/models/SpendControlTimeRange.md)
 - [SpendControlTimeRangeType](docs/models/SpendControlTimeRangeType.md)
 - [SpendControlUpdateRequest](docs/models/SpendControlUpdateRequest.md)
 - [SpendingLimitWithTime](docs/models/SpendingLimitWithTime.md)
 - [SpendingLimits](docs/models/SpendingLimits.md)
 - [SsnSource](docs/models/SsnSource.md)
 - [Statement](docs/models/Statement.md)
 - [StatementList](docs/models/StatementList.md)
 - [StatementSummary](docs/models/StatementSummary.md)
 - [Status](docs/models/Status.md)
 - [Status1](docs/models/Status1.md)
 - [TemplateFields](docs/models/TemplateFields.md)
 - [TemplateFieldsChargeSecured](docs/models/TemplateFieldsChargeSecured.md)
 - [TemplateFieldsDepository](docs/models/TemplateFieldsDepository.md)
 - [TemplateFieldsGenericResponse](docs/models/TemplateFieldsGenericResponse.md)
 - [TemplateFieldsLineOfCredit](docs/models/TemplateFieldsLineOfCredit.md)
 - [TemplateList](docs/models/TemplateList.md)
 - [TenantId](docs/models/TenantId.md)
 - [TenantId1](docs/models/TenantId1.md)
 - [TokenList](docs/models/TokenList.md)
 - [TokenListResponse](docs/models/TokenListResponse.md)
 - [Transaction](docs/models/Transaction.md)
 - [Transaction1](docs/models/Transaction1.md)
 - [TransactionData](docs/models/TransactionData.md)
 - [TransactionDirectPostRequest](docs/models/TransactionDirectPostRequest.md)
 - [TransactionLine](docs/models/TransactionLine.md)
 - [TransactionLine1](docs/models/TransactionLine1.md)
 - [TransactionOptions](docs/models/TransactionOptions.md)
 - [TransactionUpdateMetaRequest](docs/models/TransactionUpdateMetaRequest.md)
 - [TransferListResponse](docs/models/TransferListResponse.md)
 - [TransferRequest](docs/models/TransferRequest.md)
 - [TransferResponse](docs/models/TransferResponse.md)
 - [TransferReversalRequest](docs/models/TransferReversalRequest.md)
 - [TransferType](docs/models/TransferType.md)
 - [TransferTypeRequest](docs/models/TransferTypeRequest.md)
 - [TxnEnhancer](docs/models/TxnEnhancer.md)
 - [UpdateCardImageRequest](docs/models/UpdateCardImageRequest.md)
 - [UpdateGatewayRequest](docs/models/UpdateGatewayRequest.md)
 - [UpdateTransfer](docs/models/UpdateTransfer.md)
 - [VendorInfo](docs/models/VendorInfo.md)
 - [VendorInfo1](docs/models/VendorInfo1.md)
 - [VendorJson](docs/models/VendorJson.md)
 - [VendorXml](docs/models/VendorXml.md)
 - [Verification](docs/models/Verification.md)
 - [VerificationList](docs/models/VerificationList.md)
 - [VerificationRequest](docs/models/VerificationRequest.md)
 - [VerificationResult](docs/models/VerificationResult.md)
 - [VerificationStatus](docs/models/VerificationStatus.md)
 - [VerificationType](docs/models/VerificationType.md)
 - [VerificationType1](docs/models/VerificationType1.md)
 - [VerificationVendorInfo](docs/models/VerificationVendorInfo.md)
 - [VerificationVendorInfoDetail](docs/models/VerificationVendorInfoDetail.md)
 - [VerificationVendorJson](docs/models/VerificationVendorJson.md)
 - [VerificationVendorXml](docs/models/VerificationVendorXml.md)
 - [VerifyResponse](docs/models/VerifyResponse.md)
 - [Version](docs/models/Version.md)
 - [ViralLoopWaitlists](docs/models/ViralLoopWaitlists.md)
 - [VirtualCard](docs/models/VirtualCard.md)
 - [VirtualCardIssuanceRequest](docs/models/VirtualCardIssuanceRequest.md)
 - [VirtualCardPlusStatus](docs/models/VirtualCardPlusStatus.md)
 - [VirtualCardResponse](docs/models/VirtualCardResponse.md)
 - [VirtualCardResponseStatus](docs/models/VirtualCardResponseStatus.md)
 - [Waitlist](docs/models/Waitlist.md)
 - [WaitlistAnalytics](docs/models/WaitlistAnalytics.md)
 - [WaitlistAnalyticsList](docs/models/WaitlistAnalyticsList.md)
 - [WaitlistEditable](docs/models/WaitlistEditable.md)
 - [WaitlistsList](docs/models/WaitlistsList.md)
 - [WalletProviderCardOnFile](docs/models/WalletProviderCardOnFile.md)
 - [WatchlistAlert](docs/models/WatchlistAlert.md)
 - [WatchlistAlertList](docs/models/WatchlistAlertList.md)
 - [WatchlistSubscription](docs/models/WatchlistSubscription.md)
 - [WatchlistSubscriptionList](docs/models/WatchlistSubscriptionList.md)
 - [WatchlistSuppress](docs/models/WatchlistSuppress.md)
 - [Webhook](docs/models/Webhook.md)
 - [WebhookConfig](docs/models/WebhookConfig.md)
 - [WebhookEvent](docs/models/WebhookEvent.md)
 - [WebhookList](docs/models/WebhookList.md)
 - [WebhookRequest](docs/models/WebhookRequest.md)
 - [WebhookRequestObject](docs/models/WebhookRequestObject.md)
 - [WebhookResponse](docs/models/WebhookResponse.md)
 - [WidgetType](docs/models/WidgetType.md)
 - [Wire](docs/models/Wire.md)
 - [WireList](docs/models/WireList.md)
 - [WireRequest](docs/models/WireRequest.md)
 - [WireTransaction](docs/models/WireTransaction.md)
 - [WireTransactionData](docs/models/WireTransactionData.md)
 - [WireTransactionSubtypes](docs/models/WireTransactionSubtypes.md)
 - [WithdrawalRequestModel](docs/models/WithdrawalRequestModel.md)
 - [Workspace](docs/models/Workspace.md)
 - [WorkspaceList](docs/models/WorkspaceList.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## bearerAuth

- **Type**: Bearer authentication (api_key)


## Author


































## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in synctera_client.apis and synctera_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from synctera_client.apis.default_api import DefaultApi`
- `from synctera_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import synctera_client
from synctera_client.apis import *
from synctera_client.models import *
```
