[NCBI Datasets]( https://www.ncbi.nlm.nih.gov/datasets/) is a new resource that lets you easily gather data from across NCBI databases.

Find and download sequence, annotation and metadata for genes and genomes using this python library with our [RESTful API](https://www.ncbi.nlm.nih.gov/datasets/docs/datasets-api/).

This Python library is automatically generated by the [OpenAPI Generator project](https://openapi-generator.tech/).

Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements

Python >= 3.7

## Installation

To install the pre-built python package, create a virtual environment and use pip:

```sh
python -m venv ve/
source ve/bin/activate
pip install ncbi-datasets-pylib
```

## Getting Started

Please follow the installation procedure above and then run the following:

```python

import time
import ncbi.datasets.openapi
from pprint import pprint
from ncbi.datasets.openapi.api import gene_api
from ncbi.datasets.openapi.model.rpc_status import RpcStatus
from ncbi.datasets.openapi.model.v1_download_summary import V1DownloadSummary
from ncbi.datasets.openapi.model.v1_fasta import V1Fasta
from ncbi.datasets.openapi.model.v1_gene_dataset_request import V1GeneDatasetRequest
from ncbi.datasets.openapi.model.v1_gene_dataset_request_content_type import V1GeneDatasetRequestContentType
from ncbi.datasets.openapi.model.v1_gene_dataset_request_sort_field import V1GeneDatasetRequestSortField
from ncbi.datasets.openapi.model.v1_gene_match import V1GeneMatch
from ncbi.datasets.openapi.model.v1_gene_metadata import V1GeneMetadata
from ncbi.datasets.openapi.model.v1_organism import V1Organism
from ncbi.datasets.openapi.model.v1_organism_query_request_tax_rank_filter import V1OrganismQueryRequestTaxRankFilter
from ncbi.datasets.openapi.model.v1_ortholog_request_content_type import V1OrthologRequestContentType
from ncbi.datasets.openapi.model.v1_ortholog_set import V1OrthologSet
from ncbi.datasets.openapi.model.v1_sci_name_and_ids import V1SciNameAndIds
from ncbi.datasets.openapi.model.v1_sort_direction import V1SortDirection
# Defining the host is optional and defaults to https://api.ncbi.nlm.nih.gov/datasets/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = ncbi.datasets.openapi.Configuration(
    host = "https://api.ncbi.nlm.nih.gov/datasets/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuthHeader
configuration.api_key['ApiKeyAuthHeader'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuthHeader'] = 'Bearer'


# Enter a context with an instance of the API client
with ncbi.datasets.openapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gene_api.GeneApi(api_client)
    gene_ids = [
        59067,
    ] # [int] | NCBI gene ids
include_annotation_type = [
        V1Fasta("FASTA_UNSPECIFIED"),
    ] # [V1Fasta] | Select additional types of annotation to include in the data package.  If unset, no annotation is provided. (optional)
fasta_filter = [
        "fasta_filter_example",
    ] # [str] | Limit the FASTA sequences in the datasets package to these transcript and protein accessions (optional)
filename = "ncbi_dataset.zip" # str | Output file name. (optional) (default to "ncbi_dataset.zip")

    try:
        # Get a gene dataset by gene ID
        api_response = api_instance.download_gene_package(gene_ids, include_annotation_type=include_annotation_type, fasta_filter=fasta_filter, filename=filename)
        pprint(api_response)
    except ncbi.datasets.openapi.ApiException as e:
        print("Exception when calling GeneApi->download_gene_package: %s\n" % e)
```

## Documentation for API Endpoints

For detailed documentation of API endpoints, see our [GitHub page]( https://github.com/ncbi/datasets/tree/master/client_docs/python#documentation-for-api-endpoints).

## NCBI Datasets command-line tool

Alternatively, you may be interested in trying the NCBI Datasets command-line tools, datasets and dataformat.

Get started with our command-line tools with our command-line tool [quickstart]( https://www.ncbi.nlm.nih.gov/datasets/docs/v1/quickstarts/command-line-tools/).
