<p align="center">
  <img src="https://user-images.githubusercontent.com/65981382/166214135-47ecd327-cba8-47c0-a034-9f6f14b777ce.png" alt="Motion Tracker Beta"/>
</p>

# Motion Tracker Beta
An easy-to-use, standalone and open-source motion tracking application for researchers and engineers, written in Python.

## Features
- Intutitive graphical user interface
- Capable of handling the most common video formats
- Capable of tracking various properties of multiple objects simultaneously
- Diverse set of built in tracking algorithms, based on the `OpenCV` libary
- Rich selection of numerical differentiation algorithms powered by the `PyNumDiff` libary
- Built in plotting an exporting features


For the complete list of features please check the [documentation](https://github.com/flochkristof/motiontracker/blob/main/docs/GUIDE.pdf).

## Dependencies
The Graphical user interface was created with the [PyQt5](https://www.riverbankcomputing.com/software/pyqt/) framework. For the handling of video files and to do the actual tracking the [OpenCV](https://opencv.org/) library was used with its built in tracking algorithms. Numerical differentiations are carried out using the [PyNumDiff](https://github.com/florisvb/PyNumDiff). Plots and figures are generated by [matplotlib](https://matplotlib.org/). For the complete list of required packages check [pyproject.toml](https://github.com/flochkristof/motiontracker/blob/main/pyproject.toml) or [requirements.txt](https://github.com/flochkristof/motiontracker/blob/main/requirements.txt)

## Installation
### Download & install via PyPI (recommended)
```
$ pip install MotionTrackerBeta
```
- Run the application
```
$ MotionTrackerBeta
```
### Download & install the wheel file
- Download the `.whl` file from the latest [release](https://github.com/flochkristof/motiontracker/releases)
- Intall with pip>
```
$ pip install <path-to-wheel-file.whl>
```
- Run the application
```
$ MotionTrackerBeta
```

### Download & build from source
- Download the source from the latest [release](https://github.com/flochkristof/motiontracker/releases) or clone the repository
```
$ git clone https://github.com/flochkristof/motiontracker.git
```
- Build with [poetry](https://python-poetry.org/):
```
$ poetry build
```
- Install with pip
```
$ pip install dist/motiontrackerbeta-<version>-py3-none-any.whl
```
- Run the application
```
$ MotionTrackerBeta
```

### Download binaries (Windows)
- Download the binaries from the latest release
- Extract it to your specified location
- Run application with `Motion Tracker Beta.exe`
### Download the installer (Windows)
- Download the installer from the latest release
- Run the installer and follow the instructions
- After successful installation the software is accessible under the name `Motion Tracker Beta`
###
# Usage
For a detailed guide about the software check out the [documentation](docs/DOCUMENTATION.pdf). A video that intorduces the main features and functions of the software is also available [online](https://www.youtube.com/watch?v=q3eWOA0FEmk).
# License
Motion Tracker Beta is released under the `GNU General Public License v3.0`.
# Author
The software has been developed by Kristof Floch at the Department of Applied Mechanics, Faculty of Mechanical Engineering, Budapest University of Technology and Economics.
### Contact
- E-mail: kristof.floch@gmail.com
