# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class V0CommandStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'request': 'str',
        'device': 'str',
        'state': 'str',
        'reason': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'request': 'request',
        'device': 'device',
        'state': 'state',
        'reason': 'reason',
        'created_on': 'created_on',
        'updated_on': 'updated_on'
    }

    def __init__(self, id=None, request=None, device=None, state=None, reason=None, created_on=None, updated_on=None):
        """V0CommandStatus - a model defined in Swagger"""

        self._id = None
        self._request = None
        self._device = None
        self._state = None
        self._reason = None
        self._created_on = None
        self._updated_on = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if request is not None:
            self.request = request
        if device is not None:
            self.device = device
        if state is not None:
            self.state = state
        if reason is not None:
            self.reason = reason
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on

    @property
    def id(self):
        """Gets the id of this V0CommandStatus.

        Unique command identifier

        :return: The id of this V0CommandStatus.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this V0CommandStatus.

        Unique command identifier

        :param id: The id of this V0CommandStatus.
        :type: str
        """

        self._id = id

    @property
    def request(self):
        """Gets the request of this V0CommandStatus.

        Request Id associated with this command

        :return: The request of this V0CommandStatus.
        :rtype: str
        """
        return self._request

    @request.setter
    def request(self, request):
        """Sets the request of this V0CommandStatus.

        Request Id associated with this command

        :param request: The request of this V0CommandStatus.
        :type: str
        """

        self._request = request

    @property
    def device(self):
        """Gets the device of this V0CommandStatus.

        Device associated with this command

        :return: The device of this V0CommandStatus.
        :rtype: str
        """
        return self._device

    @device.setter
    def device(self, device):
        """Sets the device of this V0CommandStatus.

        Device associated with this command

        :param device: The device of this V0CommandStatus.
        :type: str
        """

        self._device = device

    @property
    def state(self):
        """Gets the state of this V0CommandStatus.

        Current state of the command

        :return: The state of this V0CommandStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this V0CommandStatus.

        Current state of the command

        :param state: The state of this V0CommandStatus.
        :type: str
        """
        allowed_values = ["Command Queued", "Command Initiated", "Command Acknowledged", "Command In Progress", "Command TimeOut", "Command Success", "Command Failure", "Command Scheduled", "Command Cancelled"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def reason(self):
        """Gets the reason of this V0CommandStatus.

        details briefing the reason for current command state

        :return: The reason of this V0CommandStatus.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this V0CommandStatus.

        details briefing the reason for current command state

        :param reason: The reason of this V0CommandStatus.
        :type: str
        """

        self._reason = reason

    @property
    def created_on(self):
        """Gets the created_on of this V0CommandStatus.

        Timestamp of command creation

        :return: The created_on of this V0CommandStatus.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this V0CommandStatus.

        Timestamp of command creation

        :param created_on: The created_on of this V0CommandStatus.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this V0CommandStatus.

        Last updated timestamp of command

        :return: The updated_on of this V0CommandStatus.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this V0CommandStatus.

        Last updated timestamp of command

        :param updated_on: The updated_on of this V0CommandStatus.
        :type: datetime
        """

        self._updated_on = updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
