# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.v0_command_schedule_args_time_type_enum import V0CommandScheduleArgsTimeTypeEnum


class V0CommandScheduleArgs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'start_datetime': 'datetime',
        'end_datetime': 'datetime',
        'time_type': 'V0CommandScheduleArgsTimeTypeEnum',
        'window_start_time': 'str',
        'window_end_time': 'str',
        'days': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'start_datetime': 'start_datetime',
        'end_datetime': 'end_datetime',
        'time_type': 'time_type',
        'window_start_time': 'window_start_time',
        'window_end_time': 'window_end_time',
        'days': 'days'
    }

    def __init__(self, name=None, start_datetime=None, end_datetime=None, time_type=None, window_start_time=None, window_end_time=None, days=None):
        """V0CommandScheduleArgs - a model defined in Swagger"""

        self._name = None
        self._start_datetime = None
        self._end_datetime = None
        self._time_type = None
        self._window_start_time = None
        self._window_end_time = None
        self._days = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if start_datetime is not None:
            self.start_datetime = start_datetime
        if end_datetime is not None:
            self.end_datetime = end_datetime
        if time_type is not None:
            self.time_type = time_type
        if window_start_time is not None:
            self.window_start_time = window_start_time
        if window_end_time is not None:
            self.window_end_time = window_end_time
        if days is not None:
            self.days = days

    @property
    def name(self):
        """Gets the name of this V0CommandScheduleArgs.


        :return: The name of this V0CommandScheduleArgs.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V0CommandScheduleArgs.


        :param name: The name of this V0CommandScheduleArgs.
        :type: str
        """

        self._name = name

    @property
    def start_datetime(self):
        """Gets the start_datetime of this V0CommandScheduleArgs.


        :return: The start_datetime of this V0CommandScheduleArgs.
        :rtype: datetime
        """
        return self._start_datetime

    @start_datetime.setter
    def start_datetime(self, start_datetime):
        """Sets the start_datetime of this V0CommandScheduleArgs.


        :param start_datetime: The start_datetime of this V0CommandScheduleArgs.
        :type: datetime
        """

        self._start_datetime = start_datetime

    @property
    def end_datetime(self):
        """Gets the end_datetime of this V0CommandScheduleArgs.


        :return: The end_datetime of this V0CommandScheduleArgs.
        :rtype: datetime
        """
        return self._end_datetime

    @end_datetime.setter
    def end_datetime(self, end_datetime):
        """Sets the end_datetime of this V0CommandScheduleArgs.


        :param end_datetime: The end_datetime of this V0CommandScheduleArgs.
        :type: datetime
        """

        self._end_datetime = end_datetime

    @property
    def time_type(self):
        """Gets the time_type of this V0CommandScheduleArgs.


        :return: The time_type of this V0CommandScheduleArgs.
        :rtype: V0CommandScheduleArgsTimeTypeEnum
        """
        return self._time_type

    @time_type.setter
    def time_type(self, time_type):
        """Sets the time_type of this V0CommandScheduleArgs.


        :param time_type: The time_type of this V0CommandScheduleArgs.
        :type: V0CommandScheduleArgsTimeTypeEnum
        """

        self._time_type = time_type

    @property
    def window_start_time(self):
        """Gets the window_start_time of this V0CommandScheduleArgs.


        :return: The window_start_time of this V0CommandScheduleArgs.
        :rtype: str
        """
        return self._window_start_time

    @window_start_time.setter
    def window_start_time(self, window_start_time):
        """Sets the window_start_time of this V0CommandScheduleArgs.


        :param window_start_time: The window_start_time of this V0CommandScheduleArgs.
        :type: str
        """

        self._window_start_time = window_start_time

    @property
    def window_end_time(self):
        """Gets the window_end_time of this V0CommandScheduleArgs.


        :return: The window_end_time of this V0CommandScheduleArgs.
        :rtype: str
        """
        return self._window_end_time

    @window_end_time.setter
    def window_end_time(self, window_end_time):
        """Sets the window_end_time of this V0CommandScheduleArgs.


        :param window_end_time: The window_end_time of this V0CommandScheduleArgs.
        :type: str
        """

        self._window_end_time = window_end_time

    @property
    def days(self):
        """Gets the days of this V0CommandScheduleArgs.


        :return: The days of this V0CommandScheduleArgs.
        :rtype: list[str]
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this V0CommandScheduleArgs.


        :param days: The days of this V0CommandScheduleArgs.
        :type: list[str]
        """

        self._days = days

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandScheduleArgs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandScheduleArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
