# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class V0CommandRequestStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'state': 'str',
        'total': 'int'
    }

    attribute_map = {
        'state': 'state',
        'total': 'total'
    }

    def __init__(self, state=None, total=None):
        """V0CommandRequestStatus - a model defined in Swagger"""

        self._state = None
        self._total = None
        self.discriminator = None

        if state is not None:
            self.state = state
        if total is not None:
            self.total = total

    @property
    def state(self):
        """Gets the state of this V0CommandRequestStatus.

        Current State of command

        :return: The state of this V0CommandRequestStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this V0CommandRequestStatus.

        Current State of command

        :param state: The state of this V0CommandRequestStatus.
        :type: str
        """

        self._state = state

    @property
    def total(self):
        """Gets the total of this V0CommandRequestStatus.

        No of commands currently in this state

        :return: The total of this V0CommandRequestStatus.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this V0CommandRequestStatus.

        No of commands currently in this state

        :param total: The total of this V0CommandRequestStatus.
        :type: int
        """

        self._total = total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandRequestStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandRequestStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
