# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class V0CommandArgs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'device_alias_name': 'str',
        'custom_settings_config': 'object',
        'app_version': 'str',
        'package_name': 'str',
        'policy_url': 'str',
        'wifi_access_points': 'object',
        'state': 'str',
        'message': 'str',
        'app_state': 'str'
    }

    attribute_map = {
        'device_alias_name': 'device_alias_name',
        'custom_settings_config': 'custom_settings_config',
        'app_version': 'app_version',
        'package_name': 'package_name',
        'policy_url': 'policy_url',
        'wifi_access_points': 'wifi_access_points',
        'state': 'state',
        'message': 'message',
        'app_state': 'app_state'
    }

    def __init__(self, device_alias_name=None, custom_settings_config=None, app_version=None, package_name=None, policy_url=None, wifi_access_points=None, state=None, message=None, app_state=None):
        """V0CommandArgs - a model defined in Swagger"""

        self._device_alias_name = None
        self._custom_settings_config = None
        self._app_version = None
        self._package_name = None
        self._policy_url = None
        self._wifi_access_points = None
        self._state = None
        self._message = None
        self._app_state = None
        self.discriminator = None

        if device_alias_name is not None:
            self.device_alias_name = device_alias_name
        if custom_settings_config is not None:
            self.custom_settings_config = custom_settings_config
        if app_version is not None:
            self.app_version = app_version
        if package_name is not None:
            self.package_name = package_name
        if policy_url is not None:
            self.policy_url = policy_url
        if wifi_access_points is not None:
            self.wifi_access_points = wifi_access_points
        if state is not None:
            self.state = state
        if message is not None:
            self.message = message
        if app_state is not None:
            self.app_state = app_state

    @property
    def device_alias_name(self):
        """Gets the device_alias_name of this V0CommandArgs.

        Alternate human-readable name for your Device

        :return: The device_alias_name of this V0CommandArgs.
        :rtype: str
        """
        return self._device_alias_name

    @device_alias_name.setter
    def device_alias_name(self, device_alias_name):
        """Sets the device_alias_name of this V0CommandArgs.

        Alternate human-readable name for your Device

        :param device_alias_name: The device_alias_name of this V0CommandArgs.
        :type: str
        """

        self._device_alias_name = device_alias_name

    @property
    def custom_settings_config(self):
        """Gets the custom_settings_config of this V0CommandArgs.

        Managed configurations for your device (passed as JSON object)

        :return: The custom_settings_config of this V0CommandArgs.
        :rtype: object
        """
        return self._custom_settings_config

    @custom_settings_config.setter
    def custom_settings_config(self, custom_settings_config):
        """Sets the custom_settings_config of this V0CommandArgs.

        Managed configurations for your device (passed as JSON object)

        :param custom_settings_config: The custom_settings_config of this V0CommandArgs.
        :type: object
        """

        self._custom_settings_config = custom_settings_config

    @property
    def app_version(self):
        """Gets the app_version of this V0CommandArgs.

        The version id of app uploaded on Esper

        :return: The app_version of this V0CommandArgs.
        :rtype: str
        """
        return self._app_version

    @app_version.setter
    def app_version(self, app_version):
        """Sets the app_version of this V0CommandArgs.

        The version id of app uploaded on Esper

        :param app_version: The app_version of this V0CommandArgs.
        :type: str
        """

        self._app_version = app_version

    @property
    def package_name(self):
        """Gets the package_name of this V0CommandArgs.

        The app package name uploaded on Esper

        :return: The package_name of this V0CommandArgs.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """Sets the package_name of this V0CommandArgs.

        The app package name uploaded on Esper

        :param package_name: The package_name of this V0CommandArgs.
        :type: str
        """

        self._package_name = package_name

    @property
    def policy_url(self):
        """Gets the policy_url of this V0CommandArgs.

        The URL to the policy

        :return: The policy_url of this V0CommandArgs.
        :rtype: str
        """
        return self._policy_url

    @policy_url.setter
    def policy_url(self, policy_url):
        """Sets the policy_url of this V0CommandArgs.

        The URL to the policy

        :param policy_url: The policy_url of this V0CommandArgs.
        :type: str
        """

        self._policy_url = policy_url

    @property
    def wifi_access_points(self):
        """Gets the wifi_access_points of this V0CommandArgs.

        Wifi access points for the device (passed as JSON object)

        :return: The wifi_access_points of this V0CommandArgs.
        :rtype: object
        """
        return self._wifi_access_points

    @wifi_access_points.setter
    def wifi_access_points(self, wifi_access_points):
        """Sets the wifi_access_points of this V0CommandArgs.

        Wifi access points for the device (passed as JSON object)

        :param wifi_access_points: The wifi_access_points of this V0CommandArgs.
        :type: object
        """

        self._wifi_access_points = wifi_access_points

    @property
    def state(self):
        """Gets the state of this V0CommandArgs.

        LOCKED/UNLOCKED

        :return: The state of this V0CommandArgs.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this V0CommandArgs.

        LOCKED/UNLOCKED

        :param state: The state of this V0CommandArgs.
        :type: str
        """

        self._state = state

    @property
    def message(self):
        """Gets the message of this V0CommandArgs.

        Message to be added with command

        :return: The message of this V0CommandArgs.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this V0CommandArgs.

        Message to be added with command

        :param message: The message of this V0CommandArgs.
        :type: str
        """

        self._message = message

    @property
    def app_state(self):
        """Gets the app_state of this V0CommandArgs.

        The state of app - SHOW/HIDE/DISABLE

        :return: The app_state of this V0CommandArgs.
        :rtype: str
        """
        return self._app_state

    @app_state.setter
    def app_state(self, app_state):
        """Sets the app_state of this V0CommandArgs.

        The state of app - SHOW/HIDE/DISABLE

        :param app_state: The app_state of this V0CommandArgs.
        :type: str
        """

        self._app_state = app_state

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V0CommandArgs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V0CommandArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
