# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class TokenInfoV1(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'enterprise': 'str',
        'user': 'str',
        'developer_app': 'str',
        'source_refresh_token': 'str',
        'token': 'str',
        'expires_on': 'datetime',
        'scope': 'list[str]',
        'created_on': 'datetime',
        'updated_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'enterprise': 'enterprise',
        'user': 'user',
        'developer_app': 'developer_app',
        'source_refresh_token': 'source_refresh_token',
        'token': 'token',
        'expires_on': 'expires_on',
        'scope': 'scope',
        'created_on': 'created_on',
        'updated_on': 'updated_on'
    }

    def __init__(self, id=None, enterprise=None, user=None, developer_app=None, source_refresh_token=None, token=None, expires_on=None, scope=None, created_on=None, updated_on=None):
        """TokenInfoV1 - a model defined in Swagger"""

        self._id = None
        self._enterprise = None
        self._user = None
        self._developer_app = None
        self._source_refresh_token = None
        self._token = None
        self._expires_on = None
        self._scope = None
        self._created_on = None
        self._updated_on = None
        self.discriminator = None

        self.id = id
        self.enterprise = enterprise
        if user is not None:
            self.user = user
        if developer_app is not None:
            self.developer_app = developer_app
        if source_refresh_token is not None:
            self.source_refresh_token = source_refresh_token
        if token is not None:
            self.token = token
        if expires_on is not None:
            self.expires_on = expires_on
        if scope is not None:
            self.scope = scope
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on

    @property
    def id(self):
        """Gets the id of this TokenInfoV1.

        Token id

        :return: The id of this TokenInfoV1.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TokenInfoV1.

        Token id

        :param id: The id of this TokenInfoV1.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def enterprise(self):
        """Gets the enterprise of this TokenInfoV1.

        Id of the enterprise resource

        :return: The enterprise of this TokenInfoV1.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this TokenInfoV1.

        Id of the enterprise resource

        :param enterprise: The enterprise of this TokenInfoV1.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    @property
    def user(self):
        """Gets the user of this TokenInfoV1.

        Id of the user resource

        :return: The user of this TokenInfoV1.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this TokenInfoV1.

        Id of the user resource

        :param user: The user of this TokenInfoV1.
        :type: str
        """

        self._user = user

    @property
    def developer_app(self):
        """Gets the developer_app of this TokenInfoV1.

        Id of the developer app resource that you created using the esper dev console

        :return: The developer_app of this TokenInfoV1.
        :rtype: str
        """
        return self._developer_app

    @developer_app.setter
    def developer_app(self, developer_app):
        """Sets the developer_app of this TokenInfoV1.

        Id of the developer app resource that you created using the esper dev console

        :param developer_app: The developer_app of this TokenInfoV1.
        :type: str
        """

        self._developer_app = developer_app

    @property
    def source_refresh_token(self):
        """Gets the source_refresh_token of this TokenInfoV1.

        The refresh token is used to refresh your expired API token

        :return: The source_refresh_token of this TokenInfoV1.
        :rtype: str
        """
        return self._source_refresh_token

    @source_refresh_token.setter
    def source_refresh_token(self, source_refresh_token):
        """Sets the source_refresh_token of this TokenInfoV1.

        The refresh token is used to refresh your expired API token

        :param source_refresh_token: The source_refresh_token of this TokenInfoV1.
        :type: str
        """

        self._source_refresh_token = source_refresh_token

    @property
    def token(self):
        """Gets the token of this TokenInfoV1.

        API token for accessing esper APIs

        :return: The token of this TokenInfoV1.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this TokenInfoV1.

        API token for accessing esper APIs

        :param token: The token of this TokenInfoV1.
        :type: str
        """

        self._token = token

    @property
    def expires_on(self):
        """Gets the expires_on of this TokenInfoV1.

        Date and time of when your API token will get expired

        :return: The expires_on of this TokenInfoV1.
        :rtype: datetime
        """
        return self._expires_on

    @expires_on.setter
    def expires_on(self, expires_on):
        """Sets the expires_on of this TokenInfoV1.

        Date and time of when your API token will get expired

        :param expires_on: The expires_on of this TokenInfoV1.
        :type: datetime
        """

        self._expires_on = expires_on

    @property
    def scope(self):
        """Gets the scope of this TokenInfoV1.

        This defines what access scopes does your API token has

        :return: The scope of this TokenInfoV1.
        :rtype: list[str]
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this TokenInfoV1.

        This defines what access scopes does your API token has

        :param scope: The scope of this TokenInfoV1.
        :type: list[str]
        """

        self._scope = scope

    @property
    def created_on(self):
        """Gets the created_on of this TokenInfoV1.

        Date and time of when this resource was created

        :return: The created_on of this TokenInfoV1.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this TokenInfoV1.

        Date and time of when this resource was created

        :param created_on: The created_on of this TokenInfoV1.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this TokenInfoV1.

        Date and time of when this resource was updated

        :return: The updated_on of this TokenInfoV1.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this TokenInfoV1.

        Date and time of when this resource was updated

        :param updated_on: The updated_on of this TokenInfoV1.
        :type: datetime
        """

        self._updated_on = updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TokenInfoV1, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenInfoV1):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
