# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class InstallDevices(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'device_name': 'str',
        'alias_name': 'str',
        'group_name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'device_name': 'device_name',
        'alias_name': 'alias_name',
        'group_name': 'group_name'
    }

    def __init__(self, id=None, device_name=None, alias_name=None, group_name=None):
        """InstallDevices - a model defined in Swagger"""

        self._id = None
        self._device_name = None
        self._alias_name = None
        self._group_name = None
        self.discriminator = None

        self.id = id
        if device_name is not None:
            self.device_name = device_name
        if alias_name is not None:
            self.alias_name = alias_name
        if group_name is not None:
            self.group_name = group_name

    @property
    def id(self):
        """Gets the id of this InstallDevices.


        :return: The id of this InstallDevices.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this InstallDevices.


        :param id: The id of this InstallDevices.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def device_name(self):
        """Gets the device_name of this InstallDevices.


        :return: The device_name of this InstallDevices.
        :rtype: str
        """
        return self._device_name

    @device_name.setter
    def device_name(self, device_name):
        """Sets the device_name of this InstallDevices.


        :param device_name: The device_name of this InstallDevices.
        :type: str
        """

        self._device_name = device_name

    @property
    def alias_name(self):
        """Gets the alias_name of this InstallDevices.


        :return: The alias_name of this InstallDevices.
        :rtype: str
        """
        return self._alias_name

    @alias_name.setter
    def alias_name(self, alias_name):
        """Sets the alias_name of this InstallDevices.


        :param alias_name: The alias_name of this InstallDevices.
        :type: str
        """

        self._alias_name = alias_name

    @property
    def group_name(self):
        """Gets the group_name of this InstallDevices.


        :return: The group_name of this InstallDevices.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """Sets the group_name of this InstallDevices.


        :param group_name: The group_name of this InstallDevices.
        :type: str
        """
        if group_name is not None and len(group_name) > 255:
            raise ValueError("Invalid value for `group_name`, length must be less than or equal to `255`")
        if group_name is not None and len(group_name) < 1:
            raise ValueError("Invalid value for `group_name`, length must be greater than or equal to `1`")

        self._group_name = group_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InstallDevices, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InstallDevices):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
