# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.group_command_args import GroupCommandArgs
from esperclient.models.group_command_enum import GroupCommandEnum


class GroupCommand(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'schedule': 'str',
        'command': 'GroupCommandEnum',
        'command_args': 'GroupCommandArgs',
        'state': 'str',
        'details': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime',
        'is_active': 'bool',
        'enterprise': 'str',
        'group': 'str',
        'issued_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'schedule': 'schedule',
        'command': 'command',
        'command_args': 'command_args',
        'state': 'state',
        'details': 'details',
        'created_on': 'created_on',
        'updated_on': 'updated_on',
        'is_active': 'is_active',
        'enterprise': 'enterprise',
        'group': 'group',
        'issued_by': 'issued_by'
    }

    def __init__(self, id=None, schedule=None, command=None, command_args=None, state=None, details=None, created_on=None, updated_on=None, is_active=None, enterprise=None, group=None, issued_by=None):
        """GroupCommand - a model defined in Swagger"""

        self._id = None
        self._schedule = None
        self._command = None
        self._command_args = None
        self._state = None
        self._details = None
        self._created_on = None
        self._updated_on = None
        self._is_active = None
        self._enterprise = None
        self._group = None
        self._issued_by = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if schedule is not None:
            self.schedule = schedule
        self.command = command
        if command_args is not None:
            self.command_args = command_args
        if state is not None:
            self.state = state
        if details is not None:
            self.details = details
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on
        if is_active is not None:
            self.is_active = is_active
        self.enterprise = enterprise
        self.group = group
        if issued_by is not None:
            self.issued_by = issued_by

    @property
    def id(self):
        """Gets the id of this GroupCommand.


        :return: The id of this GroupCommand.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GroupCommand.


        :param id: The id of this GroupCommand.
        :type: str
        """

        self._id = id

    @property
    def schedule(self):
        """Gets the schedule of this GroupCommand.


        :return: The schedule of this GroupCommand.
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this GroupCommand.


        :param schedule: The schedule of this GroupCommand.
        :type: str
        """

        self._schedule = schedule

    @property
    def command(self):
        """Gets the command of this GroupCommand.


        :return: The command of this GroupCommand.
        :rtype: GroupCommandEnum
        """
        return self._command

    @command.setter
    def command(self, command):
        """Sets the command of this GroupCommand.


        :param command: The command of this GroupCommand.
        :type: GroupCommandEnum
        """
        if command is None:
            raise ValueError("Invalid value for `command`, must not be `None`")

        self._command = command

    @property
    def command_args(self):
        """Gets the command_args of this GroupCommand.


        :return: The command_args of this GroupCommand.
        :rtype: GroupCommandArgs
        """
        return self._command_args

    @command_args.setter
    def command_args(self, command_args):
        """Sets the command_args of this GroupCommand.


        :param command_args: The command_args of this GroupCommand.
        :type: GroupCommandArgs
        """

        self._command_args = command_args

    @property
    def state(self):
        """Gets the state of this GroupCommand.


        :return: The state of this GroupCommand.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this GroupCommand.


        :param state: The state of this GroupCommand.
        :type: str
        """
        allowed_values = ["Command Initiated", "Command Success", "Command Failure", "Command Scheduled"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def details(self):
        """Gets the details of this GroupCommand.


        :return: The details of this GroupCommand.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this GroupCommand.


        :param details: The details of this GroupCommand.
        :type: str
        """

        self._details = details

    @property
    def created_on(self):
        """Gets the created_on of this GroupCommand.


        :return: The created_on of this GroupCommand.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this GroupCommand.


        :param created_on: The created_on of this GroupCommand.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this GroupCommand.


        :return: The updated_on of this GroupCommand.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this GroupCommand.


        :param updated_on: The updated_on of this GroupCommand.
        :type: datetime
        """

        self._updated_on = updated_on

    @property
    def is_active(self):
        """Gets the is_active of this GroupCommand.


        :return: The is_active of this GroupCommand.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this GroupCommand.


        :param is_active: The is_active of this GroupCommand.
        :type: bool
        """

        self._is_active = is_active

    @property
    def enterprise(self):
        """Gets the enterprise of this GroupCommand.


        :return: The enterprise of this GroupCommand.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this GroupCommand.


        :param enterprise: The enterprise of this GroupCommand.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    @property
    def group(self):
        """Gets the group of this GroupCommand.


        :return: The group of this GroupCommand.
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this GroupCommand.


        :param group: The group of this GroupCommand.
        :type: str
        """
        if group is None:
            raise ValueError("Invalid value for `group`, must not be `None`")

        self._group = group

    @property
    def issued_by(self):
        """Gets the issued_by of this GroupCommand.


        :return: The issued_by of this GroupCommand.
        :rtype: str
        """
        return self._issued_by

    @issued_by.setter
    def issued_by(self, issued_by):
        """Sets the issued_by of this GroupCommand.


        :param issued_by: The issued_by of this GroupCommand.
        :type: str
        """

        self._issued_by = issued_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GroupCommand, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupCommand):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
