# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class GeofenceUpdate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'latitude': 'str',
        'longitude': 'str',
        'radius': 'int',
        'radius_unit': 'str',
        'device_actions': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'latitude': 'latitude',
        'longitude': 'longitude',
        'radius': 'radius',
        'radius_unit': 'radius_unit',
        'device_actions': 'device_actions'
    }

    def __init__(self, name=None, description=None, latitude=None, longitude=None, radius=None, radius_unit=None, device_actions=None):
        """GeofenceUpdate - a model defined in Swagger"""

        self._name = None
        self._description = None
        self._latitude = None
        self._longitude = None
        self._radius = None
        self._radius_unit = None
        self._device_actions = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if latitude is not None:
            self.latitude = latitude
        if longitude is not None:
            self.longitude = longitude
        if radius is not None:
            self.radius = radius
        if radius_unit is not None:
            self.radius_unit = radius_unit
        if device_actions is not None:
            self.device_actions = device_actions

    @property
    def name(self):
        """Gets the name of this GeofenceUpdate.

        Name of the geofence

        :return: The name of this GeofenceUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GeofenceUpdate.

        Name of the geofence

        :param name: The name of this GeofenceUpdate.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this GeofenceUpdate.

        A description about the geofence

        :return: The description of this GeofenceUpdate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GeofenceUpdate.

        A description about the geofence

        :param description: The description of this GeofenceUpdate.
        :type: str
        """

        self._description = description

    @property
    def latitude(self):
        """Gets the latitude of this GeofenceUpdate.

        Latitude corresponding to the geofence

        :return: The latitude of this GeofenceUpdate.
        :rtype: str
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude):
        """Sets the latitude of this GeofenceUpdate.

        Latitude corresponding to the geofence

        :param latitude: The latitude of this GeofenceUpdate.
        :type: str
        """

        self._latitude = latitude

    @property
    def longitude(self):
        """Gets the longitude of this GeofenceUpdate.

        Longitude corresponding to the geofence

        :return: The longitude of this GeofenceUpdate.
        :rtype: str
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude):
        """Sets the longitude of this GeofenceUpdate.

        Longitude corresponding to the geofence

        :param longitude: The longitude of this GeofenceUpdate.
        :type: str
        """

        self._longitude = longitude

    @property
    def radius(self):
        """Gets the radius of this GeofenceUpdate.

        The radius within which the geofence should be applied

        :return: The radius of this GeofenceUpdate.
        :rtype: int
        """
        return self._radius

    @radius.setter
    def radius(self, radius):
        """Sets the radius of this GeofenceUpdate.

        The radius within which the geofence should be applied

        :param radius: The radius of this GeofenceUpdate.
        :type: int
        """

        self._radius = radius

    @property
    def radius_unit(self):
        """Gets the radius_unit of this GeofenceUpdate.

        The unit in which the radius is taken, eg - kilometers, meters etc

        :return: The radius_unit of this GeofenceUpdate.
        :rtype: str
        """
        return self._radius_unit

    @radius_unit.setter
    def radius_unit(self, radius_unit):
        """Sets the radius_unit of this GeofenceUpdate.

        The unit in which the radius is taken, eg - kilometers, meters etc

        :param radius_unit: The radius_unit of this GeofenceUpdate.
        :type: str
        """
        allowed_values = ["KILOMETERS", "METERS", "MILES"]
        if radius_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `radius_unit` ({0}), must be one of {1}"
                .format(radius_unit, allowed_values)
            )

        self._radius_unit = radius_unit

    @property
    def device_actions(self):
        """Gets the device_actions of this GeofenceUpdate.

        The actions to be performed on the device

        :return: The device_actions of this GeofenceUpdate.
        :rtype: list[str]
        """
        return self._device_actions

    @device_actions.setter
    def device_actions(self, device_actions):
        """Sets the device_actions of this GeofenceUpdate.

        The actions to be performed on the device

        :param device_actions: The device_actions of this GeofenceUpdate.
        :type: list[str]
        """
        allowed_values = ["LOCK_DOWN", "BEEP"]
        if not set(device_actions).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `device_actions` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(device_actions) - set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._device_actions = device_actions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GeofenceUpdate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GeofenceUpdate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
