# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class Geofence(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'enterprise': 'str',
        'latitude': 'str',
        'longitude': 'str',
        'radius': 'int',
        'radius_unit': 'str',
        'device_actions': 'list[str]',
        'device_count': 'int',
        'created_by': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'enterprise': 'enterprise',
        'latitude': 'latitude',
        'longitude': 'longitude',
        'radius': 'radius',
        'radius_unit': 'radius_unit',
        'device_actions': 'device_actions',
        'device_count': 'device_count',
        'created_by': 'created_by',
        'created_on': 'created_on',
        'updated_on': 'updated_on'
    }

    def __init__(self, id=None, name=None, description=None, enterprise=None, latitude=None, longitude=None, radius=None, radius_unit=None, device_actions=None, device_count=None, created_by=None, created_on=None, updated_on=None):
        """Geofence - a model defined in Swagger"""

        self._id = None
        self._name = None
        self._description = None
        self._enterprise = None
        self._latitude = None
        self._longitude = None
        self._radius = None
        self._radius_unit = None
        self._device_actions = None
        self._device_count = None
        self._created_by = None
        self._created_on = None
        self._updated_on = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        if enterprise is not None:
            self.enterprise = enterprise
        self.latitude = latitude
        self.longitude = longitude
        if radius is not None:
            self.radius = radius
        if radius_unit is not None:
            self.radius_unit = radius_unit
        if device_actions is not None:
            self.device_actions = device_actions
        if device_count is not None:
            self.device_count = device_count
        if created_by is not None:
            self.created_by = created_by
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on

    @property
    def id(self):
        """Gets the id of this Geofence.

        id of the geofence

        :return: The id of this Geofence.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Geofence.

        id of the geofence

        :param id: The id of this Geofence.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Geofence.

        Name of the geofence

        :return: The name of this Geofence.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Geofence.

        Name of the geofence

        :param name: The name of this Geofence.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """Gets the description of this Geofence.

        A description about the geofence

        :return: The description of this Geofence.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Geofence.

        A description about the geofence

        :param description: The description of this Geofence.
        :type: str
        """

        self._description = description

    @property
    def enterprise(self):
        """Gets the enterprise of this Geofence.

        id of the enterprise resource

        :return: The enterprise of this Geofence.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this Geofence.

        id of the enterprise resource

        :param enterprise: The enterprise of this Geofence.
        :type: str
        """

        self._enterprise = enterprise

    @property
    def latitude(self):
        """Gets the latitude of this Geofence.

        Latitude corresponding to the geofence

        :return: The latitude of this Geofence.
        :rtype: str
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude):
        """Sets the latitude of this Geofence.

        Latitude corresponding to the geofence

        :param latitude: The latitude of this Geofence.
        :type: str
        """
        if latitude is None:
            raise ValueError("Invalid value for `latitude`, must not be `None`")

        self._latitude = latitude

    @property
    def longitude(self):
        """Gets the longitude of this Geofence.

        Longitude corresponding to the geofence

        :return: The longitude of this Geofence.
        :rtype: str
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude):
        """Sets the longitude of this Geofence.

        Longitude corresponding to the geofence

        :param longitude: The longitude of this Geofence.
        :type: str
        """
        if longitude is None:
            raise ValueError("Invalid value for `longitude`, must not be `None`")

        self._longitude = longitude

    @property
    def radius(self):
        """Gets the radius of this Geofence.

        The radius within which the geofence should be applied

        :return: The radius of this Geofence.
        :rtype: int
        """
        return self._radius

    @radius.setter
    def radius(self, radius):
        """Sets the radius of this Geofence.

        The radius within which the geofence should be applied

        :param radius: The radius of this Geofence.
        :type: int
        """

        self._radius = radius

    @property
    def radius_unit(self):
        """Gets the radius_unit of this Geofence.

        The unit in which the radius is taken, eg - kilometers, meters etc

        :return: The radius_unit of this Geofence.
        :rtype: str
        """
        return self._radius_unit

    @radius_unit.setter
    def radius_unit(self, radius_unit):
        """Sets the radius_unit of this Geofence.

        The unit in which the radius is taken, eg - kilometers, meters etc

        :param radius_unit: The radius_unit of this Geofence.
        :type: str
        """
        allowed_values = ["KILOMETERS", "METERS", "MILES"]
        if radius_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `radius_unit` ({0}), must be one of {1}"
                .format(radius_unit, allowed_values)
            )

        self._radius_unit = radius_unit

    @property
    def device_actions(self):
        """Gets the device_actions of this Geofence.

        The actions to be performed on the device

        :return: The device_actions of this Geofence.
        :rtype: list[str]
        """
        return self._device_actions

    @device_actions.setter
    def device_actions(self, device_actions):
        """Sets the device_actions of this Geofence.

        The actions to be performed on the device

        :param device_actions: The device_actions of this Geofence.
        :type: list[str]
        """
        allowed_values = ["LOCK_DOWN", "BEEP"]
        if not set(device_actions).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `device_actions` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(device_actions) - set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._device_actions = device_actions

    @property
    def device_count(self):
        """Gets the device_count of this Geofence.

        Number of devices

        :return: The device_count of this Geofence.
        :rtype: int
        """
        return self._device_count

    @device_count.setter
    def device_count(self, device_count):
        """Sets the device_count of this Geofence.

        Number of devices

        :param device_count: The device_count of this Geofence.
        :type: int
        """

        self._device_count = device_count

    @property
    def created_by(self):
        """Gets the created_by of this Geofence.

        The user who created the geofence

        :return: The created_by of this Geofence.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Geofence.

        The user who created the geofence

        :param created_by: The created_by of this Geofence.
        :type: str
        """

        self._created_by = created_by

    @property
    def created_on(self):
        """Gets the created_on of this Geofence.

        Date and time of when the geofence was created

        :return: The created_on of this Geofence.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this Geofence.

        Date and time of when the geofence was created

        :param created_on: The created_on of this Geofence.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this Geofence.

        Date and time of when the geofence was updated

        :return: The updated_on of this Geofence.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this Geofence.

        Date and time of when the geofence was updated

        :param updated_on: The updated_on of this Geofence.
        :type: datetime
        """

        self._updated_on = updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Geofence, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Geofence):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
