# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class EventSubscription(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'aws_account_id': 'str',
        'sns_topic_arn': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime',
        'is_subscribed': 'bool',
        'enterprise': 'str'
    }

    attribute_map = {
        'id': 'id',
        'aws_account_id': 'aws_account_id',
        'sns_topic_arn': 'sns_topic_arn',
        'created_on': 'created_on',
        'updated_on': 'updated_on',
        'is_subscribed': 'is_subscribed',
        'enterprise': 'enterprise'
    }

    def __init__(self, id=None, aws_account_id=None, sns_topic_arn=None, created_on=None, updated_on=None, is_subscribed=None, enterprise=None):
        """EventSubscription - a model defined in Swagger"""

        self._id = None
        self._aws_account_id = None
        self._sns_topic_arn = None
        self._created_on = None
        self._updated_on = None
        self._is_subscribed = None
        self._enterprise = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.aws_account_id = aws_account_id
        if sns_topic_arn is not None:
            self.sns_topic_arn = sns_topic_arn
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on
        if is_subscribed is not None:
            self.is_subscribed = is_subscribed
        self.enterprise = enterprise

    @property
    def id(self):
        """Gets the id of this EventSubscription.


        :return: The id of this EventSubscription.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EventSubscription.


        :param id: The id of this EventSubscription.
        :type: str
        """

        self._id = id

    @property
    def aws_account_id(self):
        """Gets the aws_account_id of this EventSubscription.


        :return: The aws_account_id of this EventSubscription.
        :rtype: str
        """
        return self._aws_account_id

    @aws_account_id.setter
    def aws_account_id(self, aws_account_id):
        """Sets the aws_account_id of this EventSubscription.


        :param aws_account_id: The aws_account_id of this EventSubscription.
        :type: str
        """
        if aws_account_id is None:
            raise ValueError("Invalid value for `aws_account_id`, must not be `None`")
        if aws_account_id is not None and len(aws_account_id) < 1:
            raise ValueError("Invalid value for `aws_account_id`, length must be greater than or equal to `1`")

        self._aws_account_id = aws_account_id

    @property
    def sns_topic_arn(self):
        """Gets the sns_topic_arn of this EventSubscription.


        :return: The sns_topic_arn of this EventSubscription.
        :rtype: str
        """
        return self._sns_topic_arn

    @sns_topic_arn.setter
    def sns_topic_arn(self, sns_topic_arn):
        """Sets the sns_topic_arn of this EventSubscription.


        :param sns_topic_arn: The sns_topic_arn of this EventSubscription.
        :type: str
        """

        self._sns_topic_arn = sns_topic_arn

    @property
    def created_on(self):
        """Gets the created_on of this EventSubscription.


        :return: The created_on of this EventSubscription.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this EventSubscription.


        :param created_on: The created_on of this EventSubscription.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this EventSubscription.


        :return: The updated_on of this EventSubscription.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this EventSubscription.


        :param updated_on: The updated_on of this EventSubscription.
        :type: datetime
        """

        self._updated_on = updated_on

    @property
    def is_subscribed(self):
        """Gets the is_subscribed of this EventSubscription.


        :return: The is_subscribed of this EventSubscription.
        :rtype: bool
        """
        return self._is_subscribed

    @is_subscribed.setter
    def is_subscribed(self, is_subscribed):
        """Sets the is_subscribed of this EventSubscription.


        :param is_subscribed: The is_subscribed of this EventSubscription.
        :type: bool
        """

        self._is_subscribed = is_subscribed

    @property
    def enterprise(self):
        """Gets the enterprise of this EventSubscription.


        :return: The enterprise of this EventSubscription.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this EventSubscription.


        :param enterprise: The enterprise of this EventSubscription.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventSubscription, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventSubscription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
