# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.enterprise_policy_data import EnterprisePolicyData


class EnterprisePolicyPartialUpdate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'uuid': 'str',
        'enterprise': 'str',
        'url': 'str',
        'name': 'str',
        'description': 'str',
        'device_count': 'int',
        'policy': 'EnterprisePolicyData',
        'updated_on': 'datetime',
        'created_on': 'datetime',
        'is_active': 'bool',
        'google_policy_id': 'str'
    }

    attribute_map = {
        'uuid': 'uuid',
        'enterprise': 'enterprise',
        'url': 'url',
        'name': 'name',
        'description': 'description',
        'device_count': 'device_count',
        'policy': 'policy',
        'updated_on': 'updated_on',
        'created_on': 'created_on',
        'is_active': 'is_active',
        'google_policy_id': 'google_policy_id'
    }

    def __init__(self, uuid=None, enterprise=None, url=None, name=None, description=None, device_count=None, policy=None, updated_on=None, created_on=None, is_active=None, google_policy_id=None):
        """EnterprisePolicyPartialUpdate - a model defined in Swagger"""

        self._uuid = None
        self._enterprise = None
        self._url = None
        self._name = None
        self._description = None
        self._device_count = None
        self._policy = None
        self._updated_on = None
        self._created_on = None
        self._is_active = None
        self._google_policy_id = None
        self.discriminator = None

        if uuid is not None:
            self.uuid = uuid
        if enterprise is not None:
            self.enterprise = enterprise
        if url is not None:
            self.url = url
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if device_count is not None:
            self.device_count = device_count
        if policy is not None:
            self.policy = policy
        if updated_on is not None:
            self.updated_on = updated_on
        if created_on is not None:
            self.created_on = created_on
        if is_active is not None:
            self.is_active = is_active
        if google_policy_id is not None:
            self.google_policy_id = google_policy_id

    @property
    def uuid(self):
        """Gets the uuid of this EnterprisePolicyPartialUpdate.

        Unique Policy identifier

        :return: The uuid of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this EnterprisePolicyPartialUpdate.

        Unique Policy identifier

        :param uuid: The uuid of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._uuid = uuid

    @property
    def enterprise(self):
        """Gets the enterprise of this EnterprisePolicyPartialUpdate.

        Url of the enterprise resource

        :return: The enterprise of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this EnterprisePolicyPartialUpdate.

        Url of the enterprise resource

        :param enterprise: The enterprise of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._enterprise = enterprise

    @property
    def url(self):
        """Gets the url of this EnterprisePolicyPartialUpdate.

        URL link to policy

        :return: The url of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this EnterprisePolicyPartialUpdate.

        URL link to policy

        :param url: The url of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._url = url

    @property
    def name(self):
        """Gets the name of this EnterprisePolicyPartialUpdate.

        Name of the Policy

        :return: The name of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EnterprisePolicyPartialUpdate.

        Name of the Policy

        :param name: The name of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this EnterprisePolicyPartialUpdate.

        Details regarding the Policy

        :return: The description of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this EnterprisePolicyPartialUpdate.

        Details regarding the Policy

        :param description: The description of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._description = description

    @property
    def device_count(self):
        """Gets the device_count of this EnterprisePolicyPartialUpdate.

        Count of Devices with this policy applied

        :return: The device_count of this EnterprisePolicyPartialUpdate.
        :rtype: int
        """
        return self._device_count

    @device_count.setter
    def device_count(self, device_count):
        """Sets the device_count of this EnterprisePolicyPartialUpdate.

        Count of Devices with this policy applied

        :param device_count: The device_count of this EnterprisePolicyPartialUpdate.
        :type: int
        """

        self._device_count = device_count

    @property
    def policy(self):
        """Gets the policy of this EnterprisePolicyPartialUpdate.


        :return: The policy of this EnterprisePolicyPartialUpdate.
        :rtype: EnterprisePolicyData
        """
        return self._policy

    @policy.setter
    def policy(self, policy):
        """Sets the policy of this EnterprisePolicyPartialUpdate.


        :param policy: The policy of this EnterprisePolicyPartialUpdate.
        :type: EnterprisePolicyData
        """

        self._policy = policy

    @property
    def updated_on(self):
        """Gets the updated_on of this EnterprisePolicyPartialUpdate.

        Last-Updated Timestamp of Policy

        :return: The updated_on of this EnterprisePolicyPartialUpdate.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this EnterprisePolicyPartialUpdate.

        Last-Updated Timestamp of Policy

        :param updated_on: The updated_on of this EnterprisePolicyPartialUpdate.
        :type: datetime
        """

        self._updated_on = updated_on

    @property
    def created_on(self):
        """Gets the created_on of this EnterprisePolicyPartialUpdate.

        Creation Timestamp of Policy

        :return: The created_on of this EnterprisePolicyPartialUpdate.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this EnterprisePolicyPartialUpdate.

        Creation Timestamp of Policy

        :param created_on: The created_on of this EnterprisePolicyPartialUpdate.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def is_active(self):
        """Gets the is_active of this EnterprisePolicyPartialUpdate.

        Is this policy currently active

        :return: The is_active of this EnterprisePolicyPartialUpdate.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this EnterprisePolicyPartialUpdate.

        Is this policy currently active

        :param is_active: The is_active of this EnterprisePolicyPartialUpdate.
        :type: bool
        """

        self._is_active = is_active

    @property
    def google_policy_id(self):
        """Gets the google_policy_id of this EnterprisePolicyPartialUpdate.

        Id of the Google policy

        :return: The google_policy_id of this EnterprisePolicyPartialUpdate.
        :rtype: str
        """
        return self._google_policy_id

    @google_policy_id.setter
    def google_policy_id(self, google_policy_id):
        """Sets the google_policy_id of this EnterprisePolicyPartialUpdate.

        Id of the Google policy

        :param google_policy_id: The google_policy_id of this EnterprisePolicyPartialUpdate.
        :type: str
        """

        self._google_policy_id = google_policy_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterprisePolicyPartialUpdate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterprisePolicyPartialUpdate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
