# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class EnterprisePolicyDataPhonePolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'incoming_numbers': 'list[str]',
        'outgoing_numbers': 'list[str]',
        'dialer': 'str'
    }

    attribute_map = {
        'incoming_numbers': 'incomingNumbers',
        'outgoing_numbers': 'outgoingNumbers',
        'dialer': 'dialer'
    }

    def __init__(self, incoming_numbers=None, outgoing_numbers=None, dialer=None):
        """EnterprisePolicyDataPhonePolicy - a model defined in Swagger"""

        self._incoming_numbers = None
        self._outgoing_numbers = None
        self._dialer = None
        self.discriminator = None

        if incoming_numbers is not None:
            self.incoming_numbers = incoming_numbers
        if outgoing_numbers is not None:
            self.outgoing_numbers = outgoing_numbers
        if dialer is not None:
            self.dialer = dialer

    @property
    def incoming_numbers(self):
        """Gets the incoming_numbers of this EnterprisePolicyDataPhonePolicy.

        List of permitted incoming phone numbers to recieve calls from

        :return: The incoming_numbers of this EnterprisePolicyDataPhonePolicy.
        :rtype: list[str]
        """
        return self._incoming_numbers

    @incoming_numbers.setter
    def incoming_numbers(self, incoming_numbers):
        """Sets the incoming_numbers of this EnterprisePolicyDataPhonePolicy.

        List of permitted incoming phone numbers to recieve calls from

        :param incoming_numbers: The incoming_numbers of this EnterprisePolicyDataPhonePolicy.
        :type: list[str]
        """

        self._incoming_numbers = incoming_numbers

    @property
    def outgoing_numbers(self):
        """Gets the outgoing_numbers of this EnterprisePolicyDataPhonePolicy.

        List of permitted outgoing phone numbers to make calls to

        :return: The outgoing_numbers of this EnterprisePolicyDataPhonePolicy.
        :rtype: list[str]
        """
        return self._outgoing_numbers

    @outgoing_numbers.setter
    def outgoing_numbers(self, outgoing_numbers):
        """Sets the outgoing_numbers of this EnterprisePolicyDataPhonePolicy.

        List of permitted outgoing phone numbers to make calls to

        :param outgoing_numbers: The outgoing_numbers of this EnterprisePolicyDataPhonePolicy.
        :type: list[str]
        """

        self._outgoing_numbers = outgoing_numbers

    @property
    def dialer(self):
        """Gets the dialer of this EnterprisePolicyDataPhonePolicy.

        Pick a dialer - System default or Esper Dialer

        :return: The dialer of this EnterprisePolicyDataPhonePolicy.
        :rtype: str
        """
        return self._dialer

    @dialer.setter
    def dialer(self, dialer):
        """Sets the dialer of this EnterprisePolicyDataPhonePolicy.

        Pick a dialer - System default or Esper Dialer

        :param dialer: The dialer of this EnterprisePolicyDataPhonePolicy.
        :type: str
        """
        allowed_values = ["DEFAULT", "SHOONYA"]
        if dialer not in allowed_values:
            raise ValueError(
                "Invalid value for `dialer` ({0}), must be one of {1}"
                .format(dialer, allowed_values)
            )

        self._dialer = dialer

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterprisePolicyDataPhonePolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterprisePolicyDataPhonePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
