# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class EnterprisePolicyDataFrpGoogles(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'email': 'str',
        'google_id': 'str'
    }

    attribute_map = {
        'type': 'type',
        'email': 'email',
        'google_id': 'googleId'
    }

    def __init__(self, type=None, email=None, google_id=None):
        """EnterprisePolicyDataFrpGoogles - a model defined in Swagger"""

        self._type = None
        self._email = None
        self._google_id = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if email is not None:
            self.email = email
        if google_id is not None:
            self.google_id = google_id

    @property
    def type(self):
        """Gets the type of this EnterprisePolicyDataFrpGoogles.

        Type of User account provided - USER or ADMIN

        :return: The type of this EnterprisePolicyDataFrpGoogles.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this EnterprisePolicyDataFrpGoogles.

        Type of User account provided - USER or ADMIN

        :param type: The type of this EnterprisePolicyDataFrpGoogles.
        :type: str
        """
        allowed_values = ["USER", "ADMIN"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def email(self):
        """Gets the email of this EnterprisePolicyDataFrpGoogles.

        Email id to be used for Factory protection. This will be asked on the Device's UI

        :return: The email of this EnterprisePolicyDataFrpGoogles.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this EnterprisePolicyDataFrpGoogles.

        Email id to be used for Factory protection. This will be asked on the Device's UI

        :param email: The email of this EnterprisePolicyDataFrpGoogles.
        :type: str
        """

        self._email = email

    @property
    def google_id(self):
        """Gets the google_id of this EnterprisePolicyDataFrpGoogles.

        Google People ID associated with the above email (https://developers.google.com/people/api/rest/v1/people/get)

        :return: The google_id of this EnterprisePolicyDataFrpGoogles.
        :rtype: str
        """
        return self._google_id

    @google_id.setter
    def google_id(self, google_id):
        """Sets the google_id of this EnterprisePolicyDataFrpGoogles.

        Google People ID associated with the above email (https://developers.google.com/people/api/rest/v1/people/get)

        :param google_id: The google_id of this EnterprisePolicyDataFrpGoogles.
        :type: str
        """

        self._google_id = google_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterprisePolicyDataFrpGoogles, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterprisePolicyDataFrpGoogles):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
