# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class EnterprisePolicyDataDeviceUpdatePolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'maintenance_start': 'int',
        'maintenance_end': 'int'
    }

    attribute_map = {
        'type': 'type',
        'maintenance_start': 'maintenanceStart',
        'maintenance_end': 'maintenanceEnd'
    }

    def __init__(self, type=None, maintenance_start=None, maintenance_end=None):
        """EnterprisePolicyDataDeviceUpdatePolicy - a model defined in Swagger"""

        self._type = None
        self._maintenance_start = None
        self._maintenance_end = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if maintenance_start is not None:
            self.maintenance_start = maintenance_start
        if maintenance_end is not None:
            self.maintenance_end = maintenance_end

    @property
    def type(self):
        """Gets the type of this EnterprisePolicyDataDeviceUpdatePolicy.

        What type of installation is preferred?

        :return: The type of this EnterprisePolicyDataDeviceUpdatePolicy.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this EnterprisePolicyDataDeviceUpdatePolicy.

        What type of installation is preferred?

        :param type: The type of this EnterprisePolicyDataDeviceUpdatePolicy.
        :type: str
        """
        allowed_values = ["TYPE_INSTALL_AUTOMATIC", "TYPE_POSTPONE", "TYPE_INSTALL_WINDOWED", "TYPE_INSTALL_DISABLED"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def maintenance_start(self):
        """Gets the maintenance_start of this EnterprisePolicyDataDeviceUpdatePolicy.

        If the `type` is `TYPE_INSTALL_WINDOWED`, when should the maintenance start?

        :return: The maintenance_start of this EnterprisePolicyDataDeviceUpdatePolicy.
        :rtype: int
        """
        return self._maintenance_start

    @maintenance_start.setter
    def maintenance_start(self, maintenance_start):
        """Sets the maintenance_start of this EnterprisePolicyDataDeviceUpdatePolicy.

        If the `type` is `TYPE_INSTALL_WINDOWED`, when should the maintenance start?

        :param maintenance_start: The maintenance_start of this EnterprisePolicyDataDeviceUpdatePolicy.
        :type: int
        """

        self._maintenance_start = maintenance_start

    @property
    def maintenance_end(self):
        """Gets the maintenance_end of this EnterprisePolicyDataDeviceUpdatePolicy.

        If the `type` is `TYPE_INSTALL_WINDOWED`, when should the maintenance end?

        :return: The maintenance_end of this EnterprisePolicyDataDeviceUpdatePolicy.
        :rtype: int
        """
        return self._maintenance_end

    @maintenance_end.setter
    def maintenance_end(self, maintenance_end):
        """Sets the maintenance_end of this EnterprisePolicyDataDeviceUpdatePolicy.

        If the `type` is `TYPE_INSTALL_WINDOWED`, when should the maintenance end?

        :param maintenance_end: The maintenance_end of this EnterprisePolicyDataDeviceUpdatePolicy.
        :type: int
        """

        self._maintenance_end = maintenance_end

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterprisePolicyDataDeviceUpdatePolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterprisePolicyDataDeviceUpdatePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
