# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class EnterprisePolicyDataDevicePasswordPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'password_quality': 'str'
    }

    attribute_map = {
        'password_quality': 'passwordQuality'
    }

    def __init__(self, password_quality=None):
        """EnterprisePolicyDataDevicePasswordPolicy - a model defined in Swagger"""

        self._password_quality = None
        self.discriminator = None

        if password_quality is not None:
            self.password_quality = password_quality

    @property
    def password_quality(self):
        """Gets the password_quality of this EnterprisePolicyDataDevicePasswordPolicy.

        What is the type of password quality to apply to the device?

        :return: The password_quality of this EnterprisePolicyDataDevicePasswordPolicy.
        :rtype: str
        """
        return self._password_quality

    @password_quality.setter
    def password_quality(self, password_quality):
        """Sets the password_quality of this EnterprisePolicyDataDevicePasswordPolicy.

        What is the type of password quality to apply to the device?

        :param password_quality: The password_quality of this EnterprisePolicyDataDevicePasswordPolicy.
        :type: str
        """
        allowed_values = ["PASSWORD_QUALITY_ALPHABETIC", "PASSWORD_QUALITY_ALPHANUMERIC", "PASSWORD_QUALITY_BIOMETRIC_WEAK", "PASSWORD_QUALITY_COMPLEX", "PASSWORD_QUALITY_NUMERIC", "PASSWORD_QUALITY_NUMERIC_COMPLEX", "PASSWORD_QUALITY_SOMETHING", "PASSWORD_QUALITY_UNSPECIFIED"]
        if password_quality not in allowed_values:
            raise ValueError(
                "Invalid value for `password_quality` ({0}), must be one of {1}"
                .format(password_quality, allowed_values)
            )

        self._password_quality = password_quality

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterprisePolicyDataDevicePasswordPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterprisePolicyDataDevicePasswordPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
