# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class DeviceStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'data': 'str',
        'created_on': 'datetime',
        'device': 'str',
        'enterprise': 'str'
    }

    attribute_map = {
        'id': 'id',
        'data': 'data',
        'created_on': 'created_on',
        'device': 'device',
        'enterprise': 'enterprise'
    }

    def __init__(self, id=None, data=None, created_on=None, device=None, enterprise=None):
        """DeviceStatus - a model defined in Swagger"""

        self._id = None
        self._data = None
        self._created_on = None
        self._device = None
        self._enterprise = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.data = data
        if created_on is not None:
            self.created_on = created_on
        self.device = device
        self.enterprise = enterprise

    @property
    def id(self):
        """Gets the id of this DeviceStatus.


        :return: The id of this DeviceStatus.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceStatus.


        :param id: The id of this DeviceStatus.
        :type: int
        """

        self._id = id

    @property
    def data(self):
        """Gets the data of this DeviceStatus.


        :return: The data of this DeviceStatus.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this DeviceStatus.


        :param data: The data of this DeviceStatus.
        :type: str
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")

        self._data = data

    @property
    def created_on(self):
        """Gets the created_on of this DeviceStatus.


        :return: The created_on of this DeviceStatus.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this DeviceStatus.


        :param created_on: The created_on of this DeviceStatus.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def device(self):
        """Gets the device of this DeviceStatus.


        :return: The device of this DeviceStatus.
        :rtype: str
        """
        return self._device

    @device.setter
    def device(self, device):
        """Sets the device of this DeviceStatus.


        :param device: The device of this DeviceStatus.
        :type: str
        """
        if device is None:
            raise ValueError("Invalid value for `device`, must not be `None`")

        self._device = device

    @property
    def enterprise(self):
        """Gets the enterprise of this DeviceStatus.


        :return: The enterprise of this DeviceStatus.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this DeviceStatus.


        :param enterprise: The enterprise of this DeviceStatus.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
