# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six


class DeviceGroup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'created_on': 'datetime',
        'enterprise': 'str',
        'parent': 'str',
        'device_count': 'int',
        'path': 'str',
        'children_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'created_on': 'created_on',
        'enterprise': 'enterprise',
        'parent': 'parent',
        'device_count': 'device_count',
        'path': 'path',
        'children_count': 'children_count'
    }

    def __init__(self, id=None, name=None, created_on=None, enterprise=None, parent=None, device_count=None, path=None, children_count=None):
        """DeviceGroup - a model defined in Swagger"""

        self._id = None
        self._name = None
        self._created_on = None
        self._enterprise = None
        self._parent = None
        self._device_count = None
        self._path = None
        self._children_count = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if created_on is not None:
            self.created_on = created_on
        if enterprise is not None:
            self.enterprise = enterprise
        if parent is not None:
            self.parent = parent
        if device_count is not None:
            self.device_count = device_count
        if path is not None:
            self.path = path
        if children_count is not None:
            self.children_count = children_count

    @property
    def id(self):
        """Gets the id of this DeviceGroup.

        Group id

        :return: The id of this DeviceGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceGroup.

        Group id

        :param id: The id of this DeviceGroup.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this DeviceGroup.

        Group name

        :return: The name of this DeviceGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeviceGroup.

        Group name

        :param name: The name of this DeviceGroup.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def created_on(self):
        """Gets the created_on of this DeviceGroup.

        Date and time of when the group was created

        :return: The created_on of this DeviceGroup.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this DeviceGroup.

        Date and time of when the group was created

        :param created_on: The created_on of this DeviceGroup.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def enterprise(self):
        """Gets the enterprise of this DeviceGroup.

        Enterprise url

        :return: The enterprise of this DeviceGroup.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this DeviceGroup.

        Enterprise url

        :param enterprise: The enterprise of this DeviceGroup.
        :type: str
        """

        self._enterprise = enterprise

    @property
    def parent(self):
        """Gets the parent of this DeviceGroup.

        Parent group url

        :return: The parent of this DeviceGroup.
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this DeviceGroup.

        Parent group url

        :param parent: The parent of this DeviceGroup.
        :type: str
        """

        self._parent = parent

    @property
    def device_count(self):
        """Gets the device_count of this DeviceGroup.

        Count of devices in the group

        :return: The device_count of this DeviceGroup.
        :rtype: int
        """
        return self._device_count

    @device_count.setter
    def device_count(self, device_count):
        """Sets the device_count of this DeviceGroup.

        Count of devices in the group

        :param device_count: The device_count of this DeviceGroup.
        :type: int
        """

        self._device_count = device_count

    @property
    def path(self):
        """Gets the path of this DeviceGroup.

        Path of the group

        :return: The path of this DeviceGroup.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this DeviceGroup.

        Path of the group

        :param path: The path of this DeviceGroup.
        :type: str
        """

        self._path = path

    @property
    def children_count(self):
        """Gets the children_count of this DeviceGroup.

        Count of child groups

        :return: The children_count of this DeviceGroup.
        :rtype: int
        """
        return self._children_count

    @children_count.setter
    def children_count(self, children_count):
        """Sets the children_count of this DeviceGroup.

        Count of child groups

        :param children_count: The children_count of this DeviceGroup.
        :type: int
        """

        self._children_count = children_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
