# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.settings_gps_state_enum import SettingsGPSStateEnum
from esperclient.models.settings_rotate_state_enum import SettingsRotateStateEnum
from esperclient.models.settings_volume_stream_enum import SettingsVolumeStreamEnum


class CommandArgs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'wipe_external_storage': 'bool',
        'wipe_frp': 'bool',
        'brightness_value': 'int',
        'stream': 'SettingsVolumeStreamEnum',
        'volume_level': 'int',
        'wifi_state': 'bool',
        'bluetooth_state': 'bool',
        'rotate_state': 'SettingsRotateStateEnum',
        'gps_state': 'SettingsGPSStateEnum',
        'screen_off_timeout': 'int',
        'app_version': 'str',
        'package_name': 'str'
    }

    attribute_map = {
        'wipe_external_storage': 'wipe_external_storage',
        'wipe_frp': 'wipe_FRP',
        'brightness_value': 'brightness_value',
        'stream': 'stream',
        'volume_level': 'volume_level',
        'wifi_state': 'wifi_state',
        'bluetooth_state': 'bluetooth_state',
        'rotate_state': 'rotate_state',
        'gps_state': 'gps_state',
        'screen_off_timeout': 'screen_off_timeout',
        'app_version': 'app_version',
        'package_name': 'package_name'
    }

    def __init__(self, wipe_external_storage=False, wipe_frp=True, brightness_value=None, stream=None, volume_level=None, wifi_state=None, bluetooth_state=None, rotate_state=None, gps_state=None, screen_off_timeout=None, app_version=None, package_name=None):
        """CommandArgs - a model defined in Swagger"""

        self._wipe_external_storage = None
        self._wipe_frp = None
        self._brightness_value = None
        self._stream = None
        self._volume_level = None
        self._wifi_state = None
        self._bluetooth_state = None
        self._rotate_state = None
        self._gps_state = None
        self._screen_off_timeout = None
        self._app_version = None
        self._package_name = None
        self.discriminator = None

        if wipe_external_storage is not None:
            self.wipe_external_storage = wipe_external_storage
        if wipe_frp is not None:
            self.wipe_frp = wipe_frp
        if brightness_value is not None:
            self.brightness_value = brightness_value
        if stream is not None:
            self.stream = stream
        if volume_level is not None:
            self.volume_level = volume_level
        if wifi_state is not None:
            self.wifi_state = wifi_state
        if bluetooth_state is not None:
            self.bluetooth_state = bluetooth_state
        if rotate_state is not None:
            self.rotate_state = rotate_state
        if gps_state is not None:
            self.gps_state = gps_state
        if screen_off_timeout is not None:
            self.screen_off_timeout = screen_off_timeout
        if app_version is not None:
            self.app_version = app_version
        if package_name is not None:
            self.package_name = package_name

    @property
    def wipe_external_storage(self):
        """Gets the wipe_external_storage of this CommandArgs.


        :return: The wipe_external_storage of this CommandArgs.
        :rtype: bool
        """
        return self._wipe_external_storage

    @wipe_external_storage.setter
    def wipe_external_storage(self, wipe_external_storage):
        """Sets the wipe_external_storage of this CommandArgs.


        :param wipe_external_storage: The wipe_external_storage of this CommandArgs.
        :type: bool
        """

        self._wipe_external_storage = wipe_external_storage

    @property
    def wipe_frp(self):
        """Gets the wipe_frp of this CommandArgs.


        :return: The wipe_frp of this CommandArgs.
        :rtype: bool
        """
        return self._wipe_frp

    @wipe_frp.setter
    def wipe_frp(self, wipe_frp):
        """Sets the wipe_frp of this CommandArgs.


        :param wipe_frp: The wipe_frp of this CommandArgs.
        :type: bool
        """

        self._wipe_frp = wipe_frp

    @property
    def brightness_value(self):
        """Gets the brightness_value of this CommandArgs.


        :return: The brightness_value of this CommandArgs.
        :rtype: int
        """
        return self._brightness_value

    @brightness_value.setter
    def brightness_value(self, brightness_value):
        """Sets the brightness_value of this CommandArgs.


        :param brightness_value: The brightness_value of this CommandArgs.
        :type: int
        """
        if brightness_value is not None and brightness_value > 100:
            raise ValueError("Invalid value for `brightness_value`, must be a value less than or equal to `100`")
        if brightness_value is not None and brightness_value < 1:
            raise ValueError("Invalid value for `brightness_value`, must be a value greater than or equal to `1`")

        self._brightness_value = brightness_value

    @property
    def stream(self):
        """Gets the stream of this CommandArgs.


        :return: The stream of this CommandArgs.
        :rtype: SettingsVolumeStreamEnum
        """
        return self._stream

    @stream.setter
    def stream(self, stream):
        """Sets the stream of this CommandArgs.


        :param stream: The stream of this CommandArgs.
        :type: SettingsVolumeStreamEnum
        """

        self._stream = stream

    @property
    def volume_level(self):
        """Gets the volume_level of this CommandArgs.


        :return: The volume_level of this CommandArgs.
        :rtype: int
        """
        return self._volume_level

    @volume_level.setter
    def volume_level(self, volume_level):
        """Sets the volume_level of this CommandArgs.


        :param volume_level: The volume_level of this CommandArgs.
        :type: int
        """
        if volume_level is not None and volume_level > 100:
            raise ValueError("Invalid value for `volume_level`, must be a value less than or equal to `100`")
        if volume_level is not None and volume_level < 0:
            raise ValueError("Invalid value for `volume_level`, must be a value greater than or equal to `0`")

        self._volume_level = volume_level

    @property
    def wifi_state(self):
        """Gets the wifi_state of this CommandArgs.


        :return: The wifi_state of this CommandArgs.
        :rtype: bool
        """
        return self._wifi_state

    @wifi_state.setter
    def wifi_state(self, wifi_state):
        """Sets the wifi_state of this CommandArgs.


        :param wifi_state: The wifi_state of this CommandArgs.
        :type: bool
        """

        self._wifi_state = wifi_state

    @property
    def bluetooth_state(self):
        """Gets the bluetooth_state of this CommandArgs.


        :return: The bluetooth_state of this CommandArgs.
        :rtype: bool
        """
        return self._bluetooth_state

    @bluetooth_state.setter
    def bluetooth_state(self, bluetooth_state):
        """Sets the bluetooth_state of this CommandArgs.


        :param bluetooth_state: The bluetooth_state of this CommandArgs.
        :type: bool
        """

        self._bluetooth_state = bluetooth_state

    @property
    def rotate_state(self):
        """Gets the rotate_state of this CommandArgs.


        :return: The rotate_state of this CommandArgs.
        :rtype: SettingsRotateStateEnum
        """
        return self._rotate_state

    @rotate_state.setter
    def rotate_state(self, rotate_state):
        """Sets the rotate_state of this CommandArgs.


        :param rotate_state: The rotate_state of this CommandArgs.
        :type: SettingsRotateStateEnum
        """

        self._rotate_state = rotate_state

    @property
    def gps_state(self):
        """Gets the gps_state of this CommandArgs.


        :return: The gps_state of this CommandArgs.
        :rtype: SettingsGPSStateEnum
        """
        return self._gps_state

    @gps_state.setter
    def gps_state(self, gps_state):
        """Sets the gps_state of this CommandArgs.


        :param gps_state: The gps_state of this CommandArgs.
        :type: SettingsGPSStateEnum
        """

        self._gps_state = gps_state

    @property
    def screen_off_timeout(self):
        """Gets the screen_off_timeout of this CommandArgs.

        Value in seconds

        :return: The screen_off_timeout of this CommandArgs.
        :rtype: int
        """
        return self._screen_off_timeout

    @screen_off_timeout.setter
    def screen_off_timeout(self, screen_off_timeout):
        """Sets the screen_off_timeout of this CommandArgs.

        Value in seconds

        :param screen_off_timeout: The screen_off_timeout of this CommandArgs.
        :type: int
        """
        if screen_off_timeout is not None and screen_off_timeout > 1800000:
            raise ValueError("Invalid value for `screen_off_timeout`, must be a value less than or equal to `1800000`")
        if screen_off_timeout is not None and screen_off_timeout < 5000:
            raise ValueError("Invalid value for `screen_off_timeout`, must be a value greater than or equal to `5000`")

        self._screen_off_timeout = screen_off_timeout

    @property
    def app_version(self):
        """Gets the app_version of this CommandArgs.


        :return: The app_version of this CommandArgs.
        :rtype: str
        """
        return self._app_version

    @app_version.setter
    def app_version(self, app_version):
        """Sets the app_version of this CommandArgs.


        :param app_version: The app_version of this CommandArgs.
        :type: str
        """

        self._app_version = app_version

    @property
    def package_name(self):
        """Gets the package_name of this CommandArgs.


        :return: The package_name of this CommandArgs.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """Sets the package_name of this CommandArgs.


        :param package_name: The package_name of this CommandArgs.
        :type: str
        """

        self._package_name = package_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CommandArgs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CommandArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
