# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.app_install_version import AppInstallVersion


class AppInstallApplication(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'application_name': 'str',
        'package_name': 'str',
        'version': 'AppInstallVersion',
        'is_enabled': 'bool'
    }

    attribute_map = {
        'application_name': 'application_name',
        'package_name': 'package_name',
        'version': 'version',
        'is_enabled': 'is_enabled'
    }

    def __init__(self, application_name=None, package_name=None, version=None, is_enabled=None):
        """AppInstallApplication - a model defined in Swagger"""

        self._application_name = None
        self._package_name = None
        self._version = None
        self._is_enabled = None
        self.discriminator = None

        if application_name is not None:
            self.application_name = application_name
        if package_name is not None:
            self.package_name = package_name
        if version is not None:
            self.version = version
        if is_enabled is not None:
            self.is_enabled = is_enabled

    @property
    def application_name(self):
        """Gets the application_name of this AppInstallApplication.


        :return: The application_name of this AppInstallApplication.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """Sets the application_name of this AppInstallApplication.


        :param application_name: The application_name of this AppInstallApplication.
        :type: str
        """

        self._application_name = application_name

    @property
    def package_name(self):
        """Gets the package_name of this AppInstallApplication.


        :return: The package_name of this AppInstallApplication.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """Sets the package_name of this AppInstallApplication.


        :param package_name: The package_name of this AppInstallApplication.
        :type: str
        """

        self._package_name = package_name

    @property
    def version(self):
        """Gets the version of this AppInstallApplication.


        :return: The version of this AppInstallApplication.
        :rtype: AppInstallVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AppInstallApplication.


        :param version: The version of this AppInstallApplication.
        :type: AppInstallVersion
        """

        self._version = version

    @property
    def is_enabled(self):
        """Gets the is_enabled of this AppInstallApplication.


        :return: The is_enabled of this AppInstallApplication.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """Sets the is_enabled of this AppInstallApplication.


        :param is_enabled: The is_enabled of this AppInstallApplication.
        :type: bool
        """

        self._is_enabled = is_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AppInstallApplication, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppInstallApplication):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
