# coding: utf-8

"""
ESPER API REFERENCE

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.app_install_application import AppInstallApplication
from esperclient.models.app_install_state_enum import AppInstallStateEnum


class AppInstall(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'application': 'AppInstallApplication',
        'install_state': 'AppInstallStateEnum',
        'reason_details': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime',
        'is_active': 'bool',
        'enterprise': 'str',
        'device': 'str'
    }

    attribute_map = {
        'id': 'id',
        'application': 'application',
        'install_state': 'install_state',
        'reason_details': 'reason_details',
        'created_on': 'created_on',
        'updated_on': 'updated_on',
        'is_active': 'is_active',
        'enterprise': 'enterprise',
        'device': 'device'
    }

    def __init__(self, id=None, application=None, install_state=None, reason_details=None, created_on=None, updated_on=None, is_active=None, enterprise=None, device=None):
        """AppInstall - a model defined in Swagger"""

        self._id = None
        self._application = None
        self._install_state = None
        self._reason_details = None
        self._created_on = None
        self._updated_on = None
        self._is_active = None
        self._enterprise = None
        self._device = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.application = application
        self.install_state = install_state
        if reason_details is not None:
            self.reason_details = reason_details
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on
        if is_active is not None:
            self.is_active = is_active
        self.enterprise = enterprise
        self.device = device

    @property
    def id(self):
        """Gets the id of this AppInstall.


        :return: The id of this AppInstall.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AppInstall.


        :param id: The id of this AppInstall.
        :type: str
        """

        self._id = id

    @property
    def application(self):
        """Gets the application of this AppInstall.


        :return: The application of this AppInstall.
        :rtype: AppInstallApplication
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this AppInstall.


        :param application: The application of this AppInstall.
        :type: AppInstallApplication
        """
        if application is None:
            raise ValueError("Invalid value for `application`, must not be `None`")

        self._application = application

    @property
    def install_state(self):
        """Gets the install_state of this AppInstall.


        :return: The install_state of this AppInstall.
        :rtype: AppInstallStateEnum
        """
        return self._install_state

    @install_state.setter
    def install_state(self, install_state):
        """Sets the install_state of this AppInstall.


        :param install_state: The install_state of this AppInstall.
        :type: AppInstallStateEnum
        """
        if install_state is None:
            raise ValueError("Invalid value for `install_state`, must not be `None`")

        self._install_state = install_state

    @property
    def reason_details(self):
        """Gets the reason_details of this AppInstall.


        :return: The reason_details of this AppInstall.
        :rtype: str
        """
        return self._reason_details

    @reason_details.setter
    def reason_details(self, reason_details):
        """Sets the reason_details of this AppInstall.


        :param reason_details: The reason_details of this AppInstall.
        :type: str
        """
        if reason_details is not None and len(reason_details) < 1:
            raise ValueError("Invalid value for `reason_details`, length must be greater than or equal to `1`")

        self._reason_details = reason_details

    @property
    def created_on(self):
        """Gets the created_on of this AppInstall.


        :return: The created_on of this AppInstall.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this AppInstall.


        :param created_on: The created_on of this AppInstall.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this AppInstall.


        :return: The updated_on of this AppInstall.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this AppInstall.


        :param updated_on: The updated_on of this AppInstall.
        :type: datetime
        """

        self._updated_on = updated_on

    @property
    def is_active(self):
        """Gets the is_active of this AppInstall.


        :return: The is_active of this AppInstall.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this AppInstall.


        :param is_active: The is_active of this AppInstall.
        :type: bool
        """

        self._is_active = is_active

    @property
    def enterprise(self):
        """Gets the enterprise of this AppInstall.


        :return: The enterprise of this AppInstall.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this AppInstall.


        :param enterprise: The enterprise of this AppInstall.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    @property
    def device(self):
        """Gets the device of this AppInstall.


        :return: The device of this AppInstall.
        :rtype: str
        """
        return self._device

    @device.setter
    def device(self, device):
        """Sets the device of this AppInstall.


        :param device: The device of this AppInstall.
        :type: str
        """
        if device is None:
            raise ValueError("Invalid value for `device`, must not be `None`")

        self._device = device

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AppInstall, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppInstall):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
