/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/

import * as React from 'react'
import { Global } from '../../Global'
import Step from '../../core/Step';
import { Button } from '@material-ui/core';

export default function WaitForChangesStep(props: any) {

    if (Global.shouldLogOnRender) console.log('ComponentRender (' + new Date().getSeconds() + ')');
    return (
        <Step {...props}
            header={`Wait for your optimized notebook`}
            overrideNextButton={
                <Button
                    disabled
                    style={{margin: '6px'}}
                    variant='contained'
                    color='primary'
                >
                    Next
                </Button>
            }
        />
    )
}