# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-06-14 18:21
from __future__ import unicode_literals

import assignment_desk.utils
import colorfield.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('editorial_staff', '0007_populate_staffer_full_names'),
    ]

    operations = [
        migrations.CreateModel(
            name='Assignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day', models.DateField()),
                ('notes', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('slug', models.SlugField()),
                ('description', models.TextField(blank=True, null=True)),
                ('color', colorfield.fields.ColorField(default='#0185D3', max_length=18)),
                ('priority', models.PositiveSmallIntegerField(default=10)),
            ],
        ),
        migrations.CreateModel(
            name='RoleType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('slug', models.SlugField()),
                ('priority', models.PositiveSmallIntegerField(default=10)),
            ],
        ),
        migrations.CreateModel(
            name='Week',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('beginning_date', models.DateField(default=assignment_desk.utils.get_latest_monday)),
                ('ending_date', models.DateField(default=assignment_desk.utils.get_next_sunday)),
                ('extra_information', models.TextField(blank=True, null=True)),
                ('assigned_staffers', models.ManyToManyField(through='assignment_desk.Assignment', to='editorial_staff.Staffer')),
            ],
        ),
        migrations.AddField(
            model_name='role',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assignment_desk.RoleType'),
        ),
        migrations.AddField(
            model_name='assignment',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assignment_desk.Role'),
        ),
        migrations.AddField(
            model_name='assignment',
            name='staffer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='editorial_staff.Staffer'),
        ),
        migrations.AddField(
            model_name='assignment',
            name='week',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='assignment_desk.Week'),
        ),
    ]
