# coding: utf-8

"""
Esper APIs

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.google_emm import GoogleEMM


class EnterpriseV1(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'short_code': 'str',
        'registered_name': 'str',
        'registered_address': 'str',
        'location': 'str',
        'zipcode': 'str',
        'contact_person': 'str',
        'contact_number': 'str',
        'contact_email': 'str',
        'emm': 'GoogleEMM',
        'created_on': 'datetime',
        'updated_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'short_code': 'short_code',
        'registered_name': 'registered_name',
        'registered_address': 'registered_address',
        'location': 'location',
        'zipcode': 'zipcode',
        'contact_person': 'contact_person',
        'contact_number': 'contact_number',
        'contact_email': 'contact_email',
        'emm': 'emm',
        'created_on': 'created_on',
        'updated_on': 'updated_on'
    }

    def __init__(self, id=None, name=None, short_code=None, registered_name=None, registered_address=None, location=None, zipcode=None, contact_person=None, contact_number=None, contact_email=None, emm=None, created_on=None, updated_on=None):
        """EnterpriseV1 - a model defined in Swagger"""

        self._id = None
        self._name = None
        self._short_code = None
        self._registered_name = None
        self._registered_address = None
        self._location = None
        self._zipcode = None
        self._contact_person = None
        self._contact_number = None
        self._contact_email = None
        self._emm = None
        self._created_on = None
        self._updated_on = None
        self.discriminator = None

        self.id = id
        self.name = name
        self.short_code = short_code
        if registered_name is not None:
            self.registered_name = registered_name
        if registered_address is not None:
            self.registered_address = registered_address
        if location is not None:
            self.location = location
        if zipcode is not None:
            self.zipcode = zipcode
        if contact_person is not None:
            self.contact_person = contact_person
        if contact_number is not None:
            self.contact_number = contact_number
        if contact_email is not None:
            self.contact_email = contact_email
        if emm is not None:
            self.emm = emm
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on

    @property
    def id(self):
        """Gets the id of this EnterpriseV1.

        Id of the enterprise

        :return: The id of this EnterpriseV1.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EnterpriseV1.

        Id of the enterprise

        :param id: The id of this EnterpriseV1.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def name(self):
        """Gets the name of this EnterpriseV1.

        Name of the enterprise

        :return: The name of this EnterpriseV1.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EnterpriseV1.

        Name of the enterprise

        :param name: The name of this EnterpriseV1.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")

        self._name = name

    @property
    def short_code(self):
        """Gets the short_code of this EnterpriseV1.

        A short 10-char representation of the enterprise, separated by hyphens. Field is optional, as system will auto-generate a value if none is provided.

        :return: The short_code of this EnterpriseV1.
        :rtype: str
        """
        return self._short_code

    @short_code.setter
    def short_code(self, short_code):
        """Sets the short_code of this EnterpriseV1.

        A short 10-char representation of the enterprise, separated by hyphens. Field is optional, as system will auto-generate a value if none is provided.

        :param short_code: The short_code of this EnterpriseV1.
        :type: str
        """
        if short_code is None:
            raise ValueError("Invalid value for `short_code`, must not be `None`")
        if short_code is not None and len(short_code) > 10:
            raise ValueError("Invalid value for `short_code`, length must be less than or equal to `10`")
        if short_code is not None and len(short_code) < 1:
            raise ValueError("Invalid value for `short_code`, length must be greater than or equal to `1`")

        self._short_code = short_code

    @property
    def registered_name(self):
        """Gets the registered_name of this EnterpriseV1.

        Registered Name of the enterprise

        :return: The registered_name of this EnterpriseV1.
        :rtype: str
        """
        return self._registered_name

    @registered_name.setter
    def registered_name(self, registered_name):
        """Sets the registered_name of this EnterpriseV1.

        Registered Name of the enterprise

        :param registered_name: The registered_name of this EnterpriseV1.
        :type: str
        """
        if registered_name is not None and len(registered_name) > 255:
            raise ValueError("Invalid value for `registered_name`, length must be less than or equal to `255`")
        if registered_name is not None and len(registered_name) < 1:
            raise ValueError("Invalid value for `registered_name`, length must be greater than or equal to `1`")

        self._registered_name = registered_name

    @property
    def registered_address(self):
        """Gets the registered_address of this EnterpriseV1.

        Registered address of the enterprise.

        :return: The registered_address of this EnterpriseV1.
        :rtype: str
        """
        return self._registered_address

    @registered_address.setter
    def registered_address(self, registered_address):
        """Sets the registered_address of this EnterpriseV1.

        Registered address of the enterprise.

        :param registered_address: The registered_address of this EnterpriseV1.
        :type: str
        """
        if registered_address is not None and len(registered_address) > 255:
            raise ValueError("Invalid value for `registered_address`, length must be less than or equal to `255`")
        if registered_address is not None and len(registered_address) < 1:
            raise ValueError("Invalid value for `registered_address`, length must be greater than or equal to `1`")

        self._registered_address = registered_address

    @property
    def location(self):
        """Gets the location of this EnterpriseV1.

        City, State, Country location of the enterprise

        :return: The location of this EnterpriseV1.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this EnterpriseV1.

        City, State, Country location of the enterprise

        :param location: The location of this EnterpriseV1.
        :type: str
        """
        if location is not None and len(location) > 255:
            raise ValueError("Invalid value for `location`, length must be less than or equal to `255`")
        if location is not None and len(location) < 1:
            raise ValueError("Invalid value for `location`, length must be greater than or equal to `1`")

        self._location = location

    @property
    def zipcode(self):
        """Gets the zipcode of this EnterpriseV1.

        Zip code of enterprise location

        :return: The zipcode of this EnterpriseV1.
        :rtype: str
        """
        return self._zipcode

    @zipcode.setter
    def zipcode(self, zipcode):
        """Sets the zipcode of this EnterpriseV1.

        Zip code of enterprise location

        :param zipcode: The zipcode of this EnterpriseV1.
        :type: str
        """
        if zipcode is not None and len(zipcode) > 8:
            raise ValueError("Invalid value for `zipcode`, length must be less than or equal to `8`")
        if zipcode is not None and len(zipcode) < 1:
            raise ValueError("Invalid value for `zipcode`, length must be greater than or equal to `1`")

        self._zipcode = zipcode

    @property
    def contact_person(self):
        """Gets the contact_person of this EnterpriseV1.

        Person who is the point of contact for the enterprise

        :return: The contact_person of this EnterpriseV1.
        :rtype: str
        """
        return self._contact_person

    @contact_person.setter
    def contact_person(self, contact_person):
        """Sets the contact_person of this EnterpriseV1.

        Person who is the point of contact for the enterprise

        :param contact_person: The contact_person of this EnterpriseV1.
        :type: str
        """
        if contact_person is not None and len(contact_person) > 255:
            raise ValueError("Invalid value for `contact_person`, length must be less than or equal to `255`")
        if contact_person is not None and len(contact_person) < 1:
            raise ValueError("Invalid value for `contact_person`, length must be greater than or equal to `1`")

        self._contact_person = contact_person

    @property
    def contact_number(self):
        """Gets the contact_number of this EnterpriseV1.

        Contact number of the enterprise

        :return: The contact_number of this EnterpriseV1.
        :rtype: str
        """
        return self._contact_number

    @contact_number.setter
    def contact_number(self, contact_number):
        """Sets the contact_number of this EnterpriseV1.

        Contact number of the enterprise

        :param contact_number: The contact_number of this EnterpriseV1.
        :type: str
        """
        if contact_number is not None and len(contact_number) > 20:
            raise ValueError("Invalid value for `contact_number`, length must be less than or equal to `20`")
        if contact_number is not None and len(contact_number) < 1:
            raise ValueError("Invalid value for `contact_number`, length must be greater than or equal to `1`")

        self._contact_number = contact_number

    @property
    def contact_email(self):
        """Gets the contact_email of this EnterpriseV1.

        Contact email address of the enterprise

        :return: The contact_email of this EnterpriseV1.
        :rtype: str
        """
        return self._contact_email

    @contact_email.setter
    def contact_email(self, contact_email):
        """Sets the contact_email of this EnterpriseV1.

        Contact email address of the enterprise

        :param contact_email: The contact_email of this EnterpriseV1.
        :type: str
        """
        if contact_email is not None and len(contact_email) > 254:
            raise ValueError("Invalid value for `contact_email`, length must be less than or equal to `254`")
        if contact_email is not None and len(contact_email) < 1:
            raise ValueError("Invalid value for `contact_email`, length must be greater than or equal to `1`")

        self._contact_email = contact_email

    @property
    def emm(self):
        """Gets the emm of this EnterpriseV1.


        :return: The emm of this EnterpriseV1.
        :rtype: GoogleEMM
        """
        return self._emm

    @emm.setter
    def emm(self, emm):
        """Sets the emm of this EnterpriseV1.


        :param emm: The emm of this EnterpriseV1.
        :type: GoogleEMM
        """

        self._emm = emm

    @property
    def created_on(self):
        """Gets the created_on of this EnterpriseV1.

        Date and time of when this resource was created

        :return: The created_on of this EnterpriseV1.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this EnterpriseV1.

        Date and time of when this resource was created

        :param created_on: The created_on of this EnterpriseV1.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this EnterpriseV1.

        Date and time of when this resource was updated

        :return: The updated_on of this EnterpriseV1.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this EnterpriseV1.

        Date and time of when this resource was updated

        :param updated_on: The updated_on of this EnterpriseV1.
        :type: datetime
        """

        self._updated_on = updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnterpriseV1, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnterpriseV1):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
