# coding: utf-8

"""
Esper APIs

OpenAPI spec version: 1.0.0
Contact: developer@esper.io
---------------------------------------------------------

Copyright 2019 Shoonya Enterprises Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""



import pprint
import re

import six

from esperclient.models.app_permission import AppPermission


class AppVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'installed_count': 'int',
        'permissions': 'list[AppPermission]',
        'app_file': 'str',
        'app_icon': 'str',
        'version_code': 'str',
        'build_number': 'str',
        'size_in_mb': 'float',
        'hash_string': 'str',
        'release_name': 'str',
        'release_comments': 'str',
        'release_track': 'str',
        'created_on': 'datetime',
        'updated_on': 'datetime',
        'min_sdk_version': 'str',
        'target_sdk_version': 'str',
        'is_enabled': 'bool',
        'enterprise': 'str',
        'application': 'str'
    }

    attribute_map = {
        'id': 'id',
        'installed_count': 'installed_count',
        'permissions': 'permissions',
        'app_file': 'app_file',
        'app_icon': 'app_icon',
        'version_code': 'version_code',
        'build_number': 'build_number',
        'size_in_mb': 'size_in_mb',
        'hash_string': 'hash_string',
        'release_name': 'release_name',
        'release_comments': 'release_comments',
        'release_track': 'release_track',
        'created_on': 'created_on',
        'updated_on': 'updated_on',
        'min_sdk_version': 'min_sdk_version',
        'target_sdk_version': 'target_sdk_version',
        'is_enabled': 'is_enabled',
        'enterprise': 'enterprise',
        'application': 'application'
    }

    def __init__(self, id=None, installed_count=None, permissions=None, app_file=None, app_icon=None, version_code=None, build_number=None, size_in_mb=None, hash_string=None, release_name=None, release_comments=None, release_track=None, created_on=None, updated_on=None, min_sdk_version=None, target_sdk_version=None, is_enabled=None, enterprise=None, application=None):
        """AppVersion - a model defined in Swagger"""

        self._id = None
        self._installed_count = None
        self._permissions = None
        self._app_file = None
        self._app_icon = None
        self._version_code = None
        self._build_number = None
        self._size_in_mb = None
        self._hash_string = None
        self._release_name = None
        self._release_comments = None
        self._release_track = None
        self._created_on = None
        self._updated_on = None
        self._min_sdk_version = None
        self._target_sdk_version = None
        self._is_enabled = None
        self._enterprise = None
        self._application = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if installed_count is not None:
            self.installed_count = installed_count
        self.permissions = permissions
        if app_file is not None:
            self.app_file = app_file
        if app_icon is not None:
            self.app_icon = app_icon
        self.version_code = version_code
        if build_number is not None:
            self.build_number = build_number
        if size_in_mb is not None:
            self.size_in_mb = size_in_mb
        if hash_string is not None:
            self.hash_string = hash_string
        if release_name is not None:
            self.release_name = release_name
        if release_comments is not None:
            self.release_comments = release_comments
        if release_track is not None:
            self.release_track = release_track
        if created_on is not None:
            self.created_on = created_on
        if updated_on is not None:
            self.updated_on = updated_on
        if min_sdk_version is not None:
            self.min_sdk_version = min_sdk_version
        if target_sdk_version is not None:
            self.target_sdk_version = target_sdk_version
        if is_enabled is not None:
            self.is_enabled = is_enabled
        self.enterprise = enterprise
        if application is not None:
            self.application = application

    @property
    def id(self):
        """Gets the id of this AppVersion.


        :return: The id of this AppVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AppVersion.


        :param id: The id of this AppVersion.
        :type: str
        """

        self._id = id

    @property
    def installed_count(self):
        """Gets the installed_count of this AppVersion.


        :return: The installed_count of this AppVersion.
        :rtype: int
        """
        return self._installed_count

    @installed_count.setter
    def installed_count(self, installed_count):
        """Sets the installed_count of this AppVersion.


        :param installed_count: The installed_count of this AppVersion.
        :type: int
        """

        self._installed_count = installed_count

    @property
    def permissions(self):
        """Gets the permissions of this AppVersion.


        :return: The permissions of this AppVersion.
        :rtype: list[AppPermission]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this AppVersion.


        :param permissions: The permissions of this AppVersion.
        :type: list[AppPermission]
        """
        if permissions is None:
            raise ValueError("Invalid value for `permissions`, must not be `None`")

        self._permissions = permissions

    @property
    def app_file(self):
        """Gets the app_file of this AppVersion.


        :return: The app_file of this AppVersion.
        :rtype: str
        """
        return self._app_file

    @app_file.setter
    def app_file(self, app_file):
        """Sets the app_file of this AppVersion.


        :param app_file: The app_file of this AppVersion.
        :type: str
        """

        self._app_file = app_file

    @property
    def app_icon(self):
        """Gets the app_icon of this AppVersion.


        :return: The app_icon of this AppVersion.
        :rtype: str
        """
        return self._app_icon

    @app_icon.setter
    def app_icon(self, app_icon):
        """Sets the app_icon of this AppVersion.


        :param app_icon: The app_icon of this AppVersion.
        :type: str
        """

        self._app_icon = app_icon

    @property
    def version_code(self):
        """Gets the version_code of this AppVersion.


        :return: The version_code of this AppVersion.
        :rtype: str
        """
        return self._version_code

    @version_code.setter
    def version_code(self, version_code):
        """Sets the version_code of this AppVersion.


        :param version_code: The version_code of this AppVersion.
        :type: str
        """
        if version_code is None:
            raise ValueError("Invalid value for `version_code`, must not be `None`")
        if version_code is not None and len(version_code) > 50:
            raise ValueError("Invalid value for `version_code`, length must be less than or equal to `50`")
        if version_code is not None and len(version_code) < 1:
            raise ValueError("Invalid value for `version_code`, length must be greater than or equal to `1`")

        self._version_code = version_code

    @property
    def build_number(self):
        """Gets the build_number of this AppVersion.


        :return: The build_number of this AppVersion.
        :rtype: str
        """
        return self._build_number

    @build_number.setter
    def build_number(self, build_number):
        """Sets the build_number of this AppVersion.


        :param build_number: The build_number of this AppVersion.
        :type: str
        """
        if build_number is not None and len(build_number) > 100:
            raise ValueError("Invalid value for `build_number`, length must be less than or equal to `100`")
        if build_number is not None and len(build_number) < 1:
            raise ValueError("Invalid value for `build_number`, length must be greater than or equal to `1`")

        self._build_number = build_number

    @property
    def size_in_mb(self):
        """Gets the size_in_mb of this AppVersion.


        :return: The size_in_mb of this AppVersion.
        :rtype: float
        """
        return self._size_in_mb

    @size_in_mb.setter
    def size_in_mb(self, size_in_mb):
        """Sets the size_in_mb of this AppVersion.


        :param size_in_mb: The size_in_mb of this AppVersion.
        :type: float
        """

        self._size_in_mb = size_in_mb

    @property
    def hash_string(self):
        """Gets the hash_string of this AppVersion.


        :return: The hash_string of this AppVersion.
        :rtype: str
        """
        return self._hash_string

    @hash_string.setter
    def hash_string(self, hash_string):
        """Sets the hash_string of this AppVersion.


        :param hash_string: The hash_string of this AppVersion.
        :type: str
        """

        self._hash_string = hash_string

    @property
    def release_name(self):
        """Gets the release_name of this AppVersion.


        :return: The release_name of this AppVersion.
        :rtype: str
        """
        return self._release_name

    @release_name.setter
    def release_name(self, release_name):
        """Sets the release_name of this AppVersion.


        :param release_name: The release_name of this AppVersion.
        :type: str
        """
        if release_name is not None and len(release_name) > 255:
            raise ValueError("Invalid value for `release_name`, length must be less than or equal to `255`")
        if release_name is not None and len(release_name) < 1:
            raise ValueError("Invalid value for `release_name`, length must be greater than or equal to `1`")

        self._release_name = release_name

    @property
    def release_comments(self):
        """Gets the release_comments of this AppVersion.


        :return: The release_comments of this AppVersion.
        :rtype: str
        """
        return self._release_comments

    @release_comments.setter
    def release_comments(self, release_comments):
        """Sets the release_comments of this AppVersion.


        :param release_comments: The release_comments of this AppVersion.
        :type: str
        """
        if release_comments is not None and len(release_comments) < 1:
            raise ValueError("Invalid value for `release_comments`, length must be greater than or equal to `1`")

        self._release_comments = release_comments

    @property
    def release_track(self):
        """Gets the release_track of this AppVersion.


        :return: The release_track of this AppVersion.
        :rtype: str
        """
        return self._release_track

    @release_track.setter
    def release_track(self, release_track):
        """Sets the release_track of this AppVersion.


        :param release_track: The release_track of this AppVersion.
        :type: str
        """
        allowed_values = ["Alpha", "Beta", "Production"]
        if release_track not in allowed_values:
            raise ValueError(
                "Invalid value for `release_track` ({0}), must be one of {1}"
                .format(release_track, allowed_values)
            )

        self._release_track = release_track

    @property
    def created_on(self):
        """Gets the created_on of this AppVersion.


        :return: The created_on of this AppVersion.
        :rtype: datetime
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this AppVersion.


        :param created_on: The created_on of this AppVersion.
        :type: datetime
        """

        self._created_on = created_on

    @property
    def updated_on(self):
        """Gets the updated_on of this AppVersion.


        :return: The updated_on of this AppVersion.
        :rtype: datetime
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this AppVersion.


        :param updated_on: The updated_on of this AppVersion.
        :type: datetime
        """

        self._updated_on = updated_on

    @property
    def min_sdk_version(self):
        """Gets the min_sdk_version of this AppVersion.


        :return: The min_sdk_version of this AppVersion.
        :rtype: str
        """
        return self._min_sdk_version

    @min_sdk_version.setter
    def min_sdk_version(self, min_sdk_version):
        """Sets the min_sdk_version of this AppVersion.


        :param min_sdk_version: The min_sdk_version of this AppVersion.
        :type: str
        """
        if min_sdk_version is not None and len(min_sdk_version) > 10:
            raise ValueError("Invalid value for `min_sdk_version`, length must be less than or equal to `10`")
        if min_sdk_version is not None and len(min_sdk_version) < 1:
            raise ValueError("Invalid value for `min_sdk_version`, length must be greater than or equal to `1`")

        self._min_sdk_version = min_sdk_version

    @property
    def target_sdk_version(self):
        """Gets the target_sdk_version of this AppVersion.


        :return: The target_sdk_version of this AppVersion.
        :rtype: str
        """
        return self._target_sdk_version

    @target_sdk_version.setter
    def target_sdk_version(self, target_sdk_version):
        """Sets the target_sdk_version of this AppVersion.


        :param target_sdk_version: The target_sdk_version of this AppVersion.
        :type: str
        """
        if target_sdk_version is not None and len(target_sdk_version) > 10:
            raise ValueError("Invalid value for `target_sdk_version`, length must be less than or equal to `10`")
        if target_sdk_version is not None and len(target_sdk_version) < 1:
            raise ValueError("Invalid value for `target_sdk_version`, length must be greater than or equal to `1`")

        self._target_sdk_version = target_sdk_version

    @property
    def is_enabled(self):
        """Gets the is_enabled of this AppVersion.


        :return: The is_enabled of this AppVersion.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """Sets the is_enabled of this AppVersion.


        :param is_enabled: The is_enabled of this AppVersion.
        :type: bool
        """

        self._is_enabled = is_enabled

    @property
    def enterprise(self):
        """Gets the enterprise of this AppVersion.


        :return: The enterprise of this AppVersion.
        :rtype: str
        """
        return self._enterprise

    @enterprise.setter
    def enterprise(self, enterprise):
        """Sets the enterprise of this AppVersion.


        :param enterprise: The enterprise of this AppVersion.
        :type: str
        """
        if enterprise is None:
            raise ValueError("Invalid value for `enterprise`, must not be `None`")

        self._enterprise = enterprise

    @property
    def application(self):
        """Gets the application of this AppVersion.


        :return: The application of this AppVersion.
        :rtype: str
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this AppVersion.


        :param application: The application of this AppVersion.
        :type: str
        """

        self._application = application

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AppVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
