# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class MarkersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_marker(self, **kwargs):  # noqa: E501
        """Creates a new Marker for an asset  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_marker(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MarkerCreateRequest body: Request containing marker information
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_marker_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_marker_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_marker_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a new Marker for an asset  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_marker_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MarkerCreateRequest body: Request containing marker information
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_marker" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Markers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarkerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_marker(self, marker_id, **kwargs):  # noqa: E501
        """Deletes the specified Marker  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_marker(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: Id of the marker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
            return data

    def delete_marker_with_http_info(self, marker_id, **kwargs):  # noqa: E501
        """Deletes the specified Marker  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_marker_with_http_info(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: Id of the marker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['marker_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_marker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'marker_id' is set
        if ('marker_id' not in params or
                params['marker_id'] is None):
            raise ValueError("Missing the required parameter `marker_id` when calling `delete_marker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'marker_id' in params:
            path_params['markerId'] = params['marker_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Markers/{markerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_marker(self, marker_id, **kwargs):  # noqa: E501
        """Gets the specified marker  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_marker(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `MarkerType` | MarkerType | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` | | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String | | `Order` | Int32 | | `Value` | Double |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: None.
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
            return data

    def get_marker_with_http_info(self, marker_id, **kwargs):  # noqa: E501
        """Gets the specified marker  # noqa: E501

        Required Permissions: User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_marker_with_http_info(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: (required)
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `MarkerType` | MarkerType | `eq, neq, in` | | `Name` | String | `eq, neq, like, in` | | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String | | `Order` | Int32 | | `Value` | Double |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: None.
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['marker_id', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_marker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'marker_id' is set
        if ('marker_id' not in params or
                params['marker_id'] is None):
            raise ValueError("Missing the required parameter `marker_id` when calling `get_marker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'marker_id' in params:
            path_params['markerId'] = params['marker_id']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Markers/{markerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarkerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_marker(self, marker_id, **kwargs):  # noqa: E501
        """Updates the specified Marker  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_marker(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: Id of the marker (required)
        :param MarkerUpdateRequest body: Request containing marker information
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_marker_with_http_info(marker_id, **kwargs)  # noqa: E501
            return data

    def update_marker_with_http_info(self, marker_id, **kwargs):  # noqa: E501
        """Updates the specified Marker  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_marker_with_http_info(marker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marker_id: Id of the marker (required)
        :param MarkerUpdateRequest body: Request containing marker information
        :return: MarkerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['marker_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_marker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'marker_id' is set
        if ('marker_id' not in params or
                params['marker_id'] is None):
            raise ValueError("Missing the required parameter `marker_id` when calling `update_marker`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'marker_id' in params:
            path_params['markerId'] = params['marker_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Markers/{markerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarkerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
