from typing import Any, Dict, Union

import httpx

from ...client import AuthenticatedClient
from ...types import UNSET, Response, Unset


def _get_kwargs(
    id: int,
    message_id: int,
    *,
    client: AuthenticatedClient,
    unrendered_fields: Union[Unset, None, bool] = UNSET,
) -> Dict[str, Any]:
    url = "{}/convo/{id}/messages/{message_id}".format(client.base_url, id=id, message_id=message_id)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    params: Dict[str, Any] = {}
    params["unrenderedFields"] = unrendered_fields

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _build_response(*, response: httpx.Response) -> Response[Any]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=None,
    )


def sync_detailed(
    id: int,
    message_id: int,
    *,
    client: AuthenticatedClient,
    unrendered_fields: Union[Unset, None, bool] = UNSET,
) -> Response[Any]:
    """get a specific convo message

    Args:
        id (int):
        message_id (int):
        unrendered_fields (Union[Unset, None, bool]):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        id=id,
        message_id=message_id,
        client=client,
        unrendered_fields=unrendered_fields,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


async def asyncio_detailed(
    id: int,
    message_id: int,
    *,
    client: AuthenticatedClient,
    unrendered_fields: Union[Unset, None, bool] = UNSET,
) -> Response[Any]:
    """get a specific convo message

    Args:
        id (int):
        message_id (int):
        unrendered_fields (Union[Unset, None, bool]):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        id=id,
        message_id=message_id,
        client=client,
        unrendered_fields=unrendered_fields,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(response=response)
