# MERCS

MERCS stands for **multi-directional ensembles of classification and regression trees**. It is a novel ML-paradigm under active development at the [DTAI-lab at KU Leuven](https://dtai.cs.kuleuven.be/).

## Installation

Easy via pip:

```
pip install mercs-mixed
```

Dask is a required dependency that needs to be installed separately:
```
python -m pip install "dask[delayed]"
```

## Website

Cf. [https://systemallica.github.io/mercs/](https://systemallica.github.io/mercs/)

## Tutorials

Cf. the quickstart section of the website, [https://systemallica.github.io/mercs/quickstart](https://systemallica.github.io/mercs/quickstart).

## Code

MERCS is fully open-source cf. our [github-repository](https://github.com/systemallica/mercs/)

## Publications

MERCS is an active research project, hence we periodically publish our findings;

### MERCS: Multi-Directional Ensembles of Regression and Classification Trees

**Abstract**
*Learning a function f(X) that predicts Y from X is the archetypal Machine Learning (ML) problem. Typically, both sets of attributes (i.e., X,Y) have to be known before a model can be trained. When this is not the case, or when functions f(X) that predict Y from X are needed for varying X and Y, this may introduce significant overhead (separate learning runs for each function). In this paper, we explore the possibility of omitting the specification of X and Y at training time altogether, by learning a multi-directional, or versatile model, which will allow prediction of any Y from any X. Specifically, we introduce a decision tree-based paradigm that generalizes the well-known Random Forests approach to allow for multi-directionality. The result of these efforts is a novel method called MERCS: Multi-directional Ensembles of Regression and Classification treeS. Experiments show the viability of the approach.*

**Authors**
Elia Van Wolputte, Evgeniya Korneva, Hendrik Blockeel

**Open Access**
A pdf version can be found at [AAAI-publications](https://www.aaai.org/ocs/index.php/AAAI/AAAI18/paper/viewFile/16875/16735)

## People

People involved in this project:

* [Elia Van Wolputte](https://eliavw.github.io/)
* Evgeniya Korneva
* [Prof. Hendrik Blockeel](https://people.cs.kuleuven.be/~hendrik.blockeel/)
* [Andrés Reverón Molina](https://andres.reveronmolina.me)
