"""
    Apicurio Registry API [v2]

    Apicurio Registry is a datastore for standard event schemas and API designs. Apicurio Registry enables developers to manage and share the structure of their data using a REST interface. For example, client applications can dynamically push or pull the latest updates to or from the registry without needing to redeploy. Apicurio Registry also enables developers to create rules that govern how registry content can evolve over time. For example, this includes rules for content validation and version compatibility.  The Apicurio Registry REST API enables client applications to manage the artifacts in the registry. This API provides create, read, update, and delete operations for schema and API artifacts, rules, versions, and metadata.   The supported artifact types include: - Apache Avro schema - AsyncAPI specification - Google protocol buffers - GraphQL schema - JSON Schema - Kafka Connect schema - OpenAPI specification - Web Services Description Language - XML Schema Definition   **Important**: The Apicurio Registry REST API is available from `https://MY-REGISTRY-URL/apis/registry/v2` by default. Therefore you must prefix all API operation paths with `../apis/registry/v2` in this case. For example: `../apis/registry/v2/ids/globalIds/{globalId}`.   # noqa: E501

    The version of the OpenAPI document: 2.2.3-SNAPSHOT
    Contact: apicurio@lists.jboss.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apicurioregistryclient.api_client import ApiClient, Endpoint as _Endpoint
from apicurioregistryclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from apicurioregistryclient.model.artifact_meta_data import ArtifactMetaData
from apicurioregistryclient.model.artifact_reference import ArtifactReference
from apicurioregistryclient.model.artifact_search_results import ArtifactSearchResults
from apicurioregistryclient.model.artifact_type import ArtifactType
from apicurioregistryclient.model.content_create_request import ContentCreateRequest
from apicurioregistryclient.model.error import Error
from apicurioregistryclient.model.if_exists import IfExists
from apicurioregistryclient.model.rule_violation_error import RuleViolationError
from apicurioregistryclient.model.sort_by import SortBy
from apicurioregistryclient.model.sort_order import SortOrder
from apicurioregistryclient.model.update_state import UpdateState


class ArtifactsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_artifact_endpoint = _Endpoint(
            settings={
                'response_type': (ArtifactMetaData,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts',
                'operation_id': 'create_artifact',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'body',
                    'x_registry_artifact_type',
                    'x_registry_artifact_id',
                    'x_registry_version',
                    'if_exists',
                    'canonical',
                    'x_registry_description',
                    'x_registry_description_encoded',
                    'x_registry_name',
                    'x_registry_name_encoded',
                ],
                'required': [
                    'group_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'body':
                        (file_type,),
                    'x_registry_artifact_type':
                        (ArtifactType,),
                    'x_registry_artifact_id':
                        (str,),
                    'x_registry_version':
                        (str,),
                    'if_exists':
                        (IfExists,),
                    'canonical':
                        (bool,),
                    'x_registry_description':
                        (str,),
                    'x_registry_description_encoded':
                        (str,),
                    'x_registry_name':
                        (str,),
                    'x_registry_name_encoded':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'x_registry_artifact_type': 'X-Registry-ArtifactType',
                    'x_registry_artifact_id': 'X-Registry-ArtifactId',
                    'x_registry_version': 'X-Registry-Version',
                    'if_exists': 'ifExists',
                    'canonical': 'canonical',
                    'x_registry_description': 'X-Registry-Description',
                    'x_registry_description_encoded': 'X-Registry-Description-Encoded',
                    'x_registry_name': 'X-Registry-Name',
                    'x_registry_name_encoded': 'X-Registry-Name-Encoded',
                },
                'location_map': {
                    'group_id': 'path',
                    'body': 'body',
                    'x_registry_artifact_type': 'header',
                    'x_registry_artifact_id': 'header',
                    'x_registry_version': 'header',
                    'if_exists': 'query',
                    'canonical': 'query',
                    'x_registry_description': 'header',
                    'x_registry_description_encoded': 'header',
                    'x_registry_name': 'header',
                    'x_registry_name_encoded': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/create.extended+json'
                ]
            },
            api_client=api_client
        )
        self.delete_artifact_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}',
                'operation_id': 'delete_artifact',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_artifacts_in_group_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts',
                'operation_id': 'delete_artifacts_in_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                ],
                'required': [
                    'group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                },
                'location_map': {
                    'group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_content_by_global_id_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [],
                'endpoint_path': '/ids/globalIds/{globalId}',
                'operation_id': 'get_content_by_global_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'global_id',
                    'dereference',
                ],
                'required': [
                    'global_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'global_id':
                        (int,),
                    'dereference':
                        (bool,),
                },
                'attribute_map': {
                    'global_id': 'globalId',
                    'dereference': 'dereference',
                },
                'location_map': {
                    'global_id': 'path',
                    'dereference': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_content_by_hash_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [],
                'endpoint_path': '/ids/contentHashes/{contentHash}/',
                'operation_id': 'get_content_by_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'content_hash',
                ],
                'required': [
                    'content_hash',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'content_hash':
                        (str,),
                },
                'attribute_map': {
                    'content_hash': 'contentHash',
                },
                'location_map': {
                    'content_hash': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_content_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [],
                'endpoint_path': '/ids/contentIds/{contentId}/',
                'operation_id': 'get_content_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'content_id',
                ],
                'required': [
                    'content_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'content_id':
                        (int,),
                },
                'attribute_map': {
                    'content_id': 'contentId',
                },
                'location_map': {
                    'content_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_latest_artifact_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}',
                'operation_id': 'get_latest_artifact',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'dereference',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'dereference':
                        (bool,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                    'dereference': 'dereference',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'dereference': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_artifacts_in_group_endpoint = _Endpoint(
            settings={
                'response_type': (ArtifactSearchResults,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts',
                'operation_id': 'list_artifacts_in_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'limit',
                    'offset',
                    'order',
                    'orderby',
                ],
                'required': [
                    'group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'order':
                        (SortOrder,),
                    'orderby':
                        (SortBy,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'limit': 'limit',
                    'offset': 'offset',
                    'order': 'order',
                    'orderby': 'orderby',
                },
                'location_map': {
                    'group_id': 'path',
                    'limit': 'query',
                    'offset': 'query',
                    'order': 'query',
                    'orderby': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.references_by_content_hash_endpoint = _Endpoint(
            settings={
                'response_type': ([ArtifactReference],),
                'auth': [],
                'endpoint_path': '/ids/contentHashes/{contentHash}/references',
                'operation_id': 'references_by_content_hash',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'required': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'UNKNOWN_PARAMETER_NAME':
                        (,),
                },
                'attribute_map': {
                    'UNKNOWN_PARAMETER_NAME': 'contentHash',
                },
                'location_map': {
                    'UNKNOWN_PARAMETER_NAME': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.references_by_content_id_endpoint = _Endpoint(
            settings={
                'response_type': ([ArtifactReference],),
                'auth': [],
                'endpoint_path': '/ids/contentIds/{contentId}/references',
                'operation_id': 'references_by_content_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'required': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'UNKNOWN_PARAMETER_NAME':
                        (,),
                },
                'attribute_map': {
                    'UNKNOWN_PARAMETER_NAME': 'contentId',
                },
                'location_map': {
                    'UNKNOWN_PARAMETER_NAME': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.references_by_global_id_endpoint = _Endpoint(
            settings={
                'response_type': ([ArtifactReference],),
                'auth': [],
                'endpoint_path': '/ids/globalIds/{globalId}/references',
                'operation_id': 'references_by_global_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'required': [
                    'UNKNOWN_PARAMETER_NAME',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'UNKNOWN_PARAMETER_NAME':
                        (,),
                },
                'attribute_map': {
                    'UNKNOWN_PARAMETER_NAME': 'globalId',
                },
                'location_map': {
                    'UNKNOWN_PARAMETER_NAME': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_artifacts_endpoint = _Endpoint(
            settings={
                'response_type': (ArtifactSearchResults,),
                'auth': [],
                'endpoint_path': '/search/artifacts',
                'operation_id': 'search_artifacts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'offset',
                    'limit',
                    'order',
                    'orderby',
                    'labels',
                    'properties',
                    'description',
                    'group',
                    'global_id',
                    'content_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'order':
                        (SortOrder,),
                    'orderby':
                        (SortBy,),
                    'labels':
                        ([str],),
                    'properties':
                        ([str],),
                    'description':
                        (str,),
                    'group':
                        (str,),
                    'global_id':
                        (int,),
                    'content_id':
                        (int,),
                },
                'attribute_map': {
                    'name': 'name',
                    'offset': 'offset',
                    'limit': 'limit',
                    'order': 'order',
                    'orderby': 'orderby',
                    'labels': 'labels',
                    'properties': 'properties',
                    'description': 'description',
                    'group': 'group',
                    'global_id': 'globalId',
                    'content_id': 'contentId',
                },
                'location_map': {
                    'name': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'order': 'query',
                    'orderby': 'query',
                    'labels': 'query',
                    'properties': 'query',
                    'description': 'query',
                    'group': 'query',
                    'global_id': 'query',
                    'content_id': 'query',
                },
                'collection_format_map': {
                    'labels': 'multi',
                    'properties': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.search_artifacts_by_content_endpoint = _Endpoint(
            settings={
                'response_type': (ArtifactSearchResults,),
                'auth': [],
                'endpoint_path': '/search/artifacts',
                'operation_id': 'search_artifacts_by_content',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                    'canonical',
                    'artifact_type',
                    'offset',
                    'limit',
                    'order',
                    'orderby',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                    'order',
                    'orderby',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                    ('orderby',): {

                        "NAME": "name",
                        "CREATEDON": "createdOn"
                    },
                },
                'openapi_types': {
                    'body':
                        (file_type,),
                    'canonical':
                        (bool,),
                    'artifact_type':
                        (ArtifactType,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'order':
                        (str,),
                    'orderby':
                        (str,),
                },
                'attribute_map': {
                    'canonical': 'canonical',
                    'artifact_type': 'artifactType',
                    'offset': 'offset',
                    'limit': 'limit',
                    'order': 'order',
                    'orderby': 'orderby',
                },
                'location_map': {
                    'body': 'body',
                    'canonical': 'query',
                    'artifact_type': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'order': 'query',
                    'orderby': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_artifact_endpoint = _Endpoint(
            settings={
                'response_type': (ArtifactMetaData,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}',
                'operation_id': 'update_artifact',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'body',
                    'x_registry_version',
                    'x_registry_name',
                    'x_registry_name_encoded',
                    'x_registry_description',
                    'x_registry_description_encoded',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'body':
                        (file_type,),
                    'x_registry_version':
                        (str,),
                    'x_registry_name':
                        (str,),
                    'x_registry_name_encoded':
                        (str,),
                    'x_registry_description':
                        (str,),
                    'x_registry_description_encoded':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                    'x_registry_version': 'X-Registry-Version',
                    'x_registry_name': 'X-Registry-Name',
                    'x_registry_name_encoded': 'X-Registry-Name-Encoded',
                    'x_registry_description': 'X-Registry-Description',
                    'x_registry_description_encoded': 'X-Registry-Description-Encoded',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'body': 'body',
                    'x_registry_version': 'header',
                    'x_registry_name': 'header',
                    'x_registry_name_encoded': 'header',
                    'x_registry_description': 'header',
                    'x_registry_description_encoded': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/create.extended+json'
                ]
            },
            api_client=api_client
        )
        self.update_artifact_state_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/state',
                'operation_id': 'update_artifact_state',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'update_state',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'update_state',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'update_state':
                        (UpdateState,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'update_state': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_artifact(
        self,
        group_id,
        body,
        **kwargs
    ):
        """Create artifact  # noqa: E501

        Creates a new artifact by posting the artifact content.  The body of the request should be the raw content of the artifact.  This is typically in JSON format for *most* of the  supported types, but may be in another format for a few (for example, `PROTOBUF`).  The registry attempts to figure out what kind of artifact is being added from the following supported list:  * Avro (`AVRO`) * Protobuf (`PROTOBUF`) * JSON Schema (`JSON`) * Kafka Connect (`KCONNECT`) * OpenAPI (`OPENAPI`) * AsyncAPI (`ASYNCAPI`) * GraphQL (`GRAPHQL`) * Web Services Description Language (`WSDL`) * XML Schema (`XSD`)  Alternatively, you can specify the artifact type using the `X-Registry-ArtifactType`  HTTP request header, or include a hint in the request's `Content-Type`.  For example:  ``` Content-Type: application/json; artifactType=AVRO ```  An artifact is created using the content provided in the body of the request.  This content is created under a unique artifact ID that can be provided in the request using the `X-Registry-ArtifactId` request header.  If not provided in the request, the server generates a unique ID for the artifact.  It is typically recommended that callers provide the ID, because this is typically a meaningful identifier,  and for most use cases should be supplied by the caller.  If an artifact with the provided artifact ID already exists, the default behavior is for the server to reject the content with a 409 error.  However, the caller can supply the `ifExists` query parameter to alter this default behavior. The `ifExists` query parameter can have one of the following values:  * `FAIL` (*default*) - server rejects the content with a 409 error * `UPDATE` - server updates the existing artifact and returns the new metadata * `RETURN` - server does not create or add content to the server, but instead  returns the metadata for the existing artifact * `RETURN_OR_UPDATE` - server returns an existing **version** that matches the  provided content if such a version exists, otherwise a new version is created  This operation may fail for one of the following reasons:  * An invalid `ArtifactType` was indicated (HTTP error `400`) * No `ArtifactType` was indicated and the server could not determine one from the content (HTTP error `400`) * Provided content (request body) was empty (HTTP error `400`) * An artifact with the provided ID already exists (HTTP error `409`) * The content violates one of the configured global rules (HTTP error `409`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_artifact(group_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): Unique ID of an artifact group.
            body (file_type): The content of the artifact being created. This is often, but not always, JSON data representing one of the supported artifact types:  * Avro (`AVRO`) * Protobuf (`PROTOBUF`) * JSON Schema (`JSON`) * Kafka Connect (`KCONNECT`) * OpenAPI (`OPENAPI`) * AsyncAPI (`ASYNCAPI`) * GraphQL (`GRAPHQL`) * Web Services Description Language (`WSDL`) * XML Schema (`XSD`) 

        Keyword Args:
            x_registry_artifact_type (ArtifactType): Specifies the type of the artifact being added. Possible values include:  * Avro (`AVRO`) * Protobuf (`PROTOBUF`) * JSON Schema (`JSON`) * Kafka Connect (`KCONNECT`) * OpenAPI (`OPENAPI`) * AsyncAPI (`ASYNCAPI`) * GraphQL (`GRAPHQL`) * Web Services Description Language (`WSDL`) * XML Schema (`XSD`). [optional]
            x_registry_artifact_id (str): A client-provided, globally unique identifier for the new artifact.. [optional]
            x_registry_version (str): Specifies the version number of this initial version of the artifact content.  This would typically be a simple integer or a SemVer value.  If not provided, the server will assign a version number automatically (starting with version `1`).. [optional]
            if_exists (IfExists): Set this option to instruct the server on what to do if the artifact already exists.. [optional]
            canonical (bool): Used only when the `ifExists` query parameter is set to `RETURN_OR_UPDATE`, this parameter can be set to `true` to indicate that the server should \"canonicalize\" the content when searching for a matching version.  The canonicalization algorithm is unique to each artifact type, but typically involves removing extra whitespace and formatting the content in a consistent manner.. [optional]
            x_registry_description (str): Specifies the description of artifact being added. Description must be ASCII-only string. If this is not provided, the server will extract the description from the artifact content.. [optional]
            x_registry_description_encoded (str): Specifies the description of artifact being added. Value of this must be Base64 encoded string. If this is not provided, the server will extract the description from the artifact content.. [optional]
            x_registry_name (str): Specifies the name of artifact being added. Name must be ASCII-only string. If this is not provided, the server will extract the name from the artifact content.. [optional]
            x_registry_name_encoded (str): Specifies the name of artifact being added. Value of this must be Base64 encoded string. If this is not provided, the server will extract the name from the artifact content.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ArtifactMetaData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['body'] = \
            body
        return self.create_artifact_endpoint.call_with_http_info(**kwargs)

    def delete_artifact(
        self,
        group_id,
        artifact_id,
        **kwargs
    ):
        """Delete artifact  # noqa: E501

        Deletes an artifact completely, resulting in all versions of the artifact also being deleted.  This may fail for one of the following reasons:  * No artifact with the `artifactId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_artifact(group_id, artifact_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        return self.delete_artifact_endpoint.call_with_http_info(**kwargs)

    def delete_artifacts_in_group(
        self,
        group_id,
        **kwargs
    ):
        """Deletes all artifacts in a group  # noqa: E501

        Deletes all of the artifacts that exist in a given group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_artifacts_in_group(group_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): Unique ID of an artifact group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        return self.delete_artifacts_in_group_endpoint.call_with_http_info(**kwargs)

    def get_content_by_global_id(
        self,
        global_id,
        **kwargs
    ):
        """Get artifact by global ID  # noqa: E501

        Gets the content for an artifact version in the registry using its globally unique identifier.  This operation may fail for one of the following reasons:  * No artifact version with this `globalId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_content_by_global_id(global_id, async_req=True)
        >>> result = thread.get()

        Args:
            global_id (int): Global identifier for an artifact version.

        Keyword Args:
            dereference (bool): Allows the user to specify if the content should be dereferenced when being returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['global_id'] = \
            global_id
        return self.get_content_by_global_id_endpoint.call_with_http_info(**kwargs)

    def get_content_by_hash(
        self,
        content_hash,
        **kwargs
    ):
        """Get artifact content by SHA-256 hash  # noqa: E501

        Gets the content for an artifact version in the registry using the  SHA-256 hash of the content.  This content hash may be shared by multiple artifact versions in the case where the artifact versions have identical content.  This operation may fail for one of the following reasons:  * No content with this `contentHash` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_content_by_hash(content_hash, async_req=True)
        >>> result = thread.get()

        Args:
            content_hash (str): SHA-256 content hash for a single artifact content.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['content_hash'] = \
            content_hash
        return self.get_content_by_hash_endpoint.call_with_http_info(**kwargs)

    def get_content_by_id(
        self,
        content_id,
        **kwargs
    ):
        """Get artifact content by ID  # noqa: E501

        Gets the content for an artifact version in the registry using the unique content identifier for that content.  This content ID may be shared by multiple artifact versions in the case where the artifact versions are identical.  This operation may fail for one of the following reasons:  * No content with this `contentId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_content_by_id(content_id, async_req=True)
        >>> result = thread.get()

        Args:
            content_id (int): Global identifier for a single artifact content.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['content_id'] = \
            content_id
        return self.get_content_by_id_endpoint.call_with_http_info(**kwargs)

    def get_latest_artifact(
        self,
        group_id,
        artifact_id,
        **kwargs
    ):
        """Get latest artifact  # noqa: E501

        Returns the latest version of the artifact in its raw form.  The `Content-Type` of the response depends on the artifact type.  In most cases, this is `application/json`, but  for some types it may be different (for example, `PROTOBUF`).  This operation may fail for one of the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_artifact(group_id, artifact_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.

        Keyword Args:
            dereference (bool): Allows the user to specify if the content should be dereferenced when being returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        return self.get_latest_artifact_endpoint.call_with_http_info(**kwargs)

    def list_artifacts_in_group(
        self,
        group_id,
        **kwargs
    ):
        """List artifacts in group  # noqa: E501

        Returns a list of all artifacts in the group.  This list is paged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_artifacts_in_group(group_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): Unique ID of an artifact group.

        Keyword Args:
            limit (int): The number of artifacts to return.  Defaults to 20.. [optional]
            offset (int): The number of artifacts to skip before starting the result set.  Defaults to 0.. [optional]
            order (SortOrder): Sort order, ascending (`asc`) or descending (`desc`).. [optional]
            orderby (SortBy): The field to sort by.  Can be one of:  * `name` * `createdOn` . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ArtifactSearchResults
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        return self.list_artifacts_in_group_endpoint.call_with_http_info(**kwargs)

    def references_by_content_hash(
        self,
        UNKNOWN_PARAMETER_NAME,
        **kwargs
    ):
        """Returns a list with all the references for the artifact with the given hash  # noqa: E501

        Returns a list containing all the artifact references using the artifact content hash.  This operation may fail for one of the following reasons:  * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.references_by_content_hash(UNKNOWN_PARAMETER_NAME, async_req=True)
        >>> result = thread.get()

        Args:
            UNKNOWN_PARAMETER_NAME ():

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ArtifactReference]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['UNKNOWN_PARAMETER_NAME'] = \
            UNKNOWN_PARAMETER_NAME
        return self.references_by_content_hash_endpoint.call_with_http_info(**kwargs)

    def references_by_content_id(
        self,
        UNKNOWN_PARAMETER_NAME,
        **kwargs
    ):
        """Returns a list with all the references for the artifact with the given content id.  # noqa: E501

        Returns a list containing all the artifact references using the artifact contentId.  This operation may fail for one of the following reasons:  * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.references_by_content_id(UNKNOWN_PARAMETER_NAME, async_req=True)
        >>> result = thread.get()

        Args:
            UNKNOWN_PARAMETER_NAME ():

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ArtifactReference]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['UNKNOWN_PARAMETER_NAME'] = \
            UNKNOWN_PARAMETER_NAME
        return self.references_by_content_id_endpoint.call_with_http_info(**kwargs)

    def references_by_global_id(
        self,
        UNKNOWN_PARAMETER_NAME,
        **kwargs
    ):
        """Returns a list with all the references for the artifact with the given global id.  # noqa: E501

        Returns a list containing all the artifact references using the artifact global id.  This operation may fail for one of the following reasons:  * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.references_by_global_id(UNKNOWN_PARAMETER_NAME, async_req=True)
        >>> result = thread.get()

        Args:
            UNKNOWN_PARAMETER_NAME ():

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ArtifactReference]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['UNKNOWN_PARAMETER_NAME'] = \
            UNKNOWN_PARAMETER_NAME
        return self.references_by_global_id_endpoint.call_with_http_info(**kwargs)

    def search_artifacts(
        self,
        **kwargs
    ):
        """Search for artifacts  # noqa: E501

        Returns a paginated list of all artifacts that match the provided filter criteria.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_artifacts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Filter by artifact name.. [optional]
            offset (int): The number of artifacts to skip before starting to collect the result set.  Defaults to 0.. [optional] if omitted the server will use the default value of 0
            limit (int): The number of artifacts to return.  Defaults to 20.. [optional] if omitted the server will use the default value of 20
            order (SortOrder): Sort order, ascending (`asc`) or descending (`desc`).. [optional]
            orderby (SortBy): The field to sort by.  Can be one of:  * `name` * `createdOn` . [optional]
            labels ([str]): Filter by label.  Include one or more label to only return artifacts containing all of the specified labels.. [optional]
            properties ([str]): Filter by one or more name/value property.  Separate each name/value pair using a colon.  For example `properties=foo:bar` will return only artifacts with a custom property named `foo` and value `bar`.. [optional]
            description (str): Filter by description.. [optional]
            group (str): Filter by artifact group.. [optional]
            global_id (int): Filter by globalId.. [optional]
            content_id (int): Filter by contentId.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ArtifactSearchResults
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.search_artifacts_endpoint.call_with_http_info(**kwargs)

    def search_artifacts_by_content(
        self,
        body,
        **kwargs
    ):
        """Search for artifacts by content  # noqa: E501

        Returns a paginated list of all artifacts with at least one version that matches the posted content.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_artifacts_by_content(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (file_type): The content to search for.

        Keyword Args:
            canonical (bool): Parameter that can be set to `true` to indicate that the server should \"canonicalize\" the content when searching for matching artifacts.  Canonicalization is unique to each artifact type, but typically involves removing any extra whitespace and formatting the content in a consistent manner.  Must be used along with the `artifactType` query parameter.. [optional]
            artifact_type (ArtifactType): Indicates the type of artifact represented by the content being used for the search.  This is only needed when using the `canonical` query parameter, so that the server knows how to canonicalize the content prior to searching for matching artifacts.. [optional]
            offset (int): The number of artifacts to skip before starting to collect the result set.  Defaults to 0.. [optional] if omitted the server will use the default value of 0
            limit (int): The number of artifacts to return.  Defaults to 20.. [optional] if omitted the server will use the default value of 20
            order (str): Sort order, ascending (`asc`) or descending (`desc`).. [optional]
            orderby (str): The field to sort by.  Can be one of:  * `name` * `createdOn` . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ArtifactSearchResults
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['body'] = \
            body
        return self.search_artifacts_by_content_endpoint.call_with_http_info(**kwargs)

    def update_artifact(
        self,
        group_id,
        artifact_id,
        body,
        **kwargs
    ):
        """Update artifact  # noqa: E501

        Updates an artifact by uploading new content.  The body of the request can be the raw content of the artifact or a JSON object containing both the raw content and a set of references to other artifacts..  This is typically in JSON format for *most* of the supported types, but may be in another format for a few (for example, `PROTOBUF`). The type of the content should be compatible with the artifact's type (it would be an error to update an `AVRO` artifact with new `OPENAPI` content, for example).  The update could fail for a number of reasons including:  * Provided content (request body) was empty (HTTP error `400`) * No artifact with the `artifactId` exists (HTTP error `404`) * The new content violates one of the rules configured for the artifact (HTTP error `409`) * A server error occurred (HTTP error `500`)  When successful, this creates a new version of the artifact, making it the most recent (and therefore official) version of the artifact.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_artifact(group_id, artifact_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            body (file_type): The new content of the artifact being updated. This is often, but not always, JSON data representing one of the supported artifact types:  * Avro (`AVRO`) * Protobuf (`PROTOBUF`) * JSON Schema (`JSON`) * Kafka Connect (`KCONNECT`) * OpenAPI (`OPENAPI`) * AsyncAPI (`ASYNCAPI`) * GraphQL (`GRAPHQL`) * Web Services Description Language (`WSDL`) * XML Schema (`XSD`) 

        Keyword Args:
            x_registry_version (str): Specifies the version number of this new version of the artifact content.  This would typically be a simple integer or a SemVer value.  If not provided, the server will assign a version number automatically.. [optional]
            x_registry_name (str): Specifies the artifact name of this new version of the artifact content. Name must be ASCII-only string. If this is not provided, the server will extract the name from the artifact content.. [optional]
            x_registry_name_encoded (str): Specifies the artifact name of this new version of the artifact content. Value of this must be Base64 encoded string. If this is not provided, the server will extract the name from the artifact content.. [optional]
            x_registry_description (str): Specifies the artifact description of this new version of the artifact content. Description must be ASCII-only string. If this is not provided, the server will extract the description from the artifact content.. [optional]
            x_registry_description_encoded (str): Specifies the artifact description of this new version of the artifact content. Value of this must be Base64 encoded string. If this is not provided, the server will extract the description from the artifact content.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ArtifactMetaData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['body'] = \
            body
        return self.update_artifact_endpoint.call_with_http_info(**kwargs)

    def update_artifact_state(
        self,
        group_id,
        artifact_id,
        update_state,
        **kwargs
    ):
        """Update artifact state  # noqa: E501

        Updates the state of the artifact.  For example, you can use this to mark the latest version of an artifact as `DEPRECATED`.  The operation changes the state of the latest  version of the artifact.  If multiple versions exist, only the most recent is changed.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_artifact_state(group_id, artifact_id, update_state, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            update_state (UpdateState):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['update_state'] = \
            update_state
        return self.update_artifact_state_endpoint.call_with_http_info(**kwargs)

