"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 *
 * @stability stable
 */
class TopicPolicy extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         *
         * @stability stable
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        this.document = (_b = props.policyDocument) !== null && _b !== void 0 ? _b : this.document;
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
_a = JSII_RTTI_SYMBOL_1;
TopicPolicy[_a] = { fqn: "@aws-cdk/aws-sns.TopicPolicy", version: "1.105.0" };
//# sourceMappingURL=data:application/json;base64,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