# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'EnvironmentFederationParameters',
]

@pulumi.output_type
class EnvironmentFederationParameters(dict):
    """
    Additional parameters to identify Federation mode
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationCallBackURL":
            suggest = "application_call_back_url"
        elif key == "attributeMap":
            suggest = "attribute_map"
        elif key == "federationProviderName":
            suggest = "federation_provider_name"
        elif key == "federationURN":
            suggest = "federation_urn"
        elif key == "samlMetadataDocument":
            suggest = "saml_metadata_document"
        elif key == "samlMetadataURL":
            suggest = "saml_metadata_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentFederationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentFederationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentFederationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_call_back_url: Optional[str] = None,
                 attribute_map: Optional[Any] = None,
                 federation_provider_name: Optional[str] = None,
                 federation_urn: Optional[str] = None,
                 saml_metadata_document: Optional[str] = None,
                 saml_metadata_url: Optional[str] = None):
        """
        Additional parameters to identify Federation mode
        :param str application_call_back_url: SAML metadata URL to link with the Environment
        :param Any attribute_map: Attribute map for SAML configuration
        :param str federation_provider_name: Federation provider name to link with the Environment
        :param str federation_urn: SAML metadata URL to link with the Environment
        :param str saml_metadata_document: SAML metadata document to link the federation provider to the Environment
        :param str saml_metadata_url: SAML metadata URL to link with the Environment
        """
        if application_call_back_url is not None:
            pulumi.set(__self__, "application_call_back_url", application_call_back_url)
        if attribute_map is not None:
            pulumi.set(__self__, "attribute_map", attribute_map)
        if federation_provider_name is not None:
            pulumi.set(__self__, "federation_provider_name", federation_provider_name)
        if federation_urn is not None:
            pulumi.set(__self__, "federation_urn", federation_urn)
        if saml_metadata_document is not None:
            pulumi.set(__self__, "saml_metadata_document", saml_metadata_document)
        if saml_metadata_url is not None:
            pulumi.set(__self__, "saml_metadata_url", saml_metadata_url)

    @property
    @pulumi.getter(name="applicationCallBackURL")
    def application_call_back_url(self) -> Optional[str]:
        """
        SAML metadata URL to link with the Environment
        """
        return pulumi.get(self, "application_call_back_url")

    @property
    @pulumi.getter(name="attributeMap")
    def attribute_map(self) -> Optional[Any]:
        """
        Attribute map for SAML configuration
        """
        return pulumi.get(self, "attribute_map")

    @property
    @pulumi.getter(name="federationProviderName")
    def federation_provider_name(self) -> Optional[str]:
        """
        Federation provider name to link with the Environment
        """
        return pulumi.get(self, "federation_provider_name")

    @property
    @pulumi.getter(name="federationURN")
    def federation_urn(self) -> Optional[str]:
        """
        SAML metadata URL to link with the Environment
        """
        return pulumi.get(self, "federation_urn")

    @property
    @pulumi.getter(name="samlMetadataDocument")
    def saml_metadata_document(self) -> Optional[str]:
        """
        SAML metadata document to link the federation provider to the Environment
        """
        return pulumi.get(self, "saml_metadata_document")

    @property
    @pulumi.getter(name="samlMetadataURL")
    def saml_metadata_url(self) -> Optional[str]:
        """
        SAML metadata URL to link with the Environment
        """
        return pulumi.get(self, "saml_metadata_url")


