"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTable = exports.CfnGlobalTable = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-04-22T08:41:11.067Z","fingerprint":"yhqOuZqdw2H8wY/rVfmRRi7jG1kwQJ9MPTM05eRoULI="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnGlobalTableProps`
 *
 * @param properties - the TypeScript properties of a `CfnGlobalTableProps`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTablePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeDefinitions', cdk.requiredValidator)(properties.attributeDefinitions));
    errors.collect(cdk.propertyValidator('attributeDefinitions', cdk.listValidator(CfnGlobalTable_AttributeDefinitionPropertyValidator))(properties.attributeDefinitions));
    errors.collect(cdk.propertyValidator('billingMode', cdk.validateString)(properties.billingMode));
    errors.collect(cdk.propertyValidator('globalSecondaryIndexes', cdk.listValidator(CfnGlobalTable_GlobalSecondaryIndexPropertyValidator))(properties.globalSecondaryIndexes));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnGlobalTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('localSecondaryIndexes', cdk.listValidator(CfnGlobalTable_LocalSecondaryIndexPropertyValidator))(properties.localSecondaryIndexes));
    errors.collect(cdk.propertyValidator('replicas', cdk.requiredValidator)(properties.replicas));
    errors.collect(cdk.propertyValidator('replicas', cdk.listValidator(CfnGlobalTable_ReplicaSpecificationPropertyValidator))(properties.replicas));
    errors.collect(cdk.propertyValidator('sseSpecification', CfnGlobalTable_SSESpecificationPropertyValidator)(properties.sseSpecification));
    errors.collect(cdk.propertyValidator('streamSpecification', CfnGlobalTable_StreamSpecificationPropertyValidator)(properties.streamSpecification));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    errors.collect(cdk.propertyValidator('timeToLiveSpecification', CfnGlobalTable_TimeToLiveSpecificationPropertyValidator)(properties.timeToLiveSpecification));
    errors.collect(cdk.propertyValidator('writeProvisionedThroughputSettings', CfnGlobalTable_WriteProvisionedThroughputSettingsPropertyValidator)(properties.writeProvisionedThroughputSettings));
    return errors.wrap('supplied properties not correct for "CfnGlobalTableProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable` resource
 *
 * @param properties - the TypeScript properties of a `CfnGlobalTableProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTablePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTablePropsValidator(properties).assertSuccess();
    return {
        AttributeDefinitions: cdk.listMapper(cfnGlobalTableAttributeDefinitionPropertyToCloudFormation)(properties.attributeDefinitions),
        KeySchema: cdk.listMapper(cfnGlobalTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        Replicas: cdk.listMapper(cfnGlobalTableReplicaSpecificationPropertyToCloudFormation)(properties.replicas),
        BillingMode: cdk.stringToCloudFormation(properties.billingMode),
        GlobalSecondaryIndexes: cdk.listMapper(cfnGlobalTableGlobalSecondaryIndexPropertyToCloudFormation)(properties.globalSecondaryIndexes),
        LocalSecondaryIndexes: cdk.listMapper(cfnGlobalTableLocalSecondaryIndexPropertyToCloudFormation)(properties.localSecondaryIndexes),
        SSESpecification: cfnGlobalTableSSESpecificationPropertyToCloudFormation(properties.sseSpecification),
        StreamSpecification: cfnGlobalTableStreamSpecificationPropertyToCloudFormation(properties.streamSpecification),
        TableName: cdk.stringToCloudFormation(properties.tableName),
        TimeToLiveSpecification: cfnGlobalTableTimeToLiveSpecificationPropertyToCloudFormation(properties.timeToLiveSpecification),
        WriteProvisionedThroughputSettings: cfnGlobalTableWriteProvisionedThroughputSettingsPropertyToCloudFormation(properties.writeProvisionedThroughputSettings),
    };
}
// @ts-ignore TS6133
function CfnGlobalTablePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeDefinitions', 'AttributeDefinitions', cfn_parse.FromCloudFormation.getArray(CfnGlobalTableAttributeDefinitionPropertyFromCloudFormation)(properties.AttributeDefinitions));
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnGlobalTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('replicas', 'Replicas', cfn_parse.FromCloudFormation.getArray(CfnGlobalTableReplicaSpecificationPropertyFromCloudFormation)(properties.Replicas));
    ret.addPropertyResult('billingMode', 'BillingMode', properties.BillingMode != null ? cfn_parse.FromCloudFormation.getString(properties.BillingMode) : undefined);
    ret.addPropertyResult('globalSecondaryIndexes', 'GlobalSecondaryIndexes', properties.GlobalSecondaryIndexes != null ? cfn_parse.FromCloudFormation.getArray(CfnGlobalTableGlobalSecondaryIndexPropertyFromCloudFormation)(properties.GlobalSecondaryIndexes) : undefined);
    ret.addPropertyResult('localSecondaryIndexes', 'LocalSecondaryIndexes', properties.LocalSecondaryIndexes != null ? cfn_parse.FromCloudFormation.getArray(CfnGlobalTableLocalSecondaryIndexPropertyFromCloudFormation)(properties.LocalSecondaryIndexes) : undefined);
    ret.addPropertyResult('sseSpecification', 'SSESpecification', properties.SSESpecification != null ? CfnGlobalTableSSESpecificationPropertyFromCloudFormation(properties.SSESpecification) : undefined);
    ret.addPropertyResult('streamSpecification', 'StreamSpecification', properties.StreamSpecification != null ? CfnGlobalTableStreamSpecificationPropertyFromCloudFormation(properties.StreamSpecification) : undefined);
    ret.addPropertyResult('tableName', 'TableName', properties.TableName != null ? cfn_parse.FromCloudFormation.getString(properties.TableName) : undefined);
    ret.addPropertyResult('timeToLiveSpecification', 'TimeToLiveSpecification', properties.TimeToLiveSpecification != null ? CfnGlobalTableTimeToLiveSpecificationPropertyFromCloudFormation(properties.TimeToLiveSpecification) : undefined);
    ret.addPropertyResult('writeProvisionedThroughputSettings', 'WriteProvisionedThroughputSettings', properties.WriteProvisionedThroughputSettings != null ? CfnGlobalTableWriteProvisionedThroughputSettingsPropertyFromCloudFormation(properties.WriteProvisionedThroughputSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DynamoDB::GlobalTable`
 *
 * The `AWS::DynamoDB::GlobalTable` resource enables you to create and manage a Version 2019.11.21 global table. This resource cannot be used to create or manage a Version 2017.11.29 global table.
 *
 * > You cannot convert a resource of type `AWS::DynamoDB::Table` into a resource of type `AWS::DynamoDB::GlobalTable` by changing its type in your template. *Doing so might result in the deletion of your DynamoDB table.*
 * >
 * > You can instead use the GlobalTable resource to create a new table in a single Region. This will be billed the same as a single Region table. If you later update the stack to add other Regions then Global Tables pricing will apply.
 *
 * You should be aware of the following behaviors when working with DynamoDB global tables.
 *
 * - The IAM Principal executing the stack operation must have the permissions listed below in all regions where you plan to have a global table replica. The IAM Principal's permissions should not have restrictions based on IP source address. Some global tables operations (for example, adding a replica) are asynchronous, and require that the IAM Principal is valid until they complete. You should not delete the Principal (user or IAM role) until CloudFormation has finished updating your stack.
 *
 * - `dynamodb:CreateTable`
 * - `dynamodb:UpdateTable`
 * - `dynamodb:DeleteTable`
 * - `dynamodb:DescribeContinuousBackups`
 * - `dynamodb:DescribeContributorInsights`
 * - `dynamodb:DescribeTable`
 * - `dynamodb:DescribeTableReplicaAutoScaling`
 * - `dynamodb:DescribeTimeToLive`
 * - `dynamodb:ListTables`
 * - `dynamodb:UpdateTimeToLive`
 * - `dynamodb:UpdateContributorInsights`
 * - `dynamodb:UpdateContinuousBackups`
 * - `dynamodb:ListTagsOfResource`
 * - `dynamodb:TagResource`
 * - `dynamodb:UntagResource`
 * - `dynamodb:BatchWriteItem`
 * - `dynamodb:CreateTableReplica`
 * - `dynamodb:DeleteItem`
 * - `dynamodb:DeleteTableReplica`
 * - `dynamodb:DisableKinesisStreamingDestination`
 * - `dynamodb:EnableKinesisStreamingDestination`
 * - `dynamodb:GetItem`
 * - `dynamodb:PutItem`
 * - `dynamodb:Query`
 * - `dynamodb:Scan`
 * - `dynamodb:UpdateItem`
 * - `dynamodb:DescribeTableReplicaAutoScaling`
 * - `dynamodb:UpdateTableReplicaAutoScaling`
 * - `iam:CreateServiceLinkedRole`
 * - `kms:CreateGrant`
 * - `kms:DescribeKey`
 * - `application-autoscaling:DeleteScalingPolicy`
 * - `application-autoscaling:DeleteScheduledAction`
 * - `application-autoscaling:DeregisterScalableTarget`
 * - `application-autoscaling:DescribeScalingPolicies`
 * - `application-autoscaling:DescribeScalableTargets`
 * - `application-autoscaling:PutScalingPolicy`
 * - `application-autoscaling:PutScheduledAction`
 * - `application-autoscaling:RegisterScalableTarget`
 * - When using provisioned billing mode, CloudFormation will create an auto scaling policy on each of your replicas to control their write capacities. You must configure this policy using the `WriteProvisionedThroughputSettings` property. CloudFormation will ensure that all replicas have the same write capacity auto scaling property. You cannot directly specify a value for write capacity for a global table.
 * - If your table uses provisioned capacity, you must configure auto scaling directly in the `AWS::DynamoDB::GlobalTable` resource. You should not configure additional auto scaling policies on any of the table replicas or global secondary indexes, either via API or via `AWS::ApplicationAutoScaling::ScalableTarget` or `AWS::ApplicationAutoScaling::ScalingPolicy` . Doing so might result in unexpected behavior and is unsupported.
 * - In AWS CloudFormation , each global table is controlled by a single stack, in a single region, regardless of the number of replicas. When you deploy your template, CloudFormation will create/update all replicas as part of a single stack operation. You should not deploy the same `AWS::DynamoDB::GlobalTable` resource in multiple regions. Doing so will result in errors, and is unsupported. If you deploy your application template in multiple regions, you can use conditions to only create the resource in a single region. Alternatively, you can choose to define your `AWS::DynamoDB::GlobalTable` resources in a stack separate from your application stack, and make sure it is only deployed to a single region.
 *
 * @cloudformationResource AWS::DynamoDB::GlobalTable
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html
 */
class CfnGlobalTable extends cdk.CfnResource {
    /**
     * Create a new `AWS::DynamoDB::GlobalTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGlobalTable.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_dynamodb_CfnGlobalTableProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'attributeDefinitions', this);
        cdk.requireProperty(props, 'keySchema', this);
        cdk.requireProperty(props, 'replicas', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrStreamArn = cdk.Token.asString(this.getAtt('StreamArn'));
        this.attrTableId = cdk.Token.asString(this.getAtt('TableId'));
        this.attributeDefinitions = props.attributeDefinitions;
        this.keySchema = props.keySchema;
        this.replicas = props.replicas;
        this.billingMode = props.billingMode;
        this.globalSecondaryIndexes = props.globalSecondaryIndexes;
        this.localSecondaryIndexes = props.localSecondaryIndexes;
        this.sseSpecification = props.sseSpecification;
        this.streamSpecification = props.streamSpecification;
        this.tableName = props.tableName;
        this.timeToLiveSpecification = props.timeToLiveSpecification;
        this.writeProvisionedThroughputSettings = props.writeProvisionedThroughputSettings;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::DynamoDB::GlobalTable\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGlobalTablePropsFromCloudFormation(resourceProperties);
        const ret = new CfnGlobalTable(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGlobalTable.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            attributeDefinitions: this.attributeDefinitions,
            keySchema: this.keySchema,
            replicas: this.replicas,
            billingMode: this.billingMode,
            globalSecondaryIndexes: this.globalSecondaryIndexes,
            localSecondaryIndexes: this.localSecondaryIndexes,
            sseSpecification: this.sseSpecification,
            streamSpecification: this.streamSpecification,
            tableName: this.tableName,
            timeToLiveSpecification: this.timeToLiveSpecification,
            writeProvisionedThroughputSettings: this.writeProvisionedThroughputSettings,
        };
    }
    renderProperties(props) {
        return cfnGlobalTablePropsToCloudFormation(props);
    }
}
exports.CfnGlobalTable = CfnGlobalTable;
_a = JSII_RTTI_SYMBOL_1;
CfnGlobalTable[_a] = { fqn: "@aws-cdk/aws-dynamodb.CfnGlobalTable", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGlobalTable.CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::GlobalTable";
/**
 * Determine whether the given properties match those of a `AttributeDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `AttributeDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_AttributeDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.requiredValidator)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeType', cdk.requiredValidator)(properties.attributeType));
    errors.collect(cdk.propertyValidator('attributeType', cdk.validateString)(properties.attributeType));
    return errors.wrap('supplied properties not correct for "AttributeDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.AttributeDefinition` resource
 *
 * @param properties - the TypeScript properties of a `AttributeDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.AttributeDefinition` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableAttributeDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_AttributeDefinitionPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        AttributeType: cdk.stringToCloudFormation(properties.attributeType),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableAttributeDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', cfn_parse.FromCloudFormation.getString(properties.AttributeName));
    ret.addPropertyResult('attributeType', 'AttributeType', cfn_parse.FromCloudFormation.getString(properties.AttributeType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CapacityAutoScalingSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `CapacityAutoScalingSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_CapacityAutoScalingSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.requiredValidator)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.requiredValidator)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('seedCapacity', cdk.validateNumber)(properties.seedCapacity));
    errors.collect(cdk.propertyValidator('targetTrackingScalingPolicyConfiguration', cdk.requiredValidator)(properties.targetTrackingScalingPolicyConfiguration));
    errors.collect(cdk.propertyValidator('targetTrackingScalingPolicyConfiguration', CfnGlobalTable_TargetTrackingScalingPolicyConfigurationPropertyValidator)(properties.targetTrackingScalingPolicyConfiguration));
    return errors.wrap('supplied properties not correct for "CapacityAutoScalingSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.CapacityAutoScalingSettings` resource
 *
 * @param properties - the TypeScript properties of a `CapacityAutoScalingSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.CapacityAutoScalingSettings` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableCapacityAutoScalingSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_CapacityAutoScalingSettingsPropertyValidator(properties).assertSuccess();
    return {
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
        SeedCapacity: cdk.numberToCloudFormation(properties.seedCapacity),
        TargetTrackingScalingPolicyConfiguration: cfnGlobalTableTargetTrackingScalingPolicyConfigurationPropertyToCloudFormation(properties.targetTrackingScalingPolicyConfiguration),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableCapacityAutoScalingSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity));
    ret.addPropertyResult('minCapacity', 'MinCapacity', cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity));
    ret.addPropertyResult('seedCapacity', 'SeedCapacity', properties.SeedCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.SeedCapacity) : undefined);
    ret.addPropertyResult('targetTrackingScalingPolicyConfiguration', 'TargetTrackingScalingPolicyConfiguration', CfnGlobalTableTargetTrackingScalingPolicyConfigurationPropertyFromCloudFormation(properties.TargetTrackingScalingPolicyConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContributorInsightsSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ContributorInsightsSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ContributorInsightsSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.requiredValidator)(properties.enabled));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "ContributorInsightsSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ContributorInsightsSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ContributorInsightsSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ContributorInsightsSpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableContributorInsightsSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ContributorInsightsSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableContributorInsightsSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', cfn_parse.FromCloudFormation.getBoolean(properties.Enabled));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GlobalSecondaryIndexProperty`
 *
 * @param properties - the TypeScript properties of a `GlobalSecondaryIndexProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_GlobalSecondaryIndexPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnGlobalTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('projection', cdk.requiredValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('projection', CfnGlobalTable_ProjectionPropertyValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('writeProvisionedThroughputSettings', CfnGlobalTable_WriteProvisionedThroughputSettingsPropertyValidator)(properties.writeProvisionedThroughputSettings));
    return errors.wrap('supplied properties not correct for "GlobalSecondaryIndexProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.GlobalSecondaryIndex` resource
 *
 * @param properties - the TypeScript properties of a `GlobalSecondaryIndexProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.GlobalSecondaryIndex` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableGlobalSecondaryIndexPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_GlobalSecondaryIndexPropertyValidator(properties).assertSuccess();
    return {
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        KeySchema: cdk.listMapper(cfnGlobalTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        Projection: cfnGlobalTableProjectionPropertyToCloudFormation(properties.projection),
        WriteProvisionedThroughputSettings: cfnGlobalTableWriteProvisionedThroughputSettingsPropertyToCloudFormation(properties.writeProvisionedThroughputSettings),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableGlobalSecondaryIndexPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnGlobalTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('projection', 'Projection', CfnGlobalTableProjectionPropertyFromCloudFormation(properties.Projection));
    ret.addPropertyResult('writeProvisionedThroughputSettings', 'WriteProvisionedThroughputSettings', properties.WriteProvisionedThroughputSettings != null ? CfnGlobalTableWriteProvisionedThroughputSettingsPropertyFromCloudFormation(properties.WriteProvisionedThroughputSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KeySchemaProperty`
 *
 * @param properties - the TypeScript properties of a `KeySchemaProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_KeySchemaPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.requiredValidator)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('keyType', cdk.requiredValidator)(properties.keyType));
    errors.collect(cdk.propertyValidator('keyType', cdk.validateString)(properties.keyType));
    return errors.wrap('supplied properties not correct for "KeySchemaProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.KeySchema` resource
 *
 * @param properties - the TypeScript properties of a `KeySchemaProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.KeySchema` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableKeySchemaPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_KeySchemaPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        KeyType: cdk.stringToCloudFormation(properties.keyType),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableKeySchemaPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', cfn_parse.FromCloudFormation.getString(properties.AttributeName));
    ret.addPropertyResult('keyType', 'KeyType', cfn_parse.FromCloudFormation.getString(properties.KeyType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocalSecondaryIndexProperty`
 *
 * @param properties - the TypeScript properties of a `LocalSecondaryIndexProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_LocalSecondaryIndexPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnGlobalTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('projection', cdk.requiredValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('projection', CfnGlobalTable_ProjectionPropertyValidator)(properties.projection));
    return errors.wrap('supplied properties not correct for "LocalSecondaryIndexProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.LocalSecondaryIndex` resource
 *
 * @param properties - the TypeScript properties of a `LocalSecondaryIndexProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.LocalSecondaryIndex` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableLocalSecondaryIndexPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_LocalSecondaryIndexPropertyValidator(properties).assertSuccess();
    return {
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        KeySchema: cdk.listMapper(cfnGlobalTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        Projection: cfnGlobalTableProjectionPropertyToCloudFormation(properties.projection),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableLocalSecondaryIndexPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnGlobalTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('projection', 'Projection', CfnGlobalTableProjectionPropertyFromCloudFormation(properties.Projection));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PointInTimeRecoverySpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PointInTimeRecoverySpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_PointInTimeRecoverySpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pointInTimeRecoveryEnabled', cdk.validateBoolean)(properties.pointInTimeRecoveryEnabled));
    return errors.wrap('supplied properties not correct for "PointInTimeRecoverySpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.PointInTimeRecoverySpecification` resource
 *
 * @param properties - the TypeScript properties of a `PointInTimeRecoverySpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.PointInTimeRecoverySpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTablePointInTimeRecoverySpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_PointInTimeRecoverySpecificationPropertyValidator(properties).assertSuccess();
    return {
        PointInTimeRecoveryEnabled: cdk.booleanToCloudFormation(properties.pointInTimeRecoveryEnabled),
    };
}
// @ts-ignore TS6133
function CfnGlobalTablePointInTimeRecoverySpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pointInTimeRecoveryEnabled', 'PointInTimeRecoveryEnabled', properties.PointInTimeRecoveryEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PointInTimeRecoveryEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProjectionProperty`
 *
 * @param properties - the TypeScript properties of a `ProjectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ProjectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nonKeyAttributes', cdk.listValidator(cdk.validateString))(properties.nonKeyAttributes));
    errors.collect(cdk.propertyValidator('projectionType', cdk.validateString)(properties.projectionType));
    return errors.wrap('supplied properties not correct for "ProjectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.Projection` resource
 *
 * @param properties - the TypeScript properties of a `ProjectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.Projection` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableProjectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ProjectionPropertyValidator(properties).assertSuccess();
    return {
        NonKeyAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.nonKeyAttributes),
        ProjectionType: cdk.stringToCloudFormation(properties.projectionType),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableProjectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nonKeyAttributes', 'NonKeyAttributes', properties.NonKeyAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NonKeyAttributes) : undefined);
    ret.addPropertyResult('projectionType', 'ProjectionType', properties.ProjectionType != null ? cfn_parse.FromCloudFormation.getString(properties.ProjectionType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReadProvisionedThroughputSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `ReadProvisionedThroughputSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ReadProvisionedThroughputSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('readCapacityAutoScalingSettings', CfnGlobalTable_CapacityAutoScalingSettingsPropertyValidator)(properties.readCapacityAutoScalingSettings));
    errors.collect(cdk.propertyValidator('readCapacityUnits', cdk.validateNumber)(properties.readCapacityUnits));
    return errors.wrap('supplied properties not correct for "ReadProvisionedThroughputSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReadProvisionedThroughputSettings` resource
 *
 * @param properties - the TypeScript properties of a `ReadProvisionedThroughputSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReadProvisionedThroughputSettings` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableReadProvisionedThroughputSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ReadProvisionedThroughputSettingsPropertyValidator(properties).assertSuccess();
    return {
        ReadCapacityAutoScalingSettings: cfnGlobalTableCapacityAutoScalingSettingsPropertyToCloudFormation(properties.readCapacityAutoScalingSettings),
        ReadCapacityUnits: cdk.numberToCloudFormation(properties.readCapacityUnits),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableReadProvisionedThroughputSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('readCapacityAutoScalingSettings', 'ReadCapacityAutoScalingSettings', properties.ReadCapacityAutoScalingSettings != null ? CfnGlobalTableCapacityAutoScalingSettingsPropertyFromCloudFormation(properties.ReadCapacityAutoScalingSettings) : undefined);
    ret.addPropertyResult('readCapacityUnits', 'ReadCapacityUnits', properties.ReadCapacityUnits != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReadCapacityUnits) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReplicaGlobalSecondaryIndexSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ReplicaGlobalSecondaryIndexSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ReplicaGlobalSecondaryIndexSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contributorInsightsSpecification', CfnGlobalTable_ContributorInsightsSpecificationPropertyValidator)(properties.contributorInsightsSpecification));
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('readProvisionedThroughputSettings', CfnGlobalTable_ReadProvisionedThroughputSettingsPropertyValidator)(properties.readProvisionedThroughputSettings));
    return errors.wrap('supplied properties not correct for "ReplicaGlobalSecondaryIndexSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaGlobalSecondaryIndexSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ReplicaGlobalSecondaryIndexSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaGlobalSecondaryIndexSpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableReplicaGlobalSecondaryIndexSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ReplicaGlobalSecondaryIndexSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ContributorInsightsSpecification: cfnGlobalTableContributorInsightsSpecificationPropertyToCloudFormation(properties.contributorInsightsSpecification),
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        ReadProvisionedThroughputSettings: cfnGlobalTableReadProvisionedThroughputSettingsPropertyToCloudFormation(properties.readProvisionedThroughputSettings),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableReplicaGlobalSecondaryIndexSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contributorInsightsSpecification', 'ContributorInsightsSpecification', properties.ContributorInsightsSpecification != null ? CfnGlobalTableContributorInsightsSpecificationPropertyFromCloudFormation(properties.ContributorInsightsSpecification) : undefined);
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('readProvisionedThroughputSettings', 'ReadProvisionedThroughputSettings', properties.ReadProvisionedThroughputSettings != null ? CfnGlobalTableReadProvisionedThroughputSettingsPropertyFromCloudFormation(properties.ReadProvisionedThroughputSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReplicaSSESpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ReplicaSSESpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ReplicaSSESpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsMasterKeyId', cdk.requiredValidator)(properties.kmsMasterKeyId));
    errors.collect(cdk.propertyValidator('kmsMasterKeyId', cdk.validateString)(properties.kmsMasterKeyId));
    return errors.wrap('supplied properties not correct for "ReplicaSSESpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaSSESpecification` resource
 *
 * @param properties - the TypeScript properties of a `ReplicaSSESpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaSSESpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableReplicaSSESpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ReplicaSSESpecificationPropertyValidator(properties).assertSuccess();
    return {
        KMSMasterKeyId: cdk.stringToCloudFormation(properties.kmsMasterKeyId),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableReplicaSSESpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsMasterKeyId', 'KMSMasterKeyId', cfn_parse.FromCloudFormation.getString(properties.KMSMasterKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ReplicaSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ReplicaSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_ReplicaSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contributorInsightsSpecification', CfnGlobalTable_ContributorInsightsSpecificationPropertyValidator)(properties.contributorInsightsSpecification));
    errors.collect(cdk.propertyValidator('globalSecondaryIndexes', cdk.listValidator(CfnGlobalTable_ReplicaGlobalSecondaryIndexSpecificationPropertyValidator))(properties.globalSecondaryIndexes));
    errors.collect(cdk.propertyValidator('pointInTimeRecoverySpecification', CfnGlobalTable_PointInTimeRecoverySpecificationPropertyValidator)(properties.pointInTimeRecoverySpecification));
    errors.collect(cdk.propertyValidator('readProvisionedThroughputSettings', CfnGlobalTable_ReadProvisionedThroughputSettingsPropertyValidator)(properties.readProvisionedThroughputSettings));
    errors.collect(cdk.propertyValidator('region', cdk.requiredValidator)(properties.region));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('sseSpecification', CfnGlobalTable_ReplicaSSESpecificationPropertyValidator)(properties.sseSpecification));
    errors.collect(cdk.propertyValidator('tableClass', cdk.validateString)(properties.tableClass));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "ReplicaSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ReplicaSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.ReplicaSpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableReplicaSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_ReplicaSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ContributorInsightsSpecification: cfnGlobalTableContributorInsightsSpecificationPropertyToCloudFormation(properties.contributorInsightsSpecification),
        GlobalSecondaryIndexes: cdk.listMapper(cfnGlobalTableReplicaGlobalSecondaryIndexSpecificationPropertyToCloudFormation)(properties.globalSecondaryIndexes),
        PointInTimeRecoverySpecification: cfnGlobalTablePointInTimeRecoverySpecificationPropertyToCloudFormation(properties.pointInTimeRecoverySpecification),
        ReadProvisionedThroughputSettings: cfnGlobalTableReadProvisionedThroughputSettingsPropertyToCloudFormation(properties.readProvisionedThroughputSettings),
        Region: cdk.stringToCloudFormation(properties.region),
        SSESpecification: cfnGlobalTableReplicaSSESpecificationPropertyToCloudFormation(properties.sseSpecification),
        TableClass: cdk.stringToCloudFormation(properties.tableClass),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableReplicaSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contributorInsightsSpecification', 'ContributorInsightsSpecification', properties.ContributorInsightsSpecification != null ? CfnGlobalTableContributorInsightsSpecificationPropertyFromCloudFormation(properties.ContributorInsightsSpecification) : undefined);
    ret.addPropertyResult('globalSecondaryIndexes', 'GlobalSecondaryIndexes', properties.GlobalSecondaryIndexes != null ? cfn_parse.FromCloudFormation.getArray(CfnGlobalTableReplicaGlobalSecondaryIndexSpecificationPropertyFromCloudFormation)(properties.GlobalSecondaryIndexes) : undefined);
    ret.addPropertyResult('pointInTimeRecoverySpecification', 'PointInTimeRecoverySpecification', properties.PointInTimeRecoverySpecification != null ? CfnGlobalTablePointInTimeRecoverySpecificationPropertyFromCloudFormation(properties.PointInTimeRecoverySpecification) : undefined);
    ret.addPropertyResult('readProvisionedThroughputSettings', 'ReadProvisionedThroughputSettings', properties.ReadProvisionedThroughputSettings != null ? CfnGlobalTableReadProvisionedThroughputSettingsPropertyFromCloudFormation(properties.ReadProvisionedThroughputSettings) : undefined);
    ret.addPropertyResult('region', 'Region', cfn_parse.FromCloudFormation.getString(properties.Region));
    ret.addPropertyResult('sseSpecification', 'SSESpecification', properties.SSESpecification != null ? CfnGlobalTableReplicaSSESpecificationPropertyFromCloudFormation(properties.SSESpecification) : undefined);
    ret.addPropertyResult('tableClass', 'TableClass', properties.TableClass != null ? cfn_parse.FromCloudFormation.getString(properties.TableClass) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SSESpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `SSESpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_SSESpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sseEnabled', cdk.requiredValidator)(properties.sseEnabled));
    errors.collect(cdk.propertyValidator('sseEnabled', cdk.validateBoolean)(properties.sseEnabled));
    errors.collect(cdk.propertyValidator('sseType', cdk.validateString)(properties.sseType));
    return errors.wrap('supplied properties not correct for "SSESpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.SSESpecification` resource
 *
 * @param properties - the TypeScript properties of a `SSESpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.SSESpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableSSESpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_SSESpecificationPropertyValidator(properties).assertSuccess();
    return {
        SSEEnabled: cdk.booleanToCloudFormation(properties.sseEnabled),
        SSEType: cdk.stringToCloudFormation(properties.sseType),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableSSESpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sseEnabled', 'SSEEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.SSEEnabled));
    ret.addPropertyResult('sseType', 'SSEType', properties.SSEType != null ? cfn_parse.FromCloudFormation.getString(properties.SSEType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StreamSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `StreamSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_StreamSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('streamViewType', cdk.requiredValidator)(properties.streamViewType));
    errors.collect(cdk.propertyValidator('streamViewType', cdk.validateString)(properties.streamViewType));
    return errors.wrap('supplied properties not correct for "StreamSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.StreamSpecification` resource
 *
 * @param properties - the TypeScript properties of a `StreamSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.StreamSpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableStreamSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_StreamSpecificationPropertyValidator(properties).assertSuccess();
    return {
        StreamViewType: cdk.stringToCloudFormation(properties.streamViewType),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableStreamSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('streamViewType', 'StreamViewType', cfn_parse.FromCloudFormation.getString(properties.StreamViewType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TargetTrackingScalingPolicyConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `TargetTrackingScalingPolicyConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_TargetTrackingScalingPolicyConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('disableScaleIn', cdk.validateBoolean)(properties.disableScaleIn));
    errors.collect(cdk.propertyValidator('scaleInCooldown', cdk.validateNumber)(properties.scaleInCooldown));
    errors.collect(cdk.propertyValidator('scaleOutCooldown', cdk.validateNumber)(properties.scaleOutCooldown));
    errors.collect(cdk.propertyValidator('targetValue', cdk.requiredValidator)(properties.targetValue));
    errors.collect(cdk.propertyValidator('targetValue', cdk.validateNumber)(properties.targetValue));
    return errors.wrap('supplied properties not correct for "TargetTrackingScalingPolicyConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.TargetTrackingScalingPolicyConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `TargetTrackingScalingPolicyConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.TargetTrackingScalingPolicyConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableTargetTrackingScalingPolicyConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_TargetTrackingScalingPolicyConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DisableScaleIn: cdk.booleanToCloudFormation(properties.disableScaleIn),
        ScaleInCooldown: cdk.numberToCloudFormation(properties.scaleInCooldown),
        ScaleOutCooldown: cdk.numberToCloudFormation(properties.scaleOutCooldown),
        TargetValue: cdk.numberToCloudFormation(properties.targetValue),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableTargetTrackingScalingPolicyConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('disableScaleIn', 'DisableScaleIn', properties.DisableScaleIn != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableScaleIn) : undefined);
    ret.addPropertyResult('scaleInCooldown', 'ScaleInCooldown', properties.ScaleInCooldown != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScaleInCooldown) : undefined);
    ret.addPropertyResult('scaleOutCooldown', 'ScaleOutCooldown', properties.ScaleOutCooldown != null ? cfn_parse.FromCloudFormation.getNumber(properties.ScaleOutCooldown) : undefined);
    ret.addPropertyResult('targetValue', 'TargetValue', cfn_parse.FromCloudFormation.getNumber(properties.TargetValue));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TimeToLiveSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `TimeToLiveSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_TimeToLiveSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('enabled', cdk.requiredValidator)(properties.enabled));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "TimeToLiveSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.TimeToLiveSpecification` resource
 *
 * @param properties - the TypeScript properties of a `TimeToLiveSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.TimeToLiveSpecification` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableTimeToLiveSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_TimeToLiveSpecificationPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableTimeToLiveSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', properties.AttributeName != null ? cfn_parse.FromCloudFormation.getString(properties.AttributeName) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', cfn_parse.FromCloudFormation.getBoolean(properties.Enabled));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `WriteProvisionedThroughputSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `WriteProvisionedThroughputSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnGlobalTable_WriteProvisionedThroughputSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('writeCapacityAutoScalingSettings', CfnGlobalTable_CapacityAutoScalingSettingsPropertyValidator)(properties.writeCapacityAutoScalingSettings));
    return errors.wrap('supplied properties not correct for "WriteProvisionedThroughputSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.WriteProvisionedThroughputSettings` resource
 *
 * @param properties - the TypeScript properties of a `WriteProvisionedThroughputSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::GlobalTable.WriteProvisionedThroughputSettings` resource.
 */
// @ts-ignore TS6133
function cfnGlobalTableWriteProvisionedThroughputSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalTable_WriteProvisionedThroughputSettingsPropertyValidator(properties).assertSuccess();
    return {
        WriteCapacityAutoScalingSettings: cfnGlobalTableCapacityAutoScalingSettingsPropertyToCloudFormation(properties.writeCapacityAutoScalingSettings),
    };
}
// @ts-ignore TS6133
function CfnGlobalTableWriteProvisionedThroughputSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('writeCapacityAutoScalingSettings', 'WriteCapacityAutoScalingSettings', properties.WriteCapacityAutoScalingSettings != null ? CfnGlobalTableCapacityAutoScalingSettingsPropertyFromCloudFormation(properties.WriteCapacityAutoScalingSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTableProps`
 *
 * @param properties - the TypeScript properties of a `CfnTableProps`
 *
 * @returns the result of the validation.
 */
function CfnTablePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeDefinitions', cdk.listValidator(CfnTable_AttributeDefinitionPropertyValidator))(properties.attributeDefinitions));
    errors.collect(cdk.propertyValidator('billingMode', cdk.validateString)(properties.billingMode));
    errors.collect(cdk.propertyValidator('contributorInsightsSpecification', CfnTable_ContributorInsightsSpecificationPropertyValidator)(properties.contributorInsightsSpecification));
    errors.collect(cdk.propertyValidator('globalSecondaryIndexes', cdk.listValidator(CfnTable_GlobalSecondaryIndexPropertyValidator))(properties.globalSecondaryIndexes));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('kinesisStreamSpecification', CfnTable_KinesisStreamSpecificationPropertyValidator)(properties.kinesisStreamSpecification));
    errors.collect(cdk.propertyValidator('localSecondaryIndexes', cdk.listValidator(CfnTable_LocalSecondaryIndexPropertyValidator))(properties.localSecondaryIndexes));
    errors.collect(cdk.propertyValidator('pointInTimeRecoverySpecification', CfnTable_PointInTimeRecoverySpecificationPropertyValidator)(properties.pointInTimeRecoverySpecification));
    errors.collect(cdk.propertyValidator('provisionedThroughput', CfnTable_ProvisionedThroughputPropertyValidator)(properties.provisionedThroughput));
    errors.collect(cdk.propertyValidator('sseSpecification', CfnTable_SSESpecificationPropertyValidator)(properties.sseSpecification));
    errors.collect(cdk.propertyValidator('streamSpecification', CfnTable_StreamSpecificationPropertyValidator)(properties.streamSpecification));
    errors.collect(cdk.propertyValidator('tableClass', cdk.validateString)(properties.tableClass));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timeToLiveSpecification', CfnTable_TimeToLiveSpecificationPropertyValidator)(properties.timeToLiveSpecification));
    return errors.wrap('supplied properties not correct for "CfnTableProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table` resource
 *
 * @param properties - the TypeScript properties of a `CfnTableProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table` resource.
 */
// @ts-ignore TS6133
function cfnTablePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTablePropsValidator(properties).assertSuccess();
    return {
        KeySchema: cdk.listMapper(cfnTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        AttributeDefinitions: cdk.listMapper(cfnTableAttributeDefinitionPropertyToCloudFormation)(properties.attributeDefinitions),
        BillingMode: cdk.stringToCloudFormation(properties.billingMode),
        ContributorInsightsSpecification: cfnTableContributorInsightsSpecificationPropertyToCloudFormation(properties.contributorInsightsSpecification),
        GlobalSecondaryIndexes: cdk.listMapper(cfnTableGlobalSecondaryIndexPropertyToCloudFormation)(properties.globalSecondaryIndexes),
        KinesisStreamSpecification: cfnTableKinesisStreamSpecificationPropertyToCloudFormation(properties.kinesisStreamSpecification),
        LocalSecondaryIndexes: cdk.listMapper(cfnTableLocalSecondaryIndexPropertyToCloudFormation)(properties.localSecondaryIndexes),
        PointInTimeRecoverySpecification: cfnTablePointInTimeRecoverySpecificationPropertyToCloudFormation(properties.pointInTimeRecoverySpecification),
        ProvisionedThroughput: cfnTableProvisionedThroughputPropertyToCloudFormation(properties.provisionedThroughput),
        SSESpecification: cfnTableSSESpecificationPropertyToCloudFormation(properties.sseSpecification),
        StreamSpecification: cfnTableStreamSpecificationPropertyToCloudFormation(properties.streamSpecification),
        TableClass: cdk.stringToCloudFormation(properties.tableClass),
        TableName: cdk.stringToCloudFormation(properties.tableName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TimeToLiveSpecification: cfnTableTimeToLiveSpecificationPropertyToCloudFormation(properties.timeToLiveSpecification),
    };
}
// @ts-ignore TS6133
function CfnTablePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('attributeDefinitions', 'AttributeDefinitions', properties.AttributeDefinitions != null ? cfn_parse.FromCloudFormation.getArray(CfnTableAttributeDefinitionPropertyFromCloudFormation)(properties.AttributeDefinitions) : undefined);
    ret.addPropertyResult('billingMode', 'BillingMode', properties.BillingMode != null ? cfn_parse.FromCloudFormation.getString(properties.BillingMode) : undefined);
    ret.addPropertyResult('contributorInsightsSpecification', 'ContributorInsightsSpecification', properties.ContributorInsightsSpecification != null ? CfnTableContributorInsightsSpecificationPropertyFromCloudFormation(properties.ContributorInsightsSpecification) : undefined);
    ret.addPropertyResult('globalSecondaryIndexes', 'GlobalSecondaryIndexes', properties.GlobalSecondaryIndexes != null ? cfn_parse.FromCloudFormation.getArray(CfnTableGlobalSecondaryIndexPropertyFromCloudFormation)(properties.GlobalSecondaryIndexes) : undefined);
    ret.addPropertyResult('kinesisStreamSpecification', 'KinesisStreamSpecification', properties.KinesisStreamSpecification != null ? CfnTableKinesisStreamSpecificationPropertyFromCloudFormation(properties.KinesisStreamSpecification) : undefined);
    ret.addPropertyResult('localSecondaryIndexes', 'LocalSecondaryIndexes', properties.LocalSecondaryIndexes != null ? cfn_parse.FromCloudFormation.getArray(CfnTableLocalSecondaryIndexPropertyFromCloudFormation)(properties.LocalSecondaryIndexes) : undefined);
    ret.addPropertyResult('pointInTimeRecoverySpecification', 'PointInTimeRecoverySpecification', properties.PointInTimeRecoverySpecification != null ? CfnTablePointInTimeRecoverySpecificationPropertyFromCloudFormation(properties.PointInTimeRecoverySpecification) : undefined);
    ret.addPropertyResult('provisionedThroughput', 'ProvisionedThroughput', properties.ProvisionedThroughput != null ? CfnTableProvisionedThroughputPropertyFromCloudFormation(properties.ProvisionedThroughput) : undefined);
    ret.addPropertyResult('sseSpecification', 'SSESpecification', properties.SSESpecification != null ? CfnTableSSESpecificationPropertyFromCloudFormation(properties.SSESpecification) : undefined);
    ret.addPropertyResult('streamSpecification', 'StreamSpecification', properties.StreamSpecification != null ? CfnTableStreamSpecificationPropertyFromCloudFormation(properties.StreamSpecification) : undefined);
    ret.addPropertyResult('tableClass', 'TableClass', properties.TableClass != null ? cfn_parse.FromCloudFormation.getString(properties.TableClass) : undefined);
    ret.addPropertyResult('tableName', 'TableName', properties.TableName != null ? cfn_parse.FromCloudFormation.getString(properties.TableName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timeToLiveSpecification', 'TimeToLiveSpecification', properties.TimeToLiveSpecification != null ? CfnTableTimeToLiveSpecificationPropertyFromCloudFormation(properties.TimeToLiveSpecification) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`
 *
 * The `AWS::DynamoDB::Table` resource creates a DynamoDB table. For more information, see [CreateTable](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html) in the *Amazon DynamoDB API Reference* .
 *
 * You should be aware of the following behaviors when working with DynamoDB tables:
 *
 * - AWS CloudFormation typically creates DynamoDB tables in parallel. However, if your template includes multiple DynamoDB tables with indexes, you must declare dependencies so that the tables are created sequentially. Amazon DynamoDB limits the number of tables with secondary indexes that are in the creating state. If you create multiple tables with indexes at the same time, DynamoDB returns an error and the stack operation fails. For an example, see [DynamoDB Table with a DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-examples-dependson) .
 *
 * @cloudformationResource AWS::DynamoDB::Table
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
class CfnTable extends cdk.CfnResource {
    /**
     * Create a new `AWS::DynamoDB::Table`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTable.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_dynamodb_CfnTableProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keySchema', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrStreamArn = cdk.Token.asString(this.getAtt('StreamArn'));
        this.keySchema = props.keySchema;
        this.attributeDefinitions = props.attributeDefinitions;
        this.billingMode = props.billingMode;
        this.contributorInsightsSpecification = props.contributorInsightsSpecification;
        this.globalSecondaryIndexes = props.globalSecondaryIndexes;
        this.kinesisStreamSpecification = props.kinesisStreamSpecification;
        this.localSecondaryIndexes = props.localSecondaryIndexes;
        this.pointInTimeRecoverySpecification = props.pointInTimeRecoverySpecification;
        this.provisionedThroughput = props.provisionedThroughput;
        this.sseSpecification = props.sseSpecification;
        this.streamSpecification = props.streamSpecification;
        this.tableClass = props.tableClass;
        this.tableName = props.tableName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DynamoDB::Table", props.tags, { tagPropertyName: 'tags' });
        this.timeToLiveSpecification = props.timeToLiveSpecification;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::DynamoDB::Table\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTablePropsFromCloudFormation(resourceProperties);
        const ret = new CfnTable(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTable.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keySchema: this.keySchema,
            attributeDefinitions: this.attributeDefinitions,
            billingMode: this.billingMode,
            contributorInsightsSpecification: this.contributorInsightsSpecification,
            globalSecondaryIndexes: this.globalSecondaryIndexes,
            kinesisStreamSpecification: this.kinesisStreamSpecification,
            localSecondaryIndexes: this.localSecondaryIndexes,
            pointInTimeRecoverySpecification: this.pointInTimeRecoverySpecification,
            provisionedThroughput: this.provisionedThroughput,
            sseSpecification: this.sseSpecification,
            streamSpecification: this.streamSpecification,
            tableClass: this.tableClass,
            tableName: this.tableName,
            tags: this.tags.renderTags(),
            timeToLiveSpecification: this.timeToLiveSpecification,
        };
    }
    renderProperties(props) {
        return cfnTablePropsToCloudFormation(props);
    }
}
exports.CfnTable = CfnTable;
_b = JSII_RTTI_SYMBOL_1;
CfnTable[_b] = { fqn: "@aws-cdk/aws-dynamodb.CfnTable", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTable.CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::Table";
/**
 * Determine whether the given properties match those of a `AttributeDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `AttributeDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_AttributeDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.requiredValidator)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeType', cdk.requiredValidator)(properties.attributeType));
    errors.collect(cdk.propertyValidator('attributeType', cdk.validateString)(properties.attributeType));
    return errors.wrap('supplied properties not correct for "AttributeDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.AttributeDefinition` resource
 *
 * @param properties - the TypeScript properties of a `AttributeDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.AttributeDefinition` resource.
 */
// @ts-ignore TS6133
function cfnTableAttributeDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_AttributeDefinitionPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        AttributeType: cdk.stringToCloudFormation(properties.attributeType),
    };
}
// @ts-ignore TS6133
function CfnTableAttributeDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', cfn_parse.FromCloudFormation.getString(properties.AttributeName));
    ret.addPropertyResult('attributeType', 'AttributeType', cfn_parse.FromCloudFormation.getString(properties.AttributeType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContributorInsightsSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ContributorInsightsSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ContributorInsightsSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.requiredValidator)(properties.enabled));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "ContributorInsightsSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.ContributorInsightsSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ContributorInsightsSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.ContributorInsightsSpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableContributorInsightsSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ContributorInsightsSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnTableContributorInsightsSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', cfn_parse.FromCloudFormation.getBoolean(properties.Enabled));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GlobalSecondaryIndexProperty`
 *
 * @param properties - the TypeScript properties of a `GlobalSecondaryIndexProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_GlobalSecondaryIndexPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contributorInsightsSpecification', CfnTable_ContributorInsightsSpecificationPropertyValidator)(properties.contributorInsightsSpecification));
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('projection', cdk.requiredValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('projection', CfnTable_ProjectionPropertyValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('provisionedThroughput', CfnTable_ProvisionedThroughputPropertyValidator)(properties.provisionedThroughput));
    return errors.wrap('supplied properties not correct for "GlobalSecondaryIndexProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.GlobalSecondaryIndex` resource
 *
 * @param properties - the TypeScript properties of a `GlobalSecondaryIndexProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.GlobalSecondaryIndex` resource.
 */
// @ts-ignore TS6133
function cfnTableGlobalSecondaryIndexPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_GlobalSecondaryIndexPropertyValidator(properties).assertSuccess();
    return {
        ContributorInsightsSpecification: cfnTableContributorInsightsSpecificationPropertyToCloudFormation(properties.contributorInsightsSpecification),
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        KeySchema: cdk.listMapper(cfnTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        Projection: cfnTableProjectionPropertyToCloudFormation(properties.projection),
        ProvisionedThroughput: cfnTableProvisionedThroughputPropertyToCloudFormation(properties.provisionedThroughput),
    };
}
// @ts-ignore TS6133
function CfnTableGlobalSecondaryIndexPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contributorInsightsSpecification', 'ContributorInsightsSpecification', properties.ContributorInsightsSpecification != null ? CfnTableContributorInsightsSpecificationPropertyFromCloudFormation(properties.ContributorInsightsSpecification) : undefined);
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('projection', 'Projection', CfnTableProjectionPropertyFromCloudFormation(properties.Projection));
    ret.addPropertyResult('provisionedThroughput', 'ProvisionedThroughput', properties.ProvisionedThroughput != null ? CfnTableProvisionedThroughputPropertyFromCloudFormation(properties.ProvisionedThroughput) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KeySchemaProperty`
 *
 * @param properties - the TypeScript properties of a `KeySchemaProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_KeySchemaPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.requiredValidator)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('keyType', cdk.requiredValidator)(properties.keyType));
    errors.collect(cdk.propertyValidator('keyType', cdk.validateString)(properties.keyType));
    return errors.wrap('supplied properties not correct for "KeySchemaProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.KeySchema` resource
 *
 * @param properties - the TypeScript properties of a `KeySchemaProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.KeySchema` resource.
 */
// @ts-ignore TS6133
function cfnTableKeySchemaPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_KeySchemaPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        KeyType: cdk.stringToCloudFormation(properties.keyType),
    };
}
// @ts-ignore TS6133
function CfnTableKeySchemaPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', cfn_parse.FromCloudFormation.getString(properties.AttributeName));
    ret.addPropertyResult('keyType', 'KeyType', cfn_parse.FromCloudFormation.getString(properties.KeyType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KinesisStreamSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `KinesisStreamSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_KinesisStreamSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('streamArn', cdk.requiredValidator)(properties.streamArn));
    errors.collect(cdk.propertyValidator('streamArn', cdk.validateString)(properties.streamArn));
    return errors.wrap('supplied properties not correct for "KinesisStreamSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.KinesisStreamSpecification` resource
 *
 * @param properties - the TypeScript properties of a `KinesisStreamSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.KinesisStreamSpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableKinesisStreamSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_KinesisStreamSpecificationPropertyValidator(properties).assertSuccess();
    return {
        StreamArn: cdk.stringToCloudFormation(properties.streamArn),
    };
}
// @ts-ignore TS6133
function CfnTableKinesisStreamSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('streamArn', 'StreamArn', cfn_parse.FromCloudFormation.getString(properties.StreamArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LocalSecondaryIndexProperty`
 *
 * @param properties - the TypeScript properties of a `LocalSecondaryIndexProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_LocalSecondaryIndexPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('keySchema', cdk.requiredValidator)(properties.keySchema));
    errors.collect(cdk.propertyValidator('keySchema', cdk.listValidator(CfnTable_KeySchemaPropertyValidator))(properties.keySchema));
    errors.collect(cdk.propertyValidator('projection', cdk.requiredValidator)(properties.projection));
    errors.collect(cdk.propertyValidator('projection', CfnTable_ProjectionPropertyValidator)(properties.projection));
    return errors.wrap('supplied properties not correct for "LocalSecondaryIndexProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.LocalSecondaryIndex` resource
 *
 * @param properties - the TypeScript properties of a `LocalSecondaryIndexProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.LocalSecondaryIndex` resource.
 */
// @ts-ignore TS6133
function cfnTableLocalSecondaryIndexPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_LocalSecondaryIndexPropertyValidator(properties).assertSuccess();
    return {
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        KeySchema: cdk.listMapper(cfnTableKeySchemaPropertyToCloudFormation)(properties.keySchema),
        Projection: cfnTableProjectionPropertyToCloudFormation(properties.projection),
    };
}
// @ts-ignore TS6133
function CfnTableLocalSecondaryIndexPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('keySchema', 'KeySchema', cfn_parse.FromCloudFormation.getArray(CfnTableKeySchemaPropertyFromCloudFormation)(properties.KeySchema));
    ret.addPropertyResult('projection', 'Projection', CfnTableProjectionPropertyFromCloudFormation(properties.Projection));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PointInTimeRecoverySpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `PointInTimeRecoverySpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_PointInTimeRecoverySpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pointInTimeRecoveryEnabled', cdk.validateBoolean)(properties.pointInTimeRecoveryEnabled));
    return errors.wrap('supplied properties not correct for "PointInTimeRecoverySpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.PointInTimeRecoverySpecification` resource
 *
 * @param properties - the TypeScript properties of a `PointInTimeRecoverySpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.PointInTimeRecoverySpecification` resource.
 */
// @ts-ignore TS6133
function cfnTablePointInTimeRecoverySpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_PointInTimeRecoverySpecificationPropertyValidator(properties).assertSuccess();
    return {
        PointInTimeRecoveryEnabled: cdk.booleanToCloudFormation(properties.pointInTimeRecoveryEnabled),
    };
}
// @ts-ignore TS6133
function CfnTablePointInTimeRecoverySpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pointInTimeRecoveryEnabled', 'PointInTimeRecoveryEnabled', properties.PointInTimeRecoveryEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PointInTimeRecoveryEnabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProjectionProperty`
 *
 * @param properties - the TypeScript properties of a `ProjectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ProjectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('nonKeyAttributes', cdk.listValidator(cdk.validateString))(properties.nonKeyAttributes));
    errors.collect(cdk.propertyValidator('projectionType', cdk.validateString)(properties.projectionType));
    return errors.wrap('supplied properties not correct for "ProjectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.Projection` resource
 *
 * @param properties - the TypeScript properties of a `ProjectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.Projection` resource.
 */
// @ts-ignore TS6133
function cfnTableProjectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ProjectionPropertyValidator(properties).assertSuccess();
    return {
        NonKeyAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.nonKeyAttributes),
        ProjectionType: cdk.stringToCloudFormation(properties.projectionType),
    };
}
// @ts-ignore TS6133
function CfnTableProjectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('nonKeyAttributes', 'NonKeyAttributes', properties.NonKeyAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NonKeyAttributes) : undefined);
    ret.addPropertyResult('projectionType', 'ProjectionType', properties.ProjectionType != null ? cfn_parse.FromCloudFormation.getString(properties.ProjectionType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProvisionedThroughputProperty`
 *
 * @param properties - the TypeScript properties of a `ProvisionedThroughputProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_ProvisionedThroughputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('readCapacityUnits', cdk.requiredValidator)(properties.readCapacityUnits));
    errors.collect(cdk.propertyValidator('readCapacityUnits', cdk.validateNumber)(properties.readCapacityUnits));
    errors.collect(cdk.propertyValidator('writeCapacityUnits', cdk.requiredValidator)(properties.writeCapacityUnits));
    errors.collect(cdk.propertyValidator('writeCapacityUnits', cdk.validateNumber)(properties.writeCapacityUnits));
    return errors.wrap('supplied properties not correct for "ProvisionedThroughputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.ProvisionedThroughput` resource
 *
 * @param properties - the TypeScript properties of a `ProvisionedThroughputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.ProvisionedThroughput` resource.
 */
// @ts-ignore TS6133
function cfnTableProvisionedThroughputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_ProvisionedThroughputPropertyValidator(properties).assertSuccess();
    return {
        ReadCapacityUnits: cdk.numberToCloudFormation(properties.readCapacityUnits),
        WriteCapacityUnits: cdk.numberToCloudFormation(properties.writeCapacityUnits),
    };
}
// @ts-ignore TS6133
function CfnTableProvisionedThroughputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('readCapacityUnits', 'ReadCapacityUnits', cfn_parse.FromCloudFormation.getNumber(properties.ReadCapacityUnits));
    ret.addPropertyResult('writeCapacityUnits', 'WriteCapacityUnits', cfn_parse.FromCloudFormation.getNumber(properties.WriteCapacityUnits));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SSESpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `SSESpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_SSESpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsMasterKeyId', cdk.validateString)(properties.kmsMasterKeyId));
    errors.collect(cdk.propertyValidator('sseEnabled', cdk.requiredValidator)(properties.sseEnabled));
    errors.collect(cdk.propertyValidator('sseEnabled', cdk.validateBoolean)(properties.sseEnabled));
    errors.collect(cdk.propertyValidator('sseType', cdk.validateString)(properties.sseType));
    return errors.wrap('supplied properties not correct for "SSESpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.SSESpecification` resource
 *
 * @param properties - the TypeScript properties of a `SSESpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.SSESpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableSSESpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_SSESpecificationPropertyValidator(properties).assertSuccess();
    return {
        KMSMasterKeyId: cdk.stringToCloudFormation(properties.kmsMasterKeyId),
        SSEEnabled: cdk.booleanToCloudFormation(properties.sseEnabled),
        SSEType: cdk.stringToCloudFormation(properties.sseType),
    };
}
// @ts-ignore TS6133
function CfnTableSSESpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsMasterKeyId', 'KMSMasterKeyId', properties.KMSMasterKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KMSMasterKeyId) : undefined);
    ret.addPropertyResult('sseEnabled', 'SSEEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.SSEEnabled));
    ret.addPropertyResult('sseType', 'SSEType', properties.SSEType != null ? cfn_parse.FromCloudFormation.getString(properties.SSEType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StreamSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `StreamSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_StreamSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('streamViewType', cdk.requiredValidator)(properties.streamViewType));
    errors.collect(cdk.propertyValidator('streamViewType', cdk.validateString)(properties.streamViewType));
    return errors.wrap('supplied properties not correct for "StreamSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.StreamSpecification` resource
 *
 * @param properties - the TypeScript properties of a `StreamSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.StreamSpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableStreamSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_StreamSpecificationPropertyValidator(properties).assertSuccess();
    return {
        StreamViewType: cdk.stringToCloudFormation(properties.streamViewType),
    };
}
// @ts-ignore TS6133
function CfnTableStreamSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('streamViewType', 'StreamViewType', cfn_parse.FromCloudFormation.getString(properties.StreamViewType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TimeToLiveSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `TimeToLiveSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTable_TimeToLiveSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeName', cdk.requiredValidator)(properties.attributeName));
    errors.collect(cdk.propertyValidator('attributeName', cdk.validateString)(properties.attributeName));
    errors.collect(cdk.propertyValidator('enabled', cdk.requiredValidator)(properties.enabled));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "TimeToLiveSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DynamoDB::Table.TimeToLiveSpecification` resource
 *
 * @param properties - the TypeScript properties of a `TimeToLiveSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DynamoDB::Table.TimeToLiveSpecification` resource.
 */
// @ts-ignore TS6133
function cfnTableTimeToLiveSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTable_TimeToLiveSpecificationPropertyValidator(properties).assertSuccess();
    return {
        AttributeName: cdk.stringToCloudFormation(properties.attributeName),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnTableTimeToLiveSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeName', 'AttributeName', cfn_parse.FromCloudFormation.getString(properties.AttributeName));
    ret.addPropertyResult('enabled', 'Enabled', cfn_parse.FromCloudFormation.getBoolean(properties.Enabled));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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