from hexbytes import HexBytes

trace_block_2191709_mock = [
    {
        "action": {
            "from": "0xEA674fdDe714fd979de3EdF0F56AA9716B898ec8",
            "gas": 69000,
            "value": 1000801159649151900,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x7b5A4767158DfBbaFcDE969F2B4d7FBCC19b5d3c",
        },
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x8888796bdf74b616f8900d41094bd8213b1c73385916ce4c8f5bb020f3acba3c",
        "transactionPosition": 0,
        "type": "call",
    },
    {
        "action": {
            "from": "0x2a65Aca4D5fC5B5C859090a6c34d164135398226",
            "gas": 69000,
            "value": 511624720000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x038a877d4fB63A195c22783888DA2041911Ed818",
        },
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x878d326c7cc7fd39cf7875d2ec3a69a910409d313eab3764fe253b9fed5acd60",
        "transactionPosition": 1,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7B60F3f033e6D7808428C9f2dBC81682ff24984F",
            "gas": 108562,
            "value": 286012610000000000,
            "callType": "call",
            "input": HexBytes(
                "0x0f2c9329000000000000000000000000fbb1b73c4f0bda4f67dca266ce6ef42f520fbb98000000000000000000000000e592b0d8baa2cb677034389b76a71b0d1823e0d1"
            ),
            "to": "0xE94b04a0FeD112f3664e45adb2B8915693dD5FF3",
        },
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": {
            "gasUsed": 8562,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 2,
        "traceAddress": [],
        "transactionHash": "0x849da57a0cbed360cb0367f95650c0f2cf5e37b394a519748779d825cffba6fe",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE94b04a0FeD112f3664e45adb2B8915693dD5FF3",
            "gas": 83248,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0x16c72721"),
            "to": "0x2BD2326c993DFaeF84f696526064FF22eba5b362",
        },
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": {
            "gasUsed": 197,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0x849da57a0cbed360cb0367f95650c0f2cf5e37b394a519748779d825cffba6fe",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE94b04a0FeD112f3664e45adb2B8915693dD5FF3",
            "gas": 2300,
            "value": 286012610000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xFBb1b73C4f0BDa4f67dcA266ce6Ef42f520fBB98",
        },
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1],
        "transactionHash": "0x849da57a0cbed360cb0367f95650c0f2cf5e37b394a519748779d825cffba6fe",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {"value": 5000000000000000000},
        "blockHash": "0x4169fc8dfb9ece41c90044ebc9b8e2daed9f5e08c0ba3746e337732aa48b3bc3",
        "blockNumber": 2191709,
        "result": None,
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": None,
        "transactionPosition": None,
        "type": "reward",
    },
]

trace_block_13191781_mock = [
    {
        "action": {
            "from": "0x061A9D627028fE708E1b77e591b9bdF41392D4Ba",
            "gas": 36942,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb00000000000000000000000010c6b61dbf44a083aec3780acf769c77be747e23000000000000000000000000000000000000000000000000000000012a05f200"
            ),
            "to": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 26917,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0x0ba656badfa135dec7389317fefac737f75276bbbea10e103837d87f9e853aec",
        "transactionPosition": 0,
        "type": "call",
    },
    {
        "action": {
            "from": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            "gas": 29233,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0xa9059cbb00000000000000000000000010c6b61dbf44a083aec3780acf769c77be747e23000000000000000000000000000000000000000000000000000000012a05f200"
            ),
            "to": "0xa2327a938Febf5FEC13baCFb16Ae10EcBc4cbDCF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 19628,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0x0ba656badfa135dec7389317fefac737f75276bbbea10e103837d87f9e853aec",
        "transactionPosition": 0,
        "type": "call",
    },
    {
        "action": {
            "from": "0x4091243E3fB5E637D06c265C6EAe1Be7fb8460Ce",
            "gas": 262809,
            "value": 96000000000000000,
            "callType": "call",
            "input": HexBytes(
                "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"
            ),
            "to": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "error": "Reverted",
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xbe99757628bfc3d5c7ee4e42c2629ddd13ac52354e6abb189efe5e277dce05b3",
        "transactionPosition": 1,
        "type": "call",
    },
    {
        "action": {
            "from": "0x4091243E3fB5E637D06c265C6EAe1Be7fb8460Ce",
            "gas": 276407,
            "value": 99000000000000000,
            "callType": "call",
            "input": HexBytes(
                "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"
            ),
            "to": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 201933, "output": HexBytes("0x")},
        "subtraces": 6,
        "traceAddress": [],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 227471,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xc45527910000000000000000000000008bdbf4b19cb840e9ac9b1effc2bfad47591b5bf2"
            ),
            "to": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2782,
            "output": HexBytes(
                "0x000000000000000000000000892c0feffe706b811a8437ab9e2293fa5f7b907a"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 223931,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0x97204d8e"),
            "to": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2613,
            "output": HexBytes(
                "0x000000000000000000000000f9e266af4bca5890e2781812cc6a6e89495a79f2"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 218434,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0x5c60da1b"),
            "to": "0x892C0FEfFE706b811a8437aB9e2293FA5F7b907A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2525,
            "output": HexBytes(
                "0x000000000000000000000000f9e266af4bca5890e2781812cc6a6e89495a79f2"
            ),
        },
        "subtraces": 0,
        "traceAddress": [2],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 2300,
            "value": 2475000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x5b3256965e7C3cF26E11FCAf296DfC8807C01073",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [3],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 2300,
            "value": 96525000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x8bdBF4B19cb840e9Ac9B1eFFc2BfAd47591B5bF2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [4],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7Be8076f4EA4A4AD08075C2508e481d6C946D12b",
            "gas": 173586,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x1b0f7ba9000000000000000000000000300ef850ca7754437cfce52fe0c47e5f890fb18300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000006423b872dd0000000000000000000000008bdbf4b19cb840e9ac9b1effc2bfad47591b5bf20000000000000000000000004091243e3fb5e637d06c265c6eae1be7fb8460ce0000000000000000000000000000000000000000000000000000000000000b6200000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x892C0FEfFE706b811a8437aB9e2293FA5F7b907A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 98215,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [5],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x892C0FEfFE706b811a8437aB9e2293FA5F7b907A",
            "gas": 167709,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x1b0f7ba9000000000000000000000000300ef850ca7754437cfce52fe0c47e5f890fb18300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000006423b872dd0000000000000000000000008bdbf4b19cb840e9ac9b1effc2bfad47591b5bf20000000000000000000000004091243e3fb5e637d06c265c6eae1be7fb8460ce0000000000000000000000000000000000000000000000000000000000000b6200000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xF9e266af4BcA5890e2781812cc6a6E89495a79f2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 94955,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 2,
        "traceAddress": [5, 0],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x892C0FEfFE706b811a8437aB9e2293FA5F7b907A",
            "gas": 159793,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x69dc9ff30000000000000000000000007be8076f4ea4a4ad08075c2508e481d6c946d12b"
            ),
            "to": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2553,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [5, 0, 0],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0x892C0FEfFE706b811a8437aB9e2293FA5F7b907A",
            "gas": 156423,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd0000000000000000000000008bdbf4b19cb840e9ac9b1effc2bfad47591b5bf20000000000000000000000004091243e3fb5e637d06c265c6eae1be7fb8460ce0000000000000000000000000000000000000000000000000000000000000b6200000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x300Ef850CA7754437cFcE52Fe0C47e5f890FB183",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 86058, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [5, 0, 1],
        "transactionHash": "0x7798b6ef9f281c87d45bdeabda70e4b9f24085c15aaac8e75a9f4480fb2feeef",
        "transactionPosition": 2,
        "type": "call",
    },
    {
        "action": {
            "from": "0xF598b81Ef8c7b52a7F2a89253436e72ec6DC871f",
            "gas": 84000,
            "value": 140949999999999984,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xb0BE4D6159d6480980bCCe0f8b4F0d487e8450BD",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xe0cf30aaa01f5cd786db4b14daf61aac44143778926d5e33ce416a2709d3713b",
        "transactionPosition": 3,
        "type": "call",
    },
    {
        "action": {
            "from": "0xf60c2Ea62EDBfE808163751DD0d8693DCb30019c",
            "gas": 186128,
            "value": 109720000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xe74B4E405768BcC2B6deda7710f659ba7924A245",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xf092fb03ceca9ff7e01e5b6483bfac47a7db6d8bf0a32ac44b45f8a8f0b0b665",
        "transactionPosition": 4,
        "type": "call",
    },
    {
        "action": {
            "from": "0x9E5D17e8E34d2568200C154895ba63523b3560C8",
            "gas": 129000,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x9E5D17e8E34d2568200C154895ba63523b3560C8",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x565d69c19ae671197d53591caff0d945b72f4ac0a1a6d917bda7e2179906055d",
        "transactionPosition": 5,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE851D0A60f038a8B2FF25649cFF4Aa4209c993CE",
            "gas": 40631,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000f5c48fb2f53b8c2d43a4d4a8eca7abfed364e1e90000000000000000000000000000000000000000000000f0fd3f0144b363e800"
            ),
            "to": "0xE41d2489571d322189246DaFA5ebDe1F4699F498",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 30250,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x13a3a8911e7314c8c38bdb634abab5c503aca77bab0755c36fb3d1a8e61e7820",
        "transactionPosition": 6,
        "type": "call",
    },
    {
        "action": {
            "from": "0xd5351b44102aaBB21022440e29B4295B56016ddF",
            "gas": 0,
            "value": 135417422759250043,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xa6eeFBd51A818DCBc77d6e8eF6Bd59ab61c403dF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xc3f27af4f5b8a3063b6dbd0a08019100867afb00f47227cc6e03a9c647777483",
        "transactionPosition": 7,
        "type": "call",
    },
    {
        "action": {
            "from": "0x5041ed759Dd4aFc3a72b8192C143F72f4724081A",
            "gas": 398392,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000296897c5b419c2217719dc699d244e595d675d0700000000000000000000000000000000000000000000000000000000971a1930"
            ),
            "to": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 26917,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0x7011ea340523e70f4a18f178c20367816cab4e45aa7d31e705bdb5b51265548f",
        "transactionPosition": 8,
        "type": "call",
    },
    {
        "action": {
            "from": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            "gas": 385036,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000296897c5b419c2217719dc699d244e595d675d0700000000000000000000000000000000000000000000000000000000971a1930"
            ),
            "to": "0xa2327a938Febf5FEC13baCFb16Ae10EcBc4cbDCF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 19628,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0x7011ea340523e70f4a18f178c20367816cab4e45aa7d31e705bdb5b51265548f",
        "transactionPosition": 8,
        "type": "call",
    },
    {
        "action": {
            "from": "0x9AA65464b4cFbe3Dc2BDB3dF412AeE2B3De86687",
            "gas": 228392,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb00000000000000000000000086ff7ab903e3c557aee37b383c0ceabf9ee5690700000000000000000000000000000000000000000000000000000000e880f062"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 41601, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x58d69c294aaa1503e06c4a69c895cd4fbc47e03f0a341a26c7255609d6b58c79",
        "transactionPosition": 9,
        "type": "call",
    },
    {
        "action": {
            "from": "0x3B794929566e3Ba0f25e4263e1987828b5c87161",
            "gas": 29000,
            "value": 13239660934222264,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xcAE2c1225481162eFF4c0807c7607724E5c29c9D",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x7b5e1ecaffd9bab57d8b59bf476d031bb2517192139b84362db866b88d40a295",
        "transactionPosition": 10,
        "type": "call",
    },
    {
        "action": {
            "from": "0x1f8F16a29251fA399D89e1005E3f95427Bf5B1dE",
            "gas": 0,
            "value": 4676123280340692,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x043aD94aeC8f88a62B6b0f130ccC61aC39f77A3c",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x2542cee5c144aada422aa08df4b458c594baae89061d0ae41d8b9678c527f51d",
        "transactionPosition": 11,
        "type": "call",
    },
    {
        "action": {
            "from": "0x307082e6926E4c004F3c821cb1Af08b8A2D80242",
            "gas": 53404,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb0000000000000000000000007726f93410e15e64113e3303deb73721f36a01ef00000000000000000000000000000000000000000000000000000000b2d05e00"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 41601, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x6e90803bf18163a7797d9b35fd5403c485784bf8c9480b2e1fc9b5d81194d8d2",
        "transactionPosition": 12,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC55EdDadEeB47fcDE0B3B6f25BD47D745BA7E7fa",
            "gas": 0,
            "value": 118400000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x1645521a6df217605d9949AafB84927018868cDf",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x973702b743a2e3b8caae347f74f2729b5a9cd20a5c8472b94c6758daac4407ee",
        "transactionPosition": 13,
        "type": "call",
    },
    {
        "action": {
            "from": "0xc9f5296Eb3ac266c94568D790b6e91ebA7D76a11",
            "gas": 228404,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb0000000000000000000000009f71bcf338be16007ea0502e60aa5b527677a0fc0000000000000000000000000000000000000000000000000000000002faf080"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 41601, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xd80a9b37571313117f0d34fe3152f1ad4fee03f1a6c629ff7d2bf966a37ed14f",
        "transactionPosition": 14,
        "type": "call",
    },
    {
        "action": {
            "from": "0xc9f5296Eb3ac266c94568D790b6e91ebA7D76a11",
            "gas": 228356,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000274de18b0e2c24864cfdbd0db156de962b48045e000000000000000000000000000000000000000000000035fe46d2f741100000"
            ),
            "to": "0xa117000000f279D81A1D3cc75430fAA017FA5A2e",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 29842,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x5cf28c6818d072ea14ac6f5923431202a3af58e73c833d525d75af61078ef37d",
        "transactionPosition": 15,
        "type": "call",
    },
    {
        "action": {
            "from": "0xc9f5296Eb3ac266c94568D790b6e91ebA7D76a11",
            "gas": 40,
            "value": 7088000000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x5EE7BC4c49c653778597900143702691E8AFCE48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xe8385591d43060730b568d5762656d72c4597f3c63c17e03143abb4cd2ce2549",
        "transactionPosition": 16,
        "type": "call",
    },
    {
        "action": {
            "from": "0xc9f5296Eb3ac266c94568D790b6e91ebA7D76a11",
            "gas": 228024,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd00000000000000000000000053ab688f20fdc725325b06c788226794acc47628000000000000000000000000c9f5296eb3ac266c94568d790b6e91eba7d76a11000000000000000000000000000000000000000000000000000000746a528800"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 26530, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x072f7a1f91c6281907b0b0a001bb2a58cb0e199bcf72f439b816ee7e83d1a978",
        "transactionPosition": 17,
        "type": "call",
    },
    {
        "action": {
            "from": "0x18db8B99c1d6E439fa44Fd87Bfb1109e345e98Da",
            "gas": 193674,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x38ed17390000000000000000000000000000000000000000033b2e3c9fd0803ce80000000000000000000000000000000000000000000000000000000000000281c5b6a100000000000000000000000000000000000000000000000000000000000000a000000000000000000000000018db8b99c1d6e439fa44fd87bfb1109e345e98da00000000000000000000000000000000000000000000000000000000613a117b000000000000000000000000000000000000000000000000000000000000000300000000000000000000000085f17cf997934a597031b2e18a9ab6ebd4b9f6a4000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec7"
            ),
            "to": "0xd9e1cE17f2641f24aE83637ab66a2cca9C378B9F",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "error": "Reverted",
        "subtraces": 2,
        "traceAddress": [],
        "transactionHash": "0xfac7403428a8213f3fc296412eb3f259086d80dd83be2d819b574b145b8d4855",
        "transactionPosition": 18,
        "type": "call",
    },
    {
        "action": {
            "from": "0xd9e1cE17f2641f24aE83637ab66a2cca9C378B9F",
            "gas": 185741,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes("0x0902f1ac"),
            "to": "0x6469B34a2a4723163C4902dbBdEa728D20693C12",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2517,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000002c158b1afbb13485d76c9cfe00000000000000000000000000000000000000000000000238fbe7ba3db69d46700000000000000000000000000000000000000000000000000000000613a0ab4"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0xfac7403428a8213f3fc296412eb3f259086d80dd83be2d819b574b145b8d4855",
        "transactionPosition": 18,
        "type": "call",
    },
    {
        "action": {
            "from": "0xd9e1cE17f2641f24aE83637ab66a2cca9C378B9F",
            "gas": 178382,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes("0x0902f1ac"),
            "to": "0x06da0fd433C1A5d7a4faa01111c044910A184553",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2517,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000005d91462602980322d2f000000000000000000000000000000000000000000000000000058ee2871cbb700000000000000000000000000000000000000000000000000000000613a0a97"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1],
        "transactionHash": "0xfac7403428a8213f3fc296412eb3f259086d80dd83be2d819b574b145b8d4855",
        "transactionPosition": 18,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC098B2a3Aa256D2140208C3de6543aAEf5cd3A94",
            "gas": 42000,
            "value": 903856630000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xAcF288a55C9e807e6B5d7DD4cB4f314eBe1E14FA",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x6b460cc1afa1311f9d698fb3b45a68ad537a30630b20db06a394e1d7de3c5a02",
        "transactionPosition": 19,
        "type": "call",
    },
    {
        "action": {
            "from": "0xEE022C4a3A8855356E78a3960A34842dC868B754",
            "gas": 48380,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb0000000000000000000000008abdfb25f4d46e59c4a85e3da026679999f00291000000000000000000000000000000000000000000000000000000069275d6c0"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 24501, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x9665b3325bd3a57d61c7d185f1eb428b61ef244561fa15fbb0237a4e67f593ea",
        "transactionPosition": 20,
        "type": "call",
    },
    {
        "action": {
            "from": "0x6871EaCd33fbcfE585009Ab64F0795d7152dc5a0",
            "gas": 34024,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd00000000000000000000000041335ee132cdde75acac48f1489161128440444c0000000000000000000000006871eacd33fbcfe585009ab64f0795d7152dc5a00000000000000000000000000000000000000000000000000000000a0b9329c9"
            ),
            "to": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 26530, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x3204a5a8a2c34a8f8224375968a440858aee459ca50278e33073939d9d2f0a79",
        "transactionPosition": 21,
        "type": "call",
    },
    {
        "action": {
            "from": "0x84ee5a99a08D98e2966B1a889fDCaB1CF3F7C589",
            "gas": 0,
            "value": 17790313368673531,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x1AB18ac546Cf48509D4cd41d48B41cc859A269A5",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x62dacd69eab666668088561b6d87e3f703973992b0f00666e09585af3264ea4d",
        "transactionPosition": 22,
        "type": "call",
    },
    {
        "action": {
            "from": "0xfa35113163bFD33c18A01d1A62d4D14a1Ed30a42",
            "gas": 126069,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x2e95b6c80000000000000000000000006286a9e6f7e745a6d884561d88f94542d6715698000000000000000000000000000000000000000000000b5a0ebbfe5a15da000000000000000000000000000000000000000000000000000015b1e91b911a8aeb0000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000140000000000000003b6d034084d1f4bbd0fb53b9a09e95e051f2fe1bf3e01e6a"
            ),
            "to": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "error": "Reverted",
        "subtraces": 5,
        "traceAddress": [],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 120771,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd000000000000000000000000fa35113163bfd33c18a01d1a62d4d14a1ed30a4200000000000000000000000084d1f4bbd0fb53b9a09e95e051f2fe1bf3e01e6a000000000000000000000000000000000000000000000b5a0ebbfe5a15da0000"
            ),
            "to": "0x6286A9e6f7e745A6D884561D88F94542d6715698",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 20711,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 97641,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes("0x0902f1ac"),
            "to": "0x84d1f4BBD0FB53b9a09e95E051f2fe1bF3e01e6A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2504,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000003cac63f6efb193364d5d200000000000000000000000000000000000000000000000755b352de71f2c1a600000000000000000000000000000000000000000000000000000000613a0acf"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 94841,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x022c0d9f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015a3896d5772879700000000000000000000000011111112542d85b3ef69ae05771c2dccff4faa2600000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x84d1f4BBD0FB53b9a09e95E051f2fe1bF3e01e6A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 47804, "output": HexBytes("0x")},
        "subtraces": 3,
        "traceAddress": [2],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x84d1f4BBD0FB53b9a09e95E051f2fe1bF3e01e6A",
            "gas": 80163,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb00000000000000000000000011111112542d85b3ef69ae05771c2dccff4faa2600000000000000000000000000000000000000000000000015a3896d57728797"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 12862,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [2, 0],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x84d1f4BBD0FB53b9a09e95E051f2fe1bF3e01e6A",
            "gas": 66901,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a0823100000000000000000000000084d1f4bbd0fb53b9a09e95e051f2fe1bf3e01e6a"
            ),
            "to": "0x6286A9e6f7e745A6D884561D88F94542d6715698",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 585,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000003d6204e2af973493ed5d2"
            ),
        },
        "subtraces": 0,
        "traceAddress": [2, 1],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x84d1f4BBD0FB53b9a09e95E051f2fe1bF3e01e6A",
            "gas": 65919,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a0823100000000000000000000000084d1f4bbd0fb53b9a09e95e051f2fe1bf3e01e6a"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 534,
            "output": HexBytes(
                "0x000000000000000000000000000000000000000000000007400fc9711a803a0f"
            ),
        },
        "subtraces": 0,
        "traceAddress": [2, 2],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 47597,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x2e1a7d4d00000000000000000000000000000000000000000000000015a3896d57728797"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 9219, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [3],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            "gas": 2300,
            "value": 1559240998711887767,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 79, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [3, 0],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 31832,
            "value": 1559240998711887767,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xfa35113163bFD33c18A01d1A62d4D14a1Ed30a42",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [4],
        "transactionHash": "0xd1118a18e43777636ccef0cafa5de58c3b0c6800454606342ba46a662828a8c6",
        "transactionPosition": 23,
        "type": "call",
    },
    {
        "action": {
            "from": "0xACc300998060e519d10977e25f8ef2455f5330f7",
            "gas": 28478,
            "value": 10000000000000000,
            "callType": "call",
            "input": HexBytes("0xd0e30db0"),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 23974, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x1ea951dcaf2bda8a8fb8251b2592561f35af0c879d78f34cd4ef9110f1b1b4c7",
        "transactionPosition": 24,
        "type": "call",
    },
    {
        "action": {
            "from": "0xc4F9F5F9910a59A58dB92a5ceEd80Ce1725C8855",
            "gas": 80836,
            "value": 80000000000000000,
            "callType": "call",
            "input": HexBytes(
                "0xba93c39c000000000000000000000000fc7b1dad07111c77c5d619043d75ac9a19680760000000000000000000000000c4f9f5f9910a59a58db92a5ceed80ce1725c88550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a0b86991c6218b36c1d19d4a2e9eb0ce3606eb48000000000000000000000000000000000000000000000000011c37937e080000000000000000000000000000000000000000000000000000011c37937e0800000000000000000000000000000000000000000000000000000000000010ea46140000000000000000000000000000000000000000000000000000000000c94a6e000000000000000000000000000000000000000000000000000000000000003f00000000000000000000000000000000000000000000000000000000000000000024cf29ee0de9b595a6dbddea0e2896d74de8ecbff141582259bb6b1513730200000000000000000000000000000000000000000000000000000000000001800000000000000000000000000000000000000000000000000000000000000041f8a8837c1fa4ec249ce079090fede86bfbf2273d2523186e0621e44af760eaf13d0c18a82851be01f690eee7cb71e8e2c470cf6552a5063deec2dc96ab6c193d1b00000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xa18607cA4A3804CC3Cd5730eafeFcC47a7641643",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 78872, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0x28790ea8588f1c24cbc3dacb95bad48556df979755563626652a9b3aa55799bf",
        "transactionPosition": 25,
        "type": "call",
    },
    {
        "action": {
            "from": "0xa18607cA4A3804CC3Cd5730eafeFcC47a7641643",
            "gas": 68089,
            "value": 80000000000000000,
            "callType": "call",
            "input": HexBytes(
                "0xecc0661a000000000000000000000000c4f9f5f9910a59a58db92a5ceed80ce1725c88550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a0b86991c6218b36c1d19d4a2e9eb0ce3606eb48000000000000000000000000000000000000000000000000011c37937e080000000000000000000000000000000000000000000000000000011c37937e0800000000000000000000000000000000000000000000000000000000000010ea4614000000000000000000000000000000000000000000000000000000000000003f00000000000000000000000000000000000000000000000000000000000000000024cf29ee0de9b595a6dbddea0e2896d74de8ecbff141582259bb6b1513730200000000000000000000000000000000000000000000000000000000000001400000000000000000000000000000000000000000000000000000000000000041f8a8837c1fa4ec249ce079090fede86bfbf2273d2523186e0621e44af760eaf13d0c18a82851be01f690eee7cb71e8e2c470cf6552a5063deec2dc96ab6c193d1b00000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xfc7b1daD07111c77c5d619043D75aC9A19680760",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 67101, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [0],
        "transactionHash": "0x28790ea8588f1c24cbc3dacb95bad48556df979755563626652a9b3aa55799bf",
        "transactionPosition": 25,
        "type": "call",
    },
    {
        "action": {
            "from": "0xfc7b1daD07111c77c5d619043D75aC9A19680760",
            "gas": 64354,
            "value": 80000000000000000,
            "callType": "delegatecall",
            "input": HexBytes(
                "0xecc0661a000000000000000000000000c4f9f5f9910a59a58db92a5ceed80ce1725c88550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a0b86991c6218b36c1d19d4a2e9eb0ce3606eb48000000000000000000000000000000000000000000000000011c37937e080000000000000000000000000000000000000000000000000000011c37937e0800000000000000000000000000000000000000000000000000000000000010ea4614000000000000000000000000000000000000000000000000000000000000003f00000000000000000000000000000000000000000000000000000000000000000024cf29ee0de9b595a6dbddea0e2896d74de8ecbff141582259bb6b1513730200000000000000000000000000000000000000000000000000000000000001400000000000000000000000000000000000000000000000000000000000000041f8a8837c1fa4ec249ce079090fede86bfbf2273d2523186e0621e44af760eaf13d0c18a82851be01f690eee7cb71e8e2c470cf6552a5063deec2dc96ab6c193d1b00000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x20EF25713c37855fbB8ED483eFDDFF9407442650",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 64354, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [0, 0],
        "transactionHash": "0x28790ea8588f1c24cbc3dacb95bad48556df979755563626652a9b3aa55799bf",
        "transactionPosition": 25,
        "type": "call",
    },
    {
        "action": {
            "from": "0xfc7b1daD07111c77c5d619043D75aC9A19680760",
            "gas": 46228,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000c4f9f5f9910a59a58db92a5ceed80ce1725c88550000000000000000000000000000000000000000000000000000000010ea4614"
            ),
            "to": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 44017,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [0, 0, 0],
        "transactionHash": "0x28790ea8588f1c24cbc3dacb95bad48556df979755563626652a9b3aa55799bf",
        "transactionPosition": 25,
        "type": "call",
    },
    {
        "action": {
            "from": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            "gas": 38374,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000c4f9f5f9910a59a58db92a5ceed80ce1725c88550000000000000000000000000000000000000000000000000000000010ea4614"
            ),
            "to": "0xa2327a938Febf5FEC13baCFb16Ae10EcBc4cbDCF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 36728,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0, 0, 0, 0],
        "transactionHash": "0x28790ea8588f1c24cbc3dacb95bad48556df979755563626652a9b3aa55799bf",
        "transactionPosition": 25,
        "type": "call",
    },
    {
        "action": {
            "from": "0x0211677061fB97872dD015d23fe44F3A0066Ccc3",
            "gas": 25197,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa22cb465000000000000000000000000e987cbec33f573b020e7c5672f8008d847ab8b420000000000000000000000000000000000000000000000000000000000000001"
            ),
            "to": "0x9640C1a69eadD073D273D75028a1D233CD63016C",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 25197, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xaaae290a863c7a364941fa047c5c18d0ea0e30f1cb3401537e274576a227b1b0",
        "transactionPosition": 26,
        "type": "call",
    },
    {
        "action": {
            "from": "0xAe45a8240147E6179ec7c9f92c5A18F9a97B3fCA",
            "gas": 0,
            "value": 5975748000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x61296A581598F58fA5841B44904D376eDA01127A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xc1338a392bbb9271c0de47705148127ed3685159918424a2431e085d67b0ef26",
        "transactionPosition": 27,
        "type": "call",
    },
    {
        "action": {
            "from": "0x1E9bABdb4743DbaAf287352BC9D3d8c31B0ff327",
            "gas": 162307,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x875b4f6300000000000000000000000000000000000000000000000000000000000000600000000000000000000000002f8a0eecb02a2aa17e3db6de777ea0d941984cfa0000000000000000000000000000000000000000000000000000000000000120000000000000000000000000000000000000000000000000000000000000000500000000000000000000000000000000000000000000000000000000000000fa00000000000000000000000000000000000000000000000000000000000002b0000000000000000000000000000000000000000000000000000000000000019d000000000000000000000000000000000000000000000000000000000000055a00000000000000000000000000000000000000000000000000000000000001bd00000000000000000000000000000000000000000000000000000000000000414fbe56bde7330228ad9399e9513544bcee5376331067d3ef651d2b41fb14df10039175fd80a5131928082c52e1f9fd497c3dc7b7d09334d6e5663b09728579721b00000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x00D07C53E70338c376cF6ab2A5218d8643115084",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 160190, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x662483ec1961250e0f24c9adffcf8d96d43418f573448867ecbdf65a31dd331c",
        "transactionPosition": 28,
        "type": "call",
    },
    {
        "action": {
            "from": "0x7F9Bb16Bb280D93e6e465420fD02d28b3A8fbc5f",
            "gas": 211566,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x5f5755290000000000000000000000000000000000000000000000000000000000000080000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a00000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000000000000000000c000000000000000000000000000000000000000000000000000000000000000136f6e65496e6368563346656544796e616d6963000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004476f38446e3da000000000000000000000000000000000000000000000000000000000000001200000000000000000000000000000000000000000000000000009f7fe35818eae00000000000000000000000011ededebf63bef0ea2d2d071bdf88f71543ec6fb000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000c42e95b6c8000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a00000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004511aa72b8812440000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000140000000000000003b6d0340643b47d668f7bd78e0eeaa574b0d185c46ef079c00000000000000000000000000000000000000000000000000000000ab"
            ),
            "to": "0x881D40237659C251811CEC9c364ef91dC08D300C",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 179647, "output": HexBytes("0x")},
        "subtraces": 2,
        "traceAddress": [],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x881D40237659C251811CEC9c364ef91dC08D300C",
            "gas": 196872,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd0000000000000000000000007f9bb16bb280d93e6e465420fd02d28b3a8fbc5f00000000000000000000000074de5d4fcbf63e00296fd95d33236b979401663100000000000000000000000000000000000000000000004e184ccf4dc2aa7a88"
            ),
            "to": "0x217ddEad61a42369A266F1Fb754EB5d3EBadc88a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 38792,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x881D40237659C251811CEC9c364ef91dC08D300C",
            "gas": 149180,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xe35473350000000000000000000000004fed27eac9c2477b8c14ee8bada444bd4654f8330000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000022492f5f0370000000000000000000000007f9bb16bb280d93e6e465420fd02d28b3a8fbc5f000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004476f38446e3da000000000000000000000000000000000000000000000000000000000000001200000000000000000000000000000000000000000000000000009f7fe35818eae00000000000000000000000011ededebf63bef0ea2d2d071bdf88f71543ec6fb000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000c42e95b6c8000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a00000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004511aa72b8812440000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000140000000000000003b6d0340643b47d668f7bd78e0eeaa574b0d185c46ef079c0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 117818, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [1],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 141939,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x92f5f0370000000000000000000000007f9bb16bb280d93e6e465420fd02d28b3a8fbc5f000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004476f38446e3da000000000000000000000000000000000000000000000000000000000000001200000000000000000000000000000000000000000000000000009f7fe35818eae00000000000000000000000011ededebf63bef0ea2d2d071bdf88f71543ec6fb000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000c42e95b6c8000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a00000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004511aa72b8812440000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000140000000000000003b6d0340643b47d668f7bd78e0eeaa574b0d185c46ef079c00000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x4fEd27Eac9C2477B8c14Ee8baDA444BD4654F833",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 112694, "output": HexBytes("0x")},
        "subtraces": 5,
        "traceAddress": [1, 0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 138838,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0xdd62ed3e00000000000000000000000074de5d4fcbf63e00296fd95d33236b979401663100000000000000000000000011111112542d85b3ef69ae05771c2dccff4faa26"
            ),
            "to": "0x217ddEad61a42369A266F1Fb754EB5d3EBadc88a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 3241,
            "output": HexBytes(
                "0xffffffffffffffffffffffffffffffffffffffffffff650eadd360798758cea6"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 131716,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x2e95b6c8000000000000000000000000217ddead61a42369a266f1fb754eb5d3ebadc88a00000000000000000000000000000000000000000000004e184ccf4dc2aa7a8800000000000000000000000000000000000000000000000004511aa72b8812440000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000140000000000000003b6d0340643b47d668f7bd78e0eeaa574b0d185c46ef079c"
            ),
            "to": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 85953,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000000000004734857e2fb2007"
            ),
        },
        "subtraces": 5,
        "traceAddress": [1, 0, 1],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 128791,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd00000000000000000000000074de5d4fcbf63e00296fd95d33236b9794016631000000000000000000000000643b47d668f7bd78e0eeaa574b0d185c46ef079c00000000000000000000000000000000000000000000004e184ccf4dc2aa7a88"
            ),
            "to": "0x217ddEad61a42369A266F1Fb754EB5d3EBadc88a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 14892,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 111388,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes("0x0902f1ac"),
            "to": "0x643b47D668f7BD78E0EeaA574b0d185c46Ef079C",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2504,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000003f3c270741545064e830000000000000000000000000000000000000000000000003e47aebd48870924000000000000000000000000000000000000000000000000000000006139fc25"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 1],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 108589,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x022c0d9f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004734857e2fb200700000000000000000000000011111112542d85b3ef69ae05771c2dccff4faa2600000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x643b47D668f7BD78E0EeaA574b0d185c46Ef079C",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 48105, "output": HexBytes("0x")},
        "subtraces": 3,
        "traceAddress": [1, 0, 1, 2],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x643b47D668f7BD78E0EeaA574b0d185c46Ef079C",
            "gas": 93696,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb00000000000000000000000011111112542d85b3ef69ae05771c2dccff4faa2600000000000000000000000000000000000000000000000004734857e2fb2007"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 12862,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 2, 0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x643b47D668f7BD78E0EeaA574b0d185c46Ef079C",
            "gas": 80434,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a08231000000000000000000000000643b47d668f7bd78e0eeaa574b0d185c46ef079c"
            ),
            "to": "0x217ddEad61a42369A266F1Fb754EB5d3EBadc88a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 886,
            "output": HexBytes(
                "0x000000000000000000000000000000000000000000000441dabd436307b0c90b"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 2, 1],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x643b47D668f7BD78E0EeaA574b0d185c46Ef079C",
            "gas": 79156,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a08231000000000000000000000000643b47d668f7bd78e0eeaa574b0d185c46ef079c"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 534,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000000000039d46665658be91d"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 2, 2],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 61048,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x2e1a7d4d00000000000000000000000000000000000000000000000004734857e2fb2007"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 9219, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [1, 0, 1, 3],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            "gas": 2300,
            "value": 320679540780900359,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 79, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 3, 0],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x11111112542D85B3EF69AE05771c2dCCff4fAa26",
            "gas": 45283,
            "value": 320679540780900359,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 40, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 0, 1, 4],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 37538,
            "value": 2805945981832878,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x11eDedebF63bef0ea2d2D071bdF88F71543ec6fB",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 0, 2],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 37015,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a0823100000000000000000000000074de5d4fcbf63e00296fd95d33236b9794016631"
            ),
            "to": "0x217ddEad61a42369A266F1Fb754EB5d3EBadc88a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 886,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000000"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0, 3],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0x74de5d4FCbf63E00296fd95d33236B9794016631",
            "gas": 28967,
            "value": 317873594799067481,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x7F9Bb16Bb280D93e6e465420fD02d28b3A8fbc5f",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 0, 4],
        "transactionHash": "0x7cd9fdf8ba8f3378d428e1cbb353a28142b28946840353df07b1140b5849b850",
        "transactionPosition": 29,
        "type": "call",
    },
    {
        "action": {
            "from": "0xb5d85CBf7cB3EE0D56b3bB207D5Fc4B82f43F511",
            "gas": 0,
            "value": 67660500000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x59b6E0185a290aC466A6c4B60093e33afeC7169b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xfc4763a159754d4839c1ca85382ba5f66be2cbfc33df28005e33c4928b541f97",
        "transactionPosition": 30,
        "type": "call",
    },
    {
        "action": {
            "from": "0x3cD751E6b0078Be393132286c442345e5DC49699",
            "gas": 0,
            "value": 70391500000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x1521A41240C40Cf441cc68dD7E0EED06e3dC72fF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x709198fe8195723ab00c2edf265ded5267dff4a7dcda49098a4783b4473b115e",
        "transactionPosition": 31,
        "type": "call",
    },
    {
        "action": {
            "from": "0xddfAbCdc4D8FfC6d5beaf154f18B778f892A0740",
            "gas": 0,
            "value": 119404330000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xA837149C978776B322fC7A6245a46AE89a4c5385",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xaa0a0d4f8bf778e909c48dcd13397140bfb791d86acf35a14f5271e44cfeac8f",
        "transactionPosition": 32,
        "type": "call",
    },
    {
        "action": {
            "from": "0x71660c4005BA85c37ccec55d0C4493E66Fe775d3",
            "gas": 228404,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000f068633504bf13523ed3c976c33bd842502b377b0000000000000000000000000000000000000000000000000000000037131f00"
            ),
            "to": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 44017,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0xb3d846d3937d048de62e482bc19d5fc8447a74fdd3b709b64b52b33da0ffcdab",
        "transactionPosition": 33,
        "type": "call",
    },
    {
        "action": {
            "from": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            "gas": 217704,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000f068633504bf13523ed3c976c33bd842502b377b0000000000000000000000000000000000000000000000000000000037131f00"
            ),
            "to": "0xa2327a938Febf5FEC13baCFb16Ae10EcBc4cbDCF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 36728,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0xb3d846d3937d048de62e482bc19d5fc8447a74fdd3b709b64b52b33da0ffcdab",
        "transactionPosition": 33,
        "type": "call",
    },
    {
        "action": {
            "from": "0x538CD83410D14d615590fb370E008F839CEA6024",
            "gas": 0,
            "value": 45600000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xCF5A1c6E4e157d63883f3aE9E62cAD2729838580",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x1ef77ab2e12ad5808999b5ee99ee93aa24a559849c7e2a9096ffbe7d56353b9b",
        "transactionPosition": 34,
        "type": "call",
    },
    {
        "action": {
            "from": "0x0C86284199fB87A0b391b02883b6613816393bFE",
            "gas": 50968,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x095ea7b30000000000000000000000007a250d5630b4cf539739df2c5dacb4c659f2488dffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
            ),
            "to": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 38367,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0xc7c7d796f48e336a5d895e064116ef21f1ba73826ab7b4cba208df47c03ce4ac",
        "transactionPosition": 35,
        "type": "call",
    },
    {
        "action": {
            "from": "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            "gas": 43040,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x095ea7b30000000000000000000000007a250d5630b4cf539739df2c5dacb4c659f2488dffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
            ),
            "to": "0xa2327a938Febf5FEC13baCFb16Ae10EcBc4cbDCF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 31078,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0xc7c7d796f48e336a5d895e064116ef21f1ba73826ab7b4cba208df47c03ce4ac",
        "transactionPosition": 35,
        "type": "call",
    },
    {
        "action": {
            "from": "0x02736d5c8dcea65539993d143A3DE90ceBcA9c3c",
            "gas": 160566,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xac9650d800000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000001800000000000000000000000000000000000000000000000000000000000000104414bf389000000000000000000000000ba7970f10d9f0531941dced1dda7ef3016b24e5b000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc20000000000000000000000000000000000000000000000000000000000002710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000613a11bc0000000000000000000000000000000000000000000000375c21cee45ab3852000000000000000000000000000000000000000000000000000eab1df8814dbac000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004449404b7c00000000000000000000000000000000000000000000000000eab1df8814dbac00000000000000000000000002736d5c8dcea65539993d143a3de90cebca9c3c00000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 128244,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000f66df78215e6a80000000000000000000000000000000000000000000000000000000000000000"
            ),
        },
        "subtraces": 2,
        "traceAddress": [],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 156855,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x414bf389000000000000000000000000ba7970f10d9f0531941dced1dda7ef3016b24e5b000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc20000000000000000000000000000000000000000000000000000000000002710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000613a11bc0000000000000000000000000000000000000000000000375c21cee45ab3852000000000000000000000000000000000000000000000000000eab1df8814dbac0000000000000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 107077,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000000000000f66df78215e6a8"
            ),
        },
        "subtraces": 1,
        "traceAddress": [0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 147471,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x128acb08000000000000000000000000e592427a0aece92de3edee1f18e0157c0586156400000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000375c21cee45ab3852000000000000000000000000000000000000000000000000000000001000276a400000000000000000000000000000000000000000000000000000000000000a000000000000000000000000000000000000000000000000000000000000000c00000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000004000000000000000000000000002736d5c8dcea65539993d143a3de90cebca9c3c000000000000000000000000000000000000000000000000000000000000002bba7970f10d9f0531941dced1dda7ef3016b24e5b002710c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000000000000000000000"
            ),
            "to": "0xC00C5977395664267c118d71569DCCF4BC37bF5F",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 99638,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000375c21cee45ab38520ffffffffffffffffffffffffffffffffffffffffffffffffff0992087dea1958"
            ),
        },
        "subtraces": 4,
        "traceAddress": [0, 0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC00C5977395664267c118d71569DCCF4BC37bF5F",
            "gas": 110017,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa9059cbb000000000000000000000000e592427a0aece92de3edee1f18e0157c0586156400000000000000000000000000000000000000000000000000f66df78215e6a8"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 29962,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0, 0, 0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC00C5977395664267c118d71569DCCF4BC37bF5F",
            "gas": 77191,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a08231000000000000000000000000c00c5977395664267c118d71569dccf4bc37bf5f"
            ),
            "to": "0xbA7970f10D9f0531941DcEd1dda7ef3016B24e5b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 2577,
            "output": HexBytes(
                "0x000000000000000000000000000000000000000000037a542567ad1af50e9ee7"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0, 0, 1],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC00C5977395664267c118d71569DCCF4BC37bF5F",
            "gas": 73864,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xfa461e330000000000000000000000000000000000000000000000375c21cee45ab38520ffffffffffffffffffffffffffffffffffffffffffffffffff0992087dea1958000000000000000000000000000000000000000000000000000000000000006000000000000000000000000000000000000000000000000000000000000000c00000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000004000000000000000000000000002736d5c8dcea65539993d143a3de90cebca9c3c000000000000000000000000000000000000000000000000000000000000002bba7970f10d9f0531941dced1dda7ef3016b24e5b002710c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000000000000000000000"
            ),
            "to": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 22278, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [0, 0, 2],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 69034,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd00000000000000000000000002736d5c8dcea65539993d143a3de90cebca9c3c000000000000000000000000c00c5977395664267c118d71569dccf4bc37bf5f0000000000000000000000000000000000000000000000375c21cee45ab38520"
            ),
            "to": "0xbA7970f10D9f0531941DcEd1dda7ef3016B24e5b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 18222,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0, 0, 2, 0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC00C5977395664267c118d71569DCCF4BC37bF5F",
            "gas": 51301,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a08231000000000000000000000000c00c5977395664267c118d71569dccf4bc37bf5f"
            ),
            "to": "0xbA7970f10D9f0531941DcEd1dda7ef3016B24e5b",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 577,
            "output": HexBytes(
                "0x000000000000000000000000000000000000000000037a8b81897bff4fc22407"
            ),
        },
        "subtraces": 0,
        "traceAddress": [0, 0, 3],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 50754,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x49404b7c00000000000000000000000000000000000000000000000000eab1df8814dbac00000000000000000000000002736d5c8dcea65539993d143a3de90cebca9c3c"
            ),
            "to": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 18173, "output": HexBytes("0x")},
        "subtraces": 3,
        "traceAddress": [1],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 49257,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x70a08231000000000000000000000000e592427a0aece92de3edee1f18e0157c05861564"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 534,
            "output": HexBytes(
                "0x00000000000000000000000000000000000000000000000000f66df78215e6a8"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1, 0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 48288,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x2e1a7d4d00000000000000000000000000000000000000000000000000f66df78215e6a8"
            ),
            "to": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 9223, "output": HexBytes("0x")},
        "subtraces": 1,
        "traceAddress": [1, 1],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            "gas": 2300,
            "value": 69363754077644456,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 83, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 1, 0],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0xE592427A0AEce92De3Edee1F18E0157C05861564",
            "gas": 32209,
            "value": 69363754077644456,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x02736d5c8dcea65539993d143A3DE90ceBcA9c3c",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [1, 2],
        "transactionHash": "0x2407e6b8a5be763a5f8c280f1ae10ff000ebaf75e1530a0f3651987ba311b2ba",
        "transactionPosition": 36,
        "type": "call",
    },
    {
        "action": {
            "from": "0x73800459807528072A3B2eD217c1De72F28514f3",
            "gas": 734311,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xcb133b0f0000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000d8800000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000006000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000005000000000000000000000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000001"
            ),
            "to": "0xC0981Df196dc6c6fb8673B912B07956256D7e9fF",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 734311, "output": HexBytes("0x")},
        "subtraces": 4,
        "traceAddress": [],
        "transactionHash": "0xf5e2ebf727d16274508ca3bd5f26929327e3a1fec8b6aafae19d42972547c153",
        "transactionPosition": 37,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC0981Df196dc6c6fb8673B912B07956256D7e9fF",
            "gas": 716086,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd00000000000000000000000073800459807528072a3b2ed217c1de72f28514f3000000000000000000000000c0981df196dc6c6fb8673b912b07956256d7e9ff0000000000000000000000000000000000000000000000000000000000000d88"
            ),
            "to": "0xdEcC60000ba66700a009b8F9F7D82676B5cfA88A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 76963, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [0],
        "transactionHash": "0xf5e2ebf727d16274508ca3bd5f26929327e3a1fec8b6aafae19d42972547c153",
        "transactionPosition": 37,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC0981Df196dc6c6fb8673B912B07956256D7e9fF",
            "gas": 453672,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes("0x95d89b41"),
            "to": "0xa6233451039230fAe712371dD7526f6Df7625E1f",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 3294,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000449524f4e00000000000000000000000000000000000000000000000000000000"
            ),
        },
        "subtraces": 0,
        "traceAddress": [1],
        "transactionHash": "0xf5e2ebf727d16274508ca3bd5f26929327e3a1fec8b6aafae19d42972547c153",
        "transactionPosition": 37,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC0981Df196dc6c6fb8673B912B07956256D7e9fF",
            "gas": 444267,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0x0f14d01a00000000000000000000000000000000000000000000000000000000000000a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000034000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000d8800000000000000000000000000000000000000000000000000000000000000e00000000000000000000000000000000000000000000000000000000000000120000000000000000000000000000000000000000000000000000000000000016000000000000000000000000000000000000000000000000000000000000001a000000000000000000000000000000000000000000000000000000000000001e000000000000000000000000000000000000000000000000000000000000002200000000000000000000000000000000000000000000000000000000000000260000000000000000000000000000000000000000000000000000000000000000743617069746f6c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000641737472616c000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000084d6564696576616c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000055761746572000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000757617272696e6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c4469637461746f72736869700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000856616c68616c6c61000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000449524f4e00000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0x787D1B8bFe2142af127e62dcc15D63D6D708f85F",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 191993,
            "output": HexBytes(
                "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"
            ),
        },
        "subtraces": 0,
        "traceAddress": [2],
        "transactionHash": "0xf5e2ebf727d16274508ca3bd5f26929327e3a1fec8b6aafae19d42972547c153",
        "transactionPosition": 37,
        "type": "call",
    },
    {
        "action": {
            "from": "0xC0981Df196dc6c6fb8673B912B07956256D7e9fF",
            "gas": 245691,
            "value": 0,
            "callType": "staticcall",
            "input": HexBytes(
                "0xc87b56dd0000000000000000000000000000000000000000000000000000000000000d88"
            ),
            "to": "0xdEcC60000ba66700a009b8F9F7D82676B5cfA88A",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 217795,
            "output": HexBytes(
                "0x000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000006cd646174613a6170706c69636174696f6e2f6a736f6e3b6261736536342c65794a755957316c496a6f67496c4e6c644852735a57316c626e5167497a4d304e6a51694c4341695a47567a59334a7063485270623234694f694169553256306447786c6257567564484d6759584a6c49474567644856796269426959584e6c5a43426a61585a7062476c7a595852706232346763326c74645778686447397949484e3062334a6c5a43426c626e5270636d5673655342766269426a61474670626977675a3238675a6d3979644767675957356b49474e76626e46315a58497549697767496d6c745957646c496a6f67496d526864474536615731685a32557663335a6e4b3368746244746959584e6c4e6a51735545684f4d6c7035516a52695633683159336f7761574649556a426a5247393254444e6b4d3252354e544e4e655456325932316a646b31715158644e517a6c365a47316a61556c49516e6c61574535735932356162464659546e646156303477565731474d4746584f446c4a626d684f59566331576c52586248564a527a4673576c685261556c49576e426157475244596a4e6e4f556c715157644e51304636546c52425a3031365658644a616a5134597a4e534e574a485653744d626c49305a454e434e306c48576e4269523363325355644b63316c58546e4a5065554a74596a49314d457858576d68695632787a5a5652765a324a584f5856694d3035335756644f62453935516d31694d6a55775446684f6347567456545a4a524556355930686e4e325a5564335a6a4d314931596b64564b314249536d785a4d31466e5a444a73613252485a7a6c4a616b563354554e5661556c4861477868563252765a455177615531555158644b55306c6e576d317363324a454d476c6b4d6d68775a45645661556c444f43745153464a735a5568525a3256454d476c4e56454670535568724f556c715358644a61554a71596b6447656d4e364d476c6b5347677753576f3152466c59516e426b527a6c7a55454d354d46705961444251616e6777576c686f4d456c495a7a6c4a616b563353576c434e5642545354424e51306c6e57544a3461474d7a54546c4a626c49305a454e4a4b314659546a426a62555a7a55454d354d46705961444251616e6777576c686f4d456c495a7a6c4a616b563353576c434e56425453544a4e51306c6e57544a3461474d7a54546c4a626c49305a454e4a4b315258566d746856315979575664334f45777a556d786c5346457255456853624756495557646c524442705456524261556c49617a6c4a616d643353576c43616d4a48526e706a656a42705a45686f4d456c714e56685a57464a7359327033646d5248566a526b524451345a4564574e475244516a525155306c3454554e4a5a3256554d476c4e5645463353576c43616d4a48526e706a656a42705a45686f4d456c714e56685a5745703559566331626c42444f54426157476777554770344d4670596144424a534763355357704664306c70516a565155306c345457704261556c48546e4e5a5745353655464e4b4d47564955576c5161314a7757544e53614752484f586c6a4d6d687759305233646d5248566a526b524451345a4564574e475244516a525155306c3454554e4a5a3256554d476c4e5646463353576c43616d4a48526e706a656a42705a45686f4d456c714e56645a563368765756643463316c5564335a6b523159305a4551304f45777a546a4a61656a51394969776959585230636d6c696458526c6379493657337367496e527959576c3058335235634755694f69416955326c365a53497349434a32595778315a53493649434a445958427064473973496942394c43423749434a30636d4670644639306558426c496a6f67496c4e7761584a706443497349434a32595778315a53493649434a4263335279595777694948307349487367496e527959576c3058335235634755694f6941695157646c49697767496e5a686248566c496a6f67496b316c5a476c6c646d4673496942394c43423749434a30636d4670644639306558426c496a6f67496c4a6c63323931636d4e6c49697767496e5a686248566c496a6f67496c646864475679496942394c43423749434a30636d4670644639306558426c496a6f67496b3176636d46735a53497349434a32595778315a53493649434a5859584a796157356e496942394c43423749434a30636d4670644639306558426c496a6f67496b6476646d5679626d316c626e51694c434169646d4673645755694f69416952476c6a6447463062334a7a61476c77496942394c43423749434a30636d4670644639306558426c496a6f67496c4a6c5957787449697767496e5a686248566c496a6f67496c5a686247686862477868496942395858303d00000000000000000000000000000000000000"
            ),
        },
        "subtraces": 0,
        "traceAddress": [3],
        "transactionHash": "0xf5e2ebf727d16274508ca3bd5f26929327e3a1fec8b6aafae19d42972547c153",
        "transactionPosition": 37,
        "type": "call",
    },
    {
        "action": {
            "from": "0x3907f6bC753b6A0B0ff1C68cdd3595A940a4C16A",
            "gas": 0,
            "value": 35400000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x9e8b2990f80ce4bAEF5cD6b7049e8cCF02813eB1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xc883289f103aa8ce65340eb880b4e99598707090af3f35ac38d983d59b3c272c",
        "transactionPosition": 38,
        "type": "call",
    },
    {
        "action": {
            "from": "0x3A49309413793b32F6A308769220147feDbFfa5f",
            "gas": 24984,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0xa22cb465000000000000000000000000e1f3bdd68f24934fe154fcf2c885b58d7cb0eaf60000000000000000000000000000000000000000000000000000000000000001"
            ),
            "to": "0xdDA32aabBBB6c44eFC567baC5F7C35f185338456",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 24984, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xc05e8ce528fd257471f3961ee467d56f80a17f75be6a0b8d11a2bfe25fdb8763",
        "transactionPosition": 39,
        "type": "call",
    },
    {
        "action": {
            "from": "0xd34AE229C5E8493bFC25FA17a7a04A3d72d0a455",
            "gas": 0,
            "value": 200000000000000000,
            "callType": "call",
            "input": HexBytes("0x"),
            "to": "0x77ACC06250552c8A96e9560670328974386D632F",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 0, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xaae3e3d36a7d210372e22920a103a5cbe695d6c273bfa46eb7bc7bf903c669c4",
        "transactionPosition": 40,
        "type": "call",
    },
    {
        "action": {
            "from": "0xecbeCd7369D708B2fb6489220dd045144F168328",
            "gas": 24659,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x095ea7b30000000000000000000000008692e782ea478623f3342e0fb3936f6530c5d54f00000000000000000000000000000000000000000000000000000005b5d429bc"
            ),
            "to": "0x3C4B6E6e1eA3D4863700D7F76b36B7f3D3f13E3d",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 24659,
            "output": HexBytes(
                "0x0000000000000000000000000000000000000000000000000000000000000001"
            ),
        },
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0x31aecc7e3c6c9062caf6532ec45a9239b85490fa85396d8c00cfc39f55e9138b",
        "transactionPosition": 41,
        "type": "call",
    },
    {
        "action": {
            "from": "0x229D6a31d0CF2225837DB8C82A6c78De5cDe114d",
            "gas": 20840,
            "value": 0,
            "callType": "call",
            "input": HexBytes(
                "0x23b872dd000000000000000000000000229d6a31d0cf2225837db8c82a6c78de5cde114d000000000000000000000000bc1eb4359ab755af079f6ef77e3faac465e53eda0000000000000000000000000000000000000000000000000000000000010cdd"
            ),
            "to": "0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 20840, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": "0xb26b3e31995258eecbd92e61f1d222bd16369c83eae85a4760776cb5adef26cf",
        "transactionPosition": 42,
        "type": "call",
    },
    {
        "action": {
            "from": "0x1B320348DcF5Fe741161c87BD321f4170Bf5FE45",
            "gas": 495819,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0xddd81f82"),
            "to": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 376538,
            "output": HexBytes(
                "0x0000000000000000000000001f4e3e948830f342c9e575155f7929b3512d0788"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0x87a0b62f5d2350e2161abfc9071c68a964272ec288c1e00d564437a01d48ef53",
        "transactionPosition": 43,
        "type": "call",
    },
    {
        "action": {
            "from": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
            "gas": 450467,
            "value": 0,
            "init": HexBytes(
                "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"
            ),
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 317883,
            "code": HexBytes(
                "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"
            ),
            "address": "0x1f4E3e948830F342c9E575155f7929b3512D0788",
        },
        "subtraces": 1,
        "traceAddress": [0],
        "transactionHash": "0x87a0b62f5d2350e2161abfc9071c68a964272ec288c1e00d564437a01d48ef53",
        "transactionPosition": 43,
        "type": "create",
    },
    {
        "action": {
            "from": "0x1f4E3e948830F342c9E575155f7929b3512D0788",
            "gas": 394870,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x485cc9550000000000000000000000001b320348dcf5fe741161c87bd321f4170bf5fe45000000000000000000000000a5409ec958c83c3f309868babaca7c86dcb077c100000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xF9e266af4BcA5890e2781812cc6a6E89495a79f2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 45120, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [0, 0],
        "transactionHash": "0x87a0b62f5d2350e2161abfc9071c68a964272ec288c1e00d564437a01d48ef53",
        "transactionPosition": 43,
        "type": "call",
    },
    {
        "action": {
            "from": "0x26B675Fc79EA35805b6594857c429CFe2D5f1509",
            "gas": 495819,
            "value": 0,
            "callType": "call",
            "input": HexBytes("0xddd81f82"),
            "to": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 376538,
            "output": HexBytes(
                "0x00000000000000000000000050198a0c9de7d342fdbb24f57242dddf25b2d1b6"
            ),
        },
        "subtraces": 1,
        "traceAddress": [],
        "transactionHash": "0x73c429f04ca56cd06ec53cfdaf845faf6f284e368eeeb310b1b7b825fa70a6db",
        "transactionPosition": 44,
        "type": "call",
    },
    {
        "action": {
            "from": "0xa5409ec958C83C3f309868babACA7c86DCB077c1",
            "gas": 450467,
            "value": 0,
            "init": HexBytes(
                "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"
            ),
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {
            "gasUsed": 317883,
            "code": HexBytes(
                "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"
            ),
            "address": "0x50198a0C9De7d342FDbb24F57242dDDf25B2d1b6",
        },
        "subtraces": 1,
        "traceAddress": [0],
        "transactionHash": "0x73c429f04ca56cd06ec53cfdaf845faf6f284e368eeeb310b1b7b825fa70a6db",
        "transactionPosition": 44,
        "type": "create",
    },
    {
        "action": {
            "from": "0x50198a0C9De7d342FDbb24F57242dDDf25B2d1b6",
            "gas": 394870,
            "value": 0,
            "callType": "delegatecall",
            "input": HexBytes(
                "0x485cc95500000000000000000000000026b675fc79ea35805b6594857c429cfe2d5f1509000000000000000000000000a5409ec958c83c3f309868babaca7c86dcb077c100000000000000000000000000000000000000000000000000000000"
            ),
            "to": "0xF9e266af4BcA5890e2781812cc6a6E89495a79f2",
        },
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": {"gasUsed": 45120, "output": HexBytes("0x")},
        "subtraces": 0,
        "traceAddress": [0, 0],
        "transactionHash": "0x73c429f04ca56cd06ec53cfdaf845faf6f284e368eeeb310b1b7b825fa70a6db",
        "transactionPosition": 44,
        "type": "call",
    },
    {
        "action": {"value": 2000000000000000000},
        "blockHash": "0x8f9809f6012f85803956a419e2e54914dfdebba33e4f7a0d1574b12e92499c0e",
        "blockNumber": 13191781,
        "result": None,
        "subtraces": 0,
        "traceAddress": [],
        "transactionHash": None,
        "transactionPosition": None,
        "type": "reward",
    },
]
