# This file is generated by coder.py. DO NOT EDIT!
# isort: skip_file
# flake8: noqa F401,F811
# fmt: off

from __future__ import annotations

from gaphor.core.modeling.properties import (
    association,
    attribute as _attribute,
    derived,
    derivedunion,
    enumeration as _enumeration,
    redefine,
    relation_many,
    relation_one,
)


from typing import Callable


from gaphor.core.modeling.element import Element
class NamedElement(Element):
    clientDependency: relation_many[Dependency]
    informationFlow: relation_many[InformationFlow]
    memberNamespace: relation_many[Namespace]
    name: _attribute[str] = _attribute("name", str)
    namespace: relation_one[Namespace]
    qualifiedName: derived[list[str]]
    supplierDependency: relation_many[Dependency]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class PackageableElement(NamedElement):
    component: relation_one[Component]
    owningPackage: relation_one[Package]


class DeployedArtifact(NamedElement):
    deployment: relation_many[Deployment]


class DeploymentTarget(NamedElement):
    deployment: relation_many[Deployment]


class InstanceSpecification(DeployedArtifact, DeploymentTarget, PackageableElement):
    classifier: relation_many[Classifier]
    extended: relation_many[Element]
    slot: relation_many[Slot]
    specification: _attribute[str] = _attribute("specification", str)


class EnumerationLiteral(InstanceSpecification):
    enumeration: relation_one[Enumeration]


class Relationship(Element):
    relatedElement: relation_many[Element]


class DirectedRelationship(Relationship):
    source: relation_many[Element]
    target: relation_many[Element]


class PackageMerge(DirectedRelationship):
    mergedPackage: relation_one[Package]
    mergingPackage: relation_one[Package]


class RedefinableElement(NamedElement):
    isLeaf: _attribute[int] = _attribute("isLeaf", int, default=True)
    redefinedElement: relation_many[RedefinableElement]
    redefinitionContext: relation_many[Classifier]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class Namespace(NamedElement):
    elementImport: relation_many[ElementImport]
    importedMember: derivedunion[PackageableElement]
    member: relation_many[NamedElement]
    ownedMember: relation_many[NamedElement]
    ownedRule: relation_many[Constraint]
    packageImport: relation_many[PackageImport]


class Type(PackageableElement):
    package: relation_one[Package]


class Classifier(Namespace, RedefinableElement, Type):
    attribute: relation_many[Property]
    componentRealization: relation_many[ComponentRealization]
    feature: relation_many[Feature]
    general: derived[Classifier]
    generalization: relation_many[Generalization]
    inheritedMember: derivedunion[NamedElement]
    isAbstract: _attribute[int] = _attribute("isAbstract", int, default=False)
    nestingClass: relation_one[Class]
    ownedUseCase: relation_many[UseCase]
    redefinedClassifier: relation_many[Classifier]
    specialization: relation_many[Generalization]
    useCase: relation_many[UseCase]


class Association(Classifier, Relationship):
    endType: derived[Type]
    isDerived: _attribute[int] = _attribute("isDerived", int, default=False)
    memberEnd: relation_many[Property]
    navigableOwnedEnd: relation_many[Property]
    ownedEnd: relation_many[Property]


class Extension(Association):
    isRequired: _attribute[int] = _attribute("isRequired", int)
    metaclass: property
    ownedEnd: relation_one[ExtensionEnd]  # type: ignore[assignment]


class BehavioredClassifier(Classifier):
    interfaceRealization: relation_many[InterfaceRealization]
    ownedBehavior: relation_many[Behavior]


class Actor(BehavioredClassifier):
    pass


class ActivityNode(RedefinableElement):
    activity: relation_one[Activity]
    inGroup: relation_many[ActivityGroup]
    inPartition: relation_many[ActivityPartition]
    incoming: relation_many[ActivityEdge]
    outgoing: relation_many[ActivityEdge]
    redefinedElement: relation_many[ActivityNode]  # type: ignore[assignment]


class ControlNode(ActivityNode):
    pass


class MergeNode(ControlNode):
    pass


class Feature(RedefinableElement):
    featuringClassifier: relation_many[Classifier]
    isStatic: _attribute[int] = _attribute("isStatic", int, default=False)


class ActivityEdge(RedefinableElement):
    activity: relation_one[Activity]
    guard: _attribute[str] = _attribute("guard", str)
    inGroup: relation_many[ActivityGroup]
    redefinedElement: relation_many[ActivityEdge]  # type: ignore[assignment]
    source: relation_one[ActivityNode]
    target: relation_one[ActivityNode]


class ObjectFlow(ActivityEdge):
    pass


class FinalNode(ControlNode):
    pass


class ActivityFinalNode(FinalNode):
    pass


class CommunicationPath(Association):
    pass


class Dependency(DirectedRelationship, PackageableElement):
    client: relation_one[NamedElement]
    supplier: relation_one[NamedElement]


class Abstraction(Dependency):
    mapping: _attribute[str] = _attribute("mapping", str)


class Realization(Abstraction):
    pass


class TypedElement(NamedElement):
    type: relation_one[Type]
    typeValue: _attribute[str] = _attribute("typeValue", str)


class ObjectNode(ActivityNode, TypedElement):
    isControlType: _attribute[int] = _attribute("isControlType", int, default=False)
    ordering = _enumeration("ordering", ("unordered", "ordered", "LIFO", "FIFO"), "unordered")
    selection: relation_one[Behavior]
    upperBound: _attribute[str] = _attribute("upperBound", str)


class MultiplicityElement(Element):
    isOrdered: _attribute[int] = _attribute("isOrdered", int, default=True)
    isUnique: _attribute[int] = _attribute("isUnique", int, default=True)
    lower: _attribute[str]
    lowerValue: _attribute[str] = _attribute("lowerValue", str)
    upper: _attribute[str]
    upperValue: _attribute[str] = _attribute("upperValue", str)


class Pin(MultiplicityElement, ObjectNode):
    isControl: _attribute[int] = _attribute("isControl", int, default=False)


class Generalization(DirectedRelationship):
    general: relation_one[Classifier]
    isSubstitutable: _attribute[int] = _attribute("isSubstitutable", int)
    specific: relation_one[Classifier]


class StructuredClassifier(Classifier):
    ownedAttribute: relation_many[Property]
    ownedConnector: relation_many[Connector]
    part: property
    role: relation_many[ConnectableElement]


class EncapsulatedClassifier(StructuredClassifier):
    ownedPort: relation_many[Port]


class Class(BehavioredClassifier, EncapsulatedClassifier):
    extension: property
    isActive: _attribute[int] = _attribute("isActive", int, default=False)
    nestedClassifier: relation_many[Classifier]
    ownedAttribute: relation_many[Property]  # type: ignore[assignment]
    ownedOperation: relation_many[Operation]
    superClass: derived[Classifier]


class Node(Class, DeploymentTarget):
    nestedNode: relation_many[Node]
    node: relation_one[Node]


class Device(Node):
    pass


class StructuralFeature(Feature, MultiplicityElement, TypedElement):
    isReadOnly: _attribute[int] = _attribute("isReadOnly", int, default=False)
    slot: relation_many[Slot]


class UseCase(BehavioredClassifier):
    extend: relation_many[Extend]
    extensionPoint: relation_many[ExtensionPoint]
    include: relation_many[Include]
    subject: relation_many[Classifier]


class InputPin(Pin):
    opaqueAction: relation_one[Action]


class Manifestation(Abstraction):
    artifact: relation_one[Artifact]


class Component(Class):
    isIndirectlyInstantiated: _attribute[int] = _attribute("isIndirectlyInstantiated", int, default=True)
    packagedElement: relation_many[PackageableElement]
    provided: property
    realization: relation_many[ComponentRealization]
    required: property


class ConnectableElement(TypedElement):
    end: relation_many[ConnectorEnd]


class Interface(Classifier, ConnectableElement):
    nestedClassifier: relation_many[Classifier]
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]
    redefinedInterface: relation_many[Interface]


class Include(DirectedRelationship, NamedElement):
    addition: relation_one[UseCase]
    includingCase: relation_one[UseCase]


class ProfileApplication(DirectedRelationship):
    appliedProfile: relation_one[Profile]


class ExtensionPoint(RedefinableElement):
    useCase: relation_one[UseCase]


class Usage(Dependency):
    pass


class ElementImport(DirectedRelationship):
    alias: _attribute[str] = _attribute("alias", str)
    importedElement: relation_one[PackageableElement]
    importingNamespace: relation_one[Namespace]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class Property(ConnectableElement, StructuralFeature):
    aggregation = _enumeration("aggregation", ("none", "shared", "composite"), "none")
    artifact: relation_one[Artifact]
    association: relation_one[Association]
    class_: relation_one[Class]
    classifier: relation_one[Classifier]
    datatype: relation_one[DataType]
    defaultValue: _attribute[str] = _attribute("defaultValue", str)
    interface_: relation_one[Interface]
    isComposite: derived[bool]
    isDerived: _attribute[int] = _attribute("isDerived", int, default=False)
    isDerivedUnion: _attribute[int] = _attribute("isDerivedUnion", int, default=False)
    isReadOnly: _attribute[int] = _attribute("isReadOnly", int, default=False)
    navigability: derived[bool | None]
    opposite: relation_one[Property | None]
    owningAssociation: relation_one[Association]
    redefinedProperty: relation_many[Property]
    subsettedProperty: relation_many[Property]


class ExtensionEnd(Property):
    type: relation_one[Stereotype]  # type: ignore[assignment]


class DataType(Classifier):
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class Enumeration(DataType):
    ownedLiteral: relation_many[EnumerationLiteral]


class Slot(Element):
    definingFeature: relation_one[StructuralFeature]
    owningInstance: relation_one[InstanceSpecification]
    value: _attribute[str] = _attribute("value", str)


class ExecutableNode(ActivityNode):
    pass


class InitialNode(ControlNode):
    pass


class Stereotype(Class):
    icon: relation_many[Image]
    profile: relation_one[Profile]


class Artifact(Classifier, DeployedArtifact):
    artifact: relation_one[Artifact]
    manifestation: relation_many[Manifestation]
    nestedArtifact: relation_many[Artifact]
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class ActivityParameterNode(ObjectNode):
    parameter: relation_one[Parameter]


class PrimitiveType(DataType):
    pass


class DecisionNode(ControlNode):
    decisionInput: relation_one[Behavior]


class Package(Namespace, PackageableElement):
    appliedProfile: relation_many[ProfileApplication]
    nestedPackage: relation_many[Package]
    ownedType: relation_many[Type]
    package: relation_one[Package]
    packageMerge: relation_many[PackageMerge]
    packagedElement: relation_many[PackageableElement]


class Profile(Package):
    metaclassReference: relation_many[ElementImport]
    metamodelReference: relation_many[PackageImport]


class Behavior(Class):
    context2: relation_one[BehavioredClassifier]
    isReentrant: _attribute[int] = _attribute("isReentrant", int)
    redefinedBehavior: relation_many[Behavior]


class Activity(Behavior):
    body: _attribute[str] = _attribute("body", str)
    edge: relation_many[ActivityEdge]
    group: relation_many[ActivityGroup]
    language: _attribute[str] = _attribute("language", str)
    node: relation_many[ActivityNode]


class InterfaceRealization(Realization):
    contract: relation_many[Interface]
    implementatingClassifier: relation_one[BehavioredClassifier]


class Parameter(ConnectableElement, MultiplicityElement):
    defaultValue: _attribute[str] = _attribute("defaultValue", str)
    direction = _enumeration("direction", ("inout", "in", "out", "return"), "inout")
    operation: relation_one[Operation]
    ownerFormalParam: relation_one[BehavioralFeature]
    owningNode: relation_one[ActivityParameterNode]
    parameterSet: relation_many[ParameterSet]


class BehavioralFeature(Feature, Namespace):
    isAbstract: _attribute[int] = _attribute("isAbstract", int)
    method: relation_many[Behavior]
    ownedParameter: relation_many[Parameter]
    ownedParameterSet: relation_many[ParameterSet]
    raisedException: relation_many[Type]


class Operation(BehavioralFeature):
    artifact: relation_one[Artifact]
    bodyCondition: relation_one[Constraint]
    class_: relation_one[Class]
    datatype: relation_one[DataType]
    interface_: relation_one[Interface]
    isQuery: _attribute[int] = _attribute("isQuery", int, default=False)
    ownedParameter: relation_many[Parameter]  # type: ignore[assignment]
    postcondition: relation_many[Constraint]
    precondition: relation_many[Constraint]
    raisedException: relation_many[Type]  # type: ignore[assignment]
    redefinedOperation: relation_many[Operation]
    type: derivedunion[DataType]


class ControlFlow(ActivityEdge):
    pass


class OutputPin(Pin):
    opaqueAction: relation_one[Action]


class ValuePin(InputPin):
    value_: _attribute[str] = _attribute("value_", str)


class Action(ExecutableNode):
    body: _attribute[str] = _attribute("body", str)
    context_: relation_one[Classifier]
    effect: _attribute[str] = _attribute("effect", str)
    inputValue: relation_many[InputPin]
    interaction: relation_one[Interaction]
    outputValue: relation_many[OutputPin]


class ExecutionEnvironment(Node):
    pass


class Extend(DirectedRelationship, NamedElement):
    constraint: relation_one[Constraint]
    extendedCase: relation_one[UseCase]
    extension: relation_one[UseCase]
    extensionLocation: relation_many[ExtensionPoint]


class ActivityGroup(NamedElement):
    activity: relation_one[Activity]
    edgeContents: relation_many[ActivityEdge]
    nodeContents: relation_many[ActivityNode]
    subgroup: relation_many[ActivityGroup]
    superGroup: relation_one[ActivityGroup]


class Constraint(PackageableElement):
    constrainedElement: relation_many[Element]
    owningState: relation_one[State]
    parameterSet: relation_one[ParameterSet]
    specification: _attribute[str] = _attribute("specification", str)
    stateInvariant: relation_one[StateInvariant]
    transition: relation_one[Transition]


class PackageImport(DirectedRelationship):
    importedPackage: relation_one[Package]
    importingNamespace: relation_one[Namespace]
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class InteractionFragment(NamedElement):
    covered: relation_one[Lifeline]
    enclosingInteraction: relation_one[Interaction]
    generalOrdering: relation_many[GeneralOrdering]


class Interaction(Behavior, InteractionFragment):
    action: relation_many[Action]
    fragment: relation_many[InteractionFragment]
    lifeline: relation_many[Lifeline]
    message: relation_many[Message]


class StateInvariant(InteractionFragment):
    covered: relation_one[Lifeline]  # type: ignore[assignment]
    invariant: relation_one[Constraint]


class Lifeline(NamedElement):
    coveredBy: relation_many[InteractionFragment]
    interaction: relation_one[Interaction]
    parse: Callable[[Lifeline, str], None]
    render: Callable[[Lifeline], str]


class Message(NamedElement):
    argument: _attribute[str] = _attribute("argument", str)
    interaction: relation_one[Interaction]
    messageEnd: relation_many[MessageEnd]
    messageKind: property
    messageSort = _enumeration("messageSort", ("synchCall", "asynchCall", "asynchSignal", "createMessage", "deleteMessage", "reply"), "synchCall")
    receiveEvent: relation_one[MessageEnd]
    sendEvent: relation_one[MessageEnd]
    signature: relation_one[NamedElement]


class MessageEnd(NamedElement):
    message: relation_one[Message]
    receiveMessage: relation_one[Message]
    sendMessage: relation_one[Message]


class OccurrenceSpecification(InteractionFragment):
    covered: relation_one[Lifeline]  # type: ignore[assignment]


class GeneralOrdering(NamedElement):
    interactionFragment: relation_one[InteractionFragment]


class Connector(Feature):
    contract: relation_many[Behavior]
    end: relation_many[ConnectorEnd]
    informationFlow: relation_many[InformationFlow]  # type: ignore[assignment]
    kind = _enumeration("kind", ("assembly", "delegation"), "assembly")
    redefinedConnector: relation_many[Connector]
    structuredClassifier: relation_one[StructuredClassifier]
    type: relation_one[Association]


class ConnectorEnd(MultiplicityElement):
    definingEnd: relation_one[Property]
    partWithPort: relation_one[Property]
    role: relation_one[ConnectableElement]


class FlowFinalNode(FinalNode):
    pass


class JoinNode(ControlNode):
    isCombineDuplicate: _attribute[int] = _attribute("isCombineDuplicate", int, default=True)
    joinSpec: _attribute[str] = _attribute("joinSpec", str)


class ForkNode(ControlNode):
    pass


class StateMachine(Behavior):
    region: relation_many[Region]


class Region(Namespace):
    state: relation_one[State]
    stateMachine: relation_one[StateMachine]
    subvertex: relation_many[Vertex]


class Transition(Namespace):
    container: relation_one[Region]
    effect: relation_one[Behavior]
    guard: relation_one[Constraint]
    kind = _enumeration("kind", ("internal", "local", "external"), "internal")
    source: relation_one[Vertex]
    target: relation_one[Vertex]


class Vertex(NamedElement):
    container: relation_one[Region]
    incoming: relation_many[Transition]
    outgoing: relation_many[Transition]


class Pseudostate(Vertex):
    kind = _enumeration("kind", ("initial", "deepHistory", "shallowHistory", "join", "fork", "junction", "choice", "entryPoint", "exitPoint", "terminate"), "initial")
    state: relation_one[State]
    stateMachine: relation_one[StateMachine]


class ConnectionPointReference(Vertex):
    entry: relation_many[Pseudostate]
    exit: relation_many[Pseudostate]
    state: relation_one[State]


class State(Namespace, Vertex):
    doActivity: relation_one[Behavior]
    entry: relation_one[Behavior]
    exit: relation_one[Behavior]
    statevariant: relation_one[Constraint]
    submachine: relation_one[StateMachine]


class FinalState(State):
    pass


class Port(Property):
    encapsulatedClassifier: relation_one[EncapsulatedClassifier]
    isBehavior: _attribute[int] = _attribute("isBehavior", int)
    isService: _attribute[int] = _attribute("isService", int)


class Deployment(Dependency):
    deployedArtifact: relation_many[DeployedArtifact]
    location: relation_one[DeploymentTarget]


class ActivityPartition(ActivityGroup):
    isDimension: _attribute[int] = _attribute("isDimension", int, default=False)
    isExternal: _attribute[int] = _attribute("isExternal", int, default=False)
    node: relation_many[ActivityNode]
    represents: relation_one[Element]
    subpartition: relation_many[ActivityPartition]


class MessageOccurrenceSpecification(MessageEnd, OccurrenceSpecification):
    pass


class AcceptEventAction(Action):
    isUnmarshall: _attribute[int] = _attribute("isUnmarshall", int, default=False)
    result: relation_many[OutputPin]


class ReplyAction(Action):
    replyValue: relation_one[InputPin]
    returnInformation: relation_one[InputPin]


class UnmarshallAction(Action):
    object: relation_one[InputPin]
    result: relation_many[OutputPin]
    unmarshallType: relation_one[Classifier]


class AcceptCallAction(AcceptEventAction):
    returnInformation: relation_one[OutputPin]


class InvocationAction(Action):
    pass


class SendSignalAction(InvocationAction):
    target: relation_many[InputPin]


class Collaboration(BehavioredClassifier, StructuredClassifier):
    collaborationRole: relation_many[ConnectableElement]


class Trigger(NamedElement):
    event: relation_one[Event]
    port: relation_many[Port]


class Event(PackageableElement):
    pass


class ExecutionSpecification(InteractionFragment):
    executionOccurrenceSpecification: relation_many[ExecutionOccurrenceSpecification]
    finish: relation_one[ExecutionOccurrenceSpecification]
    start: relation_one[ExecutionOccurrenceSpecification]


class ExecutionOccurrenceSpecification(OccurrenceSpecification):
    execution: relation_one[ExecutionSpecification]


class ActionExecutionSpecification(ExecutionSpecification):
    action: relation_one[Action]


class BehaviorExecutionSpecification(ExecutionSpecification):
    behavior: relation_one[Behavior]


class ChangeEvent(Event):
    changeExpression: _attribute[str] = _attribute("changeExpression", str)


class StructuralFeatureAction(Action):
    pass


class WriteStructuralFeatureAction(StructuralFeatureAction):
    pass


class AddStructuralFeatureValueAction(WriteStructuralFeatureAction):
    isReplaceAll: _attribute[int] = _attribute("isReplaceAll", int, default=False)


class ParameterSet(NamedElement):
    behavioralFeature: relation_one[BehavioralFeature]
    condition: relation_many[Constraint]
    parameter: relation_many[Parameter]


class Image(Element):
    content: _attribute[str] = _attribute("content", str)
    format: _attribute[str] = _attribute("format", str)


class ComponentRealization(Realization):
    abstraction: relation_one[Component]
    realizingClassifier: relation_one[Classifier]


class InformationItem(Classifier):
    represented: relation_many[Classifier]


class InformationFlow(DirectedRelationship, PackageableElement):
    conveyed: relation_many[Classifier]
    informationSource: relation_one[NamedElement]
    informationTarget: relation_one[NamedElement]
    realization: relation_many[Relationship]
    realizingActivityEdge: relation_many[ActivityEdge]
    realizingConnector: relation_one[Connector]
    realizingMessage: relation_many[Message]


class OpaqueAction(Action):
    body: _attribute[str] = _attribute("body", str)


# 86: override Lifeline.parse: Callable[[Lifeline, str], None]
# defined in umloverrides.py

# 89: override Lifeline.render: Callable[[Lifeline], str]
# defined in umloverrides.py


Element.appliedStereotype = association("appliedStereotype", InstanceSpecification, opposite="extended")
Element.relationship = derivedunion("relationship", Relationship)
Element.directedRelationship = derivedunion("directedRelationship", DirectedRelationship)
Element.relationship.add(Element.directedRelationship)  # type: ignore[attr-defined]
NamedElement.supplierDependency = association("supplierDependency", Dependency, opposite="supplier")
NamedElement.clientDependency = association("clientDependency", Dependency, composite=True, opposite="client")
NamedElement.namespace = derivedunion("namespace", Namespace, upper=1)
# 68: override NamedElement.qualifiedName: derived[list[str]]

from gaphor.core.modeling.diagram import qualifiedName

NamedElement.qualifiedName = derived(
    "qualifiedName",
    list[str],
    0,
    1,
    lambda obj: [qualifiedName(obj)],
)

NamedElement.memberNamespace = derivedunion("memberNamespace", Namespace)
NamedElement.informationFlow = association("informationFlow", InformationFlow, opposite="informationTarget")
Element.directedRelationship.add(NamedElement.supplierDependency)  # type: ignore[attr-defined]
Element.ownedElement.add(NamedElement.clientDependency)  # type: ignore[attr-defined]
Element.directedRelationship.add(NamedElement.clientDependency)  # type: ignore[attr-defined]
Element.owner.add(NamedElement.namespace)  # type: ignore[attr-defined]
NamedElement.memberNamespace.add(NamedElement.namespace)  # type: ignore[attr-defined]
Element.directedRelationship.add(NamedElement.informationFlow)  # type: ignore[attr-defined]
PackageableElement.owningPackage = derivedunion("owningPackage", Package, upper=1)
PackageableElement.component = association("component", Component, upper=1, opposite="packagedElement")
NamedElement.namespace.add(PackageableElement.owningPackage)  # type: ignore[attr-defined]
NamedElement.namespace.add(PackageableElement.component)  # type: ignore[attr-defined]
DeployedArtifact.deployment = association("deployment", Deployment, opposite="deployedArtifact")
DeploymentTarget.deployment = association("deployment", Deployment, composite=True, opposite="location")
Element.ownedElement.add(DeploymentTarget.deployment)  # type: ignore[attr-defined]
InstanceSpecification.slot = association("slot", Slot, composite=True, opposite="owningInstance")
InstanceSpecification.classifier = association("classifier", Classifier)
InstanceSpecification.extended = association("extended", Element, opposite="appliedStereotype")
Element.ownedElement.add(InstanceSpecification.slot)  # type: ignore[attr-defined]
EnumerationLiteral.enumeration = association("enumeration", Enumeration, upper=1, opposite="ownedLiteral")
NamedElement.namespace.add(EnumerationLiteral.enumeration)  # type: ignore[attr-defined]
Relationship.relatedElement = derivedunion("relatedElement", Element, lower=1)
DirectedRelationship.source = derivedunion("source", Element, lower=1)
DirectedRelationship.target = derivedunion("target", Element, lower=1)
Relationship.relatedElement.add(DirectedRelationship.source)  # type: ignore[attr-defined]
Relationship.relatedElement.add(DirectedRelationship.target)  # type: ignore[attr-defined]
PackageMerge.mergingPackage = association("mergingPackage", Package, upper=1, opposite="packageMerge")
PackageMerge.mergedPackage = association("mergedPackage", Package, upper=1)
DirectedRelationship.source.add(PackageMerge.mergingPackage)  # type: ignore[attr-defined]
Element.owner.add(PackageMerge.mergingPackage)  # type: ignore[attr-defined]
DirectedRelationship.target.add(PackageMerge.mergedPackage)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement = derivedunion("redefinedElement", RedefinableElement)
RedefinableElement.redefinitionContext = derivedunion("redefinitionContext", Classifier)
# 56: override Namespace.importedMember: derivedunion[PackageableElement]
Namespace.importedMember = derivedunion('importedMember', PackageableElement, 0, '*')

Namespace.ownedMember = derivedunion("ownedMember", NamedElement)
Namespace.elementImport = association("elementImport", ElementImport, composite=True, opposite="importingNamespace")
Namespace.member = derivedunion("member", NamedElement)
Namespace.packageImport = association("packageImport", PackageImport, composite=True, opposite="importingNamespace")
Namespace.ownedRule = association("ownedRule", Constraint, composite=True)
Namespace.member.add(Namespace.ownedMember)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.ownedMember)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.elementImport)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.packageImport)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Namespace.ownedRule)  # type: ignore[attr-defined]
Type.package = association("package", Package, upper=1, opposite="ownedType")
PackageableElement.owningPackage.add(Type.package)  # type: ignore[attr-defined]
Classifier.generalization = association("generalization", Generalization, composite=True, opposite="specific")
Classifier.ownedUseCase = association("ownedUseCase", UseCase, composite=True)
Classifier.redefinedClassifier = association("redefinedClassifier", Classifier)
# 47: override Classifier.inheritedMember: derivedunion[NamedElement]
Classifier.inheritedMember = derivedunion('inheritedMember', NamedElement, 0, '*')

Classifier.attribute = derivedunion("attribute", Property)
# 50: override Classifier.general(Generalization.general): derived[Classifier]
Classifier.general = derived('general', Classifier, 0, '*', lambda self: [g.general for g in self.generalization])

Classifier.useCase = association("useCase", UseCase, opposite="subject")
Classifier.nestingClass = association("nestingClass", Class, upper=1, opposite="nestedClassifier")
Classifier.specialization = association("specialization", Generalization, opposite="general")
Classifier.feature = derivedunion("feature", Feature)
Classifier.componentRealization = redefine(Classifier, "componentRealization", ComponentRealization, NamedElement.clientDependency)
Element.ownedElement.add(Classifier.generalization)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Classifier.ownedUseCase)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Classifier.redefinedClassifier)  # type: ignore[attr-defined]
Namespace.member.add(Classifier.inheritedMember)  # type: ignore[attr-defined]
Classifier.feature.add(Classifier.attribute)  # type: ignore[attr-defined]
NamedElement.namespace.add(Classifier.nestingClass)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Classifier.nestingClass)  # type: ignore[attr-defined]
Element.directedRelationship.add(Classifier.specialization)  # type: ignore[attr-defined]
Association.ownedEnd = association("ownedEnd", Property, composite=True, opposite="owningAssociation")
# 24: override Association.endType(Association.memberEnd, Property.type): derived[Type]

# References the classifiers that are used as types of the ends of the
# association.

Association.endType = derived('endType', Type, 0, '*', lambda self: [end.type for end in self.memberEnd if end])


Association.memberEnd = association("memberEnd", Property, lower=2, composite=True, opposite="association")
Association.navigableOwnedEnd = association("navigableOwnedEnd", Property)
Classifier.feature.add(Association.ownedEnd)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Association.ownedEnd)  # type: ignore[attr-defined]
Namespace.member.add(Association.memberEnd)  # type: ignore[attr-defined]
# 44: override Extension.metaclass(Extension.ownedEnd, Association.memberEnd): property
# defined in umloverrides.py

Extension.ownedEnd = association("ownedEnd", ExtensionEnd, upper=1, composite=True)
BehavioredClassifier.ownedBehavior = association("ownedBehavior", Behavior, composite=True, opposite="context2")
BehavioredClassifier.interfaceRealization = redefine(BehavioredClassifier, "interfaceRealization", InterfaceRealization, NamedElement.clientDependency)
Namespace.ownedMember.add(BehavioredClassifier.ownedBehavior)  # type: ignore[attr-defined]
ActivityNode.incoming = association("incoming", ActivityEdge, opposite="target")
ActivityNode.outgoing = association("outgoing", ActivityEdge, opposite="source")
ActivityNode.inPartition = association("inPartition", ActivityPartition, opposite="node")
ActivityNode.activity = association("activity", Activity, upper=1, opposite="node")
ActivityNode.inGroup = association("inGroup", ActivityGroup, opposite="nodeContents")
ActivityNode.redefinedElement = redefine(ActivityNode, "redefinedElement", ActivityNode, RedefinableElement.redefinedElement)
Element.owner.add(ActivityNode.activity)  # type: ignore[attr-defined]
Feature.featuringClassifier = derivedunion("featuringClassifier", Classifier, lower=1)
ActivityEdge.source = association("source", ActivityNode, upper=1, opposite="outgoing")
ActivityEdge.activity = association("activity", Activity, upper=1, opposite="edge")
ActivityEdge.target = association("target", ActivityNode, upper=1, opposite="incoming")
ActivityEdge.inGroup = association("inGroup", ActivityGroup, opposite="edgeContents")
ActivityEdge.redefinedElement = redefine(ActivityEdge, "redefinedElement", ActivityEdge, RedefinableElement.redefinedElement)
Element.owner.add(ActivityEdge.activity)  # type: ignore[attr-defined]
Dependency.supplier = association("supplier", NamedElement, upper=1, opposite="supplierDependency")
Dependency.client = association("client", NamedElement, upper=1, opposite="clientDependency")
DirectedRelationship.target.add(Dependency.supplier)  # type: ignore[attr-defined]
Element.owner.add(Dependency.client)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Dependency.client)  # type: ignore[attr-defined]
TypedElement.type = association("type", Type, upper=1)
ObjectNode.selection = association("selection", Behavior, upper=1)
# 18: override MultiplicityElement.lower(MultiplicityElement.lowerValue): _attribute[str]
MultiplicityElement.lower = MultiplicityElement.lowerValue

# 21: override MultiplicityElement.upper(MultiplicityElement.upperValue): _attribute[str]
MultiplicityElement.upper = MultiplicityElement.upperValue

Generalization.specific = association("specific", Classifier, upper=1, opposite="generalization")
Generalization.general = association("general", Classifier, upper=1, opposite="specialization")
DirectedRelationship.source.add(Generalization.specific)  # type: ignore[attr-defined]
Element.owner.add(Generalization.specific)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Generalization.general)  # type: ignore[attr-defined]
StructuredClassifier.role = derivedunion("role", ConnectableElement)
# 101: override StructuredClassifier.part: property
StructuredClassifier.part = property(lambda self: tuple(a for a in self.ownedAttribute if a.isComposite), doc="""
    Properties owned by a classifier by composition.
""")

StructuredClassifier.ownedConnector = association("ownedConnector", Connector, composite=True, opposite="structuredClassifier")
StructuredClassifier.ownedAttribute = association("ownedAttribute", Property, composite=True)
Namespace.member.add(StructuredClassifier.role)  # type: ignore[attr-defined]
Namespace.ownedMember.add(StructuredClassifier.ownedConnector)  # type: ignore[attr-defined]
Classifier.feature.add(StructuredClassifier.ownedConnector)  # type: ignore[attr-defined]
StructuredClassifier.role.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
Classifier.attribute.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(StructuredClassifier.ownedAttribute)  # type: ignore[attr-defined]
EncapsulatedClassifier.ownedPort = association("ownedPort", Port, composite=True, opposite="encapsulatedClassifier")
StructuredClassifier.role.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Classifier.attribute.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Namespace.ownedMember.add(EncapsulatedClassifier.ownedPort)  # type: ignore[attr-defined]
Class.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="class_")
Class.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="class_")
# 53: override Class.superClass: derived[Classifier]
Class.superClass = Classifier.general

Class.nestedClassifier = association("nestedClassifier", Classifier, composite=True, opposite="nestingClass")
# 32: override Class.extension(Extension.metaclass): property
# See https://www.omg.org/spec/UML/2.5/PDF, section 11.8.3.6, page 219
# It defines `Extension.allInstances()`, which basically means we have to query the element factory.

# TODO: use those as soon as Extension.metaclass can be used.
#Class.extension = derived('extension', Extension, 0, '*', class_extension, Extension.metaclass)

Class.extension = property(lambda self: self.model.lselect(lambda e: e.isKindOf(Extension) and self is e.metaclass), doc=\
"""References the Extensions that specify additional properties of the
metaclass. The property is derived from the extensions whose memberEnds
are typed by the Class.""")

Classifier.attribute.add(Class.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.ownedAttribute)  # type: ignore[attr-defined]
Classifier.feature.add(Class.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Class.nestedClassifier)  # type: ignore[attr-defined]
Node.nestedNode = association("nestedNode", Node, composite=True, opposite="node")
Node.node = association("node", Node, upper=1, opposite="nestedNode")
Namespace.ownedMember.add(Node.nestedNode)  # type: ignore[attr-defined]
NamedElement.namespace.add(Node.node)  # type: ignore[attr-defined]
StructuralFeature.slot = association("slot", Slot, composite=True, opposite="definingFeature")
UseCase.extensionPoint = association("extensionPoint", ExtensionPoint, composite=True, opposite="useCase")
UseCase.extend = association("extend", Extend, composite=True, opposite="extension")
UseCase.include = association("include", Include, composite=True, opposite="includingCase")
UseCase.subject = association("subject", Classifier, opposite="useCase")
Namespace.ownedMember.add(UseCase.extensionPoint)  # type: ignore[attr-defined]
Element.directedRelationship.add(UseCase.extend)  # type: ignore[attr-defined]
Namespace.ownedMember.add(UseCase.extend)  # type: ignore[attr-defined]
Element.directedRelationship.add(UseCase.include)  # type: ignore[attr-defined]
Namespace.ownedMember.add(UseCase.include)  # type: ignore[attr-defined]
InputPin.opaqueAction = association("opaqueAction", Action, upper=1, opposite="inputValue")
Element.owner.add(InputPin.opaqueAction)  # type: ignore[attr-defined]
Manifestation.artifact = association("artifact", Artifact, upper=1, opposite="manifestation")
Element.owner.add(Manifestation.artifact)  # type: ignore[attr-defined]
Component.packagedElement = association("packagedElement", PackageableElement, composite=True, opposite="component")
# 92: override Component.provided: property
# defined in umloverrides.py

# 95: override Component.required: property
# defined in umloverrides.py

Component.realization = redefine(Component, "realization", ComponentRealization, NamedElement.supplierDependency)
Namespace.ownedMember.add(Component.packagedElement)  # type: ignore[attr-defined]
ConnectableElement.end = association("end", ConnectorEnd, opposite="role")
Interface.nestedClassifier = association("nestedClassifier", Classifier, composite=True)
Interface.redefinedInterface = association("redefinedInterface", Interface)
Interface.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="interface_")
Interface.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="interface_")
Namespace.ownedMember.add(Interface.nestedClassifier)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Interface.redefinedInterface)  # type: ignore[attr-defined]
Classifier.feature.add(Interface.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interface.ownedOperation)  # type: ignore[attr-defined]
Classifier.attribute.add(Interface.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interface.ownedAttribute)  # type: ignore[attr-defined]
Include.includingCase = association("includingCase", UseCase, upper=1, opposite="include")
Include.addition = association("addition", UseCase, upper=1)
NamedElement.namespace.add(Include.includingCase)  # type: ignore[attr-defined]
DirectedRelationship.source.add(Include.includingCase)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Include.addition)  # type: ignore[attr-defined]
ProfileApplication.appliedProfile = association("appliedProfile", Profile, upper=1)
ExtensionPoint.useCase = association("useCase", UseCase, upper=1, opposite="extensionPoint")
NamedElement.namespace.add(ExtensionPoint.useCase)  # type: ignore[attr-defined]
ElementImport.importingNamespace = association("importingNamespace", Namespace, upper=1, opposite="elementImport")
ElementImport.importedElement = association("importedElement", PackageableElement, upper=1)
DirectedRelationship.source.add(ElementImport.importingNamespace)  # type: ignore[attr-defined]
Element.owner.add(ElementImport.importingNamespace)  # type: ignore[attr-defined]
DirectedRelationship.target.add(ElementImport.importedElement)  # type: ignore[attr-defined]
Property.redefinedProperty = association("redefinedProperty", Property)
Property.class_ = association("class_", Class, upper=1, opposite="ownedAttribute")
Property.subsettedProperty = association("subsettedProperty", Property)
Property.owningAssociation = association("owningAssociation", Association, upper=1, opposite="ownedEnd")
Property.classifier = association("classifier", Classifier, upper=1, opposite="attribute")
# 62: override Property.isComposite(Property.aggregation): derived[bool]
Property.isComposite = derived('isComposite', bool, 0, 1, lambda obj: [obj.aggregation == 'composite'])

Property.datatype = association("datatype", DataType, upper=1, opposite="ownedAttribute")
# 59: override Property.opposite(Property.association, Association.memberEnd): relation_one[Property | None]
# defined in umloverrides.py

# 80: override Property.navigability(Property.opposite, Property.association): derived[bool | None]
# defined in umloverrides.py

Property.artifact = association("artifact", Artifact, upper=1, opposite="ownedAttribute")
Property.interface_ = association("interface_", Interface, upper=1, opposite="ownedAttribute")
Property.association = association("association", Association, upper=1, opposite="memberEnd")
RedefinableElement.redefinedElement.add(Property.redefinedProperty)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.class_)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Property.class_)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.owningAssociation)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Property.owningAssociation)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Property.classifier)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.datatype)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Property.interface_)  # type: ignore[attr-defined]
NamedElement.memberNamespace.add(Property.association)  # type: ignore[attr-defined]
ExtensionEnd.type = redefine(ExtensionEnd, "type", Stereotype, Property.type)
DataType.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="datatype")
DataType.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="datatype")
Classifier.feature.add(DataType.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(DataType.ownedOperation)  # type: ignore[attr-defined]
Classifier.attribute.add(DataType.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(DataType.ownedAttribute)  # type: ignore[attr-defined]
Enumeration.ownedLiteral = association("ownedLiteral", EnumerationLiteral, composite=True, opposite="enumeration")
Namespace.ownedMember.add(Enumeration.ownedLiteral)  # type: ignore[attr-defined]
Slot.owningInstance = association("owningInstance", InstanceSpecification, upper=1, opposite="slot")
Slot.definingFeature = association("definingFeature", StructuralFeature, upper=1, opposite="slot")
Element.owner.add(Slot.owningInstance)  # type: ignore[attr-defined]
Stereotype.profile = derivedunion("profile", Profile, upper=1)
Stereotype.icon = association("icon", Image, composite=True)
Namespace.ownedMember.add(Stereotype.icon)  # type: ignore[attr-defined]
Artifact.manifestation = association("manifestation", Manifestation, composite=True, opposite="artifact")
Artifact.nestedArtifact = association("nestedArtifact", Artifact, composite=True, opposite="artifact")
Artifact.artifact = association("artifact", Artifact, upper=1, opposite="nestedArtifact")
Artifact.ownedAttribute = association("ownedAttribute", Property, composite=True, opposite="artifact")
Artifact.ownedOperation = association("ownedOperation", Operation, composite=True, opposite="artifact")
Element.ownedElement.add(Artifact.manifestation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.nestedArtifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Artifact.artifact)  # type: ignore[attr-defined]
Classifier.attribute.add(Artifact.ownedAttribute)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.ownedAttribute)  # type: ignore[attr-defined]
Classifier.feature.add(Artifact.ownedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Artifact.ownedOperation)  # type: ignore[attr-defined]
ActivityParameterNode.parameter = association("parameter", Parameter, upper=1, composite=True, opposite="owningNode")
Element.ownedElement.add(ActivityParameterNode.parameter)  # type: ignore[attr-defined]
DecisionNode.decisionInput = association("decisionInput", Behavior, upper=1)
Package.packagedElement = derivedunion("packagedElement", PackageableElement)
Package.ownedType = association("ownedType", Type, composite=True, opposite="package")
Package.packageMerge = association("packageMerge", PackageMerge, composite=True, opposite="mergingPackage")
Package.appliedProfile = association("appliedProfile", ProfileApplication, composite=True)
Package.package = association("package", Package, upper=1, opposite="nestedPackage")
Package.nestedPackage = association("nestedPackage", Package, composite=True, opposite="package")
Namespace.ownedMember.add(Package.packagedElement)  # type: ignore[attr-defined]
Package.packagedElement.add(Package.ownedType)  # type: ignore[attr-defined]
Element.ownedElement.add(Package.packageMerge)  # type: ignore[attr-defined]
Element.directedRelationship.add(Package.packageMerge)  # type: ignore[attr-defined]
Element.ownedElement.add(Package.appliedProfile)  # type: ignore[attr-defined]
PackageableElement.owningPackage.add(Package.package)  # type: ignore[attr-defined]
Package.packagedElement.add(Package.nestedPackage)  # type: ignore[attr-defined]
Profile.metaclassReference = association("metaclassReference", ElementImport, composite=True)
Profile.metamodelReference = association("metamodelReference", PackageImport, composite=True)
Behavior.redefinedBehavior = association("redefinedBehavior", Behavior)
Behavior.context2 = association("context2", BehavioredClassifier, upper=1, opposite="ownedBehavior")
RedefinableElement.redefinedElement.add(Behavior.redefinedBehavior)  # type: ignore[attr-defined]
Activity.edge = association("edge", ActivityEdge, composite=True, opposite="activity")
Activity.node = association("node", ActivityNode, composite=True, opposite="activity")
Activity.group = association("group", ActivityGroup, composite=True, opposite="activity")
Element.ownedElement.add(Activity.edge)  # type: ignore[attr-defined]
Element.ownedElement.add(Activity.node)  # type: ignore[attr-defined]
Element.ownedElement.add(Activity.group)  # type: ignore[attr-defined]
InterfaceRealization.contract = redefine(InterfaceRealization, "contract", Interface, Dependency.supplier)
InterfaceRealization.implementatingClassifier = redefine(InterfaceRealization, "implementatingClassifier", BehavioredClassifier, Dependency.client)
Parameter.parameterSet = association("parameterSet", ParameterSet, opposite="parameter")
Parameter.ownerFormalParam = association("ownerFormalParam", BehavioralFeature, upper=1, opposite="ownedParameter")
Parameter.owningNode = association("owningNode", ActivityParameterNode, upper=1, opposite="parameter")
Parameter.operation = redefine(Parameter, "operation", Operation, Parameter.ownerFormalParam)
NamedElement.namespace.add(Parameter.ownerFormalParam)  # type: ignore[attr-defined]
Element.owner.add(Parameter.owningNode)  # type: ignore[attr-defined]
BehavioralFeature.raisedException = association("raisedException", Type)
BehavioralFeature.method = association("method", Behavior)
BehavioralFeature.ownedParameter = association("ownedParameter", Parameter, composite=True, opposite="ownerFormalParam")
BehavioralFeature.ownedParameterSet = association("ownedParameterSet", ParameterSet, composite=True, opposite="behavioralFeature")
Namespace.ownedMember.add(BehavioralFeature.ownedParameter)  # type: ignore[attr-defined]
NamedElement.namespace.add(BehavioralFeature.ownedParameterSet)  # type: ignore[attr-defined]
Operation.precondition = association("precondition", Constraint, composite=True)
Operation.postcondition = association("postcondition", Constraint, composite=True)
Operation.class_ = association("class_", Class, upper=1, opposite="ownedOperation")
Operation.redefinedOperation = association("redefinedOperation", Operation)
Operation.raisedException = association("raisedException", Type)
Operation.bodyCondition = association("bodyCondition", Constraint, upper=1, composite=True)
Operation.datatype = association("datatype", DataType, upper=1, opposite="ownedOperation")
# 83: override Operation.type: derivedunion[DataType]
Operation.type = derivedunion('type', DataType, 0, 1)

Operation.artifact = association("artifact", Artifact, upper=1, opposite="ownedOperation")
Operation.interface_ = association("interface_", Interface, upper=1, opposite="ownedOperation")
Operation.ownedParameter = redefine(Operation, "ownedParameter", Parameter, BehavioralFeature.ownedParameter)
Namespace.ownedMember.add(Operation.precondition)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Operation.postcondition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.class_)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.class_)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.class_)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Operation.redefinedOperation)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Operation.bodyCondition)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.datatype)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.datatype)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.datatype)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.artifact)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Operation.artifact)  # type: ignore[attr-defined]
NamedElement.namespace.add(Operation.interface_)  # type: ignore[attr-defined]
Feature.featuringClassifier.add(Operation.interface_)  # type: ignore[attr-defined]
OutputPin.opaqueAction = association("opaqueAction", Action, upper=1, opposite="outputValue")
Element.owner.add(OutputPin.opaqueAction)  # type: ignore[attr-defined]
Action.interaction = association("interaction", Interaction, upper=1, opposite="action")
Action.outputValue = association("outputValue", OutputPin, composite=True, opposite="opaqueAction")
Action.inputValue = association("inputValue", InputPin, composite=True, opposite="opaqueAction")
Action.context_ = derivedunion("context_", Classifier, upper=1)
Element.owner.add(Action.interaction)  # type: ignore[attr-defined]
Element.ownedElement.add(Action.outputValue)  # type: ignore[attr-defined]
Element.ownedElement.add(Action.inputValue)  # type: ignore[attr-defined]
Extend.extension = association("extension", UseCase, upper=1, opposite="extend")
Extend.extensionLocation = association("extensionLocation", ExtensionPoint, lower=1)
Extend.constraint = association("constraint", Constraint, upper=1, composite=True)
Extend.extendedCase = association("extendedCase", UseCase, upper=1)
NamedElement.namespace.add(Extend.extension)  # type: ignore[attr-defined]
DirectedRelationship.source.add(Extend.extension)  # type: ignore[attr-defined]
DirectedRelationship.target.add(Extend.extendedCase)  # type: ignore[attr-defined]
ActivityGroup.superGroup = derivedunion("superGroup", ActivityGroup, upper=1)
ActivityGroup.subgroup = derivedunion("subgroup", ActivityGroup)
ActivityGroup.nodeContents = association("nodeContents", ActivityNode, opposite="inGroup")
ActivityGroup.edgeContents = association("edgeContents", ActivityEdge, opposite="inGroup")
ActivityGroup.activity = association("activity", Activity, upper=1, opposite="group")
Element.owner.add(ActivityGroup.superGroup)  # type: ignore[attr-defined]
Element.ownedElement.add(ActivityGroup.subgroup)  # type: ignore[attr-defined]
Element.owner.add(ActivityGroup.activity)  # type: ignore[attr-defined]
Constraint.owningState = association("owningState", State, upper=1, opposite="statevariant")
Constraint.transition = association("transition", Transition, upper=1, opposite="guard")
Constraint.stateInvariant = association("stateInvariant", StateInvariant, upper=1, opposite="invariant")
Constraint.constrainedElement = association("constrainedElement", Element)
Constraint.parameterSet = association("parameterSet", ParameterSet, upper=1, opposite="condition")
Element.owner.add(Constraint.transition)  # type: ignore[attr-defined]
Element.owner.add(Constraint.stateInvariant)  # type: ignore[attr-defined]
Element.owner.add(Constraint.parameterSet)  # type: ignore[attr-defined]
PackageImport.importingNamespace = association("importingNamespace", Namespace, upper=1, opposite="packageImport")
PackageImport.importedPackage = association("importedPackage", Package, upper=1)
DirectedRelationship.source.add(PackageImport.importingNamespace)  # type: ignore[attr-defined]
Element.owner.add(PackageImport.importingNamespace)  # type: ignore[attr-defined]
DirectedRelationship.target.add(PackageImport.importedPackage)  # type: ignore[attr-defined]
InteractionFragment.generalOrdering = association("generalOrdering", GeneralOrdering, composite=True, opposite="interactionFragment")
InteractionFragment.enclosingInteraction = association("enclosingInteraction", Interaction, upper=1, opposite="fragment")
InteractionFragment.covered = association("covered", Lifeline, upper=1, opposite="coveredBy")
Element.ownedElement.add(InteractionFragment.generalOrdering)  # type: ignore[attr-defined]
NamedElement.namespace.add(InteractionFragment.enclosingInteraction)  # type: ignore[attr-defined]
Interaction.lifeline = association("lifeline", Lifeline, composite=True, opposite="interaction")
Interaction.action = association("action", Action, composite=True, opposite="interaction")
Interaction.fragment = association("fragment", InteractionFragment, opposite="enclosingInteraction")
Interaction.message = association("message", Message, composite=True, opposite="interaction")
Namespace.ownedMember.add(Interaction.lifeline)  # type: ignore[attr-defined]
Element.ownedElement.add(Interaction.action)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interaction.fragment)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Interaction.message)  # type: ignore[attr-defined]
StateInvariant.invariant = association("invariant", Constraint, upper=1, composite=True, opposite="stateInvariant")
StateInvariant.covered = redefine(StateInvariant, "covered", Lifeline, InteractionFragment.covered)
Element.ownedElement.add(StateInvariant.invariant)  # type: ignore[attr-defined]
Lifeline.interaction = association("interaction", Interaction, upper=1, opposite="lifeline")
Lifeline.coveredBy = association("coveredBy", InteractionFragment, opposite="covered")
NamedElement.namespace.add(Lifeline.interaction)  # type: ignore[attr-defined]
# 98: override Message.messageKind: property
# defined in umloverrides.py

Message.sendEvent = association("sendEvent", MessageEnd, upper=1, composite=True, opposite="sendMessage")
Message.receiveEvent = association("receiveEvent", MessageEnd, upper=1, composite=True, opposite="receiveMessage")
Message.signature = association("signature", NamedElement, upper=1)
Message.messageEnd = derivedunion("messageEnd", MessageEnd, upper=2)
Message.interaction = association("interaction", Interaction, upper=1, opposite="message")
Message.messageEnd.add(Message.sendEvent)  # type: ignore[attr-defined]
Message.messageEnd.add(Message.receiveEvent)  # type: ignore[attr-defined]
NamedElement.namespace.add(Message.interaction)  # type: ignore[attr-defined]
MessageEnd.sendMessage = association("sendMessage", Message, upper=1, opposite="sendEvent")
MessageEnd.receiveMessage = association("receiveMessage", Message, upper=1, opposite="receiveEvent")
MessageEnd.message = derivedunion("message", Message, upper=1)
MessageEnd.message.add(MessageEnd.sendMessage)  # type: ignore[attr-defined]
MessageEnd.message.add(MessageEnd.receiveMessage)  # type: ignore[attr-defined]
OccurrenceSpecification.covered = redefine(OccurrenceSpecification, "covered", Lifeline, InteractionFragment.covered)
GeneralOrdering.interactionFragment = association("interactionFragment", InteractionFragment, upper=1, opposite="generalOrdering")
Element.owner.add(GeneralOrdering.interactionFragment)  # type: ignore[attr-defined]
Connector.end = association("end", ConnectorEnd, lower=2, composite=True)
Connector.type = association("type", Association, upper=1)
Connector.contract = association("contract", Behavior)
Connector.redefinedConnector = association("redefinedConnector", Connector)
Connector.structuredClassifier = association("structuredClassifier", StructuredClassifier, upper=1, opposite="ownedConnector")
Connector.informationFlow = association("informationFlow", InformationFlow, composite=True, opposite="realizingConnector")
Element.ownedElement.add(Connector.end)  # type: ignore[attr-defined]
RedefinableElement.redefinedElement.add(Connector.redefinedConnector)  # type: ignore[attr-defined]
NamedElement.namespace.add(Connector.structuredClassifier)  # type: ignore[attr-defined]
RedefinableElement.redefinitionContext.add(Connector.structuredClassifier)  # type: ignore[attr-defined]
Element.ownedElement.add(Connector.informationFlow)  # type: ignore[attr-defined]
ConnectorEnd.definingEnd = derivedunion("definingEnd", Property, upper=1)
ConnectorEnd.role = association("role", ConnectableElement, upper=1, opposite="end")
ConnectorEnd.partWithPort = association("partWithPort", Property, upper=1)
StateMachine.region = association("region", Region, lower=1, composite=True, opposite="stateMachine")
Namespace.ownedMember.add(StateMachine.region)  # type: ignore[attr-defined]
Region.stateMachine = association("stateMachine", StateMachine, upper=1, opposite="region")
Region.subvertex = association("subvertex", Vertex, composite=True, opposite="container")
Region.state = association("state", State, upper=1)
NamedElement.namespace.add(Region.stateMachine)  # type: ignore[attr-defined]
Namespace.ownedMember.add(Region.subvertex)  # type: ignore[attr-defined]
NamedElement.namespace.add(Region.state)  # type: ignore[attr-defined]
Transition.container = association("container", Region, upper=1)
Transition.effect = association("effect", Behavior, upper=1, composite=True)
Transition.guard = association("guard", Constraint, upper=1, composite=True, opposite="transition")
Transition.source = association("source", Vertex, upper=1, opposite="outgoing")
Transition.target = association("target", Vertex, upper=1, opposite="incoming")
NamedElement.namespace.add(Transition.container)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.effect)  # type: ignore[attr-defined]
Element.ownedElement.add(Transition.guard)  # type: ignore[attr-defined]
Vertex.container = association("container", Region, upper=1, opposite="subvertex")
Vertex.outgoing = association("outgoing", Transition, opposite="source")
Vertex.incoming = association("incoming", Transition, opposite="target")
NamedElement.namespace.add(Vertex.container)  # type: ignore[attr-defined]
Pseudostate.stateMachine = association("stateMachine", StateMachine, upper=1)
Pseudostate.state = association("state", State, upper=1)
NamedElement.namespace.add(Pseudostate.stateMachine)  # type: ignore[attr-defined]
Element.owner.add(Pseudostate.state)  # type: ignore[attr-defined]
ConnectionPointReference.exit = association("exit", Pseudostate)
ConnectionPointReference.entry = association("entry", Pseudostate)
ConnectionPointReference.state = association("state", State, upper=1)
NamedElement.namespace.add(ConnectionPointReference.state)  # type: ignore[attr-defined]
State.entry = association("entry", Behavior, upper=1, composite=True)
State.exit = association("exit", Behavior, upper=1, composite=True)
State.doActivity = association("doActivity", Behavior, upper=1, composite=True)
State.statevariant = association("statevariant", Constraint, upper=1, composite=True, opposite="owningState")
State.submachine = association("submachine", StateMachine, upper=1)
Element.ownedElement.add(State.entry)  # type: ignore[attr-defined]
Element.ownedElement.add(State.exit)  # type: ignore[attr-defined]
Element.ownedElement.add(State.doActivity)  # type: ignore[attr-defined]
Element.ownedElement.add(State.statevariant)  # type: ignore[attr-defined]
Port.encapsulatedClassifier = association("encapsulatedClassifier", EncapsulatedClassifier, upper=1, opposite="ownedPort")
NamedElement.namespace.add(Port.encapsulatedClassifier)  # type: ignore[attr-defined]
Deployment.location = association("location", DeploymentTarget, upper=1, opposite="deployment")
Deployment.deployedArtifact = association("deployedArtifact", DeployedArtifact, opposite="deployment")
Element.owner.add(Deployment.location)  # type: ignore[attr-defined]
ActivityPartition.node = association("node", ActivityNode, opposite="inPartition")
ActivityPartition.subpartition = association("subpartition", ActivityPartition)
ActivityPartition.represents = association("represents", Element, upper=1)
ActivityGroup.subgroup.add(ActivityPartition.subpartition)  # type: ignore[attr-defined]
AcceptEventAction.result = association("result", OutputPin, composite=True)
ReplyAction.replyValue = association("replyValue", InputPin, upper=1, composite=True)
ReplyAction.returnInformation = association("returnInformation", InputPin, upper=1, composite=True)
UnmarshallAction.result = association("result", OutputPin, composite=True)
UnmarshallAction.unmarshallType = association("unmarshallType", Classifier, upper=1)
UnmarshallAction.object = association("object", InputPin, upper=1, composite=True)
AcceptCallAction.returnInformation = association("returnInformation", OutputPin, upper=1, composite=True)
SendSignalAction.target = association("target", InputPin, composite=True)
Collaboration.collaborationRole = association("collaborationRole", ConnectableElement)
StructuredClassifier.role.add(Collaboration.collaborationRole)  # type: ignore[attr-defined]
Trigger.event = association("event", Event, upper=1)
Trigger.port = association("port", Port)
# 110: override ExecutionSpecification.finish(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.finish = derived('finish', OccurrenceSpecification, 0, 1,
    lambda obj: [eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 1])

# 106: override ExecutionSpecification.start(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.start = derived('start', OccurrenceSpecification, 0, 1,
    lambda obj: [eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 0])

ExecutionSpecification.executionOccurrenceSpecification = association("executionOccurrenceSpecification", ExecutionOccurrenceSpecification, upper=2, composite=True, opposite="execution")
ExecutionOccurrenceSpecification.execution = association("execution", ExecutionSpecification, upper=1, opposite="executionOccurrenceSpecification")
ActionExecutionSpecification.action = association("action", Action, upper=1)
BehaviorExecutionSpecification.behavior = association("behavior", Behavior, upper=1)
ParameterSet.parameter = association("parameter", Parameter, lower=1, opposite="parameterSet")
ParameterSet.condition = association("condition", Constraint, composite=True, opposite="parameterSet")
ParameterSet.behavioralFeature = association("behavioralFeature", BehavioralFeature, upper=1, opposite="ownedParameterSet")
Element.ownedElement.add(ParameterSet.condition)  # type: ignore[attr-defined]
ComponentRealization.abstraction = redefine(ComponentRealization, "abstraction", Component, Dependency.supplier)
ComponentRealization.realizingClassifier = redefine(ComponentRealization, "realizingClassifier", Classifier, Dependency.client)
InformationItem.represented = association("represented", Classifier)
InformationFlow.realization = association("realization", Relationship)
InformationFlow.conveyed = association("conveyed", Classifier, lower=1)
InformationFlow.realizingActivityEdge = association("realizingActivityEdge", ActivityEdge)
InformationFlow.realizingMessage = association("realizingMessage", Message)
InformationFlow.realizingConnector = association("realizingConnector", Connector, upper=1, opposite="informationFlow")
InformationFlow.informationSource = association("informationSource", NamedElement, upper=1)
InformationFlow.informationTarget = association("informationTarget", NamedElement, upper=1, opposite="informationFlow")
Element.owner.add(InformationFlow.realizingConnector)  # type: ignore[attr-defined]
DirectedRelationship.source.add(InformationFlow.informationSource)  # type: ignore[attr-defined]
DirectedRelationship.target.add(InformationFlow.informationTarget)  # type: ignore[attr-defined]
