import numpy as np

'''
This module contains helper function to load the iris dataset.
'''


# sepal-length, sepal-width, petal-length, petal-width
# all in cm


inputs_train = np.array([
    [5.8, 2.7, 5.1, 1.9], [5.5, 2.3, 4.0, 1.3], [5.8, 2.7, 3.9, 1.2],
    [5.5, 2.5, 4.0, 1.3], [6.4, 2.8, 5.6, 2.2], [6.8, 2.8, 4.8, 1.4],
    [5.5, 2.4, 3.7, 1.0], [7.6, 3.0, 6.6, 2.1], [5.4, 3.0, 4.5, 1.5],
    [5.5, 2.4, 3.8, 1.1], [5.9, 3.2, 4.8, 1.8], [6.3, 3.3, 4.7, 1.6],
    [6.4, 3.2, 5.3, 2.3], [5.5, 3.5, 1.3, 0.2], [6.1, 2.8, 4.0, 1.3],
    [6.0, 3.4, 4.5, 1.6], [5.1, 3.3, 1.7, 0.5], [7.7, 3.8, 6.7, 2.2],
    [5.8, 2.7, 4.1, 1.0], [6.0, 2.9, 4.5, 1.5], [5.8, 2.8, 5.1, 2.4],
    [5.2, 3.4, 1.4, 0.2], [6.7, 2.5, 5.8, 1.8], [7.0, 3.2, 4.7, 1.4],
    [6.3, 3.3, 6.0, 2.5], [7.7, 2.6, 6.9, 2.3], [6.7, 3.3, 5.7, 2.1],
    [7.2, 3.6, 6.1, 2.5], [6.3, 3.4, 5.6, 2.4], [5.1, 3.5, 1.4, 0.3],
    [4.8, 3.4, 1.6, 0.2], [6.3, 2.7, 4.9, 1.8], [6.7, 3.1, 4.4, 1.4],
    [5.0, 3.4, 1.6, 0.4], [6.6, 3.0, 4.4, 1.4], [5.5, 4.2, 1.4, 0.2],
    [5.0, 3.4, 1.5, 0.2], [6.4, 3.1, 5.5, 1.8], [5.1, 3.8, 1.5, 0.3],
    [6.1, 2.8, 4.7, 1.2], [5.0, 2.0, 3.5, 1.0], [4.6, 3.4, 1.4, 0.3],
    [6.0, 2.2, 5.0, 1.5], [6.1, 2.6, 5.6, 1.4], [4.8, 3.4, 1.9, 0.2],
    [6.6, 2.9, 4.6, 1.3], [6.1, 2.9, 4.7, 1.4], [6.4, 2.8, 5.6, 2.1],
    [5.4, 3.7, 1.5, 0.2], [5.0, 3.2, 1.2, 0.2], [6.2, 2.8, 4.8, 1.8],
    [6.5, 3.0, 5.8, 2.2], [5.6, 3.0, 4.5, 1.5], [6.9, 3.1, 5.4, 2.1],
    [7.1, 3.0, 5.9, 2.1], [4.9, 3.1, 1.5, 0.1], [6.9, 3.2, 5.7, 2.3],
    [5.8, 4.0, 1.2, 0.2], [6.3, 2.3, 4.4, 1.3], [6.4, 2.9, 4.3, 1.3],
    [5.2, 2.7, 3.9, 1.4], [4.6, 3.1, 1.5, 0.2], [6.0, 2.7, 5.1, 1.6],
    [5.1, 3.5, 1.4, 0.2], [6.0, 3.0, 4.8, 1.8], [5.4, 3.9, 1.7, 0.4],
    [5.1, 3.4, 1.5, 0.2], [5.4, 3.4, 1.7, 0.2], [5.7, 2.5, 5.0, 2.0],
    [6.7, 3.0, 5.0, 1.7], [5.6, 2.5, 3.9, 1.1], [6.5, 2.8, 4.6, 1.5],
    [5.4, 3.9, 1.3, 0.4], [4.9, 3.0, 1.4, 0.2], [7.4, 2.8, 6.1, 1.9],
    [7.2, 3.2, 6.0, 1.8], [5.6, 2.9, 3.6, 1.3], [6.4, 3.2, 4.5, 1.5],
    [4.3, 3.0, 1.1, 0.1], [5.1, 3.7, 1.5, 0.4], [5.4, 3.4, 1.5, 0.4],
    [4.8, 3.1, 1.6, 0.2], [7.7, 3.0, 6.1, 2.3], [5.6, 3.0, 4.1, 1.3],
    [6.3, 2.5, 4.9, 1.5], [5.7, 4.4, 1.5, 0.4], [6.5, 3.2, 5.1, 2.0],
    [4.9, 3.1, 1.5, 0.1], [4.8, 3.0, 1.4, 0.1], [5.2, 3.5, 1.5, 0.2],
    [7.9, 3.8, 6.4, 2.0], [5.7, 3.8, 1.7, 0.3], [5.6, 2.8, 4.9, 2.0],
    [6.8, 3.0, 5.5, 2.1], [5.7, 2.8, 4.5, 1.3], [4.7, 3.2, 1.3, 0.2],
    [6.0, 2.2, 4.0, 1.0], [6.1, 3.0, 4.9, 1.8], [4.7, 3.2, 1.6, 0.2],
    [6.5, 3.0, 5.5, 1.8], [5.0, 3.6, 1.4, 0.2], [4.9, 2.4, 3.3, 1.0],
    [5.7, 2.6, 3.5, 1.0], [6.7, 3.1, 4.7, 1.5], [6.4, 2.7, 5.3, 1.9],
    [5.2, 4.1, 1.5, 0.1], [5.0, 3.0, 1.6, 0.2], [7.7, 2.8, 6.7, 2.0],
    [4.9, 2.5, 4.5, 1.7], [4.9, 3.1, 1.5, 0.1], [7.2, 3.0, 5.8, 1.6],
    [4.4, 2.9, 1.4, 0.2], [6.3, 2.9, 5.6, 1.8], [5.9, 3.0, 4.2, 1.5],
    [6.3, 2.8, 5.1, 1.5], [4.4, 3.0, 1.3, 0.2], [7.3, 2.9, 6.3, 1.8],
    [4.6, 3.6, 1.0, 0.2], [6.2, 2.2, 4.5, 1.5], [6.9, 3.1, 4.9, 1.5],
])

outputs_train = np.array([
    [0, 0, 1], [0, 1, 0], [0, 1, 0],
    [0, 1, 0], [0, 0, 1], [0, 1, 0],
    [0, 1, 0], [0, 0, 1], [0, 1, 0],
    [0, 1, 0], [0, 1, 0], [0, 1, 0],
    [0, 0, 1], [1, 0, 0], [0, 1, 0],
    [0, 1, 0], [1, 0, 0], [0, 0, 1],
    [0, 1, 0], [0, 1, 0], [0, 0, 1],
    [1, 0, 0], [0, 0, 1], [0, 1, 0],
    [0, 0, 1], [0, 0, 1], [0, 0, 1],
    [0, 0, 1], [0, 0, 1], [1, 0, 0],
    [1, 0, 0], [0, 0, 1], [0, 1, 0],
    [1, 0, 0], [0, 1, 0], [1, 0, 0],
    [1, 0, 0], [0, 0, 1], [1, 0, 0],
    [0, 1, 0], [0, 1, 0], [1, 0, 0],
    [0, 0, 1], [0, 0, 1], [1, 0, 0],
    [0, 1, 0], [0, 1, 0], [0, 0, 1],
    [1, 0, 0], [1, 0, 0], [0, 0, 1],
    [0, 0, 1], [0, 1, 0], [0, 0, 1],
    [0, 0, 1], [1, 0, 0], [0, 0, 1],
    [1, 0, 0], [0, 1, 0], [0, 1, 0],
    [0, 1, 0], [1, 0, 0], [0, 1, 0],
    [1, 0, 0], [0, 0, 1], [1, 0, 0],
    [1, 0, 0], [1, 0, 0], [0, 0, 1],
    [0, 1, 0], [0, 1, 0], [0, 1, 0],
    [1, 0, 0], [1, 0, 0], [0, 0, 1],
    [0, 0, 1], [0, 1, 0], [0, 1, 0],
    [1, 0, 0], [1, 0, 0], [1, 0, 0],
    [1, 0, 0], [0, 0, 1], [0, 1, 0],
    [0, 1, 0], [1, 0, 0], [0, 0, 1],
    [1, 0, 0], [1, 0, 0], [1, 0, 0],
    [0, 0, 1], [1, 0, 0], [0, 0, 1],
    [0, 0, 1], [0, 1, 0], [1, 0, 0],
    [0, 1, 0], [0, 0, 1], [1, 0, 0],
    [0, 0, 1], [1, 0, 0], [0, 1, 0],
    [0, 1, 0], [0, 1, 0], [0, 0, 1],
    [1, 0, 0], [1, 0, 0], [0, 0, 1],
    [0, 0, 1], [1, 0, 0], [0, 0, 1],
    [1, 0, 0], [0, 0, 1], [0, 1, 0],
    [0, 0, 1], [1, 0, 0], [0, 0, 1],
    [1, 0, 0], [0, 1, 0], [0, 1, 0],
])

inputs_test = np.array([
    [5.6, 2.7, 4.2, 1.3], [6.2, 3.4, 5.4, 2.3], [4.8, 3.0, 1.4, 0.3],
    [5.8, 2.7, 5.1, 1.9], [6.1, 3.0, 4.6, 1.4], [6.7, 3.3, 5.7, 2.5],
    [6.7, 3.0, 5.2, 2.3], [6.8, 3.2, 5.9, 2.3], [5.7, 2.8, 4.1, 1.3],
    [5.8, 2.6, 4.0, 1.2], [5.0, 3.5, 1.3, 0.3], [5.1, 3.8, 1.6, 0.2],
    [4.6, 3.2, 1.4, 0.2], [6.7, 3.1, 5.6, 2.4], [5.1, 3.8, 1.9, 0.4],
    [5.1, 2.5, 3.0, 1.1], [5.7, 2.9, 4.2, 1.3], [5.9, 3.0, 5.1, 1.8],
    [5.3, 3.7, 1.5, 0.2], [5.7, 3.0, 4.2, 1.2], [5.0, 2.3, 3.3, 1.0],
    [6.9, 3.1, 5.1, 2.3], [5.0, 3.3, 1.4, 0.2], [4.5, 2.3, 1.3, 0.3],
    [5.5, 2.6, 4.4, 1.2], [6.5, 3.0, 5.2, 2.0], [5.0, 3.5, 1.6, 0.6],
    [6.3, 2.5, 5.0, 1.9], [6.2, 2.9, 4.3, 1.3], [4.4, 3.2, 1.3, 0.2],
])

outputs_test = np.array([
    [0, 1, 0], [0, 0, 1], [1, 0, 0],
    [0, 0, 1], [0, 1, 0], [0, 0, 1],
    [0, 0, 1], [0, 0, 1], [0, 1, 0],
    [0, 1, 0], [1, 0, 0], [1, 0, 0],
    [1, 0, 0], [0, 0, 1], [1, 0, 0],
    [0, 1, 0], [0, 1, 0], [0, 0, 1],
    [1, 0, 0], [0, 1, 0], [0, 1, 0],
    [0, 0, 1], [1, 0, 0], [1, 0, 0],
    [0, 1, 0], [0, 0, 1], [1, 0, 0],
    [0, 0, 1], [0, 1, 0], [1, 0, 0],
])


def load():
    '''
    Loads the iris dataset without any preprocessing.
    The data set consists of 50 samples from each of three species of Iris
    (Iris setosa, Iris virginica and Iris versicolor).
    Four features were measured from each sample: the length and the width
    of the sepals and petals

    Inputs have the following features/columns:

        :code:`sepal-length sepal-width petal-length petal-width`

    Outputs:

        :code:`[1, 0, 0]` - Iris-setosa,
        :code:`[0, 1, 0]` - Iris-versicolor,
        :code:`[0, 0, 1]` - Iris-virginica.

    Returns
    -------
    inputs_train : numpy.array
        120x4 numpy array, each row having 4 features,
    outputs_train : numpy.array
        120x3 numpy array, contains 150 one-hot vectors, each
        corresponding to a category,
    inputs_test : numpy.array
        30x4 numpy array, each row having 4 features,
    outputs_test : numpy.array
        30x3 numpy array, contains 150 one-hot vectors, each
        corresponding to a category,
    '''
    return inputs_train, outputs_train, inputs_test, outputs_test
