"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MysqlServiceInstance = exports.MysqlServiceInstanceTimeoutsOutputReference = exports.mysqlServiceInstanceTimeoutsToTerraform = exports.MysqlServiceInstanceMysqlConfigurationOutputReference = exports.mysqlServiceInstanceMysqlConfigurationToTerraform = exports.MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference = exports.mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform = exports.MysqlServiceInstanceBackupsOutputReference = exports.mysqlServiceInstanceBackupsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mysqlServiceInstanceBackupsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cloud_storage_container: cdktf.stringToTerraform(struct.cloudStorageContainer),
        cloud_storage_password: cdktf.stringToTerraform(struct.cloudStoragePassword),
        cloud_storage_username: cdktf.stringToTerraform(struct.cloudStorageUsername),
        create_if_missing: cdktf.booleanToTerraform(struct.createIfMissing),
    };
}
exports.mysqlServiceInstanceBackupsToTerraform = mysqlServiceInstanceBackupsToTerraform;
class MysqlServiceInstanceBackupsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cloudStorageContainer !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageContainer = this._cloudStorageContainer;
        }
        if (this._cloudStoragePassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStoragePassword = this._cloudStoragePassword;
        }
        if (this._cloudStorageUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.cloudStorageUsername = this._cloudStorageUsername;
        }
        if (this._createIfMissing !== undefined) {
            hasAnyValues = true;
            internalValueResult.createIfMissing = this._createIfMissing;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cloudStorageContainer = undefined;
            this._cloudStoragePassword = undefined;
            this._cloudStorageUsername = undefined;
            this._createIfMissing = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cloudStorageContainer = value.cloudStorageContainer;
            this._cloudStoragePassword = value.cloudStoragePassword;
            this._cloudStorageUsername = value.cloudStorageUsername;
            this._createIfMissing = value.createIfMissing;
        }
    }
    get cloudStorageContainer() {
        return this.getStringAttribute('cloud_storage_container');
    }
    set cloudStorageContainer(value) {
        this._cloudStorageContainer = value;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageContainerInput() {
        return this._cloudStorageContainer;
    }
    get cloudStoragePassword() {
        return this.getStringAttribute('cloud_storage_password');
    }
    set cloudStoragePassword(value) {
        this._cloudStoragePassword = value;
    }
    resetCloudStoragePassword() {
        this._cloudStoragePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStoragePasswordInput() {
        return this._cloudStoragePassword;
    }
    get cloudStorageUsername() {
        return this.getStringAttribute('cloud_storage_username');
    }
    set cloudStorageUsername(value) {
        this._cloudStorageUsername = value;
    }
    resetCloudStorageUsername() {
        this._cloudStorageUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudStorageUsernameInput() {
        return this._cloudStorageUsername;
    }
    get createIfMissing() {
        return this.getBooleanAttribute('create_if_missing');
    }
    set createIfMissing(value) {
        this._createIfMissing = value;
    }
    resetCreateIfMissing() {
        this._createIfMissing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createIfMissingInput() {
        return this._createIfMissing;
    }
}
exports.MysqlServiceInstanceBackupsOutputReference = MysqlServiceInstanceBackupsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MysqlServiceInstanceBackupsOutputReference[_a] = { fqn: "@cdktf/provider-oraclepaas.mysqlServiceInstance.MysqlServiceInstanceBackupsOutputReference", version: "0.0.0" };
function mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        em_agent_password: cdktf.stringToTerraform(struct.emAgentPassword),
        em_agent_username: cdktf.stringToTerraform(struct.emAgentUsername),
        em_password: cdktf.stringToTerraform(struct.emPassword),
        em_port: cdktf.numberToTerraform(struct.emPort),
        em_username: cdktf.stringToTerraform(struct.emUsername),
    };
}
exports.mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform = mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform;
class MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._emAgentPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.emAgentPassword = this._emAgentPassword;
        }
        if (this._emAgentUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.emAgentUsername = this._emAgentUsername;
        }
        if (this._emPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.emPassword = this._emPassword;
        }
        if (this._emPort !== undefined) {
            hasAnyValues = true;
            internalValueResult.emPort = this._emPort;
        }
        if (this._emUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.emUsername = this._emUsername;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._emAgentPassword = undefined;
            this._emAgentUsername = undefined;
            this._emPassword = undefined;
            this._emPort = undefined;
            this._emUsername = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._emAgentPassword = value.emAgentPassword;
            this._emAgentUsername = value.emAgentUsername;
            this._emPassword = value.emPassword;
            this._emPort = value.emPort;
            this._emUsername = value.emUsername;
        }
    }
    get emAgentPassword() {
        return this.getStringAttribute('em_agent_password');
    }
    set emAgentPassword(value) {
        this._emAgentPassword = value;
    }
    resetEmAgentPassword() {
        this._emAgentPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emAgentPasswordInput() {
        return this._emAgentPassword;
    }
    get emAgentUsername() {
        return this.getStringAttribute('em_agent_username');
    }
    set emAgentUsername(value) {
        this._emAgentUsername = value;
    }
    resetEmAgentUsername() {
        this._emAgentUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emAgentUsernameInput() {
        return this._emAgentUsername;
    }
    get emPassword() {
        return this.getStringAttribute('em_password');
    }
    set emPassword(value) {
        this._emPassword = value;
    }
    resetEmPassword() {
        this._emPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emPasswordInput() {
        return this._emPassword;
    }
    get emPort() {
        return this.getNumberAttribute('em_port');
    }
    set emPort(value) {
        this._emPort = value;
    }
    resetEmPort() {
        this._emPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emPortInput() {
        return this._emPort;
    }
    get emUsername() {
        return this.getStringAttribute('em_username');
    }
    set emUsername(value) {
        this._emUsername = value;
    }
    resetEmUsername() {
        this._emUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emUsernameInput() {
        return this._emUsername;
    }
}
exports.MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference = MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-oraclepaas.mysqlServiceInstance.MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference", version: "0.0.0" };
function mysqlServiceInstanceMysqlConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        db_name: cdktf.stringToTerraform(struct.dbName),
        db_storage: cdktf.numberToTerraform(struct.dbStorage),
        mysql_charset: cdktf.stringToTerraform(struct.mysqlCharset),
        mysql_collation: cdktf.stringToTerraform(struct.mysqlCollation),
        mysql_password: cdktf.stringToTerraform(struct.mysqlPassword),
        mysql_port: cdktf.numberToTerraform(struct.mysqlPort),
        mysql_username: cdktf.stringToTerraform(struct.mysqlUsername),
        snapshot_name: cdktf.stringToTerraform(struct.snapshotName),
        source_service_name: cdktf.stringToTerraform(struct.sourceServiceName),
        enterprise_monitor_configuration: mysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationToTerraform(struct.enterpriseMonitorConfiguration),
    };
}
exports.mysqlServiceInstanceMysqlConfigurationToTerraform = mysqlServiceInstanceMysqlConfigurationToTerraform;
class MysqlServiceInstanceMysqlConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // enterprise_monitor_configuration - computed: false, optional: true, required: false
        this._enterpriseMonitorConfiguration = new MysqlServiceInstanceMysqlConfigurationEnterpriseMonitorConfigurationOutputReference(this, "enterprise_monitor_configuration");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dbName !== undefined) {
            hasAnyValues = true;
            internalValueResult.dbName = this._dbName;
        }
        if (this._dbStorage !== undefined) {
            hasAnyValues = true;
            internalValueResult.dbStorage = this._dbStorage;
        }
        if (this._mysqlCharset !== undefined) {
            hasAnyValues = true;
            internalValueResult.mysqlCharset = this._mysqlCharset;
        }
        if (this._mysqlCollation !== undefined) {
            hasAnyValues = true;
            internalValueResult.mysqlCollation = this._mysqlCollation;
        }
        if (this._mysqlPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.mysqlPassword = this._mysqlPassword;
        }
        if (this._mysqlPort !== undefined) {
            hasAnyValues = true;
            internalValueResult.mysqlPort = this._mysqlPort;
        }
        if (this._mysqlUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.mysqlUsername = this._mysqlUsername;
        }
        if (this._snapshotName !== undefined) {
            hasAnyValues = true;
            internalValueResult.snapshotName = this._snapshotName;
        }
        if (this._sourceServiceName !== undefined) {
            hasAnyValues = true;
            internalValueResult.sourceServiceName = this._sourceServiceName;
        }
        if (this._enterpriseMonitorConfiguration?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.enterpriseMonitorConfiguration = this._enterpriseMonitorConfiguration?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dbName = undefined;
            this._dbStorage = undefined;
            this._mysqlCharset = undefined;
            this._mysqlCollation = undefined;
            this._mysqlPassword = undefined;
            this._mysqlPort = undefined;
            this._mysqlUsername = undefined;
            this._snapshotName = undefined;
            this._sourceServiceName = undefined;
            this._enterpriseMonitorConfiguration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dbName = value.dbName;
            this._dbStorage = value.dbStorage;
            this._mysqlCharset = value.mysqlCharset;
            this._mysqlCollation = value.mysqlCollation;
            this._mysqlPassword = value.mysqlPassword;
            this._mysqlPort = value.mysqlPort;
            this._mysqlUsername = value.mysqlUsername;
            this._snapshotName = value.snapshotName;
            this._sourceServiceName = value.sourceServiceName;
            this._enterpriseMonitorConfiguration.internalValue = value.enterpriseMonitorConfiguration;
        }
    }
    // connect_string - computed: true, optional: false, required: false
    get connectString() {
        return this.getStringAttribute('connect_string');
    }
    get dbName() {
        return this.getStringAttribute('db_name');
    }
    set dbName(value) {
        this._dbName = value;
    }
    resetDbName() {
        this._dbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dbNameInput() {
        return this._dbName;
    }
    get dbStorage() {
        return this.getNumberAttribute('db_storage');
    }
    set dbStorage(value) {
        this._dbStorage = value;
    }
    resetDbStorage() {
        this._dbStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dbStorageInput() {
        return this._dbStorage;
    }
    // ip_address - computed: true, optional: false, required: false
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
    get mysqlCharset() {
        return this.getStringAttribute('mysql_charset');
    }
    set mysqlCharset(value) {
        this._mysqlCharset = value;
    }
    resetMysqlCharset() {
        this._mysqlCharset = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlCharsetInput() {
        return this._mysqlCharset;
    }
    get mysqlCollation() {
        return this.getStringAttribute('mysql_collation');
    }
    set mysqlCollation(value) {
        this._mysqlCollation = value;
    }
    resetMysqlCollation() {
        this._mysqlCollation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlCollationInput() {
        return this._mysqlCollation;
    }
    get mysqlPassword() {
        return this.getStringAttribute('mysql_password');
    }
    set mysqlPassword(value) {
        this._mysqlPassword = value;
    }
    resetMysqlPassword() {
        this._mysqlPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlPasswordInput() {
        return this._mysqlPassword;
    }
    get mysqlPort() {
        return this.getNumberAttribute('mysql_port');
    }
    set mysqlPort(value) {
        this._mysqlPort = value;
    }
    resetMysqlPort() {
        this._mysqlPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlPortInput() {
        return this._mysqlPort;
    }
    get mysqlUsername() {
        return this.getStringAttribute('mysql_username');
    }
    set mysqlUsername(value) {
        this._mysqlUsername = value;
    }
    resetMysqlUsername() {
        this._mysqlUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlUsernameInput() {
        return this._mysqlUsername;
    }
    // public_ip_address - computed: true, optional: false, required: false
    get publicIpAddress() {
        return this.getStringAttribute('public_ip_address');
    }
    get snapshotName() {
        return this.getStringAttribute('snapshot_name');
    }
    set snapshotName(value) {
        this._snapshotName = value;
    }
    resetSnapshotName() {
        this._snapshotName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotNameInput() {
        return this._snapshotName;
    }
    get sourceServiceName() {
        return this.getStringAttribute('source_service_name');
    }
    set sourceServiceName(value) {
        this._sourceServiceName = value;
    }
    resetSourceServiceName() {
        this._sourceServiceName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceServiceNameInput() {
        return this._sourceServiceName;
    }
    get enterpriseMonitorConfiguration() {
        return this._enterpriseMonitorConfiguration;
    }
    putEnterpriseMonitorConfiguration(value) {
        this._enterpriseMonitorConfiguration.internalValue = value;
    }
    resetEnterpriseMonitorConfiguration() {
        this._enterpriseMonitorConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enterpriseMonitorConfigurationInput() {
        return this._enterpriseMonitorConfiguration.internalValue;
    }
}
exports.MysqlServiceInstanceMysqlConfigurationOutputReference = MysqlServiceInstanceMysqlConfigurationOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MysqlServiceInstanceMysqlConfigurationOutputReference[_c] = { fqn: "@cdktf/provider-oraclepaas.mysqlServiceInstance.MysqlServiceInstanceMysqlConfigurationOutputReference", version: "0.0.0" };
function mysqlServiceInstanceTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
    };
}
exports.mysqlServiceInstanceTimeoutsToTerraform = mysqlServiceInstanceTimeoutsToTerraform;
class MysqlServiceInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
}
exports.MysqlServiceInstanceTimeoutsOutputReference = MysqlServiceInstanceTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MysqlServiceInstanceTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-oraclepaas.mysqlServiceInstance.MysqlServiceInstanceTimeoutsOutputReference", version: "0.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance oraclepaas_mysql_service_instance}
*/
class MysqlServiceInstance extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/mysql_service_instance oraclepaas_mysql_service_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlServiceInstanceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'oraclepaas_mysql_service_instance',
            terraformGeneratorMetadata: {
                providerName: 'oraclepaas',
                providerVersion: '1.5.3',
                providerVersionConstraint: '~> 1.5'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // backups - computed: false, optional: true, required: false
        this._backups = new MysqlServiceInstanceBackupsOutputReference(this, "backups");
        // mysql_configuration - computed: false, optional: false, required: true
        this._mysqlConfiguration = new MysqlServiceInstanceMysqlConfigurationOutputReference(this, "mysql_configuration");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MysqlServiceInstanceTimeoutsOutputReference(this, "timeouts");
        this._availabilityDomain = config.availabilityDomain;
        this._backupDestination = config.backupDestination;
        this._description = config.description;
        this._id = config.id;
        this._ipNetwork = config.ipNetwork;
        this._meteringFrequency = config.meteringFrequency;
        this._name = config.name;
        this._notificationEmail = config.notificationEmail;
        this._region = config.region;
        this._shape = config.shape;
        this._sshPublicKey = config.sshPublicKey;
        this._subnet = config.subnet;
        this._vmUser = config.vmUser;
        this._backups.internalValue = config.backups;
        this._mysqlConfiguration.internalValue = config.mysqlConfiguration;
        this._timeouts.internalValue = config.timeouts;
    }
    get availabilityDomain() {
        return this.getStringAttribute('availability_domain');
    }
    set availabilityDomain(value) {
        this._availabilityDomain = value;
    }
    resetAvailabilityDomain() {
        this._availabilityDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availabilityDomainInput() {
        return this._availabilityDomain;
    }
    get backupDestination() {
        return this.getStringAttribute('backup_destination');
    }
    set backupDestination(value) {
        this._backupDestination = value;
    }
    resetBackupDestination() {
        this._backupDestination = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupDestinationInput() {
        return this._backupDestination;
    }
    // base_release_version - computed: true, optional: false, required: false
    get baseReleaseVersion() {
        return this.getStringAttribute('base_release_version');
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // em_url - computed: true, optional: false, required: false
    get emUrl() {
        return this.getStringAttribute('em_url');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ipNetwork() {
        return this.getStringAttribute('ip_network');
    }
    set ipNetwork(value) {
        this._ipNetwork = value;
    }
    resetIpNetwork() {
        this._ipNetwork = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipNetworkInput() {
        return this._ipNetwork;
    }
    get meteringFrequency() {
        return this.getStringAttribute('metering_frequency');
    }
    set meteringFrequency(value) {
        this._meteringFrequency = value;
    }
    resetMeteringFrequency() {
        this._meteringFrequency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get meteringFrequencyInput() {
        return this._meteringFrequency;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get notificationEmail() {
        return this.getStringAttribute('notification_email');
    }
    set notificationEmail(value) {
        this._notificationEmail = value;
    }
    resetNotificationEmail() {
        this._notificationEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationEmailInput() {
        return this._notificationEmail;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    // release_version - computed: true, optional: false, required: false
    get releaseVersion() {
        return this.getStringAttribute('release_version');
    }
    // service_version - computed: true, optional: false, required: false
    get serviceVersion() {
        return this.getStringAttribute('service_version');
    }
    get shape() {
        return this.getStringAttribute('shape');
    }
    set shape(value) {
        this._shape = value;
    }
    // Temporarily expose input value. Use with caution.
    get shapeInput() {
        return this._shape;
    }
    get sshPublicKey() {
        return this.getStringAttribute('ssh_public_key');
    }
    set sshPublicKey(value) {
        this._sshPublicKey = value;
    }
    // Temporarily expose input value. Use with caution.
    get sshPublicKeyInput() {
        return this._sshPublicKey;
    }
    get subnet() {
        return this.getStringAttribute('subnet');
    }
    set subnet(value) {
        this._subnet = value;
    }
    resetSubnet() {
        this._subnet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetInput() {
        return this._subnet;
    }
    get vmUser() {
        return this.getStringAttribute('vm_user');
    }
    set vmUser(value) {
        this._vmUser = value;
    }
    resetVmUser() {
        this._vmUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmUserInput() {
        return this._vmUser;
    }
    get backups() {
        return this._backups;
    }
    putBackups(value) {
        this._backups.internalValue = value;
    }
    resetBackups() {
        this._backups.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupsInput() {
        return this._backups.internalValue;
    }
    get mysqlConfiguration() {
        return this._mysqlConfiguration;
    }
    putMysqlConfiguration(value) {
        this._mysqlConfiguration.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlConfigurationInput() {
        return this._mysqlConfiguration.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            availability_domain: cdktf.stringToTerraform(this._availabilityDomain),
            backup_destination: cdktf.stringToTerraform(this._backupDestination),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            ip_network: cdktf.stringToTerraform(this._ipNetwork),
            metering_frequency: cdktf.stringToTerraform(this._meteringFrequency),
            name: cdktf.stringToTerraform(this._name),
            notification_email: cdktf.stringToTerraform(this._notificationEmail),
            region: cdktf.stringToTerraform(this._region),
            shape: cdktf.stringToTerraform(this._shape),
            ssh_public_key: cdktf.stringToTerraform(this._sshPublicKey),
            subnet: cdktf.stringToTerraform(this._subnet),
            vm_user: cdktf.stringToTerraform(this._vmUser),
            backups: mysqlServiceInstanceBackupsToTerraform(this._backups.internalValue),
            mysql_configuration: mysqlServiceInstanceMysqlConfigurationToTerraform(this._mysqlConfiguration.internalValue),
            timeouts: mysqlServiceInstanceTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MysqlServiceInstance = MysqlServiceInstance;
_e = JSII_RTTI_SYMBOL_1;
MysqlServiceInstance[_e] = { fqn: "@cdktf/provider-oraclepaas.mysqlServiceInstance.MysqlServiceInstance", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
MysqlServiceInstance.tfResourceType = "oraclepaas_mysql_service_instance";
//# sourceMappingURL=data:application/json;base64,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