import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JavaServiceInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#assign_public_ip JavaServiceInstance#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#availability_domain JavaServiceInstance#availability_domain}
    */
    readonly availabilityDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#backup_destination JavaServiceInstance#backup_destination}
    */
    readonly backupDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#bring_your_own_license JavaServiceInstance#bring_your_own_license}
    */
    readonly bringYourOwnLicense?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#description JavaServiceInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#desired_state JavaServiceInstance#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#edition JavaServiceInstance#edition}
    */
    readonly edition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#enable_admin_console JavaServiceInstance#enable_admin_console}
    */
    readonly enableAdminConsole?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#force_delete JavaServiceInstance#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#id JavaServiceInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#ip_network JavaServiceInstance#ip_network}
    */
    readonly ipNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#level JavaServiceInstance#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#metering_frequency JavaServiceInstance#metering_frequency}
    */
    readonly meteringFrequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#name JavaServiceInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#notification_email JavaServiceInstance#notification_email}
    */
    readonly notificationEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#region JavaServiceInstance#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#service_version JavaServiceInstance#service_version}
    */
    readonly serviceVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#snapshot_name JavaServiceInstance#snapshot_name}
    */
    readonly snapshotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#source_service_name JavaServiceInstance#source_service_name}
    */
    readonly sourceServiceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#ssh_public_key JavaServiceInstance#ssh_public_key}
    */
    readonly sshPublicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#subnet JavaServiceInstance#subnet}
    */
    readonly subnet?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#use_identity_service JavaServiceInstance#use_identity_service}
    */
    readonly useIdentityService?: boolean | cdktf.IResolvable;
    /**
    * backups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#backups JavaServiceInstance#backups}
    */
    readonly backups: JavaServiceInstanceBackups;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#load_balancer JavaServiceInstance#load_balancer}
    */
    readonly loadBalancer?: JavaServiceInstanceLoadBalancer;
    /**
    * oracle_traffic_director block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#oracle_traffic_director JavaServiceInstance#oracle_traffic_director}
    */
    readonly oracleTrafficDirector?: JavaServiceInstanceOracleTrafficDirector;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#timeouts JavaServiceInstance#timeouts}
    */
    readonly timeouts?: JavaServiceInstanceTimeouts;
    /**
    * weblogic_server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#weblogic_server JavaServiceInstance#weblogic_server}
    */
    readonly weblogicServer: JavaServiceInstanceWeblogicServer;
}
export interface JavaServiceInstanceBackups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#auto_generate JavaServiceInstance#auto_generate}
    */
    readonly autoGenerate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#cloud_storage_container JavaServiceInstance#cloud_storage_container}
    */
    readonly cloudStorageContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#cloud_storage_password JavaServiceInstance#cloud_storage_password}
    */
    readonly cloudStoragePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#cloud_storage_username JavaServiceInstance#cloud_storage_username}
    */
    readonly cloudStorageUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#use_oauth_for_storage JavaServiceInstance#use_oauth_for_storage}
    */
    readonly useOauthForStorage?: boolean | cdktf.IResolvable;
}
export declare function javaServiceInstanceBackupsToTerraform(struct?: JavaServiceInstanceBackupsOutputReference | JavaServiceInstanceBackups): any;
export declare class JavaServiceInstanceBackupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceBackups | undefined;
    set internalValue(value: JavaServiceInstanceBackups | undefined);
    private _autoGenerate?;
    get autoGenerate(): boolean | cdktf.IResolvable;
    set autoGenerate(value: boolean | cdktf.IResolvable);
    resetAutoGenerate(): void;
    get autoGenerateInput(): boolean | cdktf.IResolvable | undefined;
    private _cloudStorageContainer?;
    get cloudStorageContainer(): string;
    set cloudStorageContainer(value: string);
    get cloudStorageContainerInput(): string | undefined;
    private _cloudStoragePassword?;
    get cloudStoragePassword(): string;
    set cloudStoragePassword(value: string);
    resetCloudStoragePassword(): void;
    get cloudStoragePasswordInput(): string | undefined;
    private _cloudStorageUsername?;
    get cloudStorageUsername(): string;
    set cloudStorageUsername(value: string);
    resetCloudStorageUsername(): void;
    get cloudStorageUsernameInput(): string | undefined;
    private _useOauthForStorage?;
    get useOauthForStorage(): boolean | cdktf.IResolvable;
    set useOauthForStorage(value: boolean | cdktf.IResolvable);
    resetUseOauthForStorage(): void;
    get useOauthForStorageInput(): boolean | cdktf.IResolvable | undefined;
}
export interface JavaServiceInstanceLoadBalancer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#load_balancing_policy JavaServiceInstance#load_balancing_policy}
    */
    readonly loadBalancingPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#subnets JavaServiceInstance#subnets}
    */
    readonly subnets?: string[];
}
export declare function javaServiceInstanceLoadBalancerToTerraform(struct?: JavaServiceInstanceLoadBalancerOutputReference | JavaServiceInstanceLoadBalancer): any;
export declare class JavaServiceInstanceLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceLoadBalancer | undefined;
    set internalValue(value: JavaServiceInstanceLoadBalancer | undefined);
    get adminUrl(): string;
    get consoleUrl(): string;
    private _loadBalancingPolicy?;
    get loadBalancingPolicy(): string;
    set loadBalancingPolicy(value: string);
    resetLoadBalancingPolicy(): void;
    get loadBalancingPolicyInput(): string | undefined;
    private _subnets?;
    get subnets(): string[];
    set subnets(value: string[]);
    resetSubnets(): void;
    get subnetsInput(): string[] | undefined;
    get url(): string;
}
export interface JavaServiceInstanceOracleTrafficDirectorAdmin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#password JavaServiceInstance#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#port JavaServiceInstance#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#username JavaServiceInstance#username}
    */
    readonly username: string;
}
export declare function javaServiceInstanceOracleTrafficDirectorAdminToTerraform(struct?: JavaServiceInstanceOracleTrafficDirectorAdminOutputReference | JavaServiceInstanceOracleTrafficDirectorAdmin): any;
export declare class JavaServiceInstanceOracleTrafficDirectorAdminOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceOracleTrafficDirectorAdmin | undefined;
    set internalValue(value: JavaServiceInstanceOracleTrafficDirectorAdmin | undefined);
    get hostname(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JavaServiceInstanceOracleTrafficDirectorListener {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#port JavaServiceInstance#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#privileged_port JavaServiceInstance#privileged_port}
    */
    readonly privilegedPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#privileged_secured_port JavaServiceInstance#privileged_secured_port}
    */
    readonly privilegedSecuredPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#secured_port JavaServiceInstance#secured_port}
    */
    readonly securedPort?: number;
}
export declare function javaServiceInstanceOracleTrafficDirectorListenerToTerraform(struct?: JavaServiceInstanceOracleTrafficDirectorListenerOutputReference | JavaServiceInstanceOracleTrafficDirectorListener): any;
export declare class JavaServiceInstanceOracleTrafficDirectorListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceOracleTrafficDirectorListener | undefined;
    set internalValue(value: JavaServiceInstanceOracleTrafficDirectorListener | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _privilegedPort?;
    get privilegedPort(): number;
    set privilegedPort(value: number);
    resetPrivilegedPort(): void;
    get privilegedPortInput(): number | undefined;
    private _privilegedSecuredPort?;
    get privilegedSecuredPort(): number;
    set privilegedSecuredPort(value: number);
    resetPrivilegedSecuredPort(): void;
    get privilegedSecuredPortInput(): number | undefined;
    private _securedPort?;
    get securedPort(): number;
    set securedPort(value: number);
    resetSecuredPort(): void;
    get securedPortInput(): number | undefined;
}
export interface JavaServiceInstanceOracleTrafficDirector {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#high_availability JavaServiceInstance#high_availability}
    */
    readonly highAvailability?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#ip_reservations JavaServiceInstance#ip_reservations}
    */
    readonly ipReservations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#load_balancing_policy JavaServiceInstance#load_balancing_policy}
    */
    readonly loadBalancingPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#shape JavaServiceInstance#shape}
    */
    readonly shape: string;
    /**
    * admin block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#admin JavaServiceInstance#admin}
    */
    readonly admin: JavaServiceInstanceOracleTrafficDirectorAdmin;
    /**
    * listener block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#listener JavaServiceInstance#listener}
    */
    readonly listener?: JavaServiceInstanceOracleTrafficDirectorListener;
}
export declare function javaServiceInstanceOracleTrafficDirectorToTerraform(struct?: JavaServiceInstanceOracleTrafficDirectorOutputReference | JavaServiceInstanceOracleTrafficDirector): any;
export declare class JavaServiceInstanceOracleTrafficDirectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceOracleTrafficDirector | undefined;
    set internalValue(value: JavaServiceInstanceOracleTrafficDirector | undefined);
    private _highAvailability?;
    get highAvailability(): boolean | cdktf.IResolvable;
    set highAvailability(value: boolean | cdktf.IResolvable);
    resetHighAvailability(): void;
    get highAvailabilityInput(): boolean | cdktf.IResolvable | undefined;
    private _ipReservations?;
    get ipReservations(): string[];
    set ipReservations(value: string[]);
    resetIpReservations(): void;
    get ipReservationsInput(): string[] | undefined;
    private _loadBalancingPolicy?;
    get loadBalancingPolicy(): string;
    set loadBalancingPolicy(value: string);
    resetLoadBalancingPolicy(): void;
    get loadBalancingPolicyInput(): string | undefined;
    get rootUrl(): string;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    private _admin;
    get admin(): JavaServiceInstanceOracleTrafficDirectorAdminOutputReference;
    putAdmin(value: JavaServiceInstanceOracleTrafficDirectorAdmin): void;
    get adminInput(): JavaServiceInstanceOracleTrafficDirectorAdmin | undefined;
    private _listener;
    get listener(): JavaServiceInstanceOracleTrafficDirectorListenerOutputReference;
    putListener(value: JavaServiceInstanceOracleTrafficDirectorListener): void;
    resetListener(): void;
    get listenerInput(): JavaServiceInstanceOracleTrafficDirectorListener | undefined;
}
export interface JavaServiceInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#create JavaServiceInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#delete JavaServiceInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#update JavaServiceInstance#update}
    */
    readonly update?: string;
}
export declare function javaServiceInstanceTimeoutsToTerraform(struct?: JavaServiceInstanceTimeoutsOutputReference | JavaServiceInstanceTimeouts | cdktf.IResolvable): any;
export declare class JavaServiceInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: JavaServiceInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface JavaServiceInstanceWeblogicServerAdmin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#password JavaServiceInstance#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#port JavaServiceInstance#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#secured_port JavaServiceInstance#secured_port}
    */
    readonly securedPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#username JavaServiceInstance#username}
    */
    readonly username: string;
}
export declare function javaServiceInstanceWeblogicServerAdminToTerraform(struct?: JavaServiceInstanceWeblogicServerAdminOutputReference | JavaServiceInstanceWeblogicServerAdmin): any;
export declare class JavaServiceInstanceWeblogicServerAdminOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerAdmin | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerAdmin | undefined);
    get hostname(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _securedPort?;
    get securedPort(): number;
    set securedPort(value: number);
    resetSecuredPort(): void;
    get securedPortInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JavaServiceInstanceWeblogicServerApplicationDatabase {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#name JavaServiceInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#password JavaServiceInstance#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#pdb_name JavaServiceInstance#pdb_name}
    */
    readonly pdbName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#username JavaServiceInstance#username}
    */
    readonly username: string;
}
export declare function javaServiceInstanceWeblogicServerApplicationDatabaseToTerraform(struct?: JavaServiceInstanceWeblogicServerApplicationDatabase | cdktf.IResolvable): any;
export declare class JavaServiceInstanceWeblogicServerApplicationDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JavaServiceInstanceWeblogicServerApplicationDatabase | cdktf.IResolvable | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerApplicationDatabase | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pdbName?;
    get pdbName(): string;
    set pdbName(value: string);
    resetPdbName(): void;
    get pdbNameInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class JavaServiceInstanceWeblogicServerApplicationDatabaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JavaServiceInstanceWeblogicServerApplicationDatabase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JavaServiceInstanceWeblogicServerApplicationDatabaseOutputReference;
}
export interface JavaServiceInstanceWeblogicServerCluster {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#name JavaServiceInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#path_prefixes JavaServiceInstance#path_prefixes}
    */
    readonly pathPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#server_count JavaServiceInstance#server_count}
    */
    readonly serverCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#servers_per_node JavaServiceInstance#servers_per_node}
    */
    readonly serversPerNode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#shape JavaServiceInstance#shape}
    */
    readonly shape?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#type JavaServiceInstance#type}
    */
    readonly type: string;
}
export declare function javaServiceInstanceWeblogicServerClusterToTerraform(struct?: JavaServiceInstanceWeblogicServerCluster | cdktf.IResolvable): any;
export declare class JavaServiceInstanceWeblogicServerClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): JavaServiceInstanceWeblogicServerCluster | cdktf.IResolvable | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerCluster | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pathPrefixes?;
    get pathPrefixes(): string[];
    set pathPrefixes(value: string[]);
    resetPathPrefixes(): void;
    get pathPrefixesInput(): string[] | undefined;
    private _serverCount?;
    get serverCount(): number;
    set serverCount(value: number);
    resetServerCount(): void;
    get serverCountInput(): number | undefined;
    private _serversPerNode?;
    get serversPerNode(): number;
    set serversPerNode(value: number);
    resetServersPerNode(): void;
    get serversPerNodeInput(): number | undefined;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    resetShape(): void;
    get shapeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class JavaServiceInstanceWeblogicServerClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: JavaServiceInstanceWeblogicServerCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): JavaServiceInstanceWeblogicServerClusterOutputReference;
}
export interface JavaServiceInstanceWeblogicServerDatabase {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#name JavaServiceInstance#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#password JavaServiceInstance#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#pdb_name JavaServiceInstance#pdb_name}
    */
    readonly pdbName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#username JavaServiceInstance#username}
    */
    readonly username: string;
}
export declare function javaServiceInstanceWeblogicServerDatabaseToTerraform(struct?: JavaServiceInstanceWeblogicServerDatabaseOutputReference | JavaServiceInstanceWeblogicServerDatabase): any;
export declare class JavaServiceInstanceWeblogicServerDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerDatabase | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerDatabase | undefined);
    get hostname(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pdbName?;
    get pdbName(): string;
    set pdbName(value: string);
    resetPdbName(): void;
    get pdbNameInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface JavaServiceInstanceWeblogicServerDomain {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#mode JavaServiceInstance#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#name JavaServiceInstance#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#partition_count JavaServiceInstance#partition_count}
    */
    readonly partitionCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#volume_size JavaServiceInstance#volume_size}
    */
    readonly volumeSize?: string;
}
export declare function javaServiceInstanceWeblogicServerDomainToTerraform(struct?: JavaServiceInstanceWeblogicServerDomainOutputReference | JavaServiceInstanceWeblogicServerDomain): any;
export declare class JavaServiceInstanceWeblogicServerDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerDomain | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerDomain | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partitionCount?;
    get partitionCount(): number;
    set partitionCount(value: number);
    resetPartitionCount(): void;
    get partitionCountInput(): number | undefined;
    private _volumeSize?;
    get volumeSize(): string;
    set volumeSize(value: string);
    resetVolumeSize(): void;
    get volumeSizeInput(): string | undefined;
}
export interface JavaServiceInstanceWeblogicServerManagedServers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#initial_heap_size JavaServiceInstance#initial_heap_size}
    */
    readonly initialHeapSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#initial_permanent_generation JavaServiceInstance#initial_permanent_generation}
    */
    readonly initialPermanentGeneration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#jvm_args JavaServiceInstance#jvm_args}
    */
    readonly jvmArgs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#max_heap_size JavaServiceInstance#max_heap_size}
    */
    readonly maxHeapSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#max_permanent_generation JavaServiceInstance#max_permanent_generation}
    */
    readonly maxPermanentGeneration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#overwrite_jvm_args JavaServiceInstance#overwrite_jvm_args}
    */
    readonly overwriteJvmArgs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#server_count JavaServiceInstance#server_count}
    */
    readonly serverCount?: number;
}
export declare function javaServiceInstanceWeblogicServerManagedServersToTerraform(struct?: JavaServiceInstanceWeblogicServerManagedServersOutputReference | JavaServiceInstanceWeblogicServerManagedServers): any;
export declare class JavaServiceInstanceWeblogicServerManagedServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerManagedServers | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerManagedServers | undefined);
    private _initialHeapSize?;
    get initialHeapSize(): number;
    set initialHeapSize(value: number);
    resetInitialHeapSize(): void;
    get initialHeapSizeInput(): number | undefined;
    private _initialPermanentGeneration?;
    get initialPermanentGeneration(): number;
    set initialPermanentGeneration(value: number);
    resetInitialPermanentGeneration(): void;
    get initialPermanentGenerationInput(): number | undefined;
    private _jvmArgs?;
    get jvmArgs(): string;
    set jvmArgs(value: string);
    resetJvmArgs(): void;
    get jvmArgsInput(): string | undefined;
    private _maxHeapSize?;
    get maxHeapSize(): number;
    set maxHeapSize(value: number);
    resetMaxHeapSize(): void;
    get maxHeapSizeInput(): number | undefined;
    private _maxPermanentGeneration?;
    get maxPermanentGeneration(): number;
    set maxPermanentGeneration(value: number);
    resetMaxPermanentGeneration(): void;
    get maxPermanentGenerationInput(): number | undefined;
    private _overwriteJvmArgs?;
    get overwriteJvmArgs(): boolean | cdktf.IResolvable;
    set overwriteJvmArgs(value: boolean | cdktf.IResolvable);
    resetOverwriteJvmArgs(): void;
    get overwriteJvmArgsInput(): boolean | cdktf.IResolvable | undefined;
    private _serverCount?;
    get serverCount(): number;
    set serverCount(value: number);
    resetServerCount(): void;
    get serverCountInput(): number | undefined;
}
export interface JavaServiceInstanceWeblogicServerNodeManager {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#password JavaServiceInstance#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#port JavaServiceInstance#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#username JavaServiceInstance#username}
    */
    readonly username?: string;
}
export declare function javaServiceInstanceWeblogicServerNodeManagerToTerraform(struct?: JavaServiceInstanceWeblogicServerNodeManagerOutputReference | JavaServiceInstanceWeblogicServerNodeManager): any;
export declare class JavaServiceInstanceWeblogicServerNodeManagerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerNodeManager | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerNodeManager | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface JavaServiceInstanceWeblogicServerPorts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#content_port JavaServiceInstance#content_port}
    */
    readonly contentPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#deployment_channel_port JavaServiceInstance#deployment_channel_port}
    */
    readonly deploymentChannelPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#privileged_content_port JavaServiceInstance#privileged_content_port}
    */
    readonly privilegedContentPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#privileged_secured_content_port JavaServiceInstance#privileged_secured_content_port}
    */
    readonly privilegedSecuredContentPort?: number;
}
export declare function javaServiceInstanceWeblogicServerPortsToTerraform(struct?: JavaServiceInstanceWeblogicServerPortsOutputReference | JavaServiceInstanceWeblogicServerPorts): any;
export declare class JavaServiceInstanceWeblogicServerPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServerPorts | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServerPorts | undefined);
    private _contentPort?;
    get contentPort(): number;
    set contentPort(value: number);
    resetContentPort(): void;
    get contentPortInput(): number | undefined;
    private _deploymentChannelPort?;
    get deploymentChannelPort(): number;
    set deploymentChannelPort(value: number);
    resetDeploymentChannelPort(): void;
    get deploymentChannelPortInput(): number | undefined;
    private _privilegedContentPort?;
    get privilegedContentPort(): number;
    set privilegedContentPort(value: number);
    resetPrivilegedContentPort(): void;
    get privilegedContentPortInput(): number | undefined;
    private _privilegedSecuredContentPort?;
    get privilegedSecuredContentPort(): number;
    set privilegedSecuredContentPort(value: number);
    resetPrivilegedSecuredContentPort(): void;
    get privilegedSecuredContentPortInput(): number | undefined;
}
export interface JavaServiceInstanceWeblogicServer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#backup_volume_size JavaServiceInstance#backup_volume_size}
    */
    readonly backupVolumeSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#cluster_name JavaServiceInstance#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#connect_string JavaServiceInstance#connect_string}
    */
    readonly connectString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#ip_reservations JavaServiceInstance#ip_reservations}
    */
    readonly ipReservations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#middleware_volume_size JavaServiceInstance#middleware_volume_size}
    */
    readonly middlewareVolumeSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#shape JavaServiceInstance#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#upper_stack_product_name JavaServiceInstance#upper_stack_product_name}
    */
    readonly upperStackProductName?: string;
    /**
    * admin block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#admin JavaServiceInstance#admin}
    */
    readonly admin: JavaServiceInstanceWeblogicServerAdmin;
    /**
    * application_database block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#application_database JavaServiceInstance#application_database}
    */
    readonly applicationDatabase?: JavaServiceInstanceWeblogicServerApplicationDatabase[] | cdktf.IResolvable;
    /**
    * cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#cluster JavaServiceInstance#cluster}
    */
    readonly cluster?: JavaServiceInstanceWeblogicServerCluster[] | cdktf.IResolvable;
    /**
    * database block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#database JavaServiceInstance#database}
    */
    readonly database: JavaServiceInstanceWeblogicServerDatabase;
    /**
    * domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#domain JavaServiceInstance#domain}
    */
    readonly domain?: JavaServiceInstanceWeblogicServerDomain;
    /**
    * managed_servers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#managed_servers JavaServiceInstance#managed_servers}
    */
    readonly managedServers?: JavaServiceInstanceWeblogicServerManagedServers;
    /**
    * node_manager block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#node_manager JavaServiceInstance#node_manager}
    */
    readonly nodeManager?: JavaServiceInstanceWeblogicServerNodeManager;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance#ports JavaServiceInstance#ports}
    */
    readonly ports?: JavaServiceInstanceWeblogicServerPorts;
}
export declare function javaServiceInstanceWeblogicServerToTerraform(struct?: JavaServiceInstanceWeblogicServerOutputReference | JavaServiceInstanceWeblogicServer): any;
export declare class JavaServiceInstanceWeblogicServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): JavaServiceInstanceWeblogicServer | undefined;
    set internalValue(value: JavaServiceInstanceWeblogicServer | undefined);
    private _backupVolumeSize?;
    get backupVolumeSize(): string;
    set backupVolumeSize(value: string);
    resetBackupVolumeSize(): void;
    get backupVolumeSizeInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _connectString?;
    get connectString(): string;
    set connectString(value: string);
    resetConnectString(): void;
    get connectStringInput(): string | undefined;
    private _ipReservations?;
    get ipReservations(): string[];
    set ipReservations(value: string[]);
    resetIpReservations(): void;
    get ipReservationsInput(): string[] | undefined;
    private _middlewareVolumeSize?;
    get middlewareVolumeSize(): string;
    set middlewareVolumeSize(value: string);
    resetMiddlewareVolumeSize(): void;
    get middlewareVolumeSizeInput(): string | undefined;
    get rootUrl(): string;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    private _upperStackProductName?;
    get upperStackProductName(): string;
    set upperStackProductName(value: string);
    resetUpperStackProductName(): void;
    get upperStackProductNameInput(): string | undefined;
    private _admin;
    get admin(): JavaServiceInstanceWeblogicServerAdminOutputReference;
    putAdmin(value: JavaServiceInstanceWeblogicServerAdmin): void;
    get adminInput(): JavaServiceInstanceWeblogicServerAdmin | undefined;
    private _applicationDatabase;
    get applicationDatabase(): JavaServiceInstanceWeblogicServerApplicationDatabaseList;
    putApplicationDatabase(value: JavaServiceInstanceWeblogicServerApplicationDatabase[] | cdktf.IResolvable): void;
    resetApplicationDatabase(): void;
    get applicationDatabaseInput(): cdktf.IResolvable | JavaServiceInstanceWeblogicServerApplicationDatabase[] | undefined;
    private _cluster;
    get cluster(): JavaServiceInstanceWeblogicServerClusterList;
    putCluster(value: JavaServiceInstanceWeblogicServerCluster[] | cdktf.IResolvable): void;
    resetCluster(): void;
    get clusterInput(): cdktf.IResolvable | JavaServiceInstanceWeblogicServerCluster[] | undefined;
    private _database;
    get database(): JavaServiceInstanceWeblogicServerDatabaseOutputReference;
    putDatabase(value: JavaServiceInstanceWeblogicServerDatabase): void;
    get databaseInput(): JavaServiceInstanceWeblogicServerDatabase | undefined;
    private _domain;
    get domain(): JavaServiceInstanceWeblogicServerDomainOutputReference;
    putDomain(value: JavaServiceInstanceWeblogicServerDomain): void;
    resetDomain(): void;
    get domainInput(): JavaServiceInstanceWeblogicServerDomain | undefined;
    private _managedServers;
    get managedServers(): JavaServiceInstanceWeblogicServerManagedServersOutputReference;
    putManagedServers(value: JavaServiceInstanceWeblogicServerManagedServers): void;
    resetManagedServers(): void;
    get managedServersInput(): JavaServiceInstanceWeblogicServerManagedServers | undefined;
    private _nodeManager;
    get nodeManager(): JavaServiceInstanceWeblogicServerNodeManagerOutputReference;
    putNodeManager(value: JavaServiceInstanceWeblogicServerNodeManager): void;
    resetNodeManager(): void;
    get nodeManagerInput(): JavaServiceInstanceWeblogicServerNodeManager | undefined;
    private _ports;
    get ports(): JavaServiceInstanceWeblogicServerPortsOutputReference;
    putPorts(value: JavaServiceInstanceWeblogicServerPorts): void;
    resetPorts(): void;
    get portsInput(): JavaServiceInstanceWeblogicServerPorts | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance oraclepaas_java_service_instance}
*/
export declare class JavaServiceInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "oraclepaas_java_service_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/r/java_service_instance oraclepaas_java_service_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JavaServiceInstanceConfig
    */
    constructor(scope: Construct, id: string, config: JavaServiceInstanceConfig);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityDomain?;
    get availabilityDomain(): string;
    set availabilityDomain(value: string);
    resetAvailabilityDomain(): void;
    get availabilityDomainInput(): string | undefined;
    private _backupDestination?;
    get backupDestination(): string;
    set backupDestination(value: string);
    resetBackupDestination(): void;
    get backupDestinationInput(): string | undefined;
    private _bringYourOwnLicense?;
    get bringYourOwnLicense(): boolean | cdktf.IResolvable;
    set bringYourOwnLicense(value: boolean | cdktf.IResolvable);
    resetBringYourOwnLicense(): void;
    get bringYourOwnLicenseInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    get editionInput(): string | undefined;
    private _enableAdminConsole?;
    get enableAdminConsole(): boolean | cdktf.IResolvable;
    set enableAdminConsole(value: boolean | cdktf.IResolvable);
    resetEnableAdminConsole(): void;
    get enableAdminConsoleInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipNetwork?;
    get ipNetwork(): string;
    set ipNetwork(value: string);
    resetIpNetwork(): void;
    get ipNetworkInput(): string | undefined;
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _meteringFrequency?;
    get meteringFrequency(): string;
    set meteringFrequency(value: string);
    resetMeteringFrequency(): void;
    get meteringFrequencyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationEmail?;
    get notificationEmail(): string;
    set notificationEmail(value: string);
    resetNotificationEmail(): void;
    get notificationEmailInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _serviceVersion?;
    get serviceVersion(): string;
    set serviceVersion(value: string);
    resetServiceVersion(): void;
    get serviceVersionInput(): string | undefined;
    private _snapshotName?;
    get snapshotName(): string;
    set snapshotName(value: string);
    resetSnapshotName(): void;
    get snapshotNameInput(): string | undefined;
    private _sourceServiceName?;
    get sourceServiceName(): string;
    set sourceServiceName(value: string);
    resetSourceServiceName(): void;
    get sourceServiceNameInput(): string | undefined;
    private _sshPublicKey?;
    get sshPublicKey(): string;
    set sshPublicKey(value: string);
    get sshPublicKeyInput(): string | undefined;
    get status(): string;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _useIdentityService?;
    get useIdentityService(): boolean | cdktf.IResolvable;
    set useIdentityService(value: boolean | cdktf.IResolvable);
    resetUseIdentityService(): void;
    get useIdentityServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _backups;
    get backups(): JavaServiceInstanceBackupsOutputReference;
    putBackups(value: JavaServiceInstanceBackups): void;
    get backupsInput(): JavaServiceInstanceBackups | undefined;
    private _loadBalancer;
    get loadBalancer(): JavaServiceInstanceLoadBalancerOutputReference;
    putLoadBalancer(value: JavaServiceInstanceLoadBalancer): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): JavaServiceInstanceLoadBalancer | undefined;
    private _oracleTrafficDirector;
    get oracleTrafficDirector(): JavaServiceInstanceOracleTrafficDirectorOutputReference;
    putOracleTrafficDirector(value: JavaServiceInstanceOracleTrafficDirector): void;
    resetOracleTrafficDirector(): void;
    get oracleTrafficDirectorInput(): JavaServiceInstanceOracleTrafficDirector | undefined;
    private _timeouts;
    get timeouts(): JavaServiceInstanceTimeoutsOutputReference;
    putTimeouts(value: JavaServiceInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JavaServiceInstanceTimeouts | undefined;
    private _weblogicServer;
    get weblogicServer(): JavaServiceInstanceWeblogicServerOutputReference;
    putWeblogicServer(value: JavaServiceInstanceWeblogicServer): void;
    get weblogicServerInput(): JavaServiceInstanceWeblogicServer | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
